/*~!BRK.C*/

#include "@system(include)errno.h"

 brk(neweas)              /* set new end of address space point */

 char *neweas;
 {
    int delta, oldlim, newlim, i, j;
    extern char *eas;     /* pointer to current end of address */
    extern int blksize;   /* block size */
    static reg[8];
    extern errno;

    errno = 0;      /* no error yet */
    oldlim = (int)eas;
    newlim = (int)neweas;
    mpxsvc (0x1065, reg, reg);
    if(neweas <= (char *)reg[7]) {   /* valid eom */
        eas = neweas;     /* get current eom address */
        return (0);       /* return o.k. */
     }
    delta = (oldlim-1)/blksize - (newlim-1)/blksize;  /* find new block
    */
    for (i=0; i<abs(delta); i++)

       if (delta < 0) {
          mpxsvc(0x1069,reg,reg);  /* get a map block */
          j = reg[3];       /* get status */
          if (j == 0) {
             for (j=0; j < i; j++) mpxsvc(0x106a,reg,reg);
             errno = ENOMEM;    /* set error code */
             mpxsvc (0x1065, reg, reg);
             eas = (char *)reg[7];     /* valid eom */
             eas = (char *)oldlim;     /* old eom */
             return (-1);      /* return error */
          }
       } else mpxsvc(0x106a,reg,reg);  /* put a map block */

    eas = neweas;                      /* get current eom address */
    return (0);                 /* return o.k. */
 }

