/* *********************************************************************
 *
 * $Header:  007  02-JUL-91 19:00  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT.INC)EDT.H                                   $
 * 
 *      Rev  007  02-JUL-91 19:00  GANN      GANN                       
 * Added new flag for mode where the output file has a version          
 * number.                                                              
 *
 *      Rev  006  09-APR-91 13:58  GANN      GANN
 * Changed BUFCTRL type to also contain a word that indicates
 * whether the buffer has been modified or not.
 *
 *      Rev  005  11-JAN-91 10:08  GANN      GANN
 * Changing INCLINES from 128 to 512 speeds up some buffering
 * functions.  Other things are slowed down a bit but overall
 * EDT is faster.  I also tried 1024 and decided that the
 * additional speed up was not worth the slow down on other
 * functions.
 *
 *      Rev  004  08-NOV-89 10:18  GANN      GANN
 * Changed includes to reference the correct files on ISCSRC instead
 * of the old files on SMV.
 *
 *      Rev  003  09-FEB-89 17:23  GANN      GANN
 * Swapped the definitions for FUNCT_OFF and ESC_OFF. This
 * swaps the range of number we use for those special keys.
 *
 *      Rev  002  20-JAN-89 09:34  GANN      GANN
 * Added support for qualifier /NOOUTPUT.
 * Fix for SPR's 10*337 and 10*430.
 *
 *      Rev  001  11-OCT-88 13:19  GANN      GANN
 *  Version control header added
 */
/*
 */

/**********************************************************************
 *                                                                    *
 *  Emulation of Digital Equipment Corp. EDT editor                   *
 *                                                                    *
 *                            COPYRIGHT (C)                           *
 *                 INTERNATIONAL SOFTWARE CORPORATION                 *
 *                               1986                                 *
 *                       GOLDEN, COLORADO 80401                       *
 *                                                                    *
 *                         All Rights Reserved                        *
 *                                                                    *
 *  This software is confidential information which is proprietary    *
 *  to and a trade secret of International Software Corporation.      *
 *  Use, duplication, or disclosure is subject to the terms of a      *
 *  separate license agreement.                                       *
 *                                                                    *
 *  ----------------------------------------------------------------- *
 *                                                                    *
 *  Use, duplication, or disclosure by the Government is subject to   *
 *  restrictions set forth in paragraph (b)(3)(B) of the Rights in    *
 *  Technical Data and Computer Software clause in DAR 7-104.9(a).    *
 *                                                                    *
 *  ----------------------------------------------------------------- *
 *                                                                    *
 *  Contractor:  International Software Corporation                   *
 *                 Golden, Colorado, U.S.A. 80401                     *
 *                                                                    *
 *  ----------------------------------------------------------------- *
 *                                                                    *
 *      EDT editor                                                    *
 *                                                                    *
 **********************************************************************
 */

/* Defines for ISC */
#define ISC
#define UNIX
#define ULTRIX
#define MEMRTNS
#define ANSI
#define OTTYDISC 0
#define TEST
#define KEEP_ALIVE

/* typedefs */

typedef char byte;

typedef char  *Pchar;
typedef byte  *Pbyte;
typedef short  Byte2;

typedef long  SEEK;

#include "@iscsrc(dv.mpx.cinc)stdio.h"
#include "@iscsrc(dv.mpx.cinc)ctype.h"
#include "@iscsrc(dv.mpx.cinc)string.h"
#include "@iscsrc(dv.mpx.cinc)setjmp.h"

#undef tolower
#undef toupper
#undef islower
#undef isupper

/* These don't work! islower and isupper check bit 6 of the character in
 * question. toupper and tolower increment autoincrement args twice.
 *
 * #define toupper(c) (islower(c) ? ((c)-'a'+'A') : (c))
 * #define tolower(c) (isupper(c) ? ((c)-'A'+'a') : (c))
 */

#define YES  1
#define NO  0

#define OFF  0
#define ON  1

#define LNULL  ((Line *)NULL)

#define WORKCOL  36  /* Where "Working" message goes */
#ifdef KEEP_ALIVE
/* #define BKGRND  (keep_alive++)*/ /* If it keeps growing, all is well */
#define BKGRND (keep_alive++, doclock()) /* simulate unix */
#else
#define BKGRND {}  /* Do nothing */
#endif /* KEEP_ALIVE */

#define CTRLC  0003
#define BS  0010
#define EOL  0015
#define CTRLQ  0021
#define CTRLS  0023
#define CTRLZ  0032
#define ESC  0033
#define DEL  0177

#define ENTER  280  /* "Enter" Keypad Key */

/* Definitions for memory allocation (getline, initbuf, et al) flags */

#define FREEIT 0
#define REALIT 1
#define DUPIT 2
#define NEWIT 3

#define EXITING -1  /* Flag that initbuf called while exiting */
#define QUITING -2  /* Flag that initbuf called while quiting */

/* NOKEY flags */

#define ENT 1
#define BUF 2
#define OTH 4
#define SEA 8
#define NAN 16
#define SEP 32
#define ABS 64

#define BUFNUM  20 /* number of buffers available */
 /* Size of buffer for EXIT when writing to different device */
#define EXBUFSIZ 4096

/* maximum number of users buffers open at one time */
/* iscio.s must allow MAXUSERS+MAIN+PASTE to be open at once */
#define MAXUSERS 07			/* was 80 */

#define INCLINES 512                                             /*005*/
#define PAGEOUT  (INCLINES/2)
#define MINBUFSIZE INCLINES + PAGEOUT
#define MAXLINE  254
#define MAXBUFLINES (0xfffffeL) /* 24 bits of lines */

#define FNAMELEN 40 /* length of drive + path + name + ext */

/* Default filenames */

#  define OLDFILE "EDTOLD.EDT"  /* last edited file name */
#  define CMNDFILE "EDTINI.EDT"  /* the command file name */
#  define CMNDSYS "@SYSTEM(DCL64.EDT)EDTINI.SYS"  /* the sys cmd file */
#  define HELPFILE "EDTHELP.EXE"  /* help executable */

/* Key translation constants */

#define KPF  59
#define KPFFIX  53
#define KPFOFFSET 255
#define ANSIKEYS (84-KPFFIX)

#define GOLD_OFF  512
#define SCS_OFF   384
#define FUNCT_OFF 128                                            /*003*/
#define ESC_OFF   256                                            /*003*/
#define FUNSIZE   1024

/* Convenience definitions */

/* Coercions, front-ends */

#define strend(p) strchr((p), '\000')

#ifndef MEMRTNS
#define MALLOC(n) malloc((n))
#define FREE(p) free((char *)(p))
#define REALLOC(p, n) realloc((char *)(p), (n))
#define HEYrealloc(p, n) realloc((char *)(p), (n))
#else
#define MALLOC(n) mymalloc((n))
#define FREE(p) myfree((char *)(p))
#define REALLOC(p, n) myrealloc((char *)(p), (n))
#define HEYrealloc(p, n) realloc((char *)(p), (n))
#define malloc(n) mymalloc((n))
#define free(p) myfree((char *)(p))
#define zeromem(n) Zeromem(n, NO)
#define HEYzeromem(n) Zeromem(n, YES)
#endif

#define MOVMEM(f, t, l) movmem((char *)(f), (char *)(t), (l))
#define MEMSET(p, c, n) memset((char *)(p), (char)(c), (n))
#define MEMCPY(d, s, n) memcpy((char *)(d), (char *)(s), (n))
#define MEMCHR(p, c, n) memchr((char *)(p), (char)(c), (n))

/* Easy to use */

#define strcmpi(a, b) strnicmp((a), (b), MAXLINE+1)
#define incptr(p) (cmndptr = (p) - cmndbuf)
#define ISGOLD(n) (!casecmp(funs[n], lw[S_GOLD].kw, 4))
#define LINPSIZ(n) (sizeof(LINE *) * (n))
#define ADDTOT(b, i) (b->totlines += (b->totlines<MAXBUFLINES)?i:0)
#define ISDELIM(ch, d) ((ch) && strchr((d), (ch)))
#define LASTL(b) (b->line1is + b->lines)

#define LRNBUFSIZ 255      /* Maximum size of learn buffer */
#define LRNBAG  (3)        /* Extra baggage in learn buffer */
#define LRNBUF(x) ((x) + sizeof(Pchar))

#define strnzcpy(d,s,n) Strnzcpy((char *)(d),(char *)(s),(n))
#define stpblk(p) Stpblk(p)
#define frccur(b, r, c) FrcCur(b, (long)(r), (long)(c))

#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))
#define sign(n)  ((n < 0) ? -1 : 1)

#define row (current->curlin)
#define col (current->curchr)
#define rowsel (current->selrow)
#define colsel (current->selcol)
#define marking (-(current->selrow >= 0))

#define r0 (&r0store)
#define r1 (&r1store)
#define bbctemp (&bbcstore)

/* Structure definitions */

typedef union
    {
    Byte2   w;
    char    b[2];
    } Word;

/* A line in the buffer. */

typedef struct
    {
    int len;
    byte lin[MAXLINE];
    } LINE;

/* The organization of a user buffer.  2 are predefined MAIN & PASTE.
 * The other user buffers are defined on the fly
 */

/* Flags definitions for bufctrl */

typedef struct bufctrl {
    Pchar bufnam;  /* user given name for buffer */
    Pchar fname;  /* name of input associated with buffer */
    Pchar ofname;  /* name of output for buffer */
    FILE *fp;  /* pointer to associated file if any */
    FILE *ofp;  /* pointer to associated output file if any */

    int dirty0;  /* first line of changes to buffer */
    int dirty1;  /* last line of changes to buffer */

    int curlin;  /* index to the current insert point */
    int curchr;  /* the char position for insert in curlin*/

    long selrow;  /* Start of select, row */
    short selcol;  /* Start of select, column */

    byte macro;  /* define macro? */
    byte multipas; /* True if orginal file is no longer in use */
    byte nolastcr; /* YES if last line has no EOL */

    int lines;  /* the number of used lines in buffer */
    int avlines; /* the number of reserved lines in buffer */

    long line1is; /* line1is the file line number of #1 in buf */
    long totlines; /* total number of lines in the file */
    long sctopl;  /* the top line of the screen */

    LINE **buf;  /* array of line pointers */
    int modified;          /* buffer has been modified*/
} BUFCTRL;

/* The structure of range pointers
 * you are allowed up to 20 non-contiguous ranges to selected for
 * any single given command
 */
typedef struct rangestr {
    BUFCTRL *bp; /* point to buffer (NULL if none )*/
    long l0,l1; /* line indexes start & end */
    short c0,c1; /* characters indexes */
    byte *str;
    struct rangestr *next;
} RANGESTR;

#define keylen argstuff[0]
#define argtype argstuff[1]

typedef struct nokeyrec {
    char *keyword;
    Pchar (*keyfun)();         /* ????????? */
    byte argstuff[2];
} NOKEYREC;

#define kl lens[0]
#define sl lens[1]

typedef struct linrec {
    Pchar kw;
    byte lens[2];
    int  (*func)();    /* ??????? */
} LINEREC;

/* A file I/O buffer */

typedef struct {
    FILE *fp;
    char filebuf[BUFSIZ];
} BUFFER;

typedef LINE  Line;
typedef BUFCTRL  Bufctl;
typedef RANGESTR Range;
typedef NOKEYREC Nkrec;
typedef LINEREC  Lnrec;

#define putch(c) SCPUTC(-1, -1, (c), 1, qcolor)

#ifndef EDTGLB
/*
 *  definition of non-integer functions
 */

Pchar Stpblk(), Strnzcpy(), getstr(), filecmnd();
Pchar strdup(), stpblkcd(), reallmem();
Pchar realloc(), calloc(), mymalloc(), myrealloc(), Zeromem();
Bufctl *initbuf(), *FrcCur(), *getbufn();
Line *chkshft(), *getline();
long delblok(), isnum();
void foerr(), memerr(), blast(), dowork(), fzclose(), mkpos();
void rst_all(), scprintf(), passthru(), needlines(), buf2out();
void cprintf(), scsave(), clearbot();
void setrowcol();
void initmem(), myfree();
Byte2  scmovcur();

/* ******  Some of the globals defined in EDTGLB follow ***** */

/* Working variables */

extern int keep_alive;
extern byte eraworking;

extern BUFCTRL *maine;  /* pointer to main buffer */
extern BUFCTRL *paste;  /* pointer to paste text */
extern BUFCTRL *current; /* equals one of the above */
extern BUFCTRL *lastbuf; /* equals one of the above */
extern BUFCTRL *user[]; /* defined as needed */
extern BUFCTRL *bbcbuf; /* temp buffer for cut/paste/move/copy */

extern byte gold;
extern int asciival;

extern int qjournal, journext;
extern short jourbuf[];

/*
 *  define file name arrays.  not all files are always used
 */
extern Pchar infile, outfile, temppref, inflpref, cmndfile, helpfile,
  jrnlfile, cmndsys, orgfile, incfile;
extern FILE *jfp, *stdwhat; /* Standard file pointers */

extern char qqserial[], qversion[];
extern byte loadflag;

extern long qtop, qbottom;

extern int qdir, qdcolor, qscolor, qecolor, qcolor;

extern byte quiet, qbanner, qtrunc, qverify, qtab, qtabc, qnumber;

extern Pchar qeword, qesent, qepara, qepage; /* pointer to entities */

extern byte qread, qindent;

extern char *termstr;
extern int qwrap;

/* cursor, display, and buffer management flags */

extern byte noscreen, redraw, botclr, EOBonscr, clrlines, moving;
extern int scrow, sccol, truerow, truecol, scrowmax, sccolmax,
 realcolmax, scmsgrow, scerrrow, realcur;
extern LINE **screen;
extern LINE *here;
extern long absrow, lines_rel, chars_rel;

extern byte actlin[], tmplin[];
extern char dir_sep[], switch_char;
extern Pchar readbin, readwritebin, writebin;

extern long memsize;
extern char cmndbuf[];
extern int cmndptr, cmndend;

extern LINEREC lw[];

extern char * funs[];  /* Keypad editing function array */

extern Range r0store, r1store, bbcstore;

extern NOKEYREC nokey[];

extern Pchar ents[];

extern byte qautorep, qfnf, qkeypad, qmode, qdmode, qparawps, qrepeat;
extern byte qqmc;                                                /*006*/
extern byte qseagen, qseabeg, qseabou, qseanostay, qsummary, qworddem;

extern byte qcase, qttkind, qttscrl, qtteight, qttedit;
extern Pchar qtxtend, qtxtpage;
extern Pchar qprolin, qprokey, qpronok, qprohcc, qproins, qproinn,
 qproque;
extern Pchar nulldev; /* The bit bucket */

extern int userbufs;  /* number of buffers currently open */
extern int comprom;   /* line mode command error offset */
extern int qrecover;  /* flag for recovery on */
extern int qmaxcol;   /* maximum column to read */
extern int qterm;     /* terminal type */
extern int qkeybrd;   /* Televideo keyboard type */
extern int qvers;     /* if 1 use versioning */
extern int qvnum;     /* if 1 last version is numbered */        /*007*/
extern int qold;      /* if 1 use edtold.edt */
extern int threez;    /* 3 control z's in a row cause exit */
extern byte qhit;     /* governs if a keyhit is needed going back
                         to change mode from line mode */
extern byte qmacro;   /* YES if command file/macro in process */
extern int ctrlc_hit; /* YES if user typed CTRL-C */
extern jmp_buf to_here; /* Where to go when CTRL-C hit, if non NULL */

extern int holdit;  /* Flag controlling working */

#endif /* EDTGLB */

#include "edtunix.h"
