/* *********************************************************************
 *
 * $Header:  006  20-DEC-90 09:56  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)ANSI.C                                      $
 * 
 *      Rev  006  20-DEC-90 09:56  GANN      GANN                       
 * Removed some useless calls to Alarm and Signal.                      
 *
 *      Rev  005  09-MAY-90 12:42  GANN      GANN
 * Changed GETCH to allow caller to specify a formatted read.
 *
 *      Rev  004  10-FEB-89 08:36  GANN      GANN
 * Remove changes in scputc. I had made the same changes to
 * scputc as scputs. These changes screwed up all kinds of things.
 * So I left scputc as it was.
 *
 *      Rev  003  09-FEB-89 17:13  GANN      GANN
 * Changed to properly display multinational characters if
 * qualifier /MULTI_NATIONAL is coded. Also changed the ESC
 * character range to be 256 to 383 and the Televideo FUNCTION
 * key range to be 128 to 255. (Swapped them.) Then made
 * changes in SCANTT to ignore treat keys in the range 128-255
 * same as normal characters (0-127). This allows un-American
 * keyboards to work.
 *
 *      Rev  002  30-JAN-89 13:34  GANN      GANN
 * Fix vt220 function key processing to bail out if error detected.
 *
 *      Rev  001  11-OCT-88 14:05  GANN      GANN
 *  Version control header added
 */
/*
 */

#include "edt.h"
#include "scio.h"
#include "tokens.h"
#include "sgtty.h"
#include "fcntl.h"
#include "signal.h"

typedef struct chain
{
    int  (*func)();
    struct chain *next;
}
Chain;

static char pbuf[(132*4)+20];
static Pchar pend = &pbuf[132*4];

static char vtctrl [] = {'h', 'y', 'y', 'y', 'y', 'y', 'y',
                         'f', 'y', 'b', 'e', 'i', 'c', 'd',
                         'y', 'y', 'y', 'y', 'y', 'y', 'y',
                         'y', 'y', 'y', 'y', 'y', 'y', 'a',
                         'y', 'y', 'y', 'y'};


int cur_hue = -1;
int lrow = -1;
int lcol = -1;
int ErrRowSt=0;
int ErrColSt=0;

static unsigned nxtch;
static unsigned stdinflgs;

void BELL1();
int offshift();

#undef cputs
int *infcb, *outfcb;
void cputs();

int qoverwr  = 0;
int numstate = 0;

/*
 * shift - Called to set up keyboard and screen for editing
 */

shift()
{
    extern int *fcbadr();

    infcb  = fcbadr(0) + 2;
    outfcb = fcbadr(1) + 2;
    *infcb  |= 0x20500000;
    *outfcb |= 0x20000000;

    switch (qterm) {
    case 0:
        cputs("\033[?3l");             /* Reset 80 char line width */
        cputs("\033=\033[?6h\033[?1;7l"); /* with repeat mode */
        break;
    case 1:
    case 2:
        cputs(      "\036\033*");       /* home, clear */
        cputs("\033G0\033=  ");      /* normal vidio, home curser */
        break;
    }

    lrow = lcol = 1;
    scmovcur(scmsgrow, 1);

    return(0);
}

/* offshift - Called when special keyboard and screen setups are not
 *       needed.
 */

offshift()

{

    switch (qterm) {
    case 0:
        cputs("\033[?3l");             /* Reset 80 char line width */
        cputs("\033[?6l\033[?8h\033[?5l\033[H\033>\033[2J");
        break;
    case 1:
        cputs("\033\042\033G0\033=  \033Y\033h");
            /* normal vidio, home curser, turn status line off, unlock kbrd */
        break;
    case 2:
         cputs("\033G0\032\036");
            /* normal vidio, home curser, turn status line off, unlock kbrd */
        break;
   }

    lrow = lcol = 1;
    scmovcur(scmsgrow, 1);

    *infcb ^= 0x20500000;

    return;
}

/* setcurs - Called to set the cursor to block or underline.
 *
 * Currently unimplemented.
 */

setcurs(){
    return(0);
}

/* ATON - Called to determine if this is a PC/AT, or not.
 *
 *  Always returns AT code since that keyboard is closest
 * to a LK201.
 */

ATON()
{
    return(252);  /* Trick into thinking this is a PC/AT */
}

/* HELLO - Called during initialization to set up OS specific stuff.
 */

void HELLO()

{
    extern byte working;

    qcolor = qdcolor = 0;
    qecolor = 1;
    qscolor = 7;

    switch (qterm) {
    case 0:
        working = YES;
        scrowmax = 22;
        scmsgrow = 23;
        scerrrow = 24;
        break;
    case 1:
        working = YES;
        scrowmax = 23;
        scmsgrow = 24;
        scerrrow = 25;
        break;
    case 2:
        working = NO;
        scrowmax = 22;
        scmsgrow = 23;
        scerrrow = 24;
        break;
    }

    return;
}

/*
 * BYE - Called to fix things up and then exit.
 */

void BYE(n)

{
    offshift();
    exit(n);
}

/* scantt - Read the keyboard, in a non-blocking fashion.
 *
 * Return:
 *  0 if there was no keystroke in the queue.
 * otherwise,
 *  returns a word consisting a "scan-code" in the
 *  If the scan code isless than 128 it is the character typed.
 *
 */
unsigned scantt()
{
    int ichar, gotchar, j;

    gotchar = 0;
    ichar = 0;

    while (!gotchar) {
        j = GETCH (NO);                                          /*005*/

/* do some fancy remapping to allow vt220 function keys */

        if ((ichar == SCS_OFF) && (j >= '0') && (j <= '9')) {
            for (ichar = 0; ((j >= '0') && (j <= '9'));j = GETCH (NO)) {    /*005*/
                ichar = (ichar * 10) + (j-'0');
            }
            ichar += SCS_OFF;
        }
        else    /* Otherwise just add this to the character I'm building  */
            ichar += j;

/* 004ified to not check for function sequences for DEC terminals.      003
 * DEC terminals will send and understand characters in the range of    003
 * 128 to 255 so I put the Televideo FUNCTION keys in this range and    003
 * then turn them off here for DEC terminals. That frees up 128-255     003
 * for DEC terminals to use. This range is the multinational character  003
 * set used by our European customers.                                  003*/

        if ((ichar >= FUNCT_OFF) && (ichar < (FUNCT_OFF+128)) && (qterm != 0))
            j = GETCH (NO);    /* Read up function seq. terminator   MOD*/

        if ((ichar == 1) && (qterm != 0))   /* SOH, start function sequence */
            ichar = FUNCT_OFF;
        else if ((strnicmp (funs[ichar], lw[S_FUNCTION].kw, 5)) == 0)
            ichar = FUNCT_OFF;
        else if ((strnicmp (funs[ichar], lw[S_ESC].kw, 3)) == 0)
            ichar = ESC_OFF;
        else if ((strnicmp (funs[ichar], lw[S_SCS].kw, 3)) == 0)
            ichar = SCS_OFF;
        else
            gotchar = 1;
    }
    return (ichar);
}

/* SCSCR - Scroll the screen.
 *
 * Arguments
 * nlines - Number of lines to scroll.
 *   negative means scroll down
 *   positive means scroll up
 *   zero means clear the region.
 *
 * toprow, topcol - The starting point on the screen
 * botrow        - The ending row
 *
 * Return
 * Always YES, for some reason.
 */

#undef row
#undef col

int SCSCR(nlines, toprow, topcol, botrow, botcol)

int nlines, toprow, topcol, botrow, botcol;

{
    int row, delrow;
/* new stuff C.F. */
    int    olrow = lrow;
    int olcol = lcol;

    /* The following ANSI escapes are used

     \033[<x>;<y>H - move cursor to row x, column y
     \033[<x>;<y>r - define scrolling region belween rows x and y
     \033[r  - full screen scroll
     \033[J  - erase entire screen  (really to end of screen)
     \033[K  - erase line starting from cursor postion
     \033[<x>L - add x lines at cursor
     \033[<x>M - delete x lines at cursor
     */

    if ((toprow > botrow) || (topcol > botcol)) return (YES);

    if (cur_hue != 0)
    {
        cur_hue = 0;
        switch (qterm) {
        case 0:
            cputs("\033[m");
            break; /* normal vidio */
            /*          case 1: cputs("\033G0\033("); break; */
        case 1:
        case 2:
            cputs("\033(");
            break; /* normal vidio */
        }
    }

    switch (qterm) {               /* start termin switch */
    case 0:
        {                  /* VT100 */
            if (nlines != 0)
            {
                if (nlines > 0) {
  /*                sprintf(pbuf, "\033[%d;%dr\033[%dM\033[r",toprow
                        ,botrow,nlines);   */
                    sprintf(pbuf, "\033[%d;%dr\033[%d;%dH"
                       ,toprow ,botrow, botrow, botcol);
                    cputs(pbuf);
                    for (row = nlines; row; row--)
                        cputs ("\012");   /* delete line */
                    sprintf(pbuf, "\033[%d;%dH",toprow ,topcol);
                    cputs(pbuf);
                } else {
/*                  sprintf(pbuf, "\033[%d;%dr\033[%dL\033[r", toprow,
                    botrow, -nlines);  */
                    sprintf(pbuf, "\033[%d;%dr",toprow, botrow);
                    cputs(pbuf);
                    for (row = nlines; row; row++)
                        cputs ("\033M");   /* insert line */
                }
                cputs("\033[r");  /* reset scroll regin */
/* old          lrow = lcol = -1; */ /* Current position of cursor */
                lrow = lcol = 1; /* Current position of cursor */
            }
            else
            {
                scmovcur(toprow, topcol);
                if (toprow == botrow)
                    cputs("\033[K");
                else if (botrow > scrowmax)
                    cputs("\033[J");
                else
                    for (row = toprow; row <= botrow; row++, lrow++)
                        cputs("\033[K\r\n");
            }
            break;
        } /* end of case 0 (vt100)  */
    case 1:                    /* start of TV921 switch */
    case 2:                    /* start of ascii switch */
        {
            if (nlines != 0) {
                ErrRowSt = 0;        /* not on err row any more */
                if (nlines > 0) {
                    sprintf (pbuf,"\033=%c \033T",scmsgrow+31);
                    cputs(pbuf);
                    sprintf (pbuf,"\033=%c%c",toprow+31, topcol+31);
                    cputs(pbuf);
                    for (row = nlines; row; row--)
                        cputs ("\033R");   /* delete line */
                    if (botrow < scrowmax) {
                        delrow = botrow - nlines + 1;
                        sprintf (pbuf,"\033=%c ", delrow+31);
                        cputs (pbuf);
                        for (row=nlines; row; row--)
                            cputs ("\033E");
                        sprintf (pbuf,"\033=%c%c",toprow+31, topcol+31);
                        cputs(pbuf);
                    }
                }
                else
                {
                    if (botrow < scrowmax) {
                        delrow = botrow + nlines + 1;
                        if (delrow < toprow)
                            delrow = toprow;
                        sprintf (pbuf,"\033=%c%c", delrow+31, botcol+31);
                        cputs (pbuf);
                        for (row=nlines; row; row++)
                            cputs ("\033R");
                    }
                    sprintf (pbuf,"\033=%c%c",toprow+31, topcol+31);
                    cputs(pbuf);
                    for (row = nlines; row; row++)
                        cputs ("\033E");             /* insert lines */
                }
                lrow = lcol = -1; /* Current position of cursor */
            }
            else
            {
                scmovcur(toprow, topcol);
                if (toprow == botrow)
                    cputs("\033T");      /* erase to end of line */
                else if (botrow > scrowmax)
                    cputs("\033Y");      /* erase to end of screen */
                else
                    for (row = toprow; row <= botrow; row++, lrow++)
                        cputs("\033T\r\n");   /* curr pos to n lines */
            }
            break;
          /* end of case 1 (tv921)  */
        } /* end of case 2 (ascii)  */
    } /* end of switch */

/* new stuff C.F. */
scmovcur(olrow, olcol);

    return(YES);
}

/* scmovcur
 * Move cursor to indicated position, with some optimization
 *
 * Arguments
 * row, col - The screen address at which to position cursor.
 *     If row is < 0, do nothing.
 *
 * Return
 * a word containing the the row in the high order byte
 * and the column in the low order.
 */

Byte2 scmovcur(row, col)

register int row, col;

{
    int  n;
    Pchar  pos = NULL;

    if ((row <= 0) || (col <=0))
        {
        n = (byte)lcol | (lrow << 8);
        if ((row & col) == 0)
        lrow = lcol = -1;   /* De-stabilize */
        }
    else if ((lrow == row) && (lcol == col))
        n = -1;        /* No movement necessary */
    else if ((row == scerrrow ) && (qterm == 1)) {
        if (ErrRowSt == 0) {
            pos = "\033g";
            cputs (pos);
            ErrRowSt = 1;
            ErrColSt = col;
            row = col = -1;
            lrow = lcol = -1;
        }
    }
    else {
        ErrRowSt = 0;
        if (lrow > 0)
        if (row != lrow)
            {
            if (row == (lrow + 1))
            {
                if (col == lcol)
                    pos = "\n";  /* Same cursor position next line */
                else if (col == 1)
                    pos = "\r\n";  /* Beginning of next line */
            }
            else if (row == (lrow - 1))
            {
            if (col == lcol)
                switch (qterm) {
                case 0:
                    pos = "\033[A";  /* Same curr pos next line */
                    break;
                case 1:
                case 2:
                    pos = "\013";   /* cursor up */
                    break;
                }
            else if (col == 1)
                switch (qterm) {
                case 0:
                    pos = "\r\033[A"; /* Beginning of next line */
                    break;
                case 1:
                case 2:
                    pos = "\r\013";   /* Beginning of next line */
                    break;
                }
            }
            else if (col == lcol)
            {
                n = row - lrow;
                switch (qterm) {
                case 0:
                    sprintf(pos = pbuf, "\033[%d%c",
                        abs(n), (n < 0) ? 'A' : 'B');
                    break;
                case 1:
                case 2:
                    sprintf(pos = pbuf, "\033=%c%c",row+31,col+31);
                    break;
                }
            }
            else if (col == 1)
                switch (qterm) {
                case 0:
                    sprintf(pos = pbuf, "\033[%dH", row);
                    break;
                case 1:
                case 2:
                    sprintf(pos = pbuf, "\033=%c " ,row+31);
                    break;
                }
        }
        else if (col == 1)
            switch (qterm) {
            case 0:
                pos = "\r";
                break;
            case 1:
            case 2:
                sprintf(pos = pbuf, "\033=%c%c",row+31,col+31);
                break;
            }
        else if (col == (lcol + 1))
            switch (qterm) {
            case 0:
                pos = "\033[C";
                break;
            case 1:
            case 2:
                pos = "\014";
                break;
            }
        else if (col == (lcol - 1))
            pos = "\b";
        else
        {
            n = col - lcol;
            switch (qterm) {
            case 0:
                sprintf(pos = pbuf, "\033[%d%c",
                    abs(n), (n > 0) ? 'C' : 'D');
                break;
            case 1:
            case 2:
                sprintf(pos = pbuf, "\033=%c%c",row+31,col+31);
                break;
            }
        }

    if (pos == NULL)
        switch (qterm) {
        case 0:
            sprintf(pos = pbuf, "\033[%d;%dH", row, col);
            break;
        case 1:
        case 2:
            sprintf(pos = pbuf, "\033=%c%c",row+31,col+31);
            break;
        }

    cputs(pos);
    lrow = row;
    lcol = col;
    }

    return(n);
}

void    fixwrap(col)
int    col;
{
lcol = (col > realcolmax) ? realcolmax : col;
return;
}

/* _scputs
 * Output a string to a position on the string with attributes
 *
 * Arguments
 * row, col - Where to display the string
 * buf  - The characters and attributes to display
 *     These are organized as char/attr pairs
 * len  - The number of entities in the buffer.
 *     (not the number of bytes)
 *
 * Discussion
 * Attributes currently are either either normal, bold, or,
 * reverse video.
 * No attempt is made to write beyond realcolmax.
 *
 * Return
 * The last column actually displayed in.
 */

#undef putch
int _scputs(row, col, buf, len)

int row, col;
Pchar buf;
int len;

{
    register Pchar p;
    register int ch, lch, nch, graphison;
    register int hue;
    register Pchar newhue;
    Pchar  ongraphic, offgraphic;

    scmovcur(row, col);

    graphison = 0;
    pbuf [0] = 0;
    p = pbuf;
    ch = ' ';            /* some non exciting char */
    nch = *buf++;        /* start with next char */

    for ( ; ((len > 0) && (col <= realcolmax) && (p <= pend)); len--)    {

        lch = ch;
        ch     = nch;
        hue = *buf++;
        nch = *buf++;

        if (hue != cur_hue) {
            switch (qterm) {
            case 0:
                sprintf(p, "\033[%s%dm", (cur_hue ? "0;" : ""), hue);
                break;
            case 1:
            case 2:
                if (ErrRowSt == 0)
                    sprintf(p,  "\033%c"           ,(hue ? ')' : '('));
                else
                    sprintf(p,  "\033f");
                break;
            }
            cur_hue = hue;
            p = strend(p);
        }

        ongraphic = offgraphic = (char *)"";
        if ((ch < ' ') || (ch >= DEL)) {
            switch (qterm) {
            case 0:

                if (ch < ' ')
                    ch = vtctrl [ch];
                else if ((ch >= DEL) && (ch < 160))              /*003*/
                    ch = 'z';                                    /*003*/
                else if (qkeybrd != 128)                         /*003*/
                    ch = 'z';                                    /*003*/
                if ((lch >= ' ') && (lch < DEL)) {
                    ongraphic = (char *) "\033(0";
                    graphison = 1;
                }
                if ((nch >= ' ') && (nch < DEL)) {
                    offgraphic = (char *) "\033(B";
                    graphison = 0;
                }
                break;

            case 1:

                if ((ch >= DEL) || (ch == 0))
                    ch = 0x7f;
                if ((lch >= ' ') && (lch < DEL)) {
                    ongraphic = (char *) "\033U";
                    graphison = 1;
                }
                if ((nch >= ' ') && (nch < DEL)) {
                    offgraphic = (char *) "\033X";
                    graphison = 0;
                }
                break;

            case 2:

                if ((ch >= DEL) || (ch == 0))
                    ch = 23;
                else if (ch == 27)
                    ch = 31;
                else if (ch > 15)
                    ch = 30;
                if ((lch >= ' ') && (lch < DEL)) {
                    ongraphic = (char *) "\033U";
                    graphison = 1;
                }
                if ((nch >= ' ') && (nch < DEL)) {
                    offgraphic = (char *) "\033X";
                    graphison = 0;
                }
                break;

            }
        }

        col++;
        sprintf(p, "%s%c%s", ongraphic, ch, offgraphic);
        p = strend(p);
    }

    p = strend(p);
    if (graphison) {    /* insure graphics mode off    */
        if (qterm == 0)
            offgraphic = (char *) "\033(B";
        else
            offgraphic = (char *) "\033X";
        sprintf (p, "%s", offgraphic);
        p = strend (p);
        graphison = 0;
    }
    *outfcb |= 0x20000000;
    writraw(1, pbuf, p - pbuf);
    if (ErrRowSt > 0) {
        writraw(1, "\015", 1);
        ErrRowSt = 2;
    }
    *outfcb ^= 0x20000000;

    return(lcol = min(col, realcolmax));
}

/* SCPUTC - put a character on the screen.
 *
 * Arguments
 * row, col - Where to place the character
 * ch  - The character
 * pad  - How many spaces to place before character
 * hue  - The attribute of the character (see above)
 *
 * Discussion
 * Will not display beyond realcolmax
 *
 * Return
 * The actual number of characters displayed
 */

int SCPUTC(row, col, ch, pad, hue)

int  row, col;
register int ch;
/*register*/ int pad;
register int  hue;

{
    int  nxtcol;
    int  oldch = ch;
    char  lch = ch & 0xff;
    byte  altgraphic;
    Pchar p = pbuf;

    if ((row | col) < 0)
        col = lcol;
    else
        scmovcur(row, col);

    *p = '\000';

    if ((nxtcol = col + pad) > realcolmax)
        if ((pad -= nxtcol - realcolmax) < 0)
            pad = 0;

    if (altgraphic = ((lch < ' ') || (lch >= DEL)))
    {
        switch (qterm) {
        case 0:
            switch (ch)
            {
            case 0:
                ch = '\150';
                break;
            case 11:
                ch = '\151';
                break;
            case 12:
                ch = '\143';
                break;
            case 260:
                ch = '\140';
                break;
            default:
                if (row < 0)
                {
                    if (ch == BS)
                        lcol -= (2 * pad) - 1;
                    else if (ch == EOL)
                        lcol = 1 - pad;
                    else if (ch != '\n')
                        goto done;  /* Sorry. */
                    else if ((lrow += pad) > scerrrow)
                        lrow = scerrrow;

                    lcol--;
                }
                else if (ch <= DEL)
                    ch = '\141';
            }
            break; /* end case 0 */
        case 1:
        case 2:
            switch (ch)
            {
            case 0:
                ch = '\000';
                break;    /* display n/l */
            case 11:
                ch = '\013';
                break;    /* display v/t */
            case 12:
                ch = '\014';
                break;    /* display f/f */
            case 260:
                ch = '\111';
                break;    /* display + */
            default:
                if (row < 0)
                {
                    if (ch == BS)
                        lcol -= (2 * pad) - 1;
                    else if (ch == EOL)
                        lcol = 1 - pad;
                    else if (ch != '\n')
                        goto done;  /* Sorry. */
                    else if ((lrow += pad) > scerrrow)
                        lrow = scerrrow;

                    lcol--;
                }
                else if (ch <= DEL)
                    ch = '\177';        /* display DEL */
            }
            break; /* end case 1 */
                   /* end case 2 */
        } /* end qterm switch */

        if (altgraphic = (ch != oldch))
        {
            switch (qterm) {
            case 0:
                sprintf(p, "\033(0");
                break;
            case 1:
            case 2:
                sprintf(p, "\b\033$");
                break;
            }
            p = strend(p);
        }
    }

done:
    if (hue == cur_hue)
        if (pad != 1)
            sprintf(p, "%c", ch);
        else
        {
/*          sprintf(p, "%c", ch);   */
            pbuf[0] = ch;
            pbuf[1] = '\000';
        }
    else
    {
        switch (qterm) {
        case 0:
            sprintf(p, "\033[%s%dm%c",
               ((cur_hue != 0) ? "0;" : ""), hue, ch);
            break;
        case 1:
        case 2:
            sprintf(p, "\033%c%c", (hue ? ')' : '('), ch);
            break;
        }
        cur_hue = hue;
    }

    p = strend(p);

    if ((lcol += pad) < 1)
        lcol = 1;

    if (altgraphic)
    {
        switch (qterm) {
        case 0:
            sprintf(p, "\033(B");
            break;
        case 1:
        case 2:
            sprintf(p, "\033%%\b");
            break;
        }
        p = strend(p);
    }

    p = strend(p);
    *p = '\000';
    cputs(pbuf);

    return(pad);
}

/* BELL1 - Beep the terminal
 */

void BELL1()
{
    cputs("\007");
}

/* SETWID - Set the width of the (VTxx) terminal as specified.
 *
 * Argument
 * towhat - Number of columns to display.
 */

void SETWID(towhat)

int towhat;

{
    switch (qterm) {
    case 0:
        if (towhat <= 80)
            cputs("\033[?3l");
        else
            cputs("\033[?3h");
        lrow = lcol = 1;
        scmovcur(scmsgrow, 1);
        break;
    case 1:
        /* tv921 displays only 80 char line */
    case 2:
        /* ansi displays only 80 char line */
        break;
    }

    return;
}

/* getnum - get a number from the keyboard.
 *
 * Discussion
 * Reads digits from the keyboard until a non-digit is found.
 * This does blocking reads from the keyboard.
 * The non-digit character is stored in nextch.
 *
 * Return
 * the value of the number.
 */

int getnum()
{
    int i;
    char ch1, ch2;

    i = -1;
    if (!isdigit(ch1 = GETCH(NO)))
        nxtch = ch1;
    else if (!isdigit(nxtch = ch2 = GETCH(NO)))
        i = ch1 - '0';
    else
        i = (10 * (ch1 - '0')) + (ch2 - '0'), nxtch = GETCH(NO);

    return(i);
}

/* iniclk - Start the clock ticking for "Working" display
 */

static byte clkinuse;

void iniclk()

{
    int doclock();

    clkinuse = YES;
/*006     signal(SIGALRM, doclock);*/

    return;
}

/* rstclk - Stop the clock from ticking
 */

int rstclk()

{
    if (!clkinuse)
        return(NO);

    clkinuse = NO;
/*006     alarm(0);*/
/*006     signal(SIGALRM, SIG_IGN);*/

    return(YES);
}

/* strupr - Convert a string to upper case
 */

Pchar strupr(s)

register Pchar s;

{
    Pchar  orig_s = s;

    s--;
    while (*++s != '\000')
        *s = toupper(*s);

    return(orig_s);
}

/* spawnvp - Do a PC-like spawn of a sub-process
 *
 * Arguments
 * mode - Not used.  For PC compatibility
 * pgm - The name of the program to run
 * argv - An argv style array of character pointers
 *
 * Discussion
 * Forks a subprocess, execs the indicated program, and
 * waits for it to complete.
 *
 * Return
 * 0 if fork/exec succeeded, non-zero otherwise
 */

int spawnvp(mode, pgm, argv)

int  mode;
Pchar  pgm;
Pchar  *argv;

{
    register int p;
    int  status;

    p = helpmain(argv);

    lrow = lcol = -1;

    return(p);
}

/* unixfile - Translate a leading "~" in a filename to the home
 *       directory, a la csh.
 *
 * Arguments
 * fn - The filename to be translated.
 * len - The length of the filename in the string.
 *
 * Return
 * A pointer to a freshly malloced, possibly translated filename.
 */

Pchar unixfile(fn, len)

register Pchar fn;

{
    register Pchar home;

    if (((home = getenv("HOME")) == NULL) ||
        (strncmp(fn, "~/", 2) != 0))
            home = (Pchar)"";
    else
        fn++, len--;

    return( strncat( strcpy( zeromem(
        strlen(home) + len + 1), home), fn, len));
}

/* itoa - PC compatible routine.  Translates a number to its ASCII
 *   representation.
 *
 * Arguments
 * num - The number.
 * s - Pointer to where to put the ASCII representation
 * base - Not used
 *
 * Return
 * s.
 */

Pchar itoa(num, s, base)

int num;
Pchar s;
int base;

{
    sprintf(s, "%d", num);
    return(s);
}

/* GETCH - Get a character from the terminal.
 *
 * Argument:
 * flag - NO      - do a one char unformatted read
 *        YES     - do a formatted read into cmndbuf
 *
 * Return:
 *      for NO  - the character
 *      for YES - the input count
 */

int GETCH(flag)

register int flag;

{
    static int repoff = 0;

    if ((qterm == 0) && (repoff == 1)) {
        *outfcb |= 0x20000000;
        writraw (1, "\033[?8h", 5);    /* auto repeat on */
        *outfcb ^= 0x20000000;
        repoff = 0;
    }
    else if (repoff == 1) {
        *outfcb |= 0x20000000;
        writraw (1, "\033\042", 2);        /* unlock keyboard     */
        *outfcb ^= 0x20000000;
        repoff = 0;
    }
    if (flag == YES) {                                           /*005*/
       *infcb &= 0xdfafffff;        /* turn on formatting */     /*005*/
       bytebuf = readraw (0, cmndbuf, MAXLINE);                  /*005*/
       *infcb |= 0x20500000;        /* back to unformated */     /*005*/
    }                                                            /*005*/
    else {                                                       /*005*/
       *infcb |= 0x20500000;                /* make sure always unformated */
       if (readraw(0, &bytebuf, 1) < 1) {
           *infcb |= 0x00080000;  /* clear type ahead buffer next read */
           bytebuf = '\000';
       } else
           *infcb &= 0xfff7ffff;  /* reset clear type ahead flag */
    }                                                            /*005*/
    if (qterm == 0) {
       if (repoff == 0) {
          *outfcb |= 0x20000000;
          writraw (1, "\033[?8l", 5);    /* auto repeat off */
          *outfcb ^= 0x20000000;
       }
       if (bytebuf == '\033')
          repoff = 3;
       else if ((repoff == 3) && ((bytebuf == 'O') || (bytebuf == '[')))
          repoff = 2;
       else
          repoff = 1;
    }
    else {
       if (((bytebuf < ' ') && (bytebuf != 13)) || (bytebuf == DEL)){
          *outfcb |= 0x20000000;
          writraw (1, "\033\043", 2);        /* lock keybrd    */
          *outfcb ^= 0x20000000;
          repoff = 1;
       }
    }
    return(bytebuf);
}

/* rename - Simulate Ultrix, PC rename call using links and unlinks.
 *
 * Arguments
 * from - The old filename
 * to - The new filename
 *
 * Return
 * Zero if success, non-zero if failure.
 */

int rename(from, to)

register Pchar from, to;

{
    register int err;
    extern int         errno;

    errno = 0;
    err = link(strupr(from), strupr(to));

    return(err);
}

void cputs(s)

char *s;

{

    *outfcb |= 0x20000000;
    if ((ErrRowSt > 0) && (*s != '\007')) {
        if (*s == '\033') {
            if ((ErrRowSt == 1) && (*(s+1) == 'T')) {
                 writraw (1, "\033h\033f \015", 6);
            }
        }
        else if (*s >= ' ') {
            writraw (1, "\033f", 2);
            if (ErrColSt > 1)
                writraw (1, "                              ", 30);
            writraw (1, s, strlen(s));
            writraw (1, "\015", 1);
            ErrRowSt = 2;
        }
    }
    else {
        writraw(1, s, strlen(s));
    }
    *outfcb ^= 0x20000000;

    return;

}

