/* *********************************************************************
 *
 * $Header:  002  20-DEC-90 09:57  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)BUFFER.C                                    $
 * 
 *      Rev  002  20-DEC-90 09:57  GANN      GANN                       
 * Made some optimization calls.  Removed many redundant calls to       
 * doclock (BKGRND) and changed upshft to not call downshft.  This      
 * looked like a useless call that made an upshft take two or three     
 * times longer than it should have.                                    
 *
 *      Rev  001  11-OCT-88 14:06  GANN      GANN
 *  Version control header added
 */
/*
 */

#include "edt.h"
#include "scio.h"
#include "tokens.h"

#undef MEMSET
#undef MEMCPY
#define MEMSET(p, c, n) memswd ((int *)(p), (int)(c), ((int)(n)+3)/4)
#define MEMCPY(d, s, n) memcwd ((int *)(d), (int *)(s), ((int)(n)+3)/4)

void shrinkbuf(), bufcop();
long downshft(), upshft();

void buf2out(bp, lines)

register Bufctl *bp;
int lines;

{
    register LINE *lp;
    int  i;

    if ((lines <= 0) || ((lines > bp->lines) &&
        ((lines = bp->lines) <= 0)))
        return;

    opentemp(bp);

    for (i = 0; i < lines; i++)
    {
        lp = bp->buf[i];
        lp->lin[lp->len] = '\n';
        outtemp(bp->ofp, lp->lin, lp->len);

        FREE(lp);
    }

    if ((bp->lines -= lines) > 0)
        MEMCPY(bp->buf, bp->buf + lines, LINPSIZ(bp->lines));
    MEMSET(bp->buf + bp->lines, 0, LINPSIZ(lines));

#ifdef USEDIRTY
    bp->dirty0 = max(bp->dirty0-lines, 0 );
    bp->dirty1 = max(bp->dirty1-lines, 0 );
#endif

    bp->line1is += lines;

    if ((bp->curlin -= lines) <= 0)
        bp->curlin = 1;

    /* go set screen if in memory */
    setscreen(bp);

/*002     BKGRND;*/

    return;
}

in2buf(bp, lines)

Bufctl *bp;
int  lines;

{
    register LINE **bpbuf;
    int  i;
    SEEK  cin;
    int  more = 0;

    if (lines > (i = bp->avlines - bp->lines))
        lines = i;

    if ((lines <= 0) || (bp->fp == NULL))
        return(0);

    loadflag = YES;
    bpbuf = bp->buf + bp->lines;
    for (i = 0, lines++; --lines; bpbuf++, i++)
    {
        /* nospace */
        if ((*bpbuf = (LINE *)MALLOC(MAXLINE)) == LNULL)
            break;
        FREE(*bpbuf); /* free temp buffer */
        if ((more = fetchlin(bp->fp)) < 0)
            break; /* no data left */
        else if ((*bpbuf = getline(NEWIT, more)) == LNULL)
        {
			cprintf("Mem alloc error in in2buf, %u bytes, retrying\n",more);
/*            memerr("in2buf", more);   should not happen */
                break;
            }
            else
                strnzcpy((*bpbuf)->lin, actlin, more);
        }
        loadflag = NO;

        *bpbuf = LNULL;
        bp->lines += i;

        if (more < 0)
        {
            bp->totlines = LASTL(bp);
            if (bp->multipas)
                blast(&bp->fp, &bp->fname);
            else
            {
                fclose(bp->fp);
                bp->fname = NULL;
                bp->fp = NULL;
            }
        }

        return(i);
    }

/* REALLMEM plays with memory to squeeze your needs in
 *
 * Arguments
 * size = the number of bytes needed
 */
    Pchar reallmem(size)

    int size;

    {
        register Bufctl **u;
        register Pchar p;
        Pchar  shrink();

        for (u = user, p = zeromem(size);
            (p == NULL) && (*u != NULL); u++)
                p = shrink(*u, (int)size);

        if(p == NULL)
            memerr("reallmem", size);

        return(p);
    } /* end reallmem */

    Pchar shrink(bp, needed)

    Bufctl *bp;
    int   needed;

    {
        int  downto;
        long  line1is;
        long  absrow = bp->line1is + bp->curlin;
        int  relcol = bp->curchr;
        register Pchar p;

        if (bp->lines <= 0)
            return((needed < 0) ? (Pchar)1 : NULL);

        while ((downto = (bp->curlin - 1) - (2 * scrowmax)) > 1)
        {
            if (downto > PAGEOUT)
                downto = PAGEOUT;
            buf2out(bp, downto);
            shrinkbuf(bp, bp->avlines - (downto / 2));
            if (needed < 0)
                return(0);

            if ((p = zeromem(needed)) != NULL)
                return(p);
        }

        if (bp->avlines <= MINBUFSIZE)
            return((needed < 0) ? (Pchar)1 : NULL);

        /* Take drastic action */

        line1is = bp->line1is;

        passthru(bp, YES);   /* Output rest of file */
        shrinkbuf(bp, MINBUFSIZE);  /* Shrink bp->buf */
        bp->line1is = line1is;   /* Want to come back here */
        passthru(bp, NO);   /* Back to where we were */
        in2buf(bp, INCLINES);   /* Read in reduced buffer */
        bp->curchr = relcol;   /* Back to old column position */
        bp->curlin = absrow - line1is;  /* New position in buffer */

        return((needed >= 0) ? zeromem(needed) : (Pchar)0);
    }

#ifndef shrinkbuf
    void shrinkbuf(b, size)

    Bufctl *b;
    int  size;

    {
        if ((size >= b->avlines) || (size <= 0) || (size <= b->lines)
            || (b->avlines <= MINBUFSIZE) || (size < MINBUFSIZE))
            return;

        b->avlines = size;
        if ((b->buf = (LINE **)REALLOC(b->buf,
        LINPSIZ(++size))) == NULL)
            memerr("shrinkbuf", size);

        if ((size -= b->lines) > 0)
            MEMSET(b->buf + b->lines, 0, LINPSIZ(size));

        /* set screen if lines in memory */
        setscreen(b);

        return;
    }
#endif

    int chkpage(bp, needed)

    Bufctl *bp;
    int  needed;

    {
        LINE  **holdbuf = bp->buf;
        register int howmuch;

/*002         BKGRND;*/

        if((howmuch = bp->avlines - bp->lines) >= (INCLINES + needed))
            /* Do nothing */;
        else if((bp->buf = (LINE **)REALLOC(bp->buf,
        LINPSIZ(bp->avlines + INCLINES + 1))) != NULL)
        {
            MEMSET(bp->buf + bp->avlines, 0, LINPSIZ(INCLINES + 1));
            bp->avlines += INCLINES;

            /* set screen array if lines in memory */
            setscreen(bp);

            howmuch += INCLINES;
        }
        else if ((bp->buf = (LINE **)HEYrealloc(holdbuf,
        LINPSIZ(bp->avlines + 1))) == NULL)
            bailout("REALLOC failed in chkpage");

        return(howmuch);
    }

/* CHKSHFT adjusts the buffer window up/down if needed
 *    called from tstcur & qqgoto
 *
 * Arguments
 * bp = the buffer in question
 * inrow= absolute line to be moved to
 *
 * Returns
 * A pointer to the requested line
 */

Line *chkshft(bp, inrow)

    Bufctl *bp;
    long  inrow;

    {
        if ((bp == NULL) || (bp->buf == NULL))
            return(LNULL);

        if (inrow == 0)
            inrow = 1;

        if (inrow <= bp->line1is)
            inrow = upshft(bp, inrow);

        if (inrow > LASTL(bp))
            inrow = downshft(bp, inrow);

        tstcc();   /* May never return, if ^C hit */

        return(bp->buf[(bp->curlin = inrow - bp->line1is) - 1]);
    }

    long upshft(bp, in)

    Bufctl *bp;
    long  in;

    {
        BKGRND;

        if (in < 1)
            in = 1;
        if (in > bp->line1is)
            return(0L);

#ifndef USEDIRTY
        passthru(bp, YES);
#else
        if (!bp->dirty0)
            zerobuf(bp);
        else
            passthru(bp, YES);
#endif

/*002         shrinkbuf(bp, MINBUFSIZE);*/

/*002         return(downshft(bp, in));*/
         return (in);                                            /*002*/
    } /* end of upshft */

    long downshft( bp, in )

    Bufctl *bp;
    long   in;

    {
        register int needed;
        long  lines, i;
        long  deltatop = (in - bp->line1is) - scrowmax;
        register int added;

        BKGRND;                                                  /*002*/

        if (in > bp->totlines)
            in = bp->totlines + 1;

        if (bp->fp == NULL)
            return(in);

        lines = in - LASTL(bp);

        i = 0L;
        while (i < lines)
        {
            tstcc();  /* May never return if ^C hit */

            needed = chkpage(bp, 0);
            if ((i += (added = in2buf(bp, needed))) >= lines)
                break;

            if ((added < needed) || (needed == 0))
                if( bp->fp == NULL )
                    break;
                else
                {
                    bp->curlin = bp->lines;
                    if ((deltatop -= PAGEOUT) >= 0)
                        buf2out(bp, PAGEOUT);
                    else if ((needed = deltatop + PAGEOUT) > 0)
                        buf2out(bp, needed);
                    else if (deltatop <= 0)
                        FREE(reallmem(BUFSIZ)); /* Simplistic */
                }
        }

        return(min(in, bp->totlines + 1));
    } /* end of downshft */

/* INITBUF takes a bufctrl pointer as an argument and sets up the
 *    needed space.  Killing the program if allocation is not
 *    possible.
 * Argument
 *  bp = the old buffer if any
 * flag = 0 - free buffer
 *        1 - reset buffer
 *        3 - Set up new buffer
 * bname = name of buffer
 */

    Bufctl *initbuf(flag, bp, bname)

    int  flag;
    Bufctl *bp;
    Pchar  bname;

    {
        Pchar  p;
        register int i;
        Bufctl  *icur;

        icur = current;

        BKGRND;

        if (flag == NEWIT)
        {
            if ((i = userbufs) == MAXUSERS)
            {
                errorout("Unable to open more than %d buffers",
                MAXUSERS);
                return((Bufctl *)NULL);
            }

            bp = user[i] =
                (Bufctl *)reallmem((unsigned)sizeof(Bufctl));
            user[++userbufs] = NULL;
        }
        else
        {
#ifdef DEBUG
            if (bp == NULL)
                bailout("Initbuf called with null pointer");
#endif

            if (flag != QUITING)
            {
#ifdef KEEP_ALIVE
                for (i = 0; i < bp->lines; i++)
#else
                    for (i = 0; i < bp->lines; i++)
#endif
                        if ((flag >= FREEIT) ||
                            ((p = MALLOC(EXBUFSIZ)) == NULL))
                            FREE(bp->buf[i]);
                        else
                        {
                            FREE(p);
                            break;
                        }

                FREE(bp->buf);
                FREE(bp->bufnam);

                if ((flag != REALIT) && (icur == bp))
                    icur = maine;
            }

            blast(&bp->fp, &bp->fname);
            blast(&bp->ofp, &bp->ofname);

            i = getbufl(bp);

            if (flag > FREEIT)
                MEMSET(bp, '\0', sizeof(Bufctl)); /* Clear out buffer */
            else
            { /* Free entire buffer, delete it from buffer list */
                BKGRND;
                MEMCPY(user + i, user + i + 1,
                sizeof(Bufctl *) * (userbufs - i));
                FREE(bp);  /* Back to the pool */
                userbufs--;  /* One less buffer */

                return(icur);  /* Return if <= FREE */
            }
        }

        BKGRND;

#ifdef DEBUG
        if (i == -1)
            bailout("Buffer confusion in Initbuf");
#endif

/* Please note that if bp->bufnam is the third argument, and if this
 * is the MAIN or PASTE buffer, then there can exist a time during
 * which "bname" is actually not allocated memory if the flag
 * was FREEIT or REALIT.
 */

        getbname(&bname, -1);
        bp->bufnam = strdup(tmplin);

        bp->avlines = INCLINES;
        bp->buf = (LINE **)reallmem((unsigned)LINPSIZ(INCLINES + 1));

        bp->selrow = -1;
        bp->selcol = -1;
        bp->curlin = bp->curchr = 1;
        bp->dirty0 = 1;
        lastbuf = current;
        current = icur;

        return(bp);
    }

    void passthru(bp, whole)

    Bufctl *bp;
    int  whole;

    {
        register int i;
        long  totl;
        long  lines = MAXBUFLINES + 1;
        extern BUFFER inbuf, outbuf;

        if (whole)
            buf2out(bp, bp->lines);
        else
            lines = bp->line1is;

        opentemp(bp);

        if (bp->fp != NULL)
        {
            totl = LASTL(bp);
            while ((lines-- > 0) && ((i = fetchlin(bp->fp)) >= 0))
            {
                totl++;
                outtemp(bp->ofp, actlin, i);
                tstcc();  /* may not return */                   /*002*/
            }

            if (whole)
            {
                fclose(bp->fp);
                bp->totlines = totl;
            }
        }

        if (whole)
        {
            if (bp->multipas && (bp->fname != NULL))
            {
                unlink(bp->fname);
                FREE(bp->fname);
            }

            fzclose(bp->ofp);
            bp->ofp = NULL;
/*002             BKGRND;*/
            if ((bp->fp = fopen(bp->fname =
                bp->ofname, readbin)) == NULL)
                foerr("passthru", bp->fname);
            setbuf(bp->fp, inbuf.filebuf);
            bp->ofname = NULL;
            outbuf.fp = NULL;
            zerobuf(bp);
            bp->multipas = bp->dirty0 = YES;
        }

        return;
    }

/* DELBLOK moves a section of lines someplace
 *
 * Arguments
 * rpin = range of rows to be deleted
 * rpout = Output range if any
 * delflag = YES if you should delete the lines
 */

    long delblok(rpin, rpout, delflag)

    Range *rpin;
    Range  *rpout;
    int  delflag;

    {
        register Bufctl *bp = rpin->bp;
        LINE  *lp;
        long  i = 0;
        int  len;
        extern long chars1, lines, chars2;
        long  scldel();

        redraw = YES;

        lines = i = rpin->l1 - rpin->l0; /* Calculate how many lines */

        if (rpout != NULL)   /* != NULL means copy/move operation */
        {
            qqgoto(rpout);

            i++;
            absrow = rpin->l0 - 1;

            while (--i)
            {
                if ((lp = chkshft(bp, ++absrow)) == LNULL)
                    break;
                if ((len = lp->len) > 0)
                    MEMCPY(tmplin, lp->lin, len);
                lminsc(tmplin, len);
            }

            i = lines - i;
        }

        if (delflag)
        {
            bp = frccur(bp, rpin->l0, 1); /* Position "cursor" */
            i = scldel(lines, LNULL);
            if (bp != rpin->bp)
                frccur(rpin->bp, 0, 0);
        }

        return(i);
    }

    lminsc(lin, len)

    Pchar lin;
    int len;

    {
        register LINE **bpbuf;
        register LINE *lp;
        int  lines;

        lp = getline(NEWIT, len);
        strnzcpy(lp->lin, lin, len);

        needlines(current, 1);

        bpbuf = current->buf + row - 1;

        if ((lines = (1 + current->lines - row)) > 0)
            MEMCPY(bpbuf + 1, bpbuf, LINPSIZ(lines));

        *bpbuf = lp;
        current->dirty0 = YES;
        ADDTOT(current, 1);
        current->lines++;
        row++;

        redraw = YES;
        return;
    }

    zerobuf(bp)

    Bufctl *bp;

    {
        register LINE **bpbuf;

        BKGRND;
        for (bpbuf = bp->buf - 1, bp->lines++; --bp->lines > 0; )
            if (*++bpbuf != NULL)
            {
                FREE(*bpbuf);
                *bpbuf = LNULL;
            }

        bp->curlin = bp->curchr = 1;
        bp->line1is = 0L;

        if (bp->fp != NULL)
            fseek(bp->fp, 0L, 0);
/*002         BKGRND;*/

        return;
    }

    void needlines(b, num)

    Bufctl *b;
    int num;

    {
        int  l;
        Pchar  p = NULL;

        while ((l = (b->lines + num)) > b->avlines)
            if (chkpage(b, num) >= num)
                continue;
            else if (!shrink(b, -num))
                continue;
            else if ((p == NULL) &&
                ((p = reallmem(LINPSIZ(b->avlines
                + num + 1))) != NULL))
                FREE(p);
            else
                break;

        if (l > current->avlines)
            memerr("needlines", num);

        b->dirty0 = YES;

        return;
    }

    Bufctl *FrcCur(bp, inrow, incol)

    Bufctl *bp;
    long  inrow, incol;

    {
        Bufctl  *oldcur = current;

        current = bp;
        absrow = bp->line1is + bp->curlin;
        sccol = bp->curchr;
        scsetcur(ABSADDR, inrow, ((incol & ~ADDFLAG) ? incol : sccol));

        return(oldcur);
    }

    /*
     * setscreen
     * used to set screen array pointer and here if bp is current
     * buffer and lines are actually in memory.
     */

     setscreen(bp)
     Bufctl *bp;

     {

       if (bp != current)return;       /* exit if not current buffer */

       /* exit if top line of screen not in memory */
       if ((bp->line1is + bp->lines) < bp->sctopl)return;

       /* lines are in screen array, set screen pointer and here */
       screen = bp->buf + bp->sctopl - bp->line1is;
       here = screen[scrow - 1];
       return;
     }
