/* *********************************************************************
 *
 * $Header:  012  25-NOV-91 10:30  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)EDT.C                                       $
 * 
 *      Rev  012  25-NOV-91 10:30  GANN      GANN                       
 * Changed so that /NOVERSION also negates /VNUMBER and /VNUMBER        
 * ensures that /VERSION is set.                                        
 *
 *      Rev  011  25-NOV-91 10:11  GANN      GANN
 * Changed to append _JOU instead of .JOU to input filename to
 * create journal file name.  This allows us to create a journal
 * file on a remote VAX.
 *
 *      Rev  010  17-SEP-91 10:13  GANN      GANN
 * Changed to make sure that the owner of the output files
 * as all access to them.
 *
 *      Rev  009  21-AUG-91 11:53  GANN      GANN
 * Changed to preserve the filename specified on the /OUTPUT
 * qualifier, if there is one.
 *
 *      Rev  008  29-JUL-91 14:45  GANN      GANN
 * Changed to leave the version number on the input file name.
 * This is to fix the /VNUMBER option but works OK for /NOVNUMBER
 * since the input filename is not used again.  For /VNUMBER, the
 * BYE command causes EDT to overwrite the input file (and version)
 * The version number is still stripped from the output file name.
 *
 *      Rev  007  02-JUL-91 19:02  GANN      GANN
 * Added new mode where the output file has a version number.
 * This is controlled by command line option /VNUMBER.
 *
 *      Rev  006  20-DEC-90 09:59  GANN      GANN
 * Removed BS that was originally intended for the DCL-64 interface.
 *
 *      Rev  005  09-FEB-89 17:17  GANN      GANN
 * Added parsing for parameter /MULTI_NATIONAL. Also added
 * code in init to make all Televideo FUNCTION keys NULLs if
 * the terminal is a VT220 and MULTI_NATIONAL keys are indicated
 * The multi-national character set is numerically 128-255, the
 * same as the range we use for Televideo FUNCTION keys.
 *
 *      Rev  004  20-JAN-89 14:54  GANN      GANN
 * Changed to set input line length to max while reading
 * the init files. This prevents /MAXCOLUMN=n from truncating
 * init lines and causing errors.
 *
 *      Rev  003  20-JAN-89 09:29  GANN      GANN
 * Added support for qualifiers /READ_ONLY and /NOOUTPUT.
 * Fix for SPR's 10*337 and 10*430.
 *
 *      Rev  002  16-NOV-88 08:58  GANN      GANN
 * Comment out references to pckeyremap and kbremap. These
 * are not used any more and are undefined.
 *
 *      Rev  001  11-OCT-88 14:06  GANN      GANN
 *  Version control header added
 */
/*
 */

#include "edt.h"
#include "scio.h"
#include "tokens.h"
#include "signal.h"
#include "types.h"
#include "stat.h"
#include "errno.h"

Pchar getpath(), mpxfile(), dclfile();
static int dclflag = 0;
static int do_outfile = 1;                                       /*003*/

/*   the main program takes runtime options for
 *   file names and certain other general settings
 */

main(argc, argv)

int argc;          /* arg counter */
Pchar *argv;       /* array of char pointers */

{
    register int didsomething;
    extern jmp_buf cmd_loop;
    extern int errno;
    extern int criterr;
    extern char repstore[];
    extern int *infcb;
    extern int *outfcb;
    extern Pchar repcount;

    extern int *fcbadr();
    void  rst_all();
    void  initmem();

    int l, len;
    Pchar p;
    int  regs[8];           /* mpx regs */
    static char filecom[64]= {
        "/COMMAND=\0"       };
    static char filejou[64]= {
        "/JOURNAL=\0"       };
    static char fileout[64]= {
        "/OUTPUT=\0"        };
 static double dummy;
 static char tie[24] = {
  "\033TIE    GET_TERM XXXX"};
 static int  tiebits[2] = {0,0};

/* We must get our memory first */
    initmem();

/* see if edt.exe is name, i.e. is there a . in name? */
    if (strchr(*argv, '.')) dclflag = 1;

/* see if 7E?? at end of command line. MPX 3.2B bug. If so,
   delete last argv and decr argc. */

#ifdef JUNK
    if (argc > 2) {
       mpxsvc(0x104c, regs, regs);     /* get program option word */
       if (regs[7] & 0x0200) {   /* if no option 10, no print */
          setbuf(stderr, NULL);  /*   . . .       */
          fprintf(stderr, "Third entry deleted, %s\n", argv[argc-1]);
          getchar();  /* wait for c/r */
          mpxsvc(0x1063, regs,regs);  /* call debugger */
       }
    }
#endif

    if (strlen(argv[argc-1]) == 4) {
        if ((isxdigit(argv[argc-1][0])) &&
            (isxdigit(argv[argc-1][1])) &&
            (isxdigit(argv[argc-1][2])) &&
            (isxdigit(argv[argc-1][3])) ) {
            mpxsvc(0x104c, regs, regs);     /* get program option word */
            if (regs[7] & 0x0200) {   /* if no option 10, no print */
                setbuf(stderr, NULL);  /*   . . .       */
                fprintf(stderr, "Command line entry deleted, %s\n",
                    argv[argc-1]);
                getchar();  /* wait for c/r */
            }
            argv[argc-1] = 0;
            argc--;
        }
    }

/* see if we can find out terminal type from tie */

 writraw(1, tie, 32); /* get get term type */

/* if nothing in tiebits, tie not on system. use vt100 */

 qkeybrd = 0;                                                    /*005*/
 if (tiebits[0]) {
    if (tiebits[0] & 0x20000000) {
        qterm = 0;      /* we have an ansi terminal (vt100, vt220, etc.)*/
    }
    else {              /* we have tv921 or ascii */
        if ((toupper(tie[16]) == 'T') && (toupper(tie[17]) == 'V')) {
            qterm = 1;        /* We have televideo */
            qkeybrd = 921;    /* assume tv921 keyboard (also 955)*/
            if (((toupper(tie[19]) == '5') && (toupper (tie[20]) == '0')) ||
                ((toupper(tie[20]) == '5') && (toupper (tie[21]) == '0')))
                qkeybrd = 950;
        }
        else        /* must be ascii */
            qterm = 2;
    }
 }
/* setcmd - routine to set up command line for edt when edt is
 *          activated via dcl-64 and not tsm.
 */

/*    mpxsvc(0x104c, regs, regs);        /* get program option word */
/*    if (regs[7] == 0)return;           /* if no options, return */
/*    if (regs[7] & 0x0001)argv[argc++]="/NOCOMMAND"; /* option 1 */
/*    if (regs[7] & 0x0002)argv[argc++]="/NOCREATE";  /* option 2 */
/*    if (regs[7] & 0x0004)argv[argc++]="/NOJOURNAL";  /* option 3 */
/*    if (regs[7] & 0x0008)argv[argc++]="/NOOUTPUT";  /* option 4 */
/*    if (regs[7] & 0x0010)argv[argc++]="/RECOVER";   /* option 5 */
/*    if (regs[7] & 0x0020)argv[argc++]="/NOVERSION";  /* option 6 */
/*    if (regs[7] & 0x0040)argv[argc++]="/VT100";    /* option 7 */
/*    if (regs[7] & 0x0080)argv[argc++]="/TV921";    /* option 8 */
/*    if (regs[7] & 0x0100)argv[argc++]="/ASCII";    /* option 9 */
/*    if (regs[7] & 0x0200)argv[argc++]="/VT220";    /* option 11 */
/*    if (regs[7] & 0x0400)argv[argc++]="/TV950";    /* option 12 */


    /* now see what file codes are assigned */
/*006     regs[1] = ('C' << 16) | ('O' << 8) | ('M');*/
/*006     regs[4] = (54 << 24) | (int)&filecom[9];*/
/*006     regs[7] = 0;*/
/*006     mpxsvc(0x202F, regs, regs);*/
/*006     if (regs[7] == 0) {*/
/*006         p = (Pchar)(regs[4] & 0xffffff);*/
/*006         len = regs[4] >> 24;*/
/*006         for (l=0; len--; l++)filecom[l+9] = p[l];*/
/*006         filecom[(regs[4] >> 24) + 9 ] = NULL;*/
/*006         argv[argc++] = filecom;*/
/*006         mpxsvc(0x2053, regs, regs);   /* deallocate resource */
/*006     }*/
/*006     regs[1] = ('J' << 16) | ('O' << 8) | ('U');*/
/*006     regs[4] = (54 << 24) | (int)&filejou[9];*/
/*006     regs[7] = 0;*/
/*006     mpxsvc(0x202F, regs, regs);*/
/*006     if (regs[7] == 0) {*/
/*006         p = (Pchar)(regs[4] & 0xffffff);*/
/*006         len = regs[4] >> 24;*/
/*006         for (l=0; len--; l++)filejou[l+9] = p[l];*/
/*006         filejou[(regs[4] >> 24) + 9 ] = NULL;*/
/*006         argv[argc++] = filejou;*/
/*006         mpxsvc(0x2053, regs, regs);   /* deallocate resource */
/*006     }*/
/*006     regs[1] = ('O' << 16) | ('U' << 8) | ('T');*/
/*006     regs[4] = (54 << 24) | (int)&fileout[8];*/
/*006     regs[7] = 0;*/
/*006     mpxsvc(0x202F, regs, regs);*/
/*006     if (regs[7] == 0) {*/
/*006         p = (Pchar)(regs[4] & 0xffffff);*/
/*006         len = regs[4] >> 24;*/
/*006         for (l=0; len--; l++)fileout[l+8] = p[l];*/
/*006         fileout[(regs[4] >> 24) + 8 ] = NULL;*/
/*006         argv[argc++] = fileout;*/
/*006         mpxsvc(0x2053, regs, regs);   /* deallocate resource */
/*006     }*/
    argv[argc] = (char *)NULL;

    infcb = fcbadr(0)+2;
    outfcb = fcbadr(1)+2;
    *outfcb |= 0x20000000;

    init(argv);  /* Set up the default session */

    infcb = fcbadr(0)+2;
    outfcb = fcbadr(1)+2;
    *outfcb |= 0x20000000;

    /* here is where the fun begins..  set-up is out of the way */

    setjmp(cmd_loop);
    didsomething = NO;

    while (YES)
    {
        if (ctrlc_hit)
            errorout("BREAK ignored");
        criterr = ctrlc_hit = redraw = NO;

        if (!qmode)
        {
            if (qdmode)
            {
                qdmode = NO;
                scposcur(scmsgrow, 1);
            }

            if (!qverify || !qmacro)
                cprintf("\r\n%s", qprolin);
            comprom = 1;
            linecmnd(getcmnd(EOL));
        }
        else if (qkeypad)
        {
            if (qdmode)
            {
                qdmode = NO;
                ERAEDSP(scmsgrow, 1);
            }

#ifdef ISC     /* Temporary until non-blocking read */
            scqeat(-1);
            if (repcount == repstore)
                scposcur(0, 0);
#endif

            if (winkey(-1)) {
                didsomething = keyact();    /* Perform function bound to key */
                if (stdwhat == jfp)
                    scqeat(-1);  /* Display if journalling */
            }
#ifndef ISC    /* Temporary until non-blocking read */
            else
            {
                /* dowork(YES); */
                if (!scqeat(2) && didsomething)
                    scposcur(0, 0);
                didsomething = NO;
            }
#endif
        }
        else
        {
            scprintf(scmsgrow, 1, 0, qpronok);
            getcmnd(EOL);
            qqnokey(cmndbuf, YES);
            scqeat(-1);
        }
    }
} /* end of main program */

/**********************************
 * INIT does all of the run-time default set-up
 */

Pchar npinfile; /* input file name only */
static Pchar direct;

init(argv)

register Pchar *argv;

{
    int  i, l, len;
    int  *xcess;
    static  char  dirstore[64];
    Pchar  oldfile;
    register Pchar p, cptr;
    struct stat statbuf;
    extern unsigned qchmod;
/*002     extern int pckeyremap[];      */
    extern BUFFER inbuf;
    extern Pchar qqmore;
    int  ctrlc();
    int  skill();
    int  errout();
    int *getacc();
    int  setacc();
    int  access();
    int  tqmaxcol;                                               /*004*/
    void  optcheck();
    Pchar  getdefenv();
    void  initerr();
    int regs[8];
    extern int *fcbadr();
    extern Pchar helptxtfile;

    signal(SIGINT, skill);             /* kill till ready to go */
    signal(SIGKILL, errout);           /* MPX abort receiver */
    cmndfile = CMNDFILE;
    cmndsys = CMNDSYS;
    oldfile  = OLDFILE;
    helpfile = helptxtfile;

    optcheck(argv);   /* Read command line */

    shift();   /* set up keyboard, as we like it */

    holdit++;
    iniclk();  /* Start up clock, but don't do "Working" yet */
    HELLO();   /* Initialize various things */

    setbuf(stdin, NULL);  /* Don't need buffers for these guys */
    setbuf(stdout, NULL);  /*   . . .       */
    setbuf(stderr, NULL);  /*   . . .       */

    *(direct = dirstore) = '\000';
    /* See if there is any path preceding the file name to use in
         * finding associated files.
         * Otherwise, just use current directory.
         */

    /* make sure there is a edtold.edt file here */
    close(creat(oldfile,0));

    if ((jfp = fopen(oldfile, "r")) != NULL)
    {
        regs[1] = *fcbadr(fileno(jfp));
        regs[7] = 0;   /* no cnp */
        regs[4] = (64 << 24) | (int)dirstore;
        mpxsvc(0x202f, regs, regs);    /* reconstruct pathname */
        p = (Pchar)(regs[4] & 0xffffff);
        len = regs[4] >> 24;
        for (l=0; len--; l++)dirstore[l] = p[l];
        direct[regs[4] >> 24] = 0;

        if ((p = strrchr(direct, ')')) != NULL)
            p[1] = '\0';
        else
            direct[0] = '\000';  /* No specific path */
        fclose(jfp);
    } else direct[0] = '\000';  /* No specific path */

    initfuncs();

/*002     if (ATON() != 252)*/
/*002         kbremap(pckeyremap);  Set up as a PC */

    /* Set up MAIN and PASTE buffers.
     * MAIN is current and last buffer, too
     */

    userbufs = 0;
    lastbuf = current = maine =
        initbuf(NEWIT, (BUFCTRL *)NULL, "MAIN");
    paste = initbuf(NEWIT, (BUFCTRL *)NULL, "PASTE");

    if (qterm > 0) {                    /* not vt100 */
        funs [8] = "-C";                /* redefine ctrl/h */
        funs [11] = "-V";                /* redefine ctrl/k */
        funs [12] = "+C";                /* redefine ctrl/l */
        if (qkeybrd == 950) {            /* 950, remap some keys */
            funs [ESC_OFF+'R']                 = "GOLD";
            funs [ESC_OFF+'T']                 = "HELP";
            funs [ESC_OFF+'7']                 = "D+NL";
            funs [GOLD_OFF+ESC_OFF+'7']        = "UNDL";
        }
        if (qterm == 2) {                /* dumb ascii terminal */
            funs [10] = "+V";            /* use ctrl/j for down arrow */
            funs [22] = "DBW";            /* use ctrl/v for delete beg. word */
        }
    }
    else {                              /* on VT220's, 128-255     MOD*/
        for (i=128; i<256; i++)         /* are valid chars, turn   MOD*/
            funs [i] = NULL;            /* off TV921 functions     MOD*/
    }

    for (i = 0; i < FUNSIZE; i++) {
        if (funs[i] != NULL) {
            funs[i] = strdup(funs[i]);
        }
    }

/* Ignore any max column settings while reading init files      */

    tqmaxcol = qmaxcol;                                          /*004*/
    qmaxcol = MAXLINE;                                           /*004*/

/* Read the system command file, if any     */

    if ((stdwhat = fopen(cmndsys,  readbin)) != NULL)    {

        qmacro = YES;

        while ((len = fetchlin(stdwhat)) >= 0)
            if((actlin[0] != '!') && (len != 0))
                qmode = qlexem(actlin, len);

        fzclose(stdwhat);
        qmacro = NO;
    }

    stdwhat = stdin;
    FREE(cmndsys);
    cmndsys  = NULL;

/* read the user command file if any */

    if ((stdwhat = fopen(cmndfile, readbin)) != NULL)    {
        qmacro = YES;

        while ((len = fetchlin(stdwhat)) >= 0)
            if((actlin[0] != '!') && (len != 0))
                qmode = qlexem(actlin, len);

        fzclose(stdwhat);
        qmacro = NO;
    }

    stdwhat = stdin;
    FREE(cmndfile);
    cmndfile = NULL;

/* Reset max column     */

    qmaxcol = tqmaxcol;                                        /*004*/

    if ((infile == NULL) && qold)
        if ((jfp = fopen(oldfile, "r"))  != NULL)
        {
            if (fetchlin(jfp) <= 0)
                infile = NULL;
            else
                infile = strdup(actlin);
            fzclose(jfp);
        }

    ERAEDSP(1, 1);

    while (infile == NULL)
    {
        offshift();
        cprintf("Enter input file name: ");
        if ((i = fetchlin(stdin)) > 0)
            infile = strdup(actlin);
        else exit (0);
        shift();
    }

    /* convert file name to mpx and if only filename add curr dir */

    p = infile = mpxfile(infile);
    if (strrchr(infile, ')') == NULL) {
       infile = getpath(infile);
       FREE(p);
    }
    /* get access rights of input file to use for output files */
    if ((xcess = getacc(infile)) > 0) {
        if (((xcess [0] & 0x78000000) != 0x078000000) &&         /*010*/
            (qvnum == 0)) do_outfile = 0;                        /*010*/
        xcess [0] |= 0xF8400000; /* ensure full access for me */ /*010*/
        setacc(xcess[0], xcess[1], xcess[2]);
    }
    else setacc(0,0,0);

    /* save the file name for next time */

    if (qold) {
        if ((jfp = fopen(oldfile, "w")) != NULL)
        {
            fwrite(infile, 1, strlen(infile), jfp);
            fclose(jfp);
        }
    } else unlink(oldfile);

    scdoscr(2, 1, 1, scerrrow, MAXSCCOL);

    if (qbanner) {
        helpscreen(); /* Show the help screen, if asked for */
        offshift();
        shift();
        ERAEDSP(1,1);
        scmovcur(1,1);
        botclr = redraw = YES;
    }

    /* Display lines at the bottom of the screen */

    scmovcur(scrowmax, 1);
    qdcolor = qscolor;
    dispvers();
    qdcolor = qcolor;
    qqmore = strend(qqserial) + 1;

    maine->fname = strdup(infile);
    orgfile = strdup(infile); /* save original name */
    strcpy(tmplin, infile);

    if ((p = strrchr(tmplin, *dir_sep)) != NULL)
        p[1] = '\0';
    else
        *tmplin = '\0';

    inflpref = strdup(tmplin);

    if ((p = strrchr(infile, ')')) != NULL)
            npinfile = strdup(++p);
    else
        npinfile = strdup(infile);
    strcpy(tmplin, npinfile);


/* use actual path of input file for output file */

    if (do_outfile) {                                            /*003*/

/* use input file name but strip version number if any */

       if (outfile == NULL) {                                    /*009*/
          outfile = strdup (infile);                             /*009*/
          l = strlen(outfile);                                   /*009*/
          if ((isdigit(outfile[l-1])) &&                         /*009*/
              (isdigit(outfile[l-2])) &&                         /*009*/
              (isdigit(outfile[l-3])) &&                         /*009*/
              (outfile[l-4] == '.'))  l -= 4;                    /*009*/
          outfile[l] = '\000';                                   /*009*/

/* convert file name to mpx and if only filename add curr dir */

       } else {                                                  /*009*/
          p = outfile = mpxfile(outfile);                        /*009*/
          if (strrchr(outfile, ')') == NULL) {                   /*009*/
             outfile = getpath(outfile);                         /*009*/
             FREE(p);                                            /*009*/
          }                                                      /*009*/
       }                                                         /*009*/
    }                                                            /*003*/

/* Get the journal file name. */

    if (qjournal) {
        if (jrnlfile == NULL) {
            l = strlen(tmplin);
            if ((isdigit(tmplin[l-1])) && (isdigit(tmplin[l-2])) &&
                (isdigit(tmplin[l-3])) && (tmplin[l-4] == '.'))l -= 4;
            tmplin[l] = '\000';
            if (l > 12) {
                offshift();
                cprintf("Enter Journal file name: ");
                if ((i = fetchlin(stdin)) > 0)
                    jrnlfile = mpxfile(actlin);
                else exit (0);
                shift();
            }
            else addext(tmplin, "_JOU", &jrnlfile);
        }

        p = jrnlfile = mpxfile(jrnlfile);
        if (strrchr(jrnlfile, ')') == NULL) {
            jrnlfile = getpath(jrnlfile);
            FREE(p);
        }
        if ((infile != NULL) && (jrnlfile != NULL) &&
            (strcmpi(infile, jrnlfile) == 0))
        {
            qjournal = 0;
            FREE(jrnlfile);
            jrnlfile = NULL;
            jfp = NULL;
        }
        else if ((!qrecover) && (access(jrnlfile) >= 0)) {
            offshift();
            cprintf("Journal file exists, overwrite? ");
            if ((i = fetchlin(stdin)) > 0)
                if(toupper(actlin[0]) != 'Y') exit (0);
            else if (i == 0) exit (0);
            else if (i < -1) exit (0);
            shift();
        }
        else if ((jfp = fopen(jrnlfile,
        qrecover ? readwritebin : writebin)) == NULL)
            /* Issue error and exit */
            initerr("\nCan't open journal file");
        else
            setbuf(jfp, NULL);    /* No buffering needed */

        if(jfp != NULL)fclose(jfp);   /* close so we can reopen unblocke
        /* open unblocked, random access file */
        jfp = (FILE *)mpxopen(jrnlfile, qrecover ? "a" : "w");
        if(jfp == NULL)initerr("\nCan't write to journal file");
    } /* end of journal file */

    if ((maine->fp = fopen(maine->fname, readbin)) != NULL)
    {
        if  (stat(fileno(maine->fp), &statbuf) == 0)
            qchmod = statbuf.st_mode;
        setbuf(maine->fp, inbuf.filebuf);
        maine->totlines = MAXBUFLINES;
        in2buf(maine, maine->avlines); /* fill main buffer */
    }
    else if (stat(maine->fname, &statbuf), errno != ENOENT)
        initerr("Error opening file \"%s\"", maine->fname);
    else if (qfnf) errorout("Input file does not exist");

    scsetcur(USEBUF, 1, 1);
    shift();
    signal(SIGINT, ctrlc);             /* Trap Breaks */

    if (qmode)
        scref(scrowmax);

    qdmode = NO;
    clrlines = YES;

    if (qrecover)
        stdwhat = jfp;

    return;
}

Pchar getpath(file)  /* return pointer to full pathname of file in */
                     /* current directory */
Pchar file;

{
    extern Pchar direct;

    return (strcat (strcpy( zeromem( strlen(direct) + strlen(file))
       , direct), file, strlen(file)));
}

Pchar mpxfile(file)  /* make filename into MPX filename */

Pchar file;

{
    char name[64];
    Pchar np = name;
    char ch;
    int iver = 0;

    if (strchr(file , ':'))
        *np++ = '@';
    strupr(file);

    while (ch = *file++)
        switch (ch) {
        case ':':
        case ' ':
           break;
        case ';':
           if (*file && (*file != ' ')) {
               iver = 0;
               while (((ch = *file++) >= '0') && (ch <= '9'))
                   iver = 10 * iver + (ch - '0');
               file--;
               if (iver) {
                   *np++ = '.';
                   *np++ = iver / 100 + '0';
                   *np++ = (iver % 100) / 10 + '0';
                   *np++ = iver % 10 + '0';
               }
           }
           break;
        case '[':
           *np++ = '^';
           *np++ = '(';
/* ----- must add code to handle [- and [-. and [. */
           break;
        case ']':
           *np++ = ')';
           break;
        case '.':
           if ((*file == ';') || (*file == NULL))break;
        case '@':
        case '(':
        case ')':
        default:
           *np++ = ch;
        }
    *np = 0;
    return (strcpy( zeromem( strlen(name)), name));
}
Pchar dclfile(file)  /* make MPX filename into DCL filename */

Pchar file;

{
    static char name[64];
    Pchar np = name;
    char ch;
    extern int dclflag;
    int l;

    if (dclflag == 0)return(file);
    while (ch = *file++)
        switch (ch) {
        case ' ':
        case '@':
        case '^':
           break;
        case '(':
           *np++ = ':';
           *np++ = '[';
           break;
        case ')':
           *np++ = ']';
           break;
        default:
           *np++ = ch;
        }
    *np = 0;
    l = strlen(name);
    if ((isdigit(name[l-1])) && (isdigit(name[l-2])) &&
        (isdigit(name[l-3])) && (name[l-4] == '.'))name[l-4] = ';';
    return (name);
}

Pchar getdefenv(envname, defname)

Pchar envname;
Pchar defname;

{
    Pchar p;

    if ((p = getenv(envname)) == NULL)
        p = defname;

    return(unixfile(p, strlen(p)));  /* Convert "~"'s to home dir */
}

static void optcheck(argv)

register Pchar *argv;

{
    register Pchar p;
    void  initerr();

    infile = outfile = NULL;

    while (*++argv)
    {
        if ((p = strchr(*argv, switch_char)) != NULL)
            *p = '\000';

        if (p != *argv)
            if (infile == NULL)
                infile = *argv;
            else
                initerr("Invalid argument to EDT, %s\n", *argv);

        if ((p == NULL) || (*++p == '\000'))
            continue;

        strcpy(cmndbuf, p);
        cmndptr = 0;
        cmndend = strlen(cmndbuf);

        do
            {
            if (isword(lw[S_OUTPUT].kw, lw[S_OUTPUT].kl))
                cmndptr++, outfile = filecmnd();
            if (isword(lw[S_NOOUTPUT].kw, lw[S_NOOUTPUT].kl))    /*003*/
                do_outfile = 0;                                  /*003*/
            if (isword(lw[S_READO].kw, lw[S_READO].kl))          /*003*/
                do_outfile = 0, qjournal = 0;                    /*003*/
            if (isword(lw[S_NOCOMM].kw, lw[S_NOCOMM].kl))
                cmndfile = NULL;
            if (isword(lw[S_COMMAN].kw, lw[S_COMMAN].kl))
                cmndptr++, cmndfile = filecmnd();
            if (isword(lw[S_JOURNA].kw, lw[S_JOURNA].kl))
                cmndptr++, jrnlfile = filecmnd();
            if (isword(lw[S_NOJOUR].kw, lw[S_NOJOUR].kl))
                qjournal = 0;
            if (isword(lw[S_NOVERS].kw, lw[S_NOVERS].kl)) {      /*012*/
                qvers = 0;
                qvnum = 0;                                       /*012*/
            }                                                    /*012*/
            if (isword(lw[S_VERSIO].kw, lw[S_VERSIO].kl))
                qvers = 1;
            if (isword(lw[S_NOVNUM].kw, lw[S_NOVNUM].kl))        /*012*/
                qvnum = 0;                                       /*007*/
            if (isword(lw[S_VNUMBR].kw, lw[S_VNUMBR].kl)) {      /*012*/
                qvnum = 1;                                       /*007*/
                qvers = 1;                                       /*012*/
            }
            if (isword(lw[S_NOEDTOLD].kw, lw[S_NOEDTOLD].kl))
                qold = 0;
            if (isword(lw[S_EDTOLD].kw, lw[S_EDTOLD].kl))
                qold = 1;
            if (isword(lw[S_RECOVE].kw, lw[S_RECOVE].kl) &&
                ((qrecover = isnum()) == 0))
                qrecover = -1;
            if (isword(lw[S_VT100].kw, lw[S_VT100].kl))
                qterm = 0;  /* terminal is vt100 */
            if (isword(lw[S_TV921].kw, lw[S_TV921].kl)) {
                qterm = 1;  /* terminal is tv921 */
                qkeybrd = 921;
            }
            if (isword(lw[S_VT220].kw, lw[S_VT220].kl))
                qterm = 0;  /* terminal is vt100 */
            if (isword(lw[S_TV950].kw, lw[S_TV950].kl)) {
                qterm = 1;  /* terminal is tv921 */
                qkeybrd = 950;
            }
            if (isword(lw[S_ASCII].kw, lw[S_ASCII].kl))
                qterm = 2;  /* terminal is ASCII */
            if (isword(lw[S_MAXCOL].kw, lw[S_MAXCOL].kl)) {
                while (isalpha(cmndbuf[cmndptr++]));
                if(((qmaxcol = isnum()) < 1) ||
                    (qmaxcol > MAXLINE)) qmaxcol = MAXLINE;
            }
            if (isword(lw[S_MULTINAT].kw, lw[S_MULTINAT].kl))    /*005*/
                qkeybrd = 128;  /* terminal has foreign keyboard   MOD*/
        }
        while (cmndbuf[cmndptr++] == switch_char);

        if (cmndbuf[cmndptr-1] != 0)
            initerr("Invalid option \"%s\"", cmndbuf + cmndptr - 1);
    }

    return;
}

/* VARARGS */
static void initerr(fmt, arg)

Pchar fmt, arg;

{
    fprintf(stderr, fmt, arg);
    offshift();  /* reset keyboard */
    exit(0); /* no error for MPX */
}

int ctrlc()
{
    signal(SIGINT, ctrlc);
    if (++ctrlc_hit >= 10)
        exit(-1);
    return;
}

int skill()    /* user break received during init, stop */
{
    signal(SIGINT, exit);
    initerr ("[Interrupt]\n");
}

/* Remap function keys */

/*002 void kbremap(remap)*/
/*002 int *remap;*/
/*002 {*/
/*002 }*/
