/* *********************************************************************
 * 
 * $Header:  001  11-OCT-88 14:07  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)EDTHELP.C                                   $
 * 
 *      Rev  001  11-OCT-88 14:07  GANN      GANN     
 *  Version control header added                                        
 */
/* 
 */

/* Defines for ISC */

#define ISC
#define UNIX
#define ULTRIX
#define MEMRTNS
#define ANSI

#define PRINTF cprintf(

#include "edt.h"
#include "scio.h"

#undef char
#undef malloc
#undef strcmpi

typedef struct helprec {
    long ind;
    char *helstr[5];
}
HELPREC;

extern HELPREC hr[];

Pchar helptxtfile = (Pchar)"@SYSTEM(DCL64.EDT)EDTHELP.TXT";
static FILE *hfp;

helpmain(argv)

Pchar *argv;

{
    int  i;
    register Pchar p;
    static char *help[] = {
        "HELP", NULL    };

    switch (qterm) {   /* switch on terminal type */
    case 0:        /* vt 100 */
        cputs("\033[H\033[J\n");
        break;
    case 1:        /* tv 921 */
        cputs("\036\033*"   );              /* clear, home */
        break;
    case 2:        /* ansi */
        cputs("\036\033*"   );              /* clear, home */
        break;
    }

    if (argv == (Pchar *)NULL)
        drawnice();  /* no command line options so draw the map */
    else   /* command line options */
    {
        /* Re-open help file as standard input */

        if ((hfp = fopen(helptxtfile, "r")) == NULL)
        {
            PRINTF "Unable to locate help text file: \"%s\"\r\n",
                dclfile(helptxtfile));
            return(-1);
        }

        /* Try to match command line arguments to linked-in arguments
         * corresponding to the help file, via dohelp.
         */

        if (dohelp(++argv) == 0)
            {
            /* Failed trying to get help.  Let them know. */

            /* HELP KEYPAD? */
            i = strncmp(*argv, "KEYPAD", strlen(*argv)) != 0;
            PRINTF "No help available for \"");

            for (;;)  /* Show him his input arguments again */
            {
                PRINTF *argv);
                if (*++argv == NULL)
                    break;
                else
                PRINTF " ");
            }
            PRINTF "\"\r\n"); /* New line */

            if (i)   /* If this was not "HELP KEYPAD ..." then */
                dohelp(help); /*  print out help available */
        }
        fclose(hfp); /* close the file */
    }

    return(0);
}

/* dohelp - Match input arguments to built-in EDTHELP arguments
 *     using EDT rules
 */

int dohelp(argv)

char **argv;

{
    int  n;
    int  i = 0;
    HELPREC  *h;
    register char **a, **hs;
    char obuf[1920];

    for (a = argv; *a != NULL; a++)
        strupr(*a);  /* Change all args to upper for easier compares */

    for (h = hr; *(hs = h->helstr) != NULL; h++)
    {
        a = argv;  /* Start fresh */

        do
            if (strcmp(*a, "*") == 0) /* Wild card? */
            if (strcmp(*hs, "*") != 0) /* Yup.  Beyond end of built-in? */
            continue;  /* Nope. This matches then. */
        else
            goto nomatch;  /* Yes.  Beyond end.  No match */
        else if (isdigit(**a))
            if (atoi(*a) == atoi(*hs))
            continue;
        else
            goto nomatch;
        else if (strncmp(*a, *hs, strlen(*a)) != 0)
            goto nomatch;  /* Strings not equal.  No match */
        while ((*++hs != NULL) && (*++a != NULL)); /* Loop until end */

        if ((*hs == NULL) || (**hs == '*'))
            {
            /* Found a match. Read the file and display help */

            i = h[1].ind - h->ind;
            fseek(hfp, h->ind, 0); /* Position file pointer */
            i = fread(obuf, sizeof(char), i, hfp);
            obuf[i] = '\000';
            cputs(obuf);
        }
nomatch:;    /* Seemed the cleanest way.  Sorry. */
    }

    return(i);  /* i != 0 if something reported */
}

static drawnice()
{
    /*
    * make a nice heading
    */
    switch (qterm) {   /* switch on terminal type */
    case 0:        /* vt 100 */

        cputs("\033[H\033[J");

        /*  Rainbow heading
            4-Aug-85 PIR

        The following escape sequences are used below:

            \033(0  -  select alternate graphics mode
            \033(B  -  select normal character mode
            \033[m -  turn off all attributes
            \033[7m -  reverse video

            Graphics mode characters

            q - horizontal bar
            t - T section rotated 90 degrees counter clockwise
            u - T section rotated 90 degrees clockwise
            v - T section rotated 180 degrees
            w - T section
            x - vertical bar
            j - lower right corner
            k - upper right corner
            l - upper left corner
            m - lower left corner
            n - + intersection
        */
cputs("\r\n\033(0lqqqqqqqqqqqqqqqqqqqqqqqk  ");
cputs("lqqqqqqqwqqqqqqqwqqqqqqqwqqqqqqqk");
cputs("\r\nx\033[7m                       \033[mx  x\033[7m       ");
cputs("\033[mx       x \033(BFndnxt\033(0x \033(BDel L\033(0 x");
cputs("\r\nx\033[7m          EDT          \033[mx  x\033[7m \033(B");
cputs("Gold\033(0  \033[mx \033(BHelp\033(0  x       x       x");
cputs("\r\nx\033[7m                       \033[mx  x\033[7m       ");
cputs("\033[mx       x \033(B\033[7mFind\033[m\033(0  x \033(B\033[7m");
cputs("Und L\033[m\033(0 x");
cputs("\r\nx\033[7m \033(BBy: International\033(0     \033[mx");
cputs("  tqqqqqqqnqqqqqqqnqqqqqqqnqqqqqqqu");
cputs("\r\nx\033[7m        \033(BSoftware\033(0       \033[mx  x ");
cputs("\033(BPage\033(0  x \033(BSect\033(0  x \033(BAppend\033(0x");
cputs(" \033(BDel W\033(0 x");
cputs("\r\nx\033[7m      \033(BCorporation\033(0      \033[mx  x");
cputs("       x       x       x       x");
cputs("\r\nx\033[7m                       \033[mx  x\033(B\033[7m");
cputs("Command\033[m\033(0x \033(B\033[7m");
cputs("Fill\033[m\033(0  x\033(B\033[7m");
cputs("Replace\033[m\033(0x \033(B\033[7mUnd W\033[m\033(0 x");
cputs("\r\nx\033[7m  \033(B                    \033(0 \033[mx");
cputs("  tqqqqqqqnqqqqqqqnqqqqqqqnqqqqqqqu");
cputs("\r\nx\033[7m                       \033[mx  x\033(B");
cputs("Advance\033(0x \033(BBackup\033(0x \033(BCut");
cputs("\033(0   x \033(BDel C\033(0 x");
cputs("\r\nx\033[7m  \033(BCopyright (C) 1988\033(0   \033[mx  x");
cputs("       x       x       x       x");
cputs("\r\nmqqqqqqqqqqqqqqqqqqqqqqqj  x");
cputs(" \033(B\033[7mBottom\033[m\033(0x");
cputs(" \033(B\033[7mTop\033[m\033(0   x");
cputs(" \033(B\033[7mPaste\033[m\033(0");
cputs(" x \033(B\033[7mUnd C\033[m\033(0 x");
cputs("\r\n        lqqqqqqqk          ");
cputs("tqqqqqqqnqqqqqqqnqqqqqqqnqqqqqqqu");
cputs("\r\n        x       x          x");
cputs(" \033(BWord\033(0  x \033(BEOL\033(0");
cputs("   x \033(BChar\033(0  x       x");
cputs("\r\n        x       x          x");
cputs("       x       x       x       x");
cputs("\r\n        x  \033(BUp\033(0   ");
cputs("x          x\033(B\033[7mChgcase");
cputs("\033[m\033(0x\033(B\033[7mDel EOL\033[m\033(0x\033(B\033[7m");
cputs("Specins\033[m\033(0x \033(BEnter\033(0 x");
cputs("\r\nlqqqqqqqnqqqqqqqnqqqqqqqk  ");
cputs("tqqqqqqqvqqqqqqqnqqqqqqqu       x");
cputs("\r\nx       x       x       x  x      \033(BLine\033(0     x");
cputs("\033(BSelect\033(0 x       x");
cputs("\r\nx       x       x       x  x");
cputs("               x       x       x");
cputs("\r\nx \033(BLeft\033(0  x \033(BDown\033(0  x \033(BRight");
cputs("\033(0 x  x    \033(B\033[7mOpen Line");
cputs("\033[m\033(0  x \033(B\033[7mReset");
cputs("\033[m\033(0 x \033(B\033[7mSubs\033[m\033(0  x");
cputs("\r\nmqqqqqqqvqqqqqqqvqqqqqqqj");
cputs("  mqqqqqqqqqqqqqqqvqqqqqqqvqqqqqqqj\033(B\r\n");
        break;  /* end of terminal switch, case 0 */

    case 1:  /* tv921 terminal */

        cputs("\036\033*"   );              /* clear, home */

        /*  Rainbow heading
            4-Aug-85 PIR

        The following escape sequences are used below:

            \033$  -  select alternate graphics mode
            \033%  -  select normal character mode
            \033G0 -  turn off all attributes
            \033G4 -  reverse video

            Graphics mode characters

            K - horizontal bar
            M - T section rotated 90 degrees counter clockwise
            L - T section rotated 90 degrees clockwise
            O - T section rotated 180 degrees
            N - T section
            J - vertical bar
            H - lower right corner
            G - upper right corner
            F - upper left corner
            E - lower left corner
            I - + intersection
        */

	if (qkeybrd == 950) {

cputs ("\r\n\033$FKKKKKKKKKKKKKKKKKKKKKKG  FKKKKKKKKKKG   ");
cputs ("FKKKKKKKKKKNKKKKKKKKKKNKKKKKKKKKKG");

cputs ("\r\nJ\033%\033G4                    \033G0\033$J  J");
cputs ("\033%\033G4  Gold  \033G0\033$J   J\033%");
cputs ("   Help   \033$J\033%  Fndnxt  \033$J\033%  Del L   \033$J");

cputs ("\r\nJ\033%\033G4        EDT         \033G0\033$J  J\033%\033G4      ");
cputs ("  \033G0\033$J   J          J\033%\033G4  Find  \033G0\033$J");
cputs ("\033%\033G4 Und L  \033G0\033$J");

cputs ("\r\nJ\033%\033G4                    \033G0\033$J  EKKKKKKKKKKH   ");
cputs ("MKKKKKKKKKKIKKKKKKKKKKIKKKKKKKKKKL");

cputs ("\r\nJ\033%\033G4 By: International  \033G0\033$J                 J");
cputs ("\033%   Page   \033$J\033%   Sect   \033$J\033%  Append  \033$J");

cputs ("\r\nJ\033%\033G4        Software    \033G0\033$J                 J");
cputs ("\033%\033G4Command \033G0\033$J\033%\033G4  Fill  \033G0\033$J");
cputs ("\033%\033G4Replace \033G0\033$J");

cputs ("\r\nJ\033%\033G4      Corporation   \033G0\033$J                 ");
cputs ("MKKKKKKKKKKIKKKKKKKKKKIKKKKKKKKKKL");

cputs ("\r\nJ\033%\033G4                    \033G0\033$J                 J");
cputs ("\033% Advance  \033$J\033%  Backup  \033$J\033%   Cut    \033$J");

cputs ("\r\nJ\033%\033G4                    \033G0\033$J                 J");
cputs ("\033%\033G4 Bottom \033G0\033$J\033%\033G4  Top   \033G0\033$J");
cputs ("\033%\033G4 Paste  \033G0\033$J");

cputs ("\r\nJ\033%\033G4 Copyright (C) 1988 \033G0\033$J                 ");
cputs ("MKKKKKKKKKKIKKKKKKKKKKIKKKKKKKKKKL");

cputs ("\r\nEKKKKKKKKKKKKKKKKKKKKKKH                 J\033%");
cputs ("   Word   \033$J\033%    EOL   \033$J\033%   Char   \033$J");

cputs ("\r\n                                         J\033%\033G4");
cputs ("Chg Case\033G0\033$J\033%\033G4Del EOL \033G0\033$J\033%\033G4");
cputs ("Spec Ins\033G0\033$J");

cputs ("\r\n\033%Hold FUNCT key down when                 \033$");
cputs ("MKKKKKKKKKKIKKKKKKKKKKIKKKKKKKKKKL");

cputs ("\r\n\033%hitting keypad character                 \033$J\033%");
cputs ("  Del C   \033$J\033%   Line   \033$J\033%   SEL    \033$J");

cputs ("\r\n                                         J\033%");
cputs ("\033G4 Und C  \033G0\033$J\033%\033G4OpenLine\033G0\033$J");
cputs ("\033%\033G4 Reset  \033G0\033$J");

cputs ("\r\nFKKKKKKKKNKKKKKKKKNKKKKKKKKNKKKKKKKKG    ");
cputs ("MKKKKKKKKKKOKKKKNKKKKKOKKKKNKKKKKH");

cputs ("\r\nJ\033%  Down  \033$J\033%   Up   \033$J\033%  Left  \033$J");
cputs ("\033% Right  \033$J    J\033%     Enter     \033$J\033%  Del W   ");
cputs ("\033$J");

cputs ("\r\nJ        J        J        J        J    J\033%");
cputs ("\033G4     Subs    \033G0\033$J");
cputs ("\033%\033G4 Und W  \033G0\033$J");

cputs ("\r\nEKKKKKKKKOKKKKKKKKOKKKKKKKKOKKKKKKKKH    ");
cputs ("EKKKKKKKKKKKKKKKOKKKKKKKKKKH\033%\r\n");
	}
	else {

cputs("\r\033T\r\n\033$FKKKKKKKKKKKKKKKKKKKKKKKG  ");
cputs("FKKKKKKKNKKKKKKKNKKKKKKKNKKKKKKKNKKKKKKKG");
cputs("\r\nJ\033G4                       \033G0J  J\033G4       ");
cputs("\033G0J       J \033%Fndnxt\033$J \033%Del L\033$ J");
cputs(" \033%Do Not\033$J");
cputs("\r\nJ\033G4          \033%EDT\033$          \033G0J  J");
cputs("\033G4 \033%");
cputs("Gold\033$  \033G0J \033%Help\033$  J       J       J       J");
cputs("\r\nJ\033G4                       \033G0J  J\033G4       ");
cputs("\033G0J       J \033%\033G4Find\033G0\033$  J \033%\033G4");
cputs("Und L\033G0\033$ J  \033%Use\033$  J");
cputs("\r\nJ\033G4 \033%By: International\033$     \033G0J");
cputs("  MKKKKKKKIKKKKKKKIKKKKKKKIKKKKKKKIKKKKKKKL");
cputs("\r\nJ\033G4        \033%Software\033$       \033G0J  J");
cputs("       J ");
cputs("\033%Page\033$  J \033%Sect\033$  J \033%Append\033$J");
cputs(" \033%Del W\033$ J");
cputs("\r\nJ\033G4      \033%Corporation\033$      \033G0J  J");
cputs("       J       J       J       J       J");
cputs("\r\nJ\033G4                       \033G0J  J");
cputs("   \033%T\033$   J\033%\033G4");
cputs("Command\033G0\033$J \033%\033G4");
cputs("Fill\033G0\033$  J\033%\033G4");
cputs("Replace\033G0\033$J \033%\033G4Und W\033G0\033$ J");
cputs("\r\nJ\033G4                       \033G0J");
cputs("  J   \033%A\033$   MKKKKKKKIKKKKKKKIKKKKKKKIKKKKKKKL");
cputs("\r\nJ\033G4                       \033G0J  J");
cputs("   \033%B\033$   J\033%");
cputs("Advance\033$J \033%Backup\033$J \033%Cut");
cputs("\033$   J \033%Del C\033$ J");
cputs("\r\nJ\033G4  \033%Copyright (C) 1988\033$   \033G0J  J");
cputs("       J       J       J       J       J");
cputs("\r\nEKKKKKKKKKKKKKKKKKKKKKKKH  J       J");
cputs(" \033%\033G4Bottom\033G0\033$J");
cputs("  \033%\033G4Top\033G0\033$  J");
cputs(" \033%\033G4Paste\033G0\033$");
cputs(" J \033%\033G4Und C\033G0\033$ J");
cputs("\r\n                           ");
cputs("MKKKKKKKIKKKKKKKIKKKKKKKIKKKKKKKIKKKKKKKL");
cputs("\r\n\033%Hold FUNCT key down when\033$   J  \033%Back\033$ J");
cputs(" \033%Word\033$  J \033%EOL\033$");
cputs("   J \033%Char\033$  J       J");
cputs("\r\n\033%hitting keypad character\033$   J");
cputs("       J       J       J       J       J");
cputs("\r\n                           J");
cputs(" \033%Space\033$ J\033%\033G4Chgcase");
cputs("\033G0\033$J\033%\033G4Del EOL\033G0\033$J\033%\033G4");
cputs("Specins\033G0\033$J \033%Enter\033$ J");
cputs("\r\nFKKKKKNKKKKKNKKKKKNKKKKKG  ");
cputs("MKKKKKKKOKKKKKKKIKKKKKKKIKKKKKKKL       J");
cputs("\r\nJ     J     J     J     J  J      \033%Line\033$     J");
cputs("  \033%Not\033$  J\033%Select\033$ J       J");
cputs("\r\nJ  \033%L\033$  J  \033%D\033$  J");
cputs("  \033%U\033$  J  \033%R\033$  J");
cputs("  J               J       J       J       J");
cputs("\r\nJ     J     J     J     J");
cputs("  J   \033%\033G4Open Line");
cputs("\033G0\033$   J \033%Used\033$  J \033%\033G4Reset");
cputs("\033G0\033$ J \033%\033G4Subs\033G0\033$  J");
cputs("\r\nEKKKKKOKKKKKOKKKKKOKKKKKH");
cputs("  EKKKKKKKKKKKKKKKOKKKKKKKOKKKKKKKOKKKKKKKH\033%\r\n");
	} /* end of keyboard switch */
        break;  /* end of terminal switch, case 1 */
                /* end of terminal switch, case 2 */
    case 2:  /* ascii terminal */
cputs ("\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
cputs ("\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
cputs ("\r\n+--------------------+    +--------+--------+--------+--------+");
cputs ("\r\n|                    |    |  Gold  |  Help  | Fndnxt |  Del L |");
cputs ("\r\n|        EDT         |    |   G    |   H    |   F    |   L    |");
cputs ("\r\n|                    |    |        |        |  Find  |  Und L  ");
cputs ("\r\n| By: International  |    +--------+--------+--------+--------+");
cputs ("\r\n|        Software    |    |  Page  |  Sect  | Append |  Del W |");
cputs ("\r\n|      Corporation   |    |   7    |   8    |   9    |   -    |");
cputs ("\r\n|                    |    | Command|  Fill  | Replace|  Und W |");
cputs ("\r\n|                    |    +--------+--------+--------+--------+");
cputs ("\r\n| Copyright (C) 1988 |    | Advance| Backup |   Cut  |  Del C |");
cputs ("\r\n|                    |    |   4    |   5    |   6    |   ,    |");
cputs ("\r\n+--------------------+    | Bottom |   Top  |  Paste |  Und C |");
cputs ("\r\n                          +--------+--------+--------+--------+");
cputs ("\r\n Press ESC and key for    |  Word  |   EOL  |  Char  |        |");
cputs ("\r\n top functions.           |   1    |   2    |   3    |        |");
cputs ("\r\n                          |Chg Case| Del EOL|Spec Ins|  Enter |");
cputs ("\r\n Press ESC G ESC and key  +-----------------+--------+        |");
cputs ("\r\n for bottom functions.    |      Line       | Select |  Return|");
cputs ("\r\n                          |       0         |   .    |        |");
cputs ("\r\n                          |   Open Line     |  Reset |  Subs  |");
cputs ("\r\n                          +-----------------+--------+--------+");
cputs ("\r\n");
		break;

    } /* end of switch */

    return;
} /* end draw nice */
