*       UNIX I/O SIMULATOR FOR MPX FILES      08-FEB-83 HEADER  UNIXIO.S
************************************************************************
*
*        RESTRICTED RIGHTS LEGEND
*
*        USE, DUPLICATION, OR DISCLOSURE IS SUBJECT TO THE RESTRICTIONS
*        STATED IN GOULD'S LICENSE AGREEMENT (FORM NO. 1218) OR, FOR
*        GOVERNMENT CUSTOMERS, DAR 7-104.9A.
*
************************************************************************
         SPACE     2
         PROGRAM   UNIX.IO         FILE:  UNIXIO
         DEF       VER.UNIO
         DEF       PRG.UNIO
VER.UNIO EQU       X'A003'
PRG.UNIO EQU       X'3860'
************************************************************************
*                                                                      *
*                   UNIXIO  CHANGE HISTORY                             *
*                                                                      *
************************************************************************
*   VER       DATE      BY             DESCRIPTION.                    *
************************************************************************
*                                                                      *
*  A000      02/08/83   JCB           GENERATE INITIAL MPX BLOCKED     *
*                                     FILE SUPPORT.                    *
*                                                                      *
*  A001      02/11/83   JCB           ADDED EOM SUPPORT AND GENERAL    *
*                                     FIXES FROM LANGUAGES GROUP.      *
*                                                                      *
*  A002      02/15/83   JCB           ADDED STANDARD MPX DEVICE        *
*                                     ASSIGNMENT SUPPORT.              *
*                                                                      *
*  A003      02/23/83   JCB           ADDED STANDARD MPX PARSING       *
*                                     LOGIC FOR ASSIGNMENTS FROM TSM.  *
*                                                                      *
************************************************************************
         SPACE      5
************************************************************************
*                                                                      *
*        G O U L D   S. E. L.   U N I X I O  S U B R O U T I N E S     *
*                                                                      *
*                         UNIX                                         *
*                                                                      *
*                     FEBRUARY 1983                                    *
*                                                                      *
************************************************************************
         LIST      ON,NOMAC,NOREP
         SPACE     2
************************************************************************
*   UNIX I/O EMULATION ROUTINES
************************************************************************
         SPACE     2
************************************************************************
*
*   THE UNIX I/O EMULATOR ROUTINES EMULATE THE UNIX I/O ENVIRONMENT
*   NECESSARY TO RUN THE C COMPILER TO BE PROVIDED BY BELL LABS.  THE
*   CALLING CONVENTIONS ARE GUESSED.  THE ARGUMENT LIST IS COPIED FROM
*   UNIX WITH THE EXCEPTION THAT CERTAIN ARGUMENTS ARE NOT USED OR
*   ONLY PARTIALLY USED.
*
*   THESE ROUTINES MAKE IT POSSIBLE TO READ, WRITE, SEEK, AND APPEND
*   MPX-32 BLOCKED FILES.  MAXIMUM TRANSFER COUNT IS LIMITED TO 254
*   BYTES.  SEEK TO BOM OR EOF ARE SUPPORTED.  MPX-32 COMPRESSED SOURCE
*   FILES ARE NOT SUPPORTED.  A LF (X'0A') IS APPENDED TO ALL LINES
*   READ.  LF'S ARE STRIPED FROM OUTPUT BEFORE WRITING.  NULL LINES
*   ARE WRITTEN AS ONE SPACE FOR MPX-32 COMPATABILITY.  THESE ROUTINES
*   ASSUME THAT BLOCKED FILES CONTAIN TEXT.  READING OTHER NON-TEXT
*   BLOCKED FILES MAY CAUSE UNDETERMINED RESULTS.
*
************************************************************************
         SPACE     2
*                                  PACKAGE CAN ACCESS THE FILE TABLE
         DEF       _open
         DEF       _fcbadr
         DEF       _close
         DEF       _creat
         DEF       _read
         DEF       _write
         DEF       _readraw
         DEF       _writraw
         DEF       _seek
         DEF       _isatty
         DEF       _access
         DEF       _fstat
         DEF       _link
         DEF       _unlink
*XXX     DEF       RM.OPEN
*XXX     DEF       RM.CLSE
*XXX     DEF       RM.READ
*XXX     DEF       RM.WRIT
*XXX     DEF       RM.ADVF
*XXX     DEF       RM.ADVR
*XXX     DEF       RM.RWND
*XXX     DEF       RM.BACK
         SPACE     2
************************************************************************
*   PROGRAM SIZING EQUATES
************************************************************************
         SPACE     1
FILECNT  EQU       10              OPEN FILE LIMIT
FCBSIZE  EQU       16W             FCB SIZE
PARMSIZE EQU       12W             FILE PARAMETERS SIZE
PNBSIZE  EQU       18W             PATHNAME BLOCK SIZE
PNBWSIZE EQU       2W              PATHNAME BLOCK VECTOR WORD SIZE
LINESIZE EQU       768             LINE BUFFER SIZE IN BYTES
FILESIZE EQU       FCBSIZE+PARMSIZE+PNBSIZE+PNBWSIZE+LINESIZE
*                                  FILE TABLE ENTRY SIZE
SIZER    SET       FILESIZE*FILECNT/4
_filtabl COMMON    >FILTABL(2400)
         SPACE     2
************************************************************************
*   REGISTER EQUATES
************************************************************************
         SPACE     1
AP       EQU       1              ARGUMENT POINTER
X1       EQU       1
X2       EQU       2              GENERAL INDEX NUMBER 1
SP       EQU       3              STACK POINTER
X3       EQU       3
         SPACE     1
R0       EQU       0              GENERAL REGISTER EQUATES
R1       EQU       1
R2       EQU       2
R3       EQU       3
R4       EQU       4
R5       EQU       5
R6       EQU       6
R7       EQU       7
         PAGE
************************************************************************
*   SYSTEM EQUATES                                                     *
************************************************************************
C.DTTA   EQU       X'00AA0'
C.DTTN   EQU       X'00CB1'
C.TSAD   EQU       X'00A80'
C.UDTA   EQU       X'00B38'
C.UDTN   EQU       X'00C38'
DFT.STB  EQU       X'00000'
DFT.ACF  EQU       X'00001'
DFT.FLGS EQU       X'00004'
RR.ACCS  EQU       X'00008'
RR.APPND EQU       X'00004'
RR.BLK   EQU       X'00004'
RR.DATE  EQU       X'00020'
RR.DENS  EQU       X'00006'
RR.DEV   EQU       X'00020'                                         3205
RR.DEVC  EQU       X'00003'
RR.DT3   EQU       X'00010'
RR.EXCL  EQU       X'00011'
RR.LFC   EQU       X'00000'
RR.LFC2  EQU       X'00004'
RR.MODFY EQU       X'00002'
RR.NAME1 EQU       X'00010'
RR.NBLKS EQU       X'00014'
RR.OPTS  EQU       X'0000C'
RR.PATH  EQU       X'00001'
RR.PLEN  EQU       X'00006'
RR.READ  EQU       X'00000'
RR.RID   EQU       X'00006'
RR.SBO   EQU       X'00003'
RR.SEP   EQU       X'0000F'                                         2129
RR.SFC   EQU       X'00008'
RR.SGO   EQU       X'00001'
RR.SHAR  EQU       X'00010'
RR.SIZE  EQU       X'00005'
RR.SLO   EQU       X'00002'
RR.SYC   EQU       X'00000'
RR.TEMP  EQU       X'00002'
RR.TYPE  EQU       X'00004'
RR.UNBLK EQU       X'00005'
RR.UNFID EQU       X'00014'
RR.UPDAT EQU       X'00003'
RR.VLNUM EQU       X'00011'
RR.WRITE EQU       X'00001'
UDT.SIZE EQU       X'00040'
UDT.STAT EQU       X'00004'
         PAGE
************************************************************************
*   DEVICE EQUATES                                                     *
************************************************************************
         SPACE     1
TERMINAL EQU       -1              FILE IS A TERMINAL
LINEPTR  EQU       1               FILE IS AN SLO FILE
NULL     EQU       2               FILE IS NULL
EOM      EQU       -2              FILE GOT EOM
         SPACE     4
************************************************************************
*   MODE EQUATES
************************************************************************
         SPACE     1
NOTUSED  EQU       55             FILE NOT IN USE
READMODE EQU       0              FILE IN READ MODE
WRITMODE EQU       1              FILE IN WRITE MODE
READWRIT EQU       2              FILE IN READ/WRITE MODE
RWE      EQU       7              FILE IN READ/WRITE/EXECUTE MODE
RD.ACC   EQU       X'80'           READ ACCESS                 A001
UPD.ACC  EQU       X'10'           UPDATE ACCESS               A001
         SPACE     2
************************************************************************
*   BLOCKED EQUATES
************************************************************************
         SPACE     1
UNBLOCK  EQU       0              FILE IS NOT BLOCKED
BLOCKED  EQU       1              FILE IS BLOCKED
         SPACE     2
************************************************************************
*   WRITTEN, EOF EQUATES
************************************************************************
         SPACE     1
FALSE    EQU       0
TRUE     EQU       1
         SPACE     2
************************************************************************
*   LOCAL MACROS
************************************************************************
         SPACE     1
ENTER    DEFM
         TRR       SP,R1           STACK PTR FOR CALLING FUNCTION
         ADI       SP,-8W          DECREMENT SP FOR CALLED ROUTINE A001
         STD       R0,2W,SP        STORE RETURN ADDR IN STACK & PREV. SP
         STF       R4,4W,SP        STORE REGS 4 THROUGH 7 IN STACK
         LA        AP,8W,R1        PUT ARG AREA ADDR IN AP
         STW       SP,SPSAVE      SAVE STACK POINTER
         STW       AP,APSAVE      SAVE COPY OF AP
         ENDM
         SPACE     1
RETURN   DEFM
         LW        SP,SPSAVE      RESTORE OLD STACK PTR FROM SPSAVE
         LF        R2,2W,SP        RESTORE REGISTERS FROM STACK
         TRR       SP,R3           RESTORE OLD STACK PTR TO R3
         TRSW      R2              RETURN TO CALLING ROUTINE
         ENDM
         SPACE     1
FIL      DEFM      UNIT,BUFFER
         DATAW     %UNIT
         REZ       7W
         DATAW     %BUFFER
         DATAW     LINESIZE
         REZ       6W
         DATAW     NOTUSED
         REZ       PARMSIZE-1W
         REZ       PNBSIZE
         REZ       PNBWSIZE
         REZ       LINESIZE
         ENDM
         SPACE     1
INDEX    DEFM      REG
         TRR       %REG,R5         SET UP FOR MULTIPLY
         MPI       R4,FILESIZE     GET OFFSET FROM START OF TABLE
         TRR       R5,%REG
         LA        R5,>FILTABL     BASE ADDRESS OF TABLE
         ADR       R5,%REG         ABSOLUTE ADDRESS OF DESIRED ENTRY
         ENDM
         PAGE
************************************************************************
*   FILE TABLE FIELD EQUATES
*
*   LINE           CONTAINS THE CURRENT DATA RECORD.
*
*   LINPTR         CONTAINS THE BYTE POSITION FOR THE NEXT BYTE TO
*                  BE TRANSFERRED TO OR FROM A LINE.
*
*   BLKPTR         CONTAINS THE CURRENT BLOCK POSITION IN THE FILE
*                  (ONLY USED IN UNBLOCKED MODE).
*
*   MODE           CONTAINS THE CURRENT ACCESS MODE OF THE FILE.  WRITE
*
*   BLOCK          CONTAINS THE INDICATION OF WHETHER THE FILE IS
*                  BLOCKED (MPX-32 SOURCE FILE) OR UNBLOCKED (UNIX
*                  STYLE FILE).
*
*   EOFPTR,EOLPTR  CONTAINS THE EOF BYTE POSITION (USED BY UNIX
*                  STYLE FILES), OR THE END OF CURRENT LINE POINTER
*                  (USED BY MPX-32 STYLE FILES).
*
*   EOF            INDICATION IF END OF FILE HAS BEEN ENCOUNTERED (USED
*                  BY MPX-32 STYLE FILES).
*
*   DEVICE         CONTAINS INDICATION IF DEVICE CANNOT BE TREATED LIKE
*                  A DISC FILE
*
*   FCB            CONTAINS A SHORT FCB.
*
************************************************************************
         SPACE     1
FCB      EQU       0W
MODE     EQU       FCBSIZE
LINPTR   EQU       FCBSIZE+1W
BLKPTR   EQU       FCBSIZE+2W
BLOCK    EQU       FCBSIZE+3W
EOFPTR   EQU       FCBSIZE+4W
EOLPTR   EQU       EOFPTR
EOF      EQU       FCBSIZE+5W
DEVICE   EQU       FCBSIZE+6W
FLAGS    EQU       FCBSIZE+7W      R.M. FLAGS FOR BLOCKED FILES
*        BIT 0     SET - THIS FCB USING RM ROUTINES
*                  RESET - USE STANDARD SVC'C
*        BIT 1     SET - THIS IS A COMPRESSED FILE
*                  RESET - STANDARD BLOCKED FILE
*
FLOC     EQU       FCBSIZE+8W      CURRENT OFFSET INTO FILE (BYTES)
CPTR     EQU       FCBSIZE+9W      POINTER INTO LINE FOR COMP FILES
SECTA    EQU       FCBSIZE+10W     CURRENT SECTOR ADDRESS FOR FILES
FREE1    EQU       FCBSIZE+11W     SPARE WORD
*                                  BOUNDING FOR THE PNB THAT FOLLOWS
PNB      EQU       FCBSIZE+PARMSIZE
PNBWORD  EQU       FCBSIZE+PARMSIZE+PNBSIZE
LINE     EQU       FCBSIZE+PARMSIZE+PNBSIZE+PNBWSIZE
         SPACE     2
************************************************************************
*    LINE FEED TCW
************************************************************************
         SPACE     1
         BOUND     1W
         CSECT
LFCHAR   DATAB     X'20'
ACMODES  DATAB     1,4,4           ACCESS MODES FOR RRS        A001
         PAGE
************************************************************************
*   VARIOUS CONTROL BLOCK EQUATES
************************************************************************
         SPACE     1
FCB.LFC  EQU       0W             LFC OFFSET IN FCB
FCB.TCW  EQU       1W             TCW LOC IN FCB
FCB.GCFG EQU       2W             GENERAL CONTROL FLAGS
FCB.CBRA EQU       5H             RANDOM ACCESS ADDRESS
FCB.SFLG EQU       3W             STATUS FLAGS
FCB.RECL EQU       4W             RECORD LENGTH
FCB.SPST EQU       6W             SPECIAL STATUS FLAGS
FCB.ERWA EQU       8W             EXPANDED DATA ADDRESS
FCB.EQTY EQU       9W             EXPANDED TRANSFER QUANTITY
FCB.IST1 EQU       11W            XIO STATUS WD 1
FCB.IST2 EQU       12W            XIO STATUS WD 2
FCB.XCT  EQU       9W             BYTE COUNT
FCB.XAD  EQU       8W             BUFFER ADDR
FCB.OPT  EQU       2W             OPTION OFFSET IN FCB
FCB.RAN  EQU       4              RANDOM ACCESS OPTION BIT
FCB.RAA  EQU       5H             RANDOM ACCESS ADDRESS OFFSET IN FCB
FCB.STAT EQU       12B            REQUEST STATUS OFFSET IN FCB
FCB.ERR  EQU       1              ERROR STATUS BIT
FCB.EOF  EQU       6              EOF STATUS BIT
FCB.EOM  EQU       7              EOM STATUS BIT
FCB.CNT  EQU       4W             TRANSFER COUNT OFFSET IN FCB
FCB.FAT  EQU       7W             FAT ADDRESS OFFSET IN FCB
FAT.BBUF EQU       10W            BLOCKING BUFFER ADDRESS OFFSET IN FAT
RD.TYPE  EQU       15H            RESOURCE TYPE OFFSET IN RD
RD.PERM  EQU       10             PERMANENT FILE RESOURCE
RD.FLAG  EQU       64W            RESOURCE FLAG WORD
RD.BLK   EQU       31             RESOURCE BLOCKED BIT
RD.USER  EQU       160W           USER AREA IN RD
RD.EOF   EQU       190W           EOF POINTER OFFSET IN RD
CP.OPTS  EQU       2W             OPTION FLAGS IN CNP
         SPACE     2
NEWLINE  EQU       X'0A'          NEW LINE CHARACTER (LINE FEED)
CR       EQU       X'0D'           CARRIAGE RETURN CHARACTER
         SPACE     2
************************************************************************
*   REGISTER SAVE AREA
************************************************************************
         SPACE     1
         BOUND     1D
         SPACE     2
************************************************************************
*
*   PROGRAMMING CONVENTIONS
*
*   1) THE ARGUMENT POINTER IS MAINTAINED IN REGISTER AP.  AP IS SAVED
*   AROUND CODE THAT MAY DESTROY IT, IN PARTICULAR, SVC'S.
*
*   2) THE FILE TABLE ENTRY ADDRESS IS TYPICALLY HELD IN REGISTER X2.
*   X2 IS REGENERATED AROUND CODE THAT MAY DESTROY IT, IN PARTICULAR,
*   SVC'S.
*
*   3) ALL ENTRIES INTO THIS PACKAGE ARE FUNCTIONS, THAT IS, THEY RETURN
*   A VALUE.  THE VALUE IS RETURNED IN R0.  ERRORS ARE GENERALLY
*   INDICATED BY -1.  SUCCESS IS GENERALLY INDICATED BY 0.  CREAT AND
*   OPEN RETURN THE FILE DESCRIPTOR TO SHOW SUCCESS.  WRITE RETURNS 0
*   TO INDICATE EOF DETECTED AND N(>0) TO INDICATE THE NUMBER OF
*   CHARACTERS ACTUALLY TRANSFERRED.
*
*   4) UTILITY SUBROUTINES EXPECT AP AND X2 TO BE PROPERLY INITIALIZED.
*   RESULTS ARE RETURNED IN R7.  ERRORS ARE GENERALLY INDICATED BY -1.
*   SUCCESS IS GENERALLY INDICATED BY 0.
*
************************************************************************
         PAGE
************************************************************************
*   CLOSE FILE
************************************************************************
         SPACE     1
_close   EQU       $
         ENTER                    SAVE REGISTERS ON STACK
         LW        X2,0W,AP       PICK UP FILE DESCRIPTOR
         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR
         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR
         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS
         LW        R4,MODE,X2     GET FILE MODE
         CI        R4,NOTUSED     IN USE?
         BEQ       ERRETURN       NOT USED, RETURN WITH ERROR
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         CI        R7,NULL        NULL FILE?
         BEQ       CLOS.0         YES, FINISH UP
         CI        R4,READMODE    ARE WE OUTPUT ACTIVE
         BEQ       CLOS.X          NO, JUST CLOSE
         LW        R4,LINPTR,X2    ANY CHARS LEFT IN BUFFER
         BZ        CLOS.Y          NO, JUST CLOSE IT
         BL        SETTCW          YES, PURGE IT
         BL        WRITLINU        WRIT IT
CLOS.Y   LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
*XXX     TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.WEOF        WEOF FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL WEOF
         SVC       1,X'38'        WRITE EOF
CLOS.X   LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
*XXX     TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.CLSE        CLSE FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL CLSE
         SVC       1,X'39'         CLOSE THE FILE
         ZR        R7             NO CNB
         SVC       2,X'53'        DEASSIGN FILE
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
*        TRR       R7,R7          TEST THE RETURN VALUE
*        BNE       ERRETURN       NON ZERO, RETURN WITH ERROR
CLOS.0   LI        R4,NOTUSED
         STW       R4,MODE,X2     RETURN FILE DESCRIPTOR TO POOL
         ZR        R0             INDICATE NO ERROR
         RETURN                   RETURN TO USER
         PAGE
************************************************************************
*   GET FCB ADDRESS
************************************************************************
         SPACE     1
_fcbadr  EQU       $               get fcb addr
         ENTER                    SAVE REGISTERS ON STACK
         LW        X2,0W,AP       PICK UP FILE DESCRIPTOR
         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR
         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR
         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         LW        R4,MODE,X2     GET FILE MODE
         CI        R4,NOTUSED     IN USE?
         BEQ       ERRETURN       NOT USED, RETURN WITH ERROR
         TRR       R2,R0           FCB ADDR TO R0 FOR RETURN
         RETURN                    RETURN ADDRESS TO CALLER
         PAGE
************************************************************************
*   CREATE FILE
************************************************************************
         SPACE     1
_creat   EQU       $
         ENTER                    SAVE REGISTERS ON STACK
         BL        PARSE          PARSE PATHNAME
         TRR       R7,R7          TEST THE RETURN VALUE
         BLT       ERRETURN       LESS THAN ZERO, RETURN WITH ERROR
         BGT       CREAT.2        ZERO PATHNAME LENGTH, GET FILE DESC
         BL        EXISTS         TEST IF THE FILE ALREADY EXISTS
         TRR       R7,R7          TEST THE RETURN VALUE
         BGE       CREAT.1        JUMP AHEAD IF FILE EXISTS
         LW        R1,PNBWRDX    GET PNB VECTOR WORD IN REGISTER FOR
*                                   SERVICE
*        ADD CODE HERE TO CREATE DIRECTORY IF PATH END WITH DIRECTORY
*
         LA        R2,RCB          CREATE PERMANENT FILE
         ZR        R7
         SVC       2,X'20'
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TRR       R7,R7          TEST THE RETURN VALUE
         BNE       ERRETURN       NON ZERO, RETURN WITH ERROR
CREAT.1  EQU       $
         BL        GETFD          GET FILE DESCRIPTOR
         TRR       R7,X2
         BLT       ERRETURN       NO FILE DESCRIPTORS, RETURN WITH ERROR
         STW       R7,0W,AP       SAVE THE FD AND TEST THE RETURN VALUE
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS
         LI        R4,LINESIZE    GET FULL CHARACTER COUNT
         BL        SETTCW         INITIALIZE TCW IN FCB
         BL        PNBSAVE        TUCK PATHNAME BLOCK AWAY
         LW        R4,FCB+FCB.LFC,X2
*                                 GET LFC
         SLL       R4,8
         SRL       R4,8           CLEAR OUT LEAD BYTE
         STW       R4,RRS+RR.LFC   SET LFC IN RRS
         ZMW       RRS+RR.TYPE     CLEAR PART OF RRS
         ZMW       RRS+RR.ACCS     CLEAR ACCESS
         ZMW       RRS+RR.OPTS     CLEAR OPTIONS
         LI        R5,1            TYPE 1 RRS
         STB       R5,RRS+RR.TYPE  PUT IN RRS
         LB        R5,PNBWRDX    GET PNB VECTOR WORD BYTE COUNT
         STB       R5,RRS+RR.PLEN
*                                 SET PATHNAME BLOCK SIZE IN RRS
         SRL       R5,2           DIVIDE COUNT BY 4 (TO GET WORDS)
         ADI       R5,RR.1.SIZ    ADD LENGTH OF RRS HEADER
         STB       R5,RRS+RR.SIZE  SET RRS SIZE IN RRS
*   FIX TO MAKE creat ASSIGN THE WITH PROPER ACCESS RIGHTS.  A001
         LI        R5,UPD.ACC      SET UPDATE ACCESS BIT       A001
         STB       R5,RRS+RR.ACCS     IN THE RRS               A001
         SBM       RR.SHAR,RRS+RR.OPTS  SET SHARED ACCESS
         LA        R1,RRS           ASSIGN LFC TO RESOURCE
         ZR        R7
         SVC       2,X'52'
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         TRR       R7,R7          TEST THE RETURN VALUE
         BNE       CR.ERR3        NON ZERO, RETURN WITH ERROR
         ZMW       FCB+FCB.OPT,X2 CLEAR FCB OPTION WORD
         SBM       6,FCB+FCB.OPT,X2  SET EXPANDED FCB
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         ZMH       CNP+CP.OPTS     OPEN DEFAULT MODE
         LI        R7,X'04'        SET UPDATE ACCESS IN CNP
         STB       R7,CNP+CP.OPTS  PUT IN CNP
         SBM       11,CNP+CP.OPTS  SET OPEN BLOCKED
*XXX     SBM       0,FLAGS,X2      SET USING RM FLAG
         ZBM       1,FLAGS,X2      NOT READING COMPRESSED YET
         SBR       R1,1            SET CC1 FOR R/W MODE FOR RM
*XXX     BL        RM.OPEN         OPEN VIA REC MGR
*XXX     TRR       R7,R7           ANY RM ERROR
*XXX     BNZ       CR.ERR2         GIVE IT TO CALLER
         LA        R7,CNP         SET UPDATE ACCESS WITH CNP
         SVC       2,X'42'        OPEN FILE
*XXX     BL        RM.WEOF        WRITE EOF
         SVC       1,X'38'         WRITE EOF TO FILE FOR APPEND MODE
*XXX     BL        RM.RWND         REWIND FILE
         SVC       1,X'37'         REWIND THE FILE
         LW        AP,APSAVE      RESTORE ARGUMENT  POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         ZMW       DEVICE,X2      NOT A SPECIAL DEVICE
         ZMW       BLKPTR,X2      SET BLOCK POINTER TO FIRST BLOCK
         ZMW       EOFPTR,X2      SET EOF POINTER TO FIRST CHARACTER
         ZMW       LINPTR,X2      SET LINE POINTER TO FIRST CHARACTER
         ZMW       FLOC,X2        FILE POSITION IS ZERO
         ZMW       CPTR,X2        NO DECOMPRESSING POINTER
         ZMW       SECTA,X2       NO SECTORS YET
         LI        R4,READWRIT
         STW       R4,MODE,X2     SET MODE TO READ/WRITE
         LI        R4,BLOCKED
         STW       R4,BLOCK,X2    SET FILE TYPE TO BLOCKED (MPX)
         BU        CRE.RET
*
* ALLOCATE THIS FILE DESCRIPTOR TO NULL DEVICE
*
CREAT.2  EQU       $
         BL        GETFD
         TRR       R7,X2
         BLT       ERRETURN       NO FILE DESCRIPTORS, RETURN WITH ERROR
         STW       R7,0W,AP
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         ZMW       FLAGS,X2       CLEAR FLAGS
         LI        R4,READWRIT
         STW       R4,MODE,X2     SET MODE TO READ/WRITE
         LI        R4,NULL        GET NULL DEVICE
         STW       R4,DEVICE,X2   SET FILE TO NULL FILE
         LI        R4,TRUE
         STW       R4,EOF,X2      SET END OF FILE STATUS
         LI        R4,BLOCKED
         STW       R4,BLOCK,X2    SET FILE TO BLOCKED MODE
CRE.RET  LW        R0,0W,AP       RETURN FILE DESCRIPTOR
         RETURN                   RETURN TO CALLER
CR.ERR2  LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         ZR        R7             NO CNB
         SVC       2,X'53'        DEASSIGN FILE
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
CR.ERR3  LI        R4,NOTUSED
         STW       R4,MODE,X2     RETURN FILE DESCRIPTOR TO POOL
         LI        R0,-1          INDICATE ERROR
         RETURN                   RETURN TO USER
         PAGE
************************************************************************
*   OPEN FILE
************************************************************************
         SPACE     1
_open    EQU       $
         ENTER                    SAVE REGISTERS ON STACK
         BL        CASSG          PARSE PATHNAME AND BUILD RRS
         BL        GETFD          GET FILE DESCRIPTOR
         TRR       R7,X2          TEST THE RETURN RESULT
         BLT       ERRETURN       NO FILE DESCRIPTORS, RETURN WITH ERROR
         LW        AP,APSAVE       RESTORE ARG POINTER
         STW       R7,0W,AP       SAVE THE FD AND TEST THE RETURN VALUE
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS
         LI        R4,LINESIZE    GET FULL CHARACTER COUNT
         BL        SETTCW         INITIALIZE TCW IN FCB
         LW        R4,FCB+FCB.LFC,X2
*                                 GET LFC
         SLL       R4,8
         SRL       R4,8           CLEAR OUT LEAD BYTE
         STW       R4,RRS+RR.LFC   SET LFC IN RRS
* FIX TO MAKE open ASSIGN FILE WITH PROPER ACCESS RIGHTS.      A001
         LW        AP,APSAVE       RESTORE ARG POINTER         A001
         LW        R5,1W,AP        GET OPEN MODE               A001
         CI        R5,READMODE     SEE IF READ                 A001
         BNE       OPEN.1          BR IF NOT                   A001
         LI        R5,RD.ACC       SET READ ACCESS BIT         A001
         LI        R4,READMODE    GET READ MODE TYPE
         BU        OPEN.2          MERGE CODE                  A001
OPEN.1   LI        R5,UPD.ACC      SET UPDATE ACCESS BIT       A001
         LI        R4,READWRIT     SET R/W MODE
OPEN.2   STB       R5,RRS+RR.ACCS  PUT IN RRS                  A001
         STW       R4,MODE,X2     SET MODE TO R/W OR R
         LB        R7,RRS+RR.TYPE  GET RRS TYPE
         CI        R7,4            SEE IF TYPE 4 (LFC=LFC)
         BNE       $+2W            BR IF NOT
         ZMB       RRS+RR.ACCS     CLEAR ACCESS BYTE
         ZR        R7              NO CNP
         LA        R1,RRS          GET ADDR OF RRS
         SVC       2,X'52'         ASSIGN RESOURCE
         LW        AP,APSAVE       RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE      RESTORE FILE TABLE ENTRY POINTER
         TRR       R7,R7           TEST RETURN CODE
         BNE       OPEN.ERR        RETURN WITH ERROR
         LA        R7,CNP          ASSUME FILE IF READ ONLY
         ZMH       CNP+CP.OPTS     OPEN DEFAULT MODE
         LI        R1,BLOCKED      OPENED BLOCKED
         SBM       11,CNP+CP.OPTS  SET OPEN BLOCKED
         TBM       RR.UNBLK,RRS+RR.OPTS  SEE IF UNBLOCKED SPECIFIED
         BNS       $+3W            BR IF NOT
         LI        R1,UNBLOCK      ASSUME UNBLOCKED FOR MOMENT
         ABM       11,CNP+CP.OPTS  SET UNBLOCKED OPEN
         STW       R1,BLOCK,R2     SET FOR LATER
         ZMW       FCB+FCB.OPT,X2 CLEAR FCB OPTION WORD
         SBM       6,FCB+FCB.OPT,X2  SET EXPANDED FCB
*XXX     CI        R1,UNBLOCK      IS FILE UNBLOCKED
*XXX     BEQ       OPEN.5          USE STD I/O IF YES
*XXX     LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
*XXX                              R7 SET TO CORRECT CNP ADDR
*XXX     TRR       R7,R0           SAVE CNP ADDRESS
*XXX     LW        R4,0W,R1        GET LFC
*XXX     ANMW      R4,=X'FFFFFF'   MASK IT
*XXX     LA        R1,INQ.INFO     SET UP INQUIRY INFO AREA
*XXX     ZR        R5              CLEAR R5
*XXX     ZR        R7              NO CNP
*XXX     SVC       2,X'48'         M.INQUIRY
*XXX     LW        R1,INQ.INFO+3W  GET DTT ADDRESS
*XXX     LB        R6,0,R1         GET DEV TYPE
*XXX     CI        R6,3            IS IT A DISC
*XXX     BGT       OPEN.3          BR IF NOT DISC
*XXX     LW        R1,INQ.INFO+1W  GET FAT ADDR
*XXX     TRR       R1,R5           SAVE FAT ADDRESS
*XXX     LB        R6,DFT.ACF,R1   GET ACCESS FLAGS/SYS FILE CODE
*XXX     ANMW      R6,=X'7'        MASK ALL BUT SYS FILE CODE
*XXX     CI        R6,0            IS IT SYS FILE
*XXX     BNE       OPEN.3          RET IF IT IS
*XXX     LA        R1,FCB,X2       GET FCB ADDRESS INTO R1
*XXX     SBM       0,FLAGS,X2      SET USING RM FLAG
*XXX     ZBM       1,FLAGS,X2      NOT READING COMPRESSED YET
*XXX     LW        R6,MODE,X2      GET MODE R/W
*XXX     BZ        $+2W            BR IF READ MODE
*XXX     SBR       R1,1            SET CC1 FOR R/W MODE FOR RM
*XXX     BL        RM.OPEN         OPEN VIA REC MGR
*XXX     STW       R5,FCB+FCB.FAT,X2  SAVE FAT ADDRESS
*XXX     TRR       R7,R7           ANY RM ERROR
*XXX     BNZ       OPEN.ERR        GIVE IT TO CALLER
*XXX     BU        OPEN.4          CONTINUE PROCESSING OPEN
*XXXOPEN.3   TRR       R0,R7           RESTORE CNP ADDRESS
OPEN.5   LA        R1,FCB,X2       GET FCB ADDRESS INTO R1
         ZBM       0,FLAGS,X2      NOT USING RM FOR THIS FILE
         ZBM       1,FLAGS,X2      NOT READING COMPRESSED YET
OPEN.6   SVC       2,X'42'        OPEN FILE
OPEN.4   LW        AP,APSAVE      RESTORE ARGUMENT  POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         ZMW       DEVICE,X2      NOT A SPECIAL DEVICE
         LW        R3,FCB+FCB.FAT,X2  GET FAT ADDR FROM FCB
         LI        R4,NULL         SET DEVICE TYPE TO NULL
         TBM       3,DFT.FLGS,X3   SEE IF NULL DEVICE
         BS        OPEN.P          BR IF YES
         LI        R4,TERMINAL     SET DEVICE TYPE TO TERMINAL
         TBM       7,DFT.STB,X3    SEE IF TERMINAL
         BS        OPEN.P          BR IF YES
         TBM       RR.SLO,RRS+RR.OPTS  SEE IF SLO FILE
         BS        OPEN.P          TREAT AS TERMINAL IF YES
         ZR        R4              INDICATE IT'S FILE
OPEN.P   STW       R4,DEVICE,R2    SET TYPE
         ZMW       BLKPTR,X2      SET BLOCK POINTER TO FIRST BLOCK
         ZMW       EOLPTR,X2      SET EOL POINTER TO FIRST CHARACTER
         ZMW       LINPTR,X2      SET LINE POINTER TO FIRST CHARACTER
         ZMW       FLOC,X2        FILE POSITION IS ZERO
         ZMW       CPTR,X2        NO DECOMPRESSING POINTER
         ZMW       SECTA,X2       NO SECTORS YET
         LI        R4,FALSE
         STW       R4,EOF,X2      SET EOF FLAG TO FALSE
         LW        R0,0W,AP       RETURN FILE DESCRIPTOR
         RETURN                   RETURN TO CALLER
*
OPEN.ERR LI        R0,-1           SET ERROR CODE
         LI        R4,NOTUSED      SET FILE DESCRIPTOR NOT USED
         STW       R4,MODE,X2      PUT IN MODE IDENTIFIER
         RETURN                    RETURN TO SENDER....
************************************************************************
*   CHECK IF FILE EXISTS AND ITS ACCESS - READ, WRITE, AND/OR EXECUTE
************************************************************************
         SPACE     1
_access  EQU       $
         ENTER                     SAVE REGISTERS ON STACK
         BL        PARSE           PARSE PATHNAME
         TRR       R7,R7           TEST RETURN VALUE
         BNE       ERRETURN        NON ZERO, RETURN WITH ERROR
         BL        EXISTS          TEST IF THE FILE ALREADY EXISTS
         TRR       R7,R7           TEST RETURN RESULT
         BLT       ACC.RET         RETURN -1 IF DOESN'T EXIST
         LI        R7,RWE          LOAD ACCESS CODE INTO R7 IF IT EXISTS
ACC.RET  EQU       $
         TRR       R7,R0           RETURN VALUE IN REG 0
         RETURN
         PAGE
************************************************************************
*   RETRIEVE FILE STATUS (FILE SIZE IN BYTES)
************************************************************************
         SPACE     1
_fstat   EQU       $
         ENTER
         LW        X2,0W,AP        RETRIEVE FILE DESCRIPTOR
         BLT       ERRETURN        CHECK IF VALID FD
         CI        X2,FILECNT      IS FD WITHIN RANGE?
         BGE       ERRETURN        IF NOT, RETURN WITH ERROR
         INDEX     X2              X2 IS FILE TABLE INDEX REGISTER
         STW       X2,FTESAVE      STORE FILE TABLE ENTRY ADDRESS
         LW        R1,PNBWORD,X2   GET PATHNAME BLOCK ADDRESS
         LA        R6,RD           RETRIEVE RESOURCE DESCRIPTOR
         ZR        R7
         SVC       2,X'2C'
         TRR       R7,R7           TEST RETURN VALUE
         BNE       ERRETURN        NON-ZERO, RETURN WITH ERROR
         LW        AP,APSAVE       RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE      RESTORE FILE TABLE ENTRY ADDRESS
         LW        R1,1W,AP        GET STATUS BUFFER ADDRESS
         LW        R5,RD+RD.EOF     GET FILESIZE FROM RESOURCE DESC
         BNZ       $+2W            USE NEW COUNT IF NOT ZERO
         LW        R5,RD+RD.USER   OTHERWISE USE OLD COUNT LOCATION
         STW       R5,16B,R1       STUFF FILE SIZE INTO STATUS BUFFER
         ZR        R0              O.K. RETURN
         RETURN                    RETURN TO CALLER
         PAGE
************************************************************************
*   LINK A NEW FILE
************************************************************************
         SPACE     1
_link    EQU       $
         ENTER
         BL        PARSE           PARSE FIRST PATHNAME
         TRR       R7,R7           TEST RETURN VALUE
         BNE       ERRETURN        NON-ZERO, RETURN WITH ERROR
         BL        EXISTS          CHECK IF FILE EXISTS
         TRR       R7,R7           TEST RETURN VALUE
         BLT       ERRETURN        NON-ZERO, RETURN WITH ERROR
         LA        R2,PNBX         LOAD REG WITH ADDR OF PNB
         LA        R3,PNB1         LOAD REG WITH ADDR OF PNB FOR 1ST PN
         LNB       R7,PNBWRDX     GET NEGATIVE PATHNAME LENGTH
L.LOOP   LB        R5,0B,R2        PERFORM BYTE-BY-BYTE COPY OF PN
         STB       R5,0B,R3        STORED TO PNB FOR FIRST PATHNAME
         ABR       R2,31           INCREMENT ADDR IN R2
         ABR       R3,31           INCREMENT ADDR IN R3
         BIB       R7,L.LOOP       GET NEXT BYTE; DROP OUT WHEN DONE
         LA        R7,PNB1         GET ADDR OF FIRST PNB
         LB        R5,PNBWRDX     GET LENGTH OF FIRST PATHNAME
         STW       R7,PNBWRD1     STUFF ADDR INTO PNB1 POINTER
         STB       R5,PNBWRD1     STUFF LENGTH INTO PNB1 POINTER
         LA        AP,1W,AP        SET ARG POINTER TO 2ND PATHNAME
         BL        PARSE           PARSE 2ND PATHNAME
         TRR       R7,R7           TEST RETURN VALUE
         BNE       ERRETURN        NON-ZERO, RETURN WITH ERROR
         LW        R1,PNBWRD1     GET OLD PATHNAME
         LW        R2,PNBWRDX     GET NEW PATHNAME
         ZR        R7
         SVC       2,X'2D'         LINK (RENAME) RESOURCE
         LW        AP,APSAVE       RESTORE ARGUMENT POINTER
         TRR       R7,R7           TEST RETURN VALUE
         BNE       ERRETURN        NON-ZERO, RETURN WITH ERROR
         ZR        R0              O.K. RETURN
         RETURN                    RETURN TO CALLER
         PAGE
************************************************************************
*   UNLINK A FILE
************************************************************************
         SPACE     1
_unlink  EQU       $
         ENTER
         BL        PARSE           PARSE PATHNAME
         TRR       R7,R7           TEST RETURN VALUE
         BNE       ERRETURN        NON-ZERO, RETURN WITH ERROR
         BL        EXISTS          CHECK IF FILE EXISTS
         TRR       R7,R7           TEST RETURN VALUE
         BLT       ERRETURN        LESS THAN ZERO, DOESN'T EXIST
         LW        R1,PNBWRDX     GET PNB VECTOR WORD FOR SERVICE
         ZR        R7              DELETE RESOURCE
         SVC       2,X'24'
         TRR       R7,R7           TEST RETURN VALUE
         BNE       ERRETURN        NON-ZERO, RETURN WITH ERROR
         ZR        R0              O.K. RETURN
         RETURN                    RETURN TO CALLER
         PAGE
************************************************************************
*   READ A SET OF CHARACTERS FROM THE FILE
************************************************************************
         SPACE     1
_readraw EQU       $               READ UNBUFFERED RECORD
         ENTER
         SBM       0,RAW           SET RAW FLAG
         BU        READC           MERGE CODE
         SPACE     2
_read    EQU       $
         ENTER                    SAVE REGISTERS ON STACK
         ZBM       0,RAW           SJOW STD READ, NOT RAW
READC    LW        X2,0W,AP       PICK UP FILE DESCRIPTOR
         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR
         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR
         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS
         LW        R7,MODE,X2     GET FILE MODE
         CI        R7,NOTUSED     IN USE?
         BEQ       ERRETURN       NOT USED, RETURN WITH ERROR
         CI        R7,WRITMODE    FILE IN WRITE MODE?
         BEQ       ERRETURN       IN WRITE MODE, RETURN WITH ERROR
         TBM       0,RAW           ARE WE IN RAW MODE
         BNS       RN.RAW          BR IF NOT
         LW        R4,LINPTR,X2    MAKE SURE WE ARE AT ZERO
         BNZ       ERRETURN        ERROR IF NOT
         LW        R4,2W,AP        GET TRANSFER COUNT
         BZ        ERRETURN        ERROR IF ZERO
         STW       R4,FCB+FCB.XCT,X2 STUFF IN FCB
         LW        R7,1W,AP        GET BUFFER ADDRESS
         STW       R7,FCB+FCB.XAD,X2 STUFF IN FCB
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
*XXX     TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.READ        READ FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL READ
         SVC       1,X'31'        READ RECORD
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         LI        R7,LINESIZE     GET LINE SIZE
         STW       R7,FCB+FCB.XCT,X2 STUFF IN FCB
         LA        R4,LINE,X2   GET LINE ADDRESS
         STW       R4,FCB+FCB.XAD,X2 STUFF IN FCB
         TBM       FCB.ERR,FCB+FCB.STAT,X2
*                                 WAS ERROR ENCOUNTERED?
         BS        ERRETURN       YES, RETURN WITH ERROR
         LW        R0,FCB+FCB.CNT,X2
*                                 GET CHARACTER COUNT
         TBM       FCB.EOF,FCB+FCB.STAT,X2
*                                 WAS EOF ENCOUNTERED?
         BNS       READ.15        YES, RETURN WITH EOF
         LI        R4,TRUE         SET EOF IND FOR NEXT TIME
         STW       R7,EOF,X2       DO IT
READ.15  ZMW       LINPTR,X2       SHOW NOTHING IN LINE
         ARMW      R0,FLOC,X2     UPDATE FILE LOCATION
         RETURN
*
RN.RAW   LW        R4,LINPTR,X2   GET THE LINE POINTER IN R4
         ZR        R5             CLEAR THE TRANSFER COUNT IN R5
         LW        R6,2W,AP       GET THE REQUEST COUNT IN R6
         LA        R7,LINE,X2  GET THE LINE ADDRESS
         ADR       R4,R7          ADJUST LINE ADDRESS BY LINE POINTER
         STW       R7,LINADRS     STORE THE LINE ADDRESS LOCALLY
         LW        R7,1W,AP       GET THE BUFFER ADDRESS
         STW       R7,BUFADRS     STORE THE BUFFER ADDRESS LOCALLY
         LW        R7,EOF,X2      GET EOF FLAG
         CI        R7,FALSE       NO EOF?
         BEQ       READ.1         NO EOF, SKIP AHEAD
         ZR        R0             SET EOF IN RESULT REGISTER
         RETURN                   RETURN WITH EOF
READ.1   CAR       R6,R5          COMPARE TRANSFER COUNT TO REQUEST
         BGE       READ.4         REQUEST SATISFIED, SKIP AHEAD
         TRR       R4,R4          LINE EMPTY?
         BGT       READ.3         NO, SKIP AHEAD
         LW        R7,EOF,X2
         CI        R7,TRUE        EOF REACHED?
         BEQ       READ.4         YES, FINISH UP
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
*XXX     TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.READ        READ FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL READ
         SVC       1,X'31'        READ RECORD
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         TBM       FCB.ERR,FCB+FCB.STAT,X2
*                                 WAS ERROR ENCOUNTERED?
         BS        ERRETURN       YES, RETURN WITH ERROR
         TBM       FCB.EOF,FCB+FCB.STAT,X2
*                                 WAS EOF ENCOUNTERED?
         BS        READ.EOF       YES, RETURN WITH EOF
         ABM       31,SECTA,X2    SHOW RECORD READ
         LW        R7,FCB+FCB.CNT,X2
*                                 GET CHARACTER COUNT
         LA        X3,LINE,X2  GET LINE ADDRESS IN X3
         STW       R3,CPTR,X2  SET DATA POINTER FOR COMPRESSED FILE
         ADR       R7,X3          OFFSET TO END OF LINE
         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE
         LW        R1,BLOCK,X2     ARE WE UNBLOCKED
         BZ        RDB.2           BR IF YES
RDB.0    TRR       R3,R1          COPY ADDR
         TRR       R7,R7          TEST IF ANY CHARS
         BLE       RDB.1          BR IF NON LEFT
         SUI       R1,1           BACK UP 1 CHAR POSITION
         LB        R1,0B,R1       GET A CHAR
         CI        R1,X'20'       IS IT A SPACE
         BNE       RDB.1          BR IF NON SPACE ENCOUNTERED
         SUI       R3,1           BACK UP END OF BUFFER POINTER
         SUI       R7,1           BACK UP TRANSFER COUNT
         BU        RDB.0          LOOP TIL FIRST NON SPACE
RDB.1    ADI       R7,1           INCREMENT LINE CHARACTER COUNT
         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE
         LI        R7,NEWLINE     GET NEW LINE CHARACTER
         STB       R7,0B,X3       PUT AT END OF LINE
RDB.2    LW        R7,DEVICE,X2    GET DEVICE TYPE
         CI        R7,TERMINAL     TERMINAL?
         BNE       RDB.NOT         NO, BRANCH AHEAD
         LA        R7,LFCHAR       GET ADDR OF 1 SPACE
         STW       R7,FCB+FCB.XAD,X2 STUFF IN FCB
         LI        R7,1            BYTE CNT OF 1
         STW       R7,FCB+FCB.XCT,X2 STUFF IN FCB
         LA        R1,FCB,X2       GET FCB ADDRESS
         SVC       1,X'32'         WRITE LINE FEED
         LW        AP,APSAVE       RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE      RESTORE FILE TABLE ENTRY ADDRESS
         LI        R7,LINESIZE     GET LINE SIZE
         STW       R7,FCB+FCB.XCT,X2 STUFF IN FCB
         LA        X3,LINE,X2   GET LINE ADDRESS
         STW       R3,FCB+FCB.XAD,X2 STUFF IN FCB
RDB.NOT  LA        R7,LINE,X2  GET LINE ADDRESS
         STW       R7,LINADRS     RESET LOCAL LINE ADDRESS
READ.3   EQU       $
         LW        R3,LINADRS      GET LINE ADDRESS
         LB        R7,0B,R3       GET BYTE FROM LINE
         LW        R3,BUFADRS      GET BUFFER ADDRESS
         STB       R7,0B,R3       STORE BYTE TO USER BUFFER
         ADI       R5,1           INCREMENT TRANSFER COUNT
         ABM       31,BUFADRS     INCREMENT BUFFER ADDRESS
         ADI       R4,1           INCREMENT LINE POINTER
         ABM       31,LINADRS     INCREMENT LINE ADDRESS
         CAMW      R4,EOLPTR,X2   COMPARE LINE POINTER TO END OF LINE
         BLT       READ.1         LINE NOT EMPTY, DO NEXT CHARACTER
         ZR        R4             INITIALIZE LINE POINTER
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         CI        R7,TERMINAL    IS IT A TERMINAL?
         BEQ       READ.4         YES FINISH UP
         ABM       31,BLKPTR,X2   NO, UPDATE BLOCK POINTER
         BU        READ.1         DO NEXT CHARACTER
READ.EOF LI        R7,TRUE
         STW       R7,EOF,X2      SET EOF FLAG
READ.4   EQU       $
         STW       R4,LINPTR,X2   ADJUST LINE POINTER
         ARMW      R5,FLOC,X2     ADJUST CURRENT CHAR POSITION
         TRR       R5,R0          MOVE TRANSFER COUNT IN RESULT REGISTER
         RETURN                   RETURN TO CALLER
         PAGE
************************************************************************
*   WRITE A SET OF CHARACTERS TO THE FILE
************************************************************************
         SPACE     1
_writraw EQU       $               WRITE RAW RECORD
         ENTER
         SBM       0,RAW           SET FLAG
         BU        WRIT.1          MERGE CODE
         SPACE     1
_write   EQU       $
         ENTER                    SAVE REGISTERS ON STACK
         ZBM       0,RAW           SHOW NOT RAW I/O
WRIT.1   LW        X2,0W,AP       PICK UP FILE DESCRIPTOR
         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR
         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR
         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS
         LW        R7,MODE,X2     GET MODE
         CI        R7,NOTUSED     FILE IN USE?
         BEQ       ERRETURN       FILE NOT USED, RETURN WITH ERROR
         CI        R7,READMODE    FILE IN READ MODE?
         BEQ       ERRETURN       IN READ MODE, RETURN WITH ERROR
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         CI        R7,NULL        NULL FILE?
         BEQ       WRITE.5        YES, FINISH UP
         TBM       0,RAW           ARE WE IN RAW MODE
         BNS       WR.RAW          BR IF NOT
         LW        R4,LINPTR,X2    MAKE SURE WE ARE AT ZERO
         BNZ       ERRETURN        ERROR IF NOT
         LW        R4,2W,AP        GET TRANSFER COUNT
         BZ        ERRETURN        ERROR IF ZERO
         STW       R4,FCB+FCB.XCT,X2 STUFF IN FCB
         LW        R7,1W,AP        GET BUFFER ADDRESS
         STW       R7,FCB+FCB.XAD,X2 STUFF IN FCB
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
*XXX     TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.WRIT        WRIT FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL WRIT
         SVC       1,X'32'         WRITE RECORD
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         TBM       FCB.ERR,FCB+FCB.STAT,X2
*                                 WAS ERROR ENCOUNTERED?
         BS        ERRETURN       YES, RETURN WITH ERROR
         LW        R0,FCB+FCB.CNT,X2
*                                 GET CHARACTER COUNT
         ARMW      R0,FLOC,X2     UPDATE FILE POSITION
         ABM       31,SECTA,X2    UPDATE RECORD COUNT
         TBM       FCB.EOF,FCB+FCB.STAT,X2
*                                 WAS EOF ENCOUNTERED?
         BNS       WRIT.2         YES, RETURN WITH EOF
         LI        R4,TRUE         SET EOF IND FOR NEXT TIME
         STW       R4,EOF,X2       DO IT
WRIT.2   TBM       FCB.EOM,FCB+FCB.STAT,X2
*                                 WAS EOM ENCOUNTERED?
         BNS       WRIT.3         NO, RETURN TRANSFER COUNT
         LI        R0,EOM          SET EOM IND FOR RETURN
WRIT.3   ZMW       LINPTR,X2       SHOW NOTHING IN LINE
         RETURN                    GO RETURN
*
WR.RAW   LW        R4,LINPTR,X2   GET LINE POINTER
         ZR        R5             CLEAR TRANSFER COUNT
         LA        R7,LINE,X2  GET THE LINE ADDRESS
         ADR       R4,R7          ADJUST LINE ADDRESS BY LINE POINTER
         STW       R7,LINADRS     STORE THE LINE ADDRESS LOCALLY
         LW        R7,1W,AP       GET THE BUFFER ADDRESS
         STW       R7,BUFADRS     STORE THE BUFFER ADDRESS LOCALLY
WRIT.BLK TRR       R4,R4          IS LINE EMPTY?
         BNE       WRITE.6        NO, SKIP AHEAD
         LW        R7,BLOCK,X2   SEE IF FILE UNBLOCKED
         BZ        WRITE.6         BR IF YES
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         BEQ       WRITE.6        NOT SPECIAL, SKIP AHEAD
         LW        R3,BUFADRS      GET BUFFER ADDR
         LB        R7,0B,R3       GET CHARACTER OF LINE
         CI        R7,X'0C'       SEE IF FORMFEED CHAR
         BNE       WRITE.4        SKIP IF NOT
         LI        R7,G'1'        GET A 1 FOR TOF ON LP
         ABM       31,BUFADRS     SKIP OVER CHAR
         ADI       R5,1           UPDATE REQUEST COUNT
         BU        WRITE.41        MERGE CODE
WRITE.4  LW        R7,=G' '       GET BLANK FOR SLO FORMS CONTROL
WRITE.41 LW        R3,LINADRS     GET LINE ADDRESS
         STB       R7,0B,R3       STUFF FORMS CONTROL CHARACTER IN LINE
         ABM       31,LINADRS     UPDATE LINE ADDRESS
         ADI       R4,1           UPDATE TRANSFER COUNT
WRITE.6  EQU       $
         CAMW      R5,2W,AP       COMPARE TRANSFER COUNT TO REQUEST
         BGE       WRITE.9        DONE, FINISH UP
         LW        R3,BUFADRS      GET BUFFER ADDRESS
         LB        R7,0B,R3       GET CHARACTER
         ABM       31,BUFADRS     UPDATE BUFFER ADDRESS
         ADI       R5,1           UPDATE REQUEST COUNT
         LW        R0,BLOCK,X2   SEE IF FILE UNBLOCKED
         BZ        WRITE.61        BR IF YES
         CI        R7,NEWLINE     NEW LINE CHARACTER?
         BEQ       WRITE.7        YES, FLUSH LINE
WRITE.61 LW        R3,LINADRS     GET LINE ADDR
         STB       R7,0B,R3       STORE CHARACTER IN LINE
         ABM       31,LINADRS     UPDATE LINE ADDRESS
         ADI       R4,1           UPDATE TRANSFER COUNT
         LW        R7,BLOCK,X2   SEE IF FILE UNBLOCKED
         BNZ       WRITE.62        BR IF NOT
         CI        R4,LINESIZE     SEE IF BUFFER FULL
         BLT       WRITE.6         BR IF NOT
         BU        WRITE.7         GO PURGE BUFFER
WRITE.62 CI        R4,254          MAX BLOCKED RECORD LENGTH
         BLT       WRITE.6         BR IF STILL O.K.
WRITE.7  EQU       $
         BL        SETTCW         SET THE TCW IN THE FCB
         BL        WRITLINU       WRITE THE LINE
         TRR       R7,R7          TEST THE RETURN RESULT
         BNE       ACC.RET        NON ZERO, RETURN WITH ERROR
         LA        R7,LINE,X2  GET LINE ADDRESS
         STW       R7,LINADRS     RESET LOCAL LINE ADDRESS
         ZR        R4             INITIALIZE LINE POINTER
         BU        WRIT.BLK       START AGAIN
WRITE.9  EQU       $
         STW       R4,LINPTR,X2   SAVE LINE POINTER
WRITE.5  LW        R0,2W,AP       SET OD IN RESULT REGISTER
         RETURN                   RETURN TO CALLER
         PAGE
************************************************************************
*   SEEK TO A POSITION IN THE FILE
************************************************************************
         SPACE     1
_seek    EQU       $
         ENTER                    SAVE THE REGISTERS ON STACK
         LW        X2,0W,AP       PICK UP FILE DESCRIPTOR
         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR
         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR
         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS
         LW        R4,MODE,X2     GET MODE
         CI        R4,NOTUSED     FILE DESCRIPTOR IN USE?
         BEQ       ERRETURN       NOT IN USE, RETURN WITH ERROR
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         CI        R7,NULL        NULL FILE?
         BEQ       SEEK.5         YES, FINISH UP
         CI        R4,READMODE    ARE WE OUTPUT ACTIVE
         BEQ       SEEK.1          NO, JUST SEEK
         LW        R4,LINPTR,X2    ANY CHARS LEFT IN BUFFER
         BZ        SEEK.1          NO, JUST CLOSE IT
         BL        SETTCW          YES, PURGE IT
         BL        WRITLINU        WRIT IT
*        OFFSET=0  OFFSET I.D.=0   ---> REWIND FILE
*        OFFSET=0  OFFSET I.D.=2   ---> SET TO EOF
*        OTHERS .EQ. ERROR RETURN
SEEK.1   CI        R7,TERMINAL     IS IT TTY
         BEQ       SEEK.5          JUST EXIT IF YES
         LW        R7,1W,AP       GET THE OFFSET
         BNE       SEEK.6         NOT ZERO, OFFSET SPECIFIED
         LW        R6,2W,AP       GET THE OFFSET IDENTIFIER
         BNE       SEEK.3         NOT ZERO, SEE IF ADV TO EOF
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         LW        R4,MODE,X2     GET MODE
         CI        R4,READMODE    ARE WE OUTPUT ACTIVE
         BEQ       SEEK.2          NO, JUST REWIND
*XXX     TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.WEOF        WEOF FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL WEOF
         SVC       1,X'38'        WRITE EOF
SEEK.2   TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.RWND        RWND FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL RWND
         SVC       1,X'37'        REWIND FILE
         ZMW       FLOC,X2        NO BYTE COUNT
         ZMW       SECTA,X2       NO RECORDS EITHER
         ZMW       CPTR,X2        NO COMPRESS POINTER
         BU        SEEK.4          MERGE CODE
SEEK.3   CI        R6,1            0 OFFSET TO CURR POSITION
         BEQ       SEEK.5          JUST RETURN O.K.
         CI        R6,2            SEE IF SEEK TO EOF
         BNE       ERRETURN        ERROR IF NOT
         LA        R1,FCB,R2       GET FCB ADDR
*        LW        R4,BLOCK,X2     SEE IF FILE BLOCKED
*        BNZ       SEEK.35         BR IF YES
SEEK.32  TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.READ        READ FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL READ
         SVC       1,X'31'         READ UNBLOCKED FILE
         TBM       FCB.ERR,FCB+FCB.STAT,X2  SEE IF ERR
         BS        SEEK.37         BR IF YES
         TBM       FCB.EOF,FCB+FCB.STAT,X2  SEE IF EOF
         BS        SEEK.37         BR IF YES
         ABM       31,SECTA,X2    ANOTHER RECORD READ
         LW        R4,FCB+FCB.CNT,X2  GET BYTE COUNT
         ARMW      R4,FLOC,X2     UPDATE BYTE POSITION
         BU        SEEK.32         GO READ NEXT RECORD
SEEK.35  TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.ADVF        ADVF FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL ADVF
         SVC       1,X'34'         ADVANCE FILE
SEEK.37  TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.BACK        BACK FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL BACK
         SVC       1,X'35'         BACKSPACE RECORD
SEEK.4   LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         ZMW       BLKPTR,X2      SET BLOCK POINTER TO FIRST BLOCK
         ZMW       EOLPTR,X2      SET EOL POINTER TO FIRST CHARACTER
         ZMW       LINPTR,X2      SET LINE POINTER TO FIRST CHARACTER
         LI        R4,FALSE
         STW       R4,EOF,X2      SET EOF FLAG TO FALSE
SEEK.5   LW        R0,FLOC,X2     SET OK IN RESULT REGISTER
         RETURN                   RETURN TO CALLER
*
*  OFFSET SPECIFIED
*
SEEK.6   BLT       SEEK.9          BACKWARK SEEK
* FORWARD SEEK SPECIFIED
         LW        R6,2W,AP        GET SEEK BASE
         BZ        SEEK.71         BR IF FROM BEGINNING OF FILE
         CI        R6,1            IS IT TO CURR POSITION
         BNE       ERRETURN        BR IF FROM EOF, ERROR
SEEK.70  ADMW      R7,FLOC,X2      ADD IN CURRENT POSITION
         BLT       ERRETURN        IF NEG, SEEK TO BEFORE BOF
         BU        SEEK.71         MERGE CODE
SEEK.9   LW        R6,2W,AP        GET SEEK BASE
         BZ        ERRETURN       NO BACKWARD FROM BOF
         CI        R6,1            CURR POSITION
         BEQ       SEEK.70         BR IF YES
         CI        R6,2            FROM EOF
         BNE       ERRETURN        BR IF NOT, ERROR
*
* MUST SEEK TO EOF FIRST
*
         LA        R1,FCB,R2       GET FCB ADDR
SEEK.92  TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.READ        READ FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL READ
         SVC       1,X'31'         READ UNBLOCKED FILE
         TBM       FCB.ERR,FCB+FCB.STAT,X2  SEE IF ERR
         BS        SEEK.97         BR IF YES
         TBM       FCB.EOF,FCB+FCB.STAT,X2  SEE IF EOF
         BS        SEEK.97         BR IF YES
         ABM       31,SECTA,X2    ANOTHER RECORD READ
         LW        R4,FCB+FCB.CNT,X2  GET BYTE COUNT
         ARMW      R4,FLOC,X2     UPDATE BYTE POSITION
         BU        SEEK.92         GO READ NEXT RECORD
SEEK.97  TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.BACK        BACK FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL BACK
         SVC       1,X'35'         BACKSPACE RECORD
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         ZMW       BLKPTR,X2      SET BLOCK POINTER TO FIRST BLOCK
         ZMW       EOLPTR,X2      SET EOL POINTER TO FIRST CHARACTER
         ZMW       LINPTR,X2      SET LINE POINTER TO FIRST CHARACTER
         LI        R4,FALSE
         STW       R4,EOF,X2      SET EOF FLAG TO FALSE
         LW        R7,FLOC,X2     GET CURRENT EOF POSITION
         LW        AP,APSAVE      RESTORE ARG POINTER
         ADMW      R7,1W,AP       GET ABSOLUTE OFFSET
         BU        SEEK.71         MERGE CODE
*
* R7 = ABSOLUTE OFFSET INTO FILE
*
SEEK.71  LW        R6,FLOC,X2      GET CURRENT POSITION
         TRR       R7,R5           SAVE ABSOLUTE POSITION
         SUR       R6,R7           REQ - CURR = DELTA
         BGT       SEEK.80         BR IF SEEK FORWARD IN FILE
         BZ        SEEK.5          IF THERE EXIT
*
* MUST SEEK BACKWARDS IN FILE - R7 = NEG NUM OF BYTES
*
         LW        R4,LINPTR,X2   GET THE LINE POINTER IN R4
         ZR        R5             CLEAR THE TRANSFER COUNT IN R5
         TRN       R7,R6          GET THE REQUEST COUNT IN R6
SEEK.701 CAR       R6,R5          COMPARE TRANSFER COUNT TO REQUEST
         BGE       SEEK.74        REQUEST SATISFIED, SKIP AHEAD
         TRR       R4,R4          LINE EMPTY?
         BGT       SEEK.73        NO, SKIP AHEAD
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
*XXX     TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+5W           BR IF NOT
*XXX     BL        RM.BACK        BACKSPACE TO CURR REC
*XXX     BL        RM.BACK        BACKSPACE TO PREV REC
*XXX     BL        RM.READ        READ FILE USING RM
*XXX     BU        $+4W           SKIP NORMAL READ
         SVC       1,X'35'        BACKSPACE RECORD
         SVC       1,X'35'        BACKSPACE RECORD
         SVC       1,X'31'        READ RECORD
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TBM       FCB.ERR,FCB+FCB.STAT,X2
*                                 WAS ERROR ENCOUNTERED?
         BS        ERRETURN       YES, RETURN WITH ERROR
         LI        R7,-1           DECR RECORD COUNT
         ARMW      R7,SECTA,X2    SHOW RECORD READ BACKWARD
         LW        R7,FCB+FCB.CNT,X2
*                                 GET CHARACTER COUNT
         LA        X3,LINE,X2  GET LINE ADDRESS IN X3
         STW       R3,CPTR,X2  SET DATA POINTER FOR COMPRESSED FILE
         ADR       R7,X3          OFFSET TO END OF LINE
         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE
         LW        R1,BLOCK,X2     ARE WE UNBLOCKED
         BZ        SKA.2           BR IF YES
SKA.0    TRR       R3,R1          COPY ADDR
         TRR       R7,R7          TEST IF ANY CHARS
         BLE       SKA.1          BR IF NON LEFT
         SUI       R1,1           BACK UP 1 CHAR POSITION
         LB        R1,0B,R1       GET A CHAR
         CI        R1,X'20'       IS IT A SPACE
         BNE       SKA.1          BR IF NON SPACE ENCOUNTERED
         SUI       R3,1           BACK UP END OF BUFFER POINTER
         SUI       R7,1           BACK UP TRANSFER COUNT
         BU        SKA.0          LOOP TIL FIRST NON SPACE
SKA.1    ADI       R7,1           INCREMENT LINE CHARACTER COUNT
         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE
         LI        R7,NEWLINE     GET NEW LINE CHARACTER
         STB       R7,0B,X3       PUT AT END OF LINE
SKA.2    LW        R4,EOLPTR,X2   GET LINE COUNT
SEEK.73  ADI       R5,1           INCREMENT TRANSFER COUNT
         SUI       R4,1           DECREMENT LINE POINTER
         BGE       SEEK.701        LINE NOT EMPTY, DO NEXT CHAR
         ZR        R4             INITIALIZE LINE POINTER
         LI        R7,-1          DECR COUNT
         ARMW      R7,BLKPTR,X2   NO, UPDATE BLOCK POINTER
         BU        SEEK.701       DO NEXT CHARACTER
SEEK.74  EQU       $
         STW       R4,LINPTR,X2   ADJUST LINE POINTER
         LW        R4,FLOC,X2     GET BYTE POSITION
         SUR       R5,R4          NEW POSITION
         TRR       R4,R0          MOVE CURRENT POSITION  RESULT REGISTER
         RETURN                   RETURN TO CALLER
*
* MUST SEEK FORWARD IN FILE - R7 = NUMBER OF BYTES
*
SEEK.80  LW        R4,LINPTR,X2   GET THE LINE POINTER IN R4
         ZR        R5             CLEAR THE TRANSFER COUNT IN R5
         TRR       R7,R6          GET THE DELTA COUNT IN R6
         LW        R7,EOF,X2      GET EOF FLAG
         CI        R7,FALSE       NO EOF?
         BEQ       SEEK.81        NO EOF, SKIP AHEAD
SEEK.84  LI        R0,-1          SET EOF IN RESULT REGISTER
         LI        R7,TRUE
         STW       R7,EOF,X2      SET EOF FLAG
         RETURN                   RETURN WITH EOF
SEEK.81  CAR       R6,R5          COMPARE TRANSFER COUNT TO REQUEST
         BGE       SEEK.90        REQUEST SATISFIED, SKIP AHEAD
         TRR       R4,R4          LINE EMPTY?
         BGT       SEEK.83        NO, SKIP AHEAD
         LW        R7,EOF,X2
         CI        R7,TRUE        EOF REACHED?
         BEQ       SEEK.84        YES, FINISH UP
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
*XXX     TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.READ        READ FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL READ
         SVC       1,X'31'        READ RECORD
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TBM       FCB.ERR,FCB+FCB.STAT,X2
*                                 WAS ERROR ENCOUNTERED?
         BS        ERRETURN       YES, RETURN WITH ERROR
         TBM       FCB.EOF,FCB+FCB.STAT,X2
*                                 WAS EOF ENCOUNTERED?
         BS        SEEK.84        YES, RETURN WITH EOF
         ABM       31,SECTA,X2    SHOW RECORD READ
         LW        R7,FCB+FCB.CNT,X2
*                                 GET CHARACTER COUNT
         LA        X3,LINE,X2  GET LINE ADDRESS IN X3
         STW       R3,CPTR,X2  SET DATA POINTER FOR COMPRESSED FILE
         ADR       R7,X3          OFFSET TO END OF LINE
         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE
         LW        R1,BLOCK,X2     ARE WE UNBLOCKED
         BZ        SEEK.83         BR IF YES
SKB.0    TRR       R3,R1          COPY ADDR
         TRR       R7,R7          TEST IF ANY CHARS
         BLE       SKB.1          BR IF NON LEFT
         SUI       R1,1           BACK UP 1 CHAR POSITION
         LB        R1,0B,R1       GET A CHAR
         CI        R1,X'20'       IS IT A SPACE
         BNE       SKB.1          BR IF NON SPACE ENCOUNTERED
         SUI       R3,1           BACK UP END OF BUFFER POINTER
         SUI       R7,1           BACK UP TRANSFER COUNT
         BU        SKB.0          LOOP TIL FIRST NON SPACE
SKB.1    ADI       R7,1           INCREMENT LINE CHARACTER COUNT
         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE
         LI        R7,NEWLINE     GET NEW LINE CHARACTER
         STB       R7,0B,X3       PUT AT END OF LINE
SEEK.83  ADI       R5,1           INCREMENT TRANSFER COUNT
         ADI       R4,1           INCREMENT LINE POINTER
         CAMW      R4,EOLPTR,X2   COMPARE LINE POINTER TO END OF LINE
         BLT       SEEK.81        LINE NOT EMPTY, DO NEXT CHARACTER
         ZR        R4             INITIALIZE LINE POINTER
         ABM       31,BLKPTR,X2   NO, UPDATE BLOCK POINTER
         BU        SEEK.81        DO NEXT CHARACTER
*        RETURN     CURRENT POSITION TO CALLER
SEEK.90  STW       R4,LINPTR,X2   ADJUST LINE POINTER
         ARMW      R5,FLOC,X2     ADJUST CURRENT CHAR POSITION
         LW        R0,FLOC,X2     MOVE TRANSFER COUNT IN RESULT REGISTER
         RETURN                   RETURN TO CALLER
         PAGE
************************************************************************
*   IS THE FILE A TERMINAL?
************************************************************************
         SPACE     1
_isatty  EQU       $
         ENTER                    SAVE THE REGISTERS ON STACK
         LW        X2,0W,AP       PICK UP FILE DESCRIPTOR
         BLT       TTY.NO         FD TOO SMALL, RETURN WITH ERROR
         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR
         BGE       TTY.NO         FD TOO LARGE, RETURN WITH ERROR
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         LW        R7,MODE,X2     GET MODE
         CI        R7,NOTUSED     FILE DESCRIPTOR IN USE?
         BEQ       TTY.NO         NOT IN USE, RETURN WITH ERROR
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         CI        R7,TERMINAL    TERMINAL?
         BEQ       TTY.YES        YES, SKIP AHEAD
TTY.NO   ZR        R0             NO, SET RETURN TO FALSE
         BU        TTY.RET
TTY.YES  LI        R0,1
TTY.RET  RETURN
         SPACE     2
************************************************************************
*   RETURN WITH AN ERROR
************************************************************************
         SPACE     1
         BOUND     1W
ERRETURN EQU       $
*        SVC       1,X'63'         ATTACH DEBUGGER
         LI        R0,-1          SET ERROR CODE IN RESULT REGISTER
         RETURN                   RETURN TO CALLER
         PAGE
************************************************************************
*   GET A FILE DESCRIPTOR
*
*   SEARCH SEQUENTIALLY BEGINNING TO END
*   R7 RETURNED AS FILE TABLE ENTRY #   OR   -1 FOR NONE AVAILABLE
*
************************************************************************
         SPACE     1
GETFD    EQU       $
         LI        X2,-FILECNT    SET UP LOOP COUNT
GET.LOOP EQU       $
         TRR       X2,X3
         ADI       X3,FILECNT
         INDEX     X3             GET FILE TABLE ENTRY ADDRESS
         LW        R7,MODE,X3     GET MODE
         CI        R7,NOTUSED     IN USE?
         BEQ       GET.FND        NO, FOUND ONE
         BIB       X2,GET.LOOP    TRY NEXT FILE DESCRIPTOR
         LI        R7,-1          NONE AVAILABLE, SET ERROR CODE
         BU        GET.RET        RETURN
GET.FND  EQU       $
         TRR       X2,R7
         ADI       R7,FILECNT     RECOVER FILE DESCRIPTOR
GET.RET  EQU       $
         TRSW      R0             RETURN
         SPACE     2
************************************************************************
*   PARSE FILE NAME INTO PATHNAME BLOCK
************************************************************************
         SPACE     1
PARSE    EQU       $
         LW        X2,0W,AP       PICK UP PATHNAME ADDRESS
*                                 *** ASSUMED TO BE A WORD ADDRESS
         TRR       X2,X3          MAKE ANOTHER COPY
PAR.LOOP EQU       $
         LB        R4,0B,X3       GET PATHNAME CHARACTER
         BEQ       PAR.NULL       STRING TERMINATOR FOUND, BRANCH
         BIB       X3,PAR.LOOP    TRY NEXT CHARACTER
PAR.NULL EQU       $
         SUR       X2,X3          GET PATHNAME LENGTH
         CI        X3,0           SEE IF PATHNAME IS ZERO
         BLE       PAR.ZER
         CI        X3,PNLENGTH    COMPARE TO MAXIMUM LENGTH
         BGT       PAR.ERR        TOO BIG, RETURN WITH ERROR
         SLL       X3,24          MOVE COUNT LEFT
         ORR       X3,X2          CONSTRUCT PATHNAME VECTOR WORD
         TRR       X2,R1          PUT IN REGISTER FOR SERVICE
         LW        R4,PNBVCTOR    GET PATHNAME BLOCK VECTOR IN REGISTER
         ZR        R7             NO CNP
         SVC       2,X'2E'        CONVERT PATHNAME TO PATHNAME BLOCK
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TRR       R7,R7          TEST THE RETURN RESULT
         BNE       PAR.ERR        DIDNT WORK, RETURN WITH ERROR
         STW       R4,PNBWRDX    SAVE PATHNAME BLOCK VECTOR WORD
         ZR        R7             SET OK IN RESULT REGISTER
         BU        PAR.RET        RETURN TO CALLER
PAR.ZER  EQU       $
         LI        R7,1           RETURN +1
         BU        PAR.RET
PAR.ERR  EQU       $
         LI        R7,-1          SET ERROR IN RESULT REGISTER
PAR.RET  EQU       $
         TRSW      R0             RETURN TO CALLER
         SPACE     2
************************************************************************
*   SEE IF A FILE EXISTS
************************************************************************
         SPACE     1
         BOUND     1W
EXISTS   EQU       $
         LW        R1,PNBWRDX    GET PNB VECTOR WORD IN REGISTER FOR
*                                   SERVICE
         LA        R6,RD           RETRIEVE RESOURCE DESCRIPTOR
         ZR        R7
         SVC       2,X'2C'
         TRR       R7,R7          TEST THE RETURN CODE
         BNE       EXI.ERR        NO RD, RETURN WITH ERROR
         LH        R7,RD+RD.TYPE  GET RESOURCE TYPE
         CI        R7,RD.PERM     IS IT A PERMANENT FILE?
         BNE       EXI.ERR        NO, RETURN WITH ERROR
         TBM       RD.BLK,RD+RD.FLAG
*                                 CHECK IF FILE IS BLOCKED
         BS        EXI.BLK        BLOCKED, SKIP AHEAD
         LI        R7,UNBLOCK     SET UNBLOCKED IN RESULT REGISTER
         BU        EXI.RET        RETURN TO SENDER
EXI.BLK  EQU       $
         LI        R7,BLOCKED     SET BLOCKED IN RESULT REGISTER
         BU        EXI.RET        RETURN TO SENDER
EXI.ERR  EQU       $
         LI        R7,-1          SET ERROR IN RESULT REGISTER
EXI.RET  EQU       $
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TRSW      R0             RETURN TO CALLER
         SPACE     2
************************************************************************
*   SAVE PATHNAME BLOCK IN FILE TABLE ENTRY
************************************************************************
         SPACE     1
         BOUND     1W
PNBSAVE  EQU       $
         LA        X3,PNB,X2      GET PATHNAME BLOCK ADDRESS
         LI        X2,-18W        GET PNB LENGTH IN X2
PNBLOOP  EQU       $
         LW        R5,PNBX+18W,X2 GET PART OF PNB
         STW       R5,0,X3        SAVE IN FILE TABLE ENTRY
         ABR       X3,29          CHANGE FILE TABLE ENTRY POINTER
         BIW       X2,PNBLOOP     MOVE NEXT WORD
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         LA        R5,PNB,X2      GET PNB ADDRESS
         STW       R5,PNBWORD,X2  STUFF IN LAST PART OF VECTOR WORD
         LB        R5,PNBWRDX    GET PNB COUNT
         STB       R5,PNBWORD,X2  STUFF IN FIRST PART OF VECTOR WORD
         TRSW      R0
         SPACE     2
************************************************************************
*   WRITE CURRENT LINE   (BLOCKED)
************************************************************************
         SPACE     1
         BOUND     1W
WRITLINU EQU       $
         STW       R0,WRTL.RET     SAVE RETURN ADDRESS
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
*XXX     TBM       0,FLAGS,X2     IS RM IN USE
*XXX     BNS       $+3W           BR IF NOT
*XXX     BL        RM.WRIT        WRIT FILE USING RM
*XXX     BU        $+2W           SKIP NORMAL WRIT
         SVC       1,X'32'        WRITE RECORD
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TBM       FCB.ERR,FCB+FCB.STAT,X2
*                                 WAS ERROR ENCOUNTERED?
         BS        WTU.ERR        YES, RETURN WITH ERROR
         TBM       FCB.EOF,FCB+FCB.STAT,X2
*                                 WAS EOF ENCOUNTERED?
         BS        WTU.ERR        YES, RETURN WITH ERROR
         TBM       FCB.EOM,FCB+FCB.STAT,X2                     A001
*                                 WAS EOM ENCOUNTERED?         A001
         BS        WTU.EOM        YES, RETURN WITH ERROR       A001
         ZR        R7             CLEAR RESULT REGISTER
         ABM       31,SECTA,X2    UPDATE RECORD COUNT
         LW        R0,FCB+FCB.CNT,X2  GET TRANSFER CNT
         ARMW      R0,FLOC,X2     UPDATE BYTE COUNT
         BU        WTU.RET        RETURN TO CALLER
WTU.EOM  LI        R7,-2          SET ERROR IN RESULT REGISTER A001
         ZMW       LINPTR,X2       RESET LINE POINTER          A001
*                                    THAT THE BUFFER IS EMPTY  A001
         BU        WTU.RET        RETURN TO CALLER             A001
WTU.ERR  EQU       $
         LI        R7,-1          SET ERROR IN RESULT REGISTER
WTU.RET  EQU       $
         LW        R0,WRTL.RET     RESTORE RTURN ADDRESS
         TRSW      R0             RETURN TO CALLER
         SPACE     2
************************************************************************
*   SET TCW IN FCB
************************************************************************
         SPACE     1
         BOUND     1W
SETTCW   EQU       $
         TRR       R4,R4           ANYTHING TO GO OUT
         BNZ       SET.1           BR IF YES
         LA        R7,LFCHAR       GET ADDR OF 1 BLANK
         LI        R4,1            GET CNT OF 1 BYTE
         BU        SET.2           GO PUT IN TCW
SET.1    LA        R7,LINE,X2   GET LINE ADDRESS
SET.2    STW       R7,FCB+FCB.XAD,X2 STUFF IN FCB
         STW       R4,FCB+FCB.XCT,X2 TRANSFER CNT TO FCB
         TRSW      R0              RETURN TO CALLER
************************************************************************
*   FILE TABLE
************************************************************************
         SPACE     1
         REL
         ORG       >FILTABL
         REPT      FILECNT
         FIL       G'UX0'+$$$-1,LINE
         ENDR
         SPACE     2
************************************************************************
*   RESOURCE REQUIREMENT SUMMARY AND PATHNAME BLOCK
************************************************************************
         SPACE     1
         REL
         BOUND     1D
RRS      RES       1W             LFC GOES HERE
         DATAB     1,0,0,0        TYPE 1 RRS
         DATAW     X'D0008000'    ALLOW FOR UPDATE EXPLICIT SHARED
         DATAW     0
PNBX     EQU       $               PNB FOR PATHNAME
         RES       18W
PNB1     EQU       $
         RES       18W             PNB FOR 1ST  PATHNAME IF 2 ARE REQ'D
PNLENGTH EQU       52              MAXIMUM PATHNAME LENGTH
PNBVCTOR GEN       8/18W,24/W(PNBX)
*                                  EMPTY PNB VECTOR WORD
         SPACE     2
************************************************************************
*   CNP  FOR OPENS
************************************************************************
         SPACE     1
CNP      DATAW     0               WAIT FOR RESOURCE
         DATAW     W(ERRETURN)    ERROR RETURN ADDRESS
         DATAW     X'00000000'    OPEN FOR READ BLOCKED
         REZ       2W
         SPACE     2
************************************************************************
*   VARIOUS SCRATCH BUFFERS
************************************************************************
         SPACE     1
         BOUND     1D
RD       RES       192W           RESOURCE DESCRIPTOR BUFFER
         SPACE     2
         PAGE
************************************************************************
*   RESOURCE CREATE BLOCK
************************************************************************
         SPACE     1
         BOUND     1D
RCB      EQU       $
         REZ       7W
         DATAW     X'00000000'     ZERO FILE   WAS X'100'      A001
         DATAW     32             MAXIMUM EXTENSION            A001
         DATAW     16             MINIMUM EXTENSION            A001
         REZ       1W
         DATAW     8              ORIGINAL SIZE
         REZ       4W
         SPACE     2
************************************************************************
*   RESOURCE REQUIREMENT SUMMARY AND PATHNAME BLOCK
************************************************************************
         SPACE     1
         BOUND     1D
SPSAVE   DATAW     0
APSAVE   DATAW     0
FTESAVE  DATAW     0
BLKSAVE  DATAW     0               BLOCKED STATUS SAVE AREA
FDSAVE   DATAW     0               FILE DESCRIPTOR SAVE AREA
PTRSAVE  DATAD     0               LINE AND BLOCK POINTER SAVE AREA
PNBWRD1  DATAW     0               PATHNAME WORD FOR FIRST ARG
PNBWRDX  DATAW     0               PATHNAME WORD FOR SINGLE OR 2ND ARG
LINADRS  DATAW     0               LOCAL LINE ADDRESS
BUFADRS  DATAW     0               LOCAL USER BUFFER ADDRESS
RAW      DATAW     0               BIT ZERO SET WHEN RAW I/O
*
* SIZES OF FIXED LENGTH RRS ENTRIES
*
RR.9.SIZ EQU       10              MOUNT DEVICE - 10 WORDS
RR.4.SIZ EQU       4               LFC          -  4 WORDS
RR.2.SIZ EQU       4               TEMP         -  4 WORDS (+ VOL)
RR.3.SIZ EQU       6               DEVICE       -  6 WORDS
RR.1.SIZ EQU       4               PATHNAME     -  4 WORDS (+ PATH)
RR.6.SIZ EQU       12              RID          - 12 WORDS
RR.D.SIZ EQU       10              EXTENDED SLO - 10 WORDS          3206
*
* SIZE IN WORDS OF REFORMATTED RRS ENTRIES
*
CASSA.NW EQU       4               ASSIGN 1
CASSB.NW EQU       4               ASSIGN 2
CASSC.D1 EQU       4               ASSIGN 3 (TEMP FILE ANY DEVICE)
CASSC.D2 EQU       8               ASSIGN 3 (TEMP FILE SPEC. DEV)
CASSC.DV EQU       6               ASSIGN 3 (DEVICE)
CASSD.NW EQU       4               ASSIGN 4
*
*  TERMINAL LINE BUFFER EQUATES                                     210D
*
TLB.LARG EQU       0D              ORIGIN OF LAST ARGUEMENT FOUND
TLB.BUFL EQU       4W+0B           LINE BUFFER LENGTH
TLB.CIND EQU       4W+1B           CURSOR INDEX
TLB.FDLM EQU       4W+2B           FIELD DELIMITER
TLB.FSIZ EQU       4W+3B           FIELD SIZE
RRS.SIZE DATAW     0               SIZE OF CURRENT RRS ENTRY
COPT90   RES       1F
CDEV90   RES       1F
*
*  SCRATCH DOUBLE WORD TO COUNT CHARACTERS IN DEVICE MNEMONIC  REV20100
*
CDEV.WRK DATAD     0
CDEV.CNT RES       1B              DEV MNEMONIC CHAR COUNT     REV20100
*
*  CDEV91 IS USED TO CONSTRUCT THE DEV-TYPE/CHAN/SUBCH WORD    REV20100
*
*  BYTE 0: BIT 0    = CHANNEL PRESENT
*          BITS 1-7 = DEVICE TYPE
*  BYTE 2: BIT 0    = SUBCHANNEL PRESENT
*          BITS 1-7 = CHANNEL
*  BYTE 3: BITS 0-7 = SUBCHANNEL
*
CDEV91   RES       1W
SAVER0   RES       1F
         BOUND     1W
CHARPOS  REZ       1W
BLNKS    REZ       1W              LEADING BLANKS FLAG
         PAGE
CCENT    RES       2D              LEFT JUSTIFIED FILED FROM SCANNER
CCSTRT   RES       1W              START OF CURRENT FILED
CCDLIM   RES       1B              LAST DELIMITTER ENCOUNTERED
CCHRS    RES       1B              NUMBER OF CHARACTERS IN FIELD
CCFLD    RES       1B              NUMBER OF FIELD
MDBUF    RES       1W              ADDRESS OF CURRENT INPUT RECORD
WRTL.RET RES       1W              WRITLIN RETURN ADDRESS
CAS.REGS RES       1F              REG SAVE AREA FOR ASSIGN
INQ.INFO RES       1F              8W FOR M.INQUIRY INFO
         CSECT
         TITLE  ASSIGN COMMANDS
***********************************************************************
*                                                                     *
*                  CASSG                                              *
*                                                                     *
***********************************************************************
*                                                                     *
*        PROCESS GENERAL ASSIGN DIRECTIVE                             *
*                                                                     *
***********************************************************************
CASSG    STF       R0,CAS.REGS     SAVE REGS
*
*  ZERO MAXIMUM SIZE RRS
*
         LI        R6,12           12 WORDS MAX                REV20094
         LA        R3,RRS          START OF NEXT RRS           REV20094
         TRN       R6,R6           NEGATE LOOP COUNTER         REV20094
CASSG.05 ZMW       0W,R3           CLEAR RRS WORD              REV20094
         ABR       R3,29           BUMP POINTER                REV20094
         BIB       R6,CASSG.05     DO NEXT WORD                REV20094
*
         ZMW       CHARPOS         CLEAR PARSER FLAG
*
         LA        R3,RRS          GET RRS ADDR
*
* NOW GET THE MAIN PART OF THE ASSIGN. THIS WILL ALSO DETERMINE
* THE TYPE OF RRS BEING PRODUCED AND THEREFORE THE SPACE
* REQUIREMENT IN THE RRS TABLE.
*
         BL        STRING          GET THE PRIMARY ASSIGN TYPE
         LB        R5,CCHRS        CHECK FOR BLANK FIELD
         BZ        ERRETURN        BRANCH IF BLANK FIELD
         LB        R4,CCDLIM       SEE IF DELIMITER IS '=' .....
         CI        R4,G'='         ..... AND IF SO GO AND  .....
         BEQ       CASSG.5         ..... IDENTIFY THE KEYWORD
*
         CAMW      R6,=C'SYC '     SEE IF SYC
         BEQ       CASS.SYC        BRANCH IF SYC
*
         CAMW      R6,=C'SGO '     SEE IF SGO
         BEQ       CASS.SGO        BRANCH IF SGO
*
         CAMW      R6,=C'SBO '     SEE IF SBO
         BEQ       CASS.SBO        BRANCH IF SBO
*
         CAMW      R6,=C'SLO '     SEE IF SLO
         BEQ       CASS.SLO        BRANCH IF SLO
*
*ISC     CAMW      R6,=C'TEMP'     SEE IF TEMP WITH NO VOLUME
*ISC     BNE       CASSG.6         BRANCH IF NOT                    2104
*ISC     CI        R5,4            4 CHARS ONLY THIS NAME           2104
*ISC     BEQ       CASS.TP5        YES.  DEFINATELY A TEMP ASSIGN   2104
*
* KEYWORD NOT RECOGNIZED SO ASSUME A PATHNAME
*
* THIS FORMS A TYPE 1 RRS WHOS LENGTH IS 4 WORDS PLUS THE NUMBER
* OF WORDS CONSTITUTING THE PATHNAME.
*
CASSG.6  EQU       $
         LW        AP,APSAVE       GET ARG POINTER
         LW        X2,0W,AP       PICK UP PATHNAME ADDRESS
*                                 *** ASSUMED TO BE A WORD ADDRESS
         TRR       X2,X3          MAKE ANOTHER COPY
         LA        R1,PNB1         GET ADDR OF TEMP AREA
PAR.L    EQU       $
         LB        R4,0B,X3       GET PATHNAME CHARACTER
         BEQ       PAR.N          STRING TERMINATOR FOUND, BRANCH
         CI        R4,X'61'        SEE IF L/C
         BLT       PAR.X           BR IF NOT
         CI        R4,X'7A'        SEE IF L/C
         BGT       PAR.X           BR IF NOT
         SUI       R4,X'20'        MAKE U/C
PAR.X    CI        R4,G' '         SEE IF SPACE
         BEQ       PAR.N           TERM IF YES
         STB       R4,0B,R1        PUT IN TEMP BUFFER
         ADI       R1,1B           BUMP ADR
         BIB       X3,PAR.L       TRY NEXT CHARACTER
PAR.N    EQU       $
         SUR       X2,X3          GET PATHNAME LENGTH
         CI        X3,0           SEE IF PATHNAME IS ZERO
         BLE       ERRETURN
         CI        X3,PNLENGTH    COMPARE TO MAXIMUM LENGTH
         BGT       ERRETURN       TOO BIG, RETURN WITH ERROR
         STW       R3,CHARPOS     SET STRING POINTER PAST PATHNAME
         SLL       X3,24          MOVE COUNT LEFT
         LA        R1,PNB1        CONSTRUCT PATHNAME VECTOR WORD
         ORR       X3,R1          PUT IN REGISTER FOR SERVICE
         LW        R4,PNBVCTOR    GET PATHNAME BLOCK VECTOR IN REGISTER
         ZR        R7             NO CNP
         SVC       2,X'2E'        CONVERT PATHNAME TO PATHNAME BLOCK
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TRR       R7,R7          TEST THE RETURN RESULT
         BNE       ERRETURN       DIDNT WORK, RETURN WITH ERROR
         STW       R4,PNBWRDX    SAVE PATHNAME BLOCK VECTOR WORD
         LB        R4,PNBWRDX      GET PATHNAME LENGTH
         TRR       R4,R7           SETUP FOR WORD ADJUSTMENT
         SRL       R7,2            EVALUATE NUMBER OF WORDS
CASS.PA1 ADI       R7,RR.1.SIZ     IN PATHNAME PLUS OVERHEAD
         STW       R7,RRS.SIZE     SAVE FOR RRS POINTER UPDATE LATER
*
* BUILD THE RRS ENTRY
*
         LA        R3,RRS          GET ADDR OF RRS
         LI        R6,RR.PATH      RRS TYPE .....
         STB       R6,RR.TYPE,R3   ..... INTO RRS
*
         STB       R4,RR.PLEN,R3   PATHNAME LENGTH
*
         TRN       R4,R4           LOOP COPYING NAME TO RRS
         TRR       R3,R1           START OF RRS ENTRY
         LA        R2,PNBX         START OF PATHNAME BLOCK
CASS.PA2 LB        R7,0B,R2        NEXT PATHNAME BYTE .....
         STB       R7,RR.NAME1,R1  ..... INTO RRS
         ABR       R1,31           NEXT RRS ENTRY
         ABR       R2,31           NEXT INPUT BYTE
         BIB       R4,CASS.PA2     AND LOOP
*
* ALL DONE, GET ANY OPTIONS AND THEN FINALLY UPDATE THE RRS POINTERS
*
* THE OPTIONS ARE THE SAME AS FOR ASSIGNING TO A TEMPORARY FILE
* SO UTILISE THE SAME CODE
*
         BU        CASS.TP2
*
* CHECK TO SEE IF A VALID KEYWORD.
* IF NOT FOUND IN THE KEYWORD TABLE ASSUME WE ARE ASSIGNING
* TO A PATHNAME BECAUSE '=' COULD APPEAR IN A PATHNAME IN QUOTES.
*
CASSG.5  ZR        R1              INDEX INTO LOCAL KEYWORD TABLE
         LI        R2,-CASSNK1     NUMBER OF KEYWORDS IN TABLE
CASSG.1  CAMD      R6,CASSKEY1,R1  CHECK FOR A MATCH
         BEQ       CASSG.2         BRANCH IF ONE FOUND
         ABR       R1,28           MOVE TO NEXT ENTRY IN TABLE
         BIB       R2,CASSG.1      AND LOOP FOR NEXT
         BU        CASSG.6         NOT THERE, GO TREAT AS PATHNAME
*
* KEYWORD FOUND SO SPLIT TO A SEPARATE ACTION ROUTINE FOR EACH
*
CASSG.2  SRL       R1,1            FORM WORD INDE TO ADDRESS TABLE
         BU        *CASSACT1,R1    AND GO TO EACH ACTION ROUTINE
*
* ASSIGNMENT TO SYC.
*
* BUILD A TYPE 2 RRS WITH BIT 0 SET IN THE OPTION WORD.
* THE CODE FOR THIS IS THE SAME AS FOR ASSIGNMENT TO SGO
* SO UTILISE COMMON CODE.
*
CASS.SYC ZR        R7              SET UP OPTION WORD .....
         SBR       R7,RR.SYC       ..... IN R7
         BU        CASS.SG1        COMMON WITH SGO
*
* ASSIGNMENT TO SGO.
*
* BUILD A TYPE 2 RRS WITH BIT 1 SET IN THE OPTION WORD.
* THE CODE FOR THIS IS COMMON WITH ASSIGNMENT TO SYC.
*
CASS.SGO ZR        R7              SET UP OPTION WORD .....
         SBR       R7,RR.SGO       ..... IN R7
         BU        CASS.SG1        COMMON MERGE POINT
*
* ASSIGNMENT TO SBO.
*
* BUILD A TYPE 2 RRS WITH BIT 3 SET IN THE OPTION WORD.
* THE CODE FOR THIS IS COMMON WITH ASSIGNMENT TO SYC.
*
CASS.SBO ZR        R7              SET UP OPTION WORD .....
         SBR       R7,RR.SBO       ..... IN R7
         BU        CASS.SG1        COMMON MERGE POINT
*
* ASSIGNMENT TO SLO.
*
* BUILD A TYPE 2 RRS WITH BIT 2 SET IN THE OPTION WORD.
* THE CODE FOR THIS IS COMMON WITH ASSIGNMENT TO SYC.
*
CASS.SLO ZR        R7              SET UP OPTION WORD .....
         SBR       R7,RR.SLO       ..... IN R7
CASS.SG1 EQU       $               COMMON SLO/SYC CODE
         LI        R6,RR.2.SIZ     MAKE SURE THERE IS .....
         STB       R6,RR.SIZE,R3   RRS SIZE
         STW       R7,RR.OPTS,R3   OPTION WORD TO RRS
         LI        R6,RR.TEMP      RRS TYPE
         STB       R6,RR.TYPE,R3
*
*        CHECK FOR 'DEVICE=' DIRECTIVE FOR SLO FILES                3206
*
         TBR       R7,RR.SLO       IS IT SLO ?                      3206
         BNS       CASS.SG2        NO, CONTINUE                     3206
         BL        STRING          YES, IS THERE A DEVICE DIRECTIVE 3206
         LB        R4,CCHRS                                         3206
         BZ        CASS.SG2        NO, CONTINUE                     3206
         LB        R4,CCDLIM       GET DELIMITER                    3206
         CI        R4,G'='         IS IT '=' ?                      3206
         BNE       ERRETURN        NO, THEN ERROR                   3206
         CAMW      R6,=C'DEVI'     IS IT DEVICE= ?                  3206
         BNE       ERRETURN        NO, THEN ERROR                   3206
         BL        STRING          GET MNEMONIC                     3206
         LI        R5,29           ERROR CODE                       3206
         CAMW      R7,=C'    '     CHANNEL SPECIFIED ?              3206
         BEQ       ERRETURN        NO, THEN ERROR                   3206
         TRR       R6,R4           SAVE IN R4,R5                    3206
         TRR       R7,R5                                            3206
         BL        CDEV            VALIDATE MNEMONIC                3206
         BS        ERRETURN        BRANCH IF ERROR                  3206
         LI        R6,RR.D.SIZ     GET EXTENDED RRS SIZE            3206
         STB       R6,RR.SIZE,R3   SAVE NEW SIZE IN RRS     3206
         STD       R4,RR.DEV,R3    YES, THEN SAVE DEVICE MNEMONIC   3206
         BU        CASSG.8                                          3206
*
* UPDATE THE RRS TABLE POINTERS
*
* FINALLY MAKE SURE THERE ARE NO OPTIONS ON THE LINE
*
CASS.SG2 LI        R6,RR.2.SIZ     SIZE OF ENTRY (FIXED PART ONLY US3206
*
CASSG.8  BL        STRING          GET OPTION FIELD (IF ANY)
         LB        R5,CCHRS        ANY OPTIONS??
         BNZ       ERRETURN        BRANCH TO ERROR IF ANY OPTIONS
         BU        CASSG.7         COMMON EXIT
         PAGE
*
* ASSIGNMENT TO ANOTHER LFC RECOGNIZED
*
* THE LFC MUST BE BETWEEN 1 AND 3 CHARACTERS.
*
* FORM A TYPE 4 RRS.
*
CASS.LFC EQU       $
         BL        STRING          GET LFC NAME
         LB        R5,CCHRS        NUMBER OF CHARS IN LFC
         BZ        ERRETURN        BRANCH TO ERROR IF NO LFC
         CI        R5,3            CHECK IF < 3 CHARS
         BGT       ERRETURN        BRANCH TO ERROR IF > 3 CHARS
         SRL       R6,8            FORM FIRST WORD OF RRS
*
         LI        R4,RR.4.SIZ     MAKE SURETHERE IS ROOM .....
*
         STW       R6,RR.SFC,R3    LFC INTO RRS
         STB       R4,RR.SIZE,R3   RRS SIZE
         LI        R6,RR.LFC2      RRS TYPE
         STB       R6,RR.TYPE,R3
         LI        R6,RR.4.SIZ     SIZE OF ENTRY IN WORDS
         BU        CASSG.8         UPDATE RRS PTRS AND CHECK NO OPTIONS
         PAGE
*
* ASSIGNMENT TO RID
*
CASS.RID EQU       $
         LI        R4,RR.6.SIZ     MAKE SURE THERE IS ROOM .....
         STW       R4,RRS.SIZE     SAVE FOR COMMON UPDATE LATER
*
         LI        R4,RR.RID       SET UP RRS .....
         STB       R4,RR.TYPE,R3   ..... TYPE
*
         BL        STRING          GET VOLUME NAME
         LB        R5,CCHRS        CHECK BETWEEN 1 AND 16 CHARS .....
         BZ        ERRETURN        ..... ELSE ERROR
         CI        R5,16           .....
         BGT       ERRETURN        ..... AND AGAIN
*
         STD       R6,RR.NAME1,R3  STORE 16 CHAR NAME .....
         LD        R6,CCENT+1D          .....
         STD       R6,RR.NAME1+1D,R3    ..... INTO RRS
*
* LOOP OF 4 OBTAINING BINARY DATE, TIME, BLOCK NUMBER AND RES TYPE
*
         TRR       R3,R2           RRS PTR (GETS UPDATED IN THE LOOP)
         LI        R4,-4           LOOP COUNT
CASS.RD1 BL        STRING          GET NEXT FIELD
         LB        R5,CCHRS        CHECK BETWEEN 1 AND 8 CHARS .....
         BZ        ERRETURN        ..... ELSE ERROR .....
         CI        R5,8            .....
         BGT       ERRETURN        ..... AND AGAIN
         SVC       1,X'29'         CONVERT HEX TO BINARY
         CI        R6,0            CHECK FOR ILLEGAL CHARACTERS .....
         BZ        ERRETURN        ..... AND BRANCH IF FOUND
         STW       R7,RR.DATE,R2   SAVE FIELD IN RRS .....
         ABR       R2,29           ..... AND UPDATE RRS PTR
         BIB       R4,CASS.RD1     LOOP FOR NEXT FIELD
*
* ALL DONE, GO GET OPTIONS
*
         BU        CASS.TP2
         PAGE
*
* ASSIGNMENT TO TEMP
*
* BUILD A TYPE 2 RRS WITH OPTIONAL VOLUME NAME IN PARENTHESES
*
* FORMAT IS:       TEMP[=(VOL)] OPTIONS
*             OR
*                  TEMP OPTIONS
*
* ENTRY POINT CASS.TMP IS USED FOR THE FIRST AND CASS.TP5 FOR
* THE SECOND.
*
CASS.TP5 EQU       $               TEMP [OPTIONS] ENTRY POINT
         LI        R6,RR.2.SIZ     SET UP DEFAULT SIZE .....
         STW       R6,RRS.SIZE     ..... FOR RRS POINTER UPDATES
         BU        CASS.TP3        GO PROCESS OPTIONS
*
CASS.TMP EQU       $               TEMP=(VOL) OPTIONS ENTRY POINT
*
         BL        STRING          GET OPTIONAL VOLUME FIELD
         LB        R5,CCHRS        MUST BE 0 WITH '(' DELIMITER
         BNZ       ERRETURN        BRANCH IF FIELD PRESENT
*
         LB        R4,CCDLIM       MAKE SURE DELIMITER IS '('
         CI        R4,G'('
         BNE       ERRETURN        BRANCH IF FORMAT ERROR
*
         BL        STRING          GET VOLUME NAME
         LB        R5,CCHRS        CHECK FOR VOLUME PRESENT
         BZ        CASS.TP4        BRANCH IF NOT PRESENT
         CI        R5,16
         BGT       ERRETURN        BRANCH IF TOO LARGE
*
         LI        R4,RR.2.SIZ+4   MAKE SURE THERE IS ROOM .....
         BGT       ERRETURN        ..... BRANCH TO ERROR IF NOT
*
         STW       R4,RRS.SIZE     SAVE RRS SIZE FOR UPDATE LATER
*
         STW       R6,RR.NAME1,R3  PUT NAME .....
         STW       R7,RR.NAME1+1W,R3    .....
         LD        R6,CCENT+1D
         STW       R6,RR.NAME1+2W,R3    .....
         STW       R7,RR.NAME1+3W,R3    ..... INTO RRS
*
CASS.TP4 LB        R4,CCDLIM       MAKE SURE DELIMITER .....
         CI        R4,G')'         ..... WAS ')'
         BNE       ERRETURN        BRANCH IF NOT ')'
*
* NOW GO AND SEE IF THERE WERE ANY OPTIONS
*
* SET UP RRS TYPE FIRST OF ALL BECAUSE THE OPTION HANDLING IS
* USED BY OTHER TYPES OF ASSIGN ALSO
*
CASS.TP3 LI        R6,RR.TEMP      RRS TYPE .....
         STB       R6,RR.TYPE,R3   ..... INTO RRS
*
CASS.TP2 BL        STRING          GET ANY OPTIONS
         LB        R5,CCHRS        CHECK FOR NONE .....
         BNZ       CASS.TP1        ..... AND BRANCH IF SOME
*
CASS.TP6 LW        R6,RRS.SIZE     SIZE OF RRS ENTRY
         STB       R6,RR.SIZE,R3   INTO RRS
*
         BU        CASSG.7         COMMON EXIT
*
* THERE IS AN OPTION, CHECK FOR VALIDITY ON THIS ASSIGN
* CC1 IS SET IF IF OPTION IS DETECTED.
* THE RRS WILL HAVE BEEN UPDATED ALREADY.
* NO RETURN IS MADE IF AN ERROR IS DETECTED.
*
CASS.TP1 BL        CAS.OPT1        SEE IF SHARED/ACCESS/BLOCKED .....
         BS        CASS.TP2        ..... BRANCH IF SO
         BL        CAS.OPT2        SEE IF SLO/SBO .....
         BS        CASS.TP2        ..... BRANCH IF SO
         BU        ERRETURN        ELSE ILLEGAL OPTION - ERROR
         PAGE
*
* ASSIGNMENT TO DEVICE
*
CASS.DEV EQU       $
         LI        R4,RR.3.SIZ     MAKE SURE THERE IS .....
         BL        STRING          GET DEVICE ASSIGNMENT .....
         BL        CDEV            ..... AND VALIDATE IT
         BS        ERRETURN        BRANCH IF ERROR             REV20100
*
* ALL IS O.K. SO SET UP RRS ENTRY
*
         STW       R7,RR.DT3,R3    DEVICE TYPE/CHAN/SUB-CHAN WORD
         STB       R4,RR.SIZE,R3   RRS SIZE
*
         LI        R6,RR.DEVC      RRS TYPE .....
         STB       R6,RR.TYPE,R3   ..... INTO RRS
*
* SEE IF ANY OPTIONS
*
CASSG.10 BL        STRING          GET FIRST OPTION STRING
         LB        R5,CCHRS        CHECK FOR NONE .....
         BNZ       CASSG.9         ..... AND BRANCH IF SOME
*
CASSG.11 LI        R6,RR.3.SIZ     UPDATE RRS POINTERS .....
         BU        CASSG.7         AND EXIT
*
* THERE IS AN OPTION, CHECK FOR VALIDITY ON THIS ASSIGN.
* CC1 IS SET IF OPTION IS DETECTED.
* THE RRS WILL HAVE BEEN UPDATED ALREADY.
* NO RETURN IS MADE IF AN ERROR IS DETECTED.
*
CASSG.9  BL        CAS.OPT1        SEE IF SHARED/ACCESS/BLOCKED .....
         BS        CASSG.10        ..... BRANCH IF SO
         BL        CAS.OPT3        SEE IF DENSITY/MULTIVOL/ID .....
         BS        CASSG.10        ..... BRANCH IF SO
         BU        ERRETURN        ELSE AN ILLEGAL OPTION - ERROR
         PAGE
*
* THIS ROUTINE CHECKS TO SEE IF THE OPTION KEYWORD IN R6/R7
* IS ONE OF THE SET:
*
*                  SIZE   = DECIMAL VALUE
*                  SHARED = Y/N
*                  ACCESS = (R,W,M,U,A)
*                  BLOCKED= Y/N
*
* IF SO, THE APPROPRIATE BITS ARE SET IN THE CURRENT RRS ENTRY
* AND CC1 IS SET ON EXIT.
*
* IF A MATCH IS NOT FOUND, CC1 IS RESET ON EXIT.
*
* IF AN ERROR IN FORMAT IS DETECTED, AN ERROR EXIT IS TAKEN
* DIRECTLY, AND NO RETURN IS MADE TO THE CALLER.
*
CAS.OPT1 ZBR       R0,1            CLEAR CC1
         STF       R0,COPT90       SAVE CONTEXT
         LB        R4,CCDLIM       SEE IF '=' WAS DELIMITER
         CI        R4,G'='
         BNE       CAS.1.6         BRANCH TO OPTION NOT FOUND EXIT
*
         CAMW      R6,=C'SIZE'     SEE IF SIZE SPECIFICATION
         BNE       CAS.1.0         BRANCH IF NOT 'SIZE'
*
         BL        STRING          GET SIZE
         SVC       1,X'28'         CONVERT TO BINARY
         TRR       R6,R6           NON DECIMAL CHARACTERS?
         BZ        ERRETURN        YES, ILLEGAL FORMAT
         LB        R6,RR.TYPE,R3   CHECK RRS TYPE
         CI        R6,RR.TEMP      IS THIS A TEMP FILE
         BNE       ERRETURN        NO, ILLEGAL OPTION
         STH       R7,RR.PLEN,R3   ELSE, SAVE THE SIZE
         BU        CAS.1.3         COMMON EXIT
CAS.1.0  EQU       $
         CAMW      R6,=C'SHAR'     SEE IF SHARED OPTION
         BNE       CAS.1.1         BRANCH IF NOT 'SHARED'
*
         BL        STRING          GET 'Y' OR 'N'
         LB        R5,CCHRS        CHECK FOR BLANK FIELD
         BZ        ERRETURN        BRANCH IF BLANK FIELD TO ERROR
         LB        R4,CCENT        GET FIRST CHAR OF FIELD
         CI        R4,G'Y'         'YES' ??
         BNE       CAS.1.2         BRANCH IF NOT 'Y'
         SBM       RR.SHAR,RR.ACCS,R3      SET SHARED BIT IN RRS
         BU        CAS.1.3         COMMON EXIT
*
CAS.1.2  CI        R4,G'N'         'NO' ??
         BNE       ERRETURN        BRANCH IF NOT 'Y' OR 'N' TO ERROR
         SBM       RR.EXCL,RR.ACCS,R3      SET EXCLUSIVE BIT IN RRS
         BU        CAS.1.3         COMMON EXIT
*
* CHECK FOR 'BLOCKED' OPTION
*
CAS.1.1  CAMW      R6,=C'BLOC'     SEE IF BLOCKED OPTION
         BNE       CAS.1.4         BRANCH IF NOT 'BLOCKED'
*
         BL        STRING          GET 'Y' OR 'N'
         LB        R5,CCHRS        CHECK FOR BLANK FIELD
         BZ        ERRETURN        BRANCH IF BLANK FIELD TO ERROR
         LB        R4,CCENT        GET FIRST CHAR OF FIELD
         CI        R4,G'Y'         'YES' ??
         BNE       CAS.1.5         BRANCH IF NOT 'Y'
         SBM       RR.BLK,RR.OPTS,R3       SET BLOCKED BIT IN RRS
         BU        CAS.1.3         COMMON EXIT
*
CAS.1.5  CI        R4,G'N'         'NO' ??
         BNE       ERRETURN        BRANCH IF NOT 'Y' OR 'N' TO ERROR
         SBM       RR.UNBLK,RR.OPTS,R3     SET UNBLOCKED BIT IN RRS
         BU        CAS.1.3         COMMON EXIT
*
* CHECK FOR ACCESS OPTION
*
CAS.1.4  CAMW      R6,=C'ACCE'
         BNE       CAS.1.6         OPTION NOT RECOGNIZED EXIT
*
         BL        STRING          GET '('
         LB        R5,CCHRS        SHOULD BE A ZERO COUNT
         BNZ       ERRETURN        BRANCH IF FIELD NOT EMPTY TO ERROR
         LB        R4,CCDLIM       CHECK FOR DELIMITER '('
         CI        R4,G'('
         BNE       ERRETURN        BRANCH IF NOT '(' TO ERROR
*
CAS.1.10 BL        STRING          GET NEXT ACCESS OPTION
         LB        R5,CCHRS        CHECK IF LAST ONE
         BNZ       CAS.1.7         BRANCH IF A FIELD TO LOOK FOR
         LB        R4,CCDLIM       MAKE SURE DELIMITER WAS ')'
         CI        R4,G')'
         BNZ       ERRETURN        BRANCH TO ERROR IF NOT ')'
         BU        CAS.1.3         COMMON EXIT
*
CAS.1.7  ZR        R1              SCAN ACCESS OPTION TABLE
         LI        R2,-CASSNK2     NUMBER OF ENTRIES IN TABLE
         LB        R6,CCENT        GET FIRST CHAR OF OPTION
CAS.1.8  CAMB      R6,CASSKEY2,R1  CHECK FOR A MATCH
         BEQ       CAS.1.9         BRANCH IF A MATCH
         ABR       R1,31           NEXT ENTRY IN TABLE
         BIB       R2,CAS.1.8      ANDLOOP
         BU        ERRETURN        OPTION NOT LEGAL
*
CAS.1.9  SLL       R1,2            WORD INDEX
         EXM       CASSACT2,R1     SET THE APPROPRIATE BIT IN RRS
         LB        R4,CCDLIM       IF DELIMETER WAS ')' .....
         CI        R4,G')'         .....
         BEQ       CAS.1.3         ..... THE EXIT, OPTION FINISHED
         BU        CAS.1.10        ..... LOOP FOR NEXT FIELD
*
* COMMON EXIT TO CALLER WHEN ALL IS O.K.
*
CAS.1.3  SBM       1,COPT90        SET CC1
*
* COMMON EXIT WHEN KEYWORD NOT RECOGNIZED.
*
CAS.1.6  LF        R0,COPT90
         TRSW      R0
         PAGE
*
* THIS ROUTINE CHECKS TO SEE IF THE OPTION KEYWORD IN R6/R7
* IS ONE OF THE SET:
*
*                  PRINT
*                  PUNCH
*
* IF SO, THE APPROPRIATE BITS ARE SET IN THE CURRENT RRS ENTRY
* AND CC1 IS SET ON EXIT.
*
* IF A MATCH IS NOT FOUND, CC1 IS RESET ON EXIT.
*
* IF AN ERROR IN FORMAT IS DETECTED, AN ERROR EXIT IS TAKEN
* DIRECTLY, AND NO RETURN IS MADE TO THE CALLER.
*
CAS.OPT2 ZBR       R0,1            CLEAR CC1
         STF       R0,COPT90       SAVE CONTEXT
         CAMW      R6,=C'PRIN'     SLO ??
         BNE       CAS.2.1         BRANCH IF NOT SLO
         SBM       RR.SLO,RR.OPTS,R3    SET SLO BIT IN RRS
         SBM       RR.SEP,RR.OPTS,R3    SET SEP BIT IN RRS          2111
         BU        CAS.1.3         COMMON EXIT
*
CAS.2.1  CAMW      R6,=C'PUNC'     SBO ??
         BNE       CAS.1.6         KEYWORD NOT RECOGNIZED EXIT
         SBM       RR.SBO,RR.OPTS,R3    SET SBO BIT IN RRS
         SBM       RR.SEP,RR.OPTS,R3    SET SEP BIT IN RRS          2111
         BU        CAS.1.3         COMMON EXIT
         PAGE
*
* THIS ROUTINE CHECKS TO SEE IF THE OPTION KEYWORD IN R6/R7
* IS ONE OF THE SET:
*
*                  DENSITY = N/P/G/800/1600/6250
*                  MULTIV  = NUMBER
*                  ID      = ID
*
* IF SO, THE APPROPRIATE BITS ARE SET IN THE CURRENT RRS ENTRY
* AND CC1 IS SET ON EXIT.
*
* IF A MATCH IS NOT FOUND, CC1 IS RESET ON EXIT.
*
* IF AN ERROR IN FORMAT IS DETECTED, AN ERROR EXIT IS TAKEN
* DIRECTLY, AND NO RETURN IS MADE TO THE CALLER.
*
CAS.OPT3 ZBR       R0,1            CLEAR CC1
         STF       R0,COPT90       SAVE CONTEXT
         LB        R4,CCDLIM       SEE IF '=' WAS DELIMITER
         CI        R4,G'='
         BNE       CAS.1.6         BRANCH TO OPTION NOT FOUND EXIT
*
* CHECK FOR 'DENSITY' OPTION
*
         CAMW      R6,=C'DENS'     SEE IF DENSITY OPTION
         BNE       CAS.3.1         BRANCH IF NOT 'DENSITY'
*
         BL        STRING          GET DENSITY VALUE
         LB        R5,CCHRS        CHECK FOR BLANK FIELD
         BZ        ERRETURN        BRANCH IF BLANK TO ERROR
*
         ZR        R1              SCAN DENSITY OPTION TABLE
         LI        R2,-CASSNK3     NUMBER OF ENTRIES IN TABLE
CAS.3.3  CAMW      R6,CASSKEY3,R1  CHECK FOR A MATCH
         BEQ       CAS.3.4         BRANCH IF A MATCH
         ABR       R1,29           NEXT ENTRY IN TABLE
         BIB       R2,CAS.3.3      AND LOOP
         BU        ERRETURN        OPTION NOT LEGAL
*
CAS.3.4  SRL       R1,2            FORM BYTE INDEX
         LB        R7,CASSACT3,R1  GET DENSITY BIT VALUE AND .....
         STB       R7,RR.DENS,R3   ..... STORE INTO RRS
         BU        CAS.1.3         COMMON EXIT
*
* CHECK FOR 'MULTIVOL' OPTION
*
CAS.3.1  CAMW      R6,=C'MULT'     SEE IF MULTIVOL OPTION
         BNE       CAS.3.2         BRANCH IF NOT 'MULTIVOL'
*
         BL        STRING          GET VOLUME NUMBER
         LB        R5,CCHRS        CHECK FOR NO FIELD
         BZ        ERRETURN        BRANCH IF BLANK FIELD
         SVC       1,X'28'         CONVERT ASCII DEC TO BINARY
         TRR       R6,R6           CHECK FOR ERROR
         BEQ       ERRETURN        BRANCH IF CONVERSION ERROR
         CI        R7,255          MAKE SURE IT FITS IN A BYTE
         BGT       ERRETURN        BRANCH IF TOO LARGE
         STB       R7,RR.VLNUM,R3  INTO RRS
         BU        CAS.1.3         COMMON EXIT
*
* CHECK FOR 'ID' OPTION
*
CAS.3.2  CAMW      R6,=C'ID  '     SEE IF ID OPTION
         BNE       CAS.1.6         OPTION NOT RECOGNIZED EXIT
*
         BL        STRING          GET ID
         LB        R5,CCHRS        MAKE SURE BETWEEN 1 AND 4 CHAR
         BZ        ERRETURN        BRANC IF BLANK FIELD
         CI        R5,4
         BGT       ERRETURN        BRANCH IF >4 CHARS
         STW       R6,RR.UNFID,R3  ID INTO RRS ENTRY
         BU        CAS.1.3         COMMON EXIT
*
* COMMON EXIT FOR END OF ASSIGN COMMAND
*
CASSG.7  LF        R0,CAS.REGS     GET REGS
         TRSW      R0              RETURN
*
* TABLE FOR RECOGNIZING PRIMARY ASSIGN KEYWORDS
*
CASSKEY1 DATAD     C'LFC     '
         DATAD     C'DEV     '
         DATAD     C'TEMP    '
         DATAD     C'RID     '
CASSNK1  EQU       $-CASSKEY1/1D   NUMBER OF ENTRIES
*
* TABLE OF ACTION ROUTINES FOR PRIMARY KEYWORDS
*
CASSACT1 EQU       $
         ACH       CASS.LFC        LFC=
         ACH       CASS.DEV        DEV=
         ACH       CASS.TMP        TEMP=
         ACH       CASS.RID        RID=
*
* TABLE FOR RECOGNIZING ACCESS RIGHTS KEYBYTES
*
CASSKEY2 DATAB     C'RWMUA'        READ/WRITE/MOD/UPDATE/APPEND
CASSNK2  EQU       $-CASSKEY2      NUMBER OF ENTRIES
         BOUND     1W
CASSACT2 SBM       RR.READ,RR.ACCS,R3
         SBM       RR.WRITE,RR.ACCS,R3
         SBM       RR.MODFY,RR.ACCS,R3
         SBM       RR.UPDAT,RR.ACCS,R3
         SBM       RR.APPND,RR.ACCS,R3
*
* TABLE FOR RECOGNIZING DENSITY KEYWORDS
*
CASSKEY3 DATAW     C'N   '         800
         DATAW     C'P   '         1600
         DATAW     C'G   '         6250
         DATAW     C'800 '         800
         DATAW     C'1600'         1600
         DATAW     C'6250'         6250
CASSNK3  EQU       $-CASSKEY3/1W   NUMBER OF ENTRIES
CASSACT3 DATAB     X'80'           800
         DATAB     X'40'           1600
         DATAB     X'02'           6250
         DATAB     X'80'           800
         DATAB     X'40'           1600
         DATAB     X'02'           6250
         BOUND     1W
*
         PAGE
************************************************************************
*                                                                      *
*                  CDEV                                                *
*                                                                      *
************************************************************************
*                                                                      *
*        PRODUCE A DEVICE-TYPE/CHANNEL/SUB-CHANNEL WORD                *
*        FROM AN INPUT DEVICE MNEMONIC (DEVMNC)                        *
*                                                                      *
*        INPUT:    R6/R7 = DEVMNC GIVEN BY USER                        *
*                                                                      *
*        OUTPUT:   R2 = ADDRESS OF DTT ENTRY FOR DEVICE                *
*                  R7 = DEVICE-TYPE/CHANNEL/SUB-CHANNEL WORD           *
*                                                                      *
*        ERRORS:   RETURN TO USER WITH CC1 SET AND R5 = CCERR          *
*                  MESSAGE ID FOR THE FOLLOWING ERRORS:                *
*                                                              (R5)    *
*                  (1) INPUT DEVMNC IS NOT 2/4/6 CHARS LONG    (29)    *
*                  (2) DEVICE IS NOT IN DTT TABLE              (06)    *
*                  (3) NON HEX CHANNEL/SUB-CHANNEL SPECIFIED   (29)    *
*                  (4) DEVICE NOT CONFIGURED IN SYSTEM         (28)    *
*                                                                      *
*        A RETURN IS NOT MADE TO THE CALLER IF ERROR DETECTED          *
*                                                                      *
************************************************************************
CDEV     STF       R0,CDEV90
         ZBM       1,CDEV90        CLEAR CC1 (ERROR RETURN FLAG)REV20100
         ZMW       CDEV91          TO BUILD OUTPUT R7 IN
*
*  COUNT THE CHARACTERS IN THE DEVICE MNEMONIC                 REV20100
*
         STD       R6,CDEV.WRK     SAVE MNEMONIC               REV20100
         LI        R5,-8           LOOP COUNTER                REV20100
         LA        R3,CDEV.WRK+7B  SCAN FROM END OF MNEMONIC   REV20100
         LI        R4,G' '         SCAN FOR FIRST NON-BLANK    REV20100
CDEV.05  CAMB      R4,0B,R3        BLANK?                      REV20100
         BNE       CDEV.06         NO.  EXIT.                  REV20100
         SUI       R3,1B           BACK TO PREVIOUS CHARACTER  REV20100
         BIB       R5,CDEV.05      CHECK IT.                   REV20100
*
CDEV.06  TRN       R5,R5           R5 HOLDS NON BLANK COUNT    REV20100
         STB       R5,CDEV.CNT     SAVE LOCALLY                REV20100
         LD        R6,CDEV.WRK     RESTORE MNEMONIC TO REGS    REV20100
         CI        R5,2
         BEQ       CDEV.0
         CI        R5,4
         BEQ       CDEV.0
         CI        R5,6
         BEQ       CDEV.0                                      REV20100
         LI        R5,29           INVALID DEVICE SPECIFIED    REV20100
         BU        CDEV.ERR        TAKE ERROR EXIT             REV20100
*
* PROCESS DEVICE MNEMONIC FIRST
*
CDEV.0   TRR       R6,R4
         SRL       R4,16           DEVICE MNEMONIC IN BOTTOM OF R4
         LW        R2,C.DTTA       DEVICE TABLE ADDRESS
         LNB       R5,C.DTTN       TOTAL ENTRIES IN TABLE
CDEV.1   CAMH      R4,3H,R2        LOOK FOR MNEMONIC
         BEQ       CDEV.2          BRANCH IF FOUND
         ABR       R2,28           MOVE TO NEXT ENTRY (2 WORDS)
         BIB       R5,CDEV.1       LOOP FOR NEXT ENTRY
         LI        R5,6            ERROR - INVALID MNEMONIC
         BU        CDEV.ERR        TAKE ERROR RETURN.          REV20100
*
* MNEMONIC FOUND, PROCESS CHANNEL/SUB-CHANNEL IF ANY
*
CDEV.2   STW       R2,CDEV90+2W    RETURN ENTRY ADDRESS TO CALLER
         LB        R5,0B,R2        GET DEVICE TYPE FROM TABLE
         STB       R5,CDEV91       INTO RESULT WORD
         LB        R5,CDEV.CNT     SEE IF ANY CHANNEL/SUB-CHANNEL
         CI        R5,2
         BEQ       CDEV.3          BRANCH IF NO CHAN/SUB-CHAN
         SBM       0,CDEV91        INDICATE CHANNEL PRESENT
*
         SLLD      R6,16           CHANNEL/SUB-CHANNEL INTO R6
         ADI       R7,G'  '        ALL SPACES IN R7
         SVC       1,X'29'         CONVERT CHAN/SUB-CHAN TO HEX
         TRR       R6,R6           CHECK FOR NON HEX DATA
         BNZ       CDEV.25         BRANCH IF CONVERSION OK.    REV20100
         LI        R5,29           INVALID DEVICE SPECIFIED.   REV20100
         BU        CDEV.ERR        TAKE ERROR RETURN           REV20100
*
* SET UP THE LOW HALFWORD OF RESULT TO CONTAIN THE CHANNEL
* NUMBER AND THE SUB-CHANNEL NUMBER, IF ANY.
* THE TOP BIT OF THE CHANNEL NUMBER FIELD IS SET IF A SUB-CHANNEL
* EXISTS.
*
CDEV.25  LB        R5,CDEV.CNT     CHECK FOR SUB-CHANNEL
         CI        R5,6
         BNE       CDEV.4          BRANCH IF CHANNEL ONLY
         SBR       R7,16           SET SUB-CHANNEL PRESENT BIT
         BU        CDEV.5          COMMON EXIT
CDEV.4   SLL       R7,8            CHANNEL NUMBER TO TOP BYTE OF .....
*                                  ..... HALFWORD
CDEV.5   STH       R7,CDEV91+1H    STORE IN RESULT
*
*  VERIFY DEVICE CONFIGURED ON SYSTEM                          REV20091
*
CDEV.3   ZR        R4              CLEAR COMPARE MASK REGISTER REV20100
*
*  IF DEVICE TYPE CODE IS A GENERIC (DC, MT, CD) THEN COMPARE
*  MASK WILL BE BUILT TO IGNORE DTC IN UDT.
*
         LB        R7,CDEV91       CHECK THE DTC FOR GENERIC   REV20100
         ZBR       R7,24           REMOVE CHAN FLAG IF PRESENT REV20100
         CI        R7,X'01'        DC?                         REV20100
         BEQ       CDEV.302        YES.  MASK = 0              REV20100
         CI        R7,X'04'        MT?                         REV20100
         BEQ       CDEV.302        YES.                        REV20100
         CI        R7,X'07'        CD?                         REV20100
         BEQ       CDEV.302        YES.                        REV20100
         LW        R4,=X'007F0000' SET MASK TO CHECK DTC       REV20100
*
*  MASK IS NOW SET FOR DTC.  PROCEED WITH CHAN AND SUBCH
*
CDEV.302 TBM       0,CDEV91        CHANNEL SPECIFIED?          REV20100
         BNS       CDEV.31         NO.  CHECK DTC ONLY.        REV20100
         ADI       R4,X'7F00'      ADD MASK FOR CHANNEL        REV20100
         TBM       16,CDEV91       SUB CHAN SPECIFIED?         REV20091
         BNS       CDEV.31         NO.  VERIFY CHAN ONLY       REV20091
         ADI       R4,X'00FF'      ADD MASK FOR SUBCHANNEL     REV20100
*
*  LOOP THRU UDT'S FOR SPECIFIED DEVICE                        REV20091
*
CDEV.31  LW        R1,C.UDTA       START OF UDT'S              REV20091
         LNH       R5,C.UDTN       NEG NUMBER OF UDT'S         REV20091
         LB        R7,CDEV91       DTC TO R7                   REV20100
         SLL       R7,16           TO BYTE 1 FOR UDT COMPARE   REV20100
         ORMH      R7,CDEV91+1H    OR IN CHANNEL AND SUBCH     REV20100
*
CDEV.32  CMMW      R7,UDT.STAT,X1  DEVICE MATCH?               REV20091
         BEQ       CDEV.33         YES.                        REV20091
         ADI       R1,UDT.SIZE     BUMP X1 TO NEXT UDT         REV20091
         BIB       R5,CDEV.32      AND COMPARE IF MORE         REV20091
*
         LI        R5,28           DEVICE NOT CONFIGURED       REV20091
*
*  CDEV.ERR - TAKE ERROR RETURN TO CALLER.
*  SET CC1, RETURN WITH R5 = CCERR MESSAGE INDEX               REV20100
*
CDEV.ERR SBM       1,CDEV90        SET CC1 BIT IN R0           REV20100
         STW       R5,CDEV90+5W    SAVE R5 FOR LOAD FILE       REV20100
*
CDEV.33  LF        R0,CDEV90
         LW        R7,CDEV91       RETURN TYPE/CHAN/SUB-CHAN WORD
         TRSW      R0
         PAGE
************************************************************************
*                                                                      *
*        STRING  - SYNTAX SCANNER FOR CATALOGER COMPATABILITY          *
*                                                                      *
************************************************************************
*
STRING   EQU       $
         STF       R0,SAVER0       SAVE GPRS
         LW        AP,APSAVE       GET ARG POINTER
         LD        R6,BLANKS       GET SOME BLANKS
         STD       R6,CCENT        CLEAR TOKEN AREA
         STD       R6,CCENT+1D
         LI        R7,16B          TOKEN BUFFER LENGTH
         LW        R1,0W,AP        GET LINE BUFFER ADDR
         LA        R6,CCENT        PICK UP TOKEN BUFFER ADDRESS
SCANNER  TRR       R1,R0           SAVE LINEBUFFER ADDRESS
         LI        R4,CR           DUMMY TERMINATOR FOR E.O.B   24OCT80A
         ZR        R5              STRING COUNTER FLAG
         TRR       R1,R2           SET UP BUFFER INDEX
         BZ        STR.3           DO NOTHING
         ZBM       31,BLNKS        CLEAR BLANKS ACTIVE FLAG
         TRR       R6,R3           SET UP OUTPUT ADDRESS
         ZBR       R3,12           CLEAR F BIT
         LW        R6,CHARPOS      GET CHARPOS
         BNE       STRING0         INITIALIZED, SKIP AHEAD
         ZMW       CHARPOS         INITIALIZE CHAR POINTER
STRING0  LI        R6,-2047        GET NEGATIVE LENGTH OF LBUF  01JAN81A
         ADMW      R6,CHARPOS      COMPUTE NEG REMAINING BYTE COUNT
         BGE       STRING4         DONE ...
         ADMW      R2,CHARPOS      ADD CURSOR POSITION
STRING1  LI        R1,0
         LB        R4,0B,R2        GET BYTE FROM LINE BUFFER
         BZ        STRING4         IF EOL, DONE
         CI        R4,X'61'        SEE IF L/C
         BLT       STRING1A        BR IF NOT
         CI        R4,X'7A'        SEE IF L/C
         BGT       STRING1A        BR IF NOT
         SUI       R4,X'20'        MAKE U/C
STRING1A EQU       $
         CAMB      R4,DELIMS,R1    CHECK AGAINST KNOWN DELIMS
         BNE       STRING1B        OK
         SLL       R1,2            WORD ALIGN INDEX
         BU        *ACTIONS,R1     DISPATCH ROUTINE
STRING1B EQU       $
         ADI       R1,1
         CI        R1,DELIM#       AT END
         BLT       STRING1A        NOT YET
STRING1C CAR       R7,R5           AMASSED ENTIRE STRING YET
         BGE       NEXTCHAR        YES
         STB       R4,0B,R3        MOVE TO WORK BUFFER
         SBM       31,BLNKS        SET BLANKS NO LONGER ACTIVE FLAG
         ABR       R2,31           INPUT STRING BYTE ADDRESS
         ABR       R3,31           OUTPUT STRING BYTE ADDRESS
         ABR       R5,31           BUMP THIS STRING COUNTER
NEXTCHAR BIB       R6,STRING1      SCAN TILL E.O.B.
STRING2  EQU       $
         TRR       R0,R1           RESTORE ADDRESS OF LINEBUFFER
         ADI       R2,1B           BUMP PAST DELIMITER
         SUR       R1,R2           DISTANCE TRAVELED
STR.2    STW       R2,CHARPOS      AND SAVE AS CURSOR NOW
STR.3    STB       R4,CCDLIM       REMEMBER CURRENT DELIMITTER
         STB       R5,CCHRS        REMEMBER FIELD SIZE
         LD        R6,CCENT        GET FIRST 8 CHAR OF TOKEN
         LD        R0,SAVER0       RESTORE R0, R1
         LD        R2,SAVER0+1D    RESTORE R2, R3
         LW        R4,SAVER0+2D    POP R4
         TRSW      R0              RETURN
*
*
*        SKIP LEADING BLANKS
*
STRING3  EQU       $
         TBM       31,BLNKS        ARE WE TRAVELING ACROSS LEAD BLANKS ?
         BS        STRING2         NOPE-> THATS A DELIMITER
         ADI       R2,1B           YES--> BUMP OVER THEM
         BIB       R6,STRING1      KEEP SCANNING TIL EOB
         BU        STRING2         DONE AT EOB
*
STRING4  TRR       R0,R1           RESTORE ADDRESS OF LINEBUFFER
         LI        R2,2047         FORCE END OF MEDIUM FOR NEXT CALL
         BU        STR.2           TAKE NORMAL RETURN
*
STRING6  EQU       $
         TRR       R0,R1           RESTORE LINEBUFFER ADDRESS
         LB        R1,CHARPOS      GET INITIAL CURSOR POSITION
         CI        R1,5W           IS THIS THE FIRST FIELD
         BEQ       STRING5         IF SO, TREAT LIKE DOLLAR SIGN
         BU        STRING4         ELSE, TREAT AS END OF LINE
*
STRING5  CI        R5,0            FIRST CHARACTER IN FIELD
         BNZ       STRING1C        NO
         STB       R4,0B,R3        SAVE THIS CHARACTER
         ABR       R5,31           BUMP CHARACTERS IN FIELD
         BU        STRING2         COMMON EXIT
         PAGE
*
BLANKS   DATAD     C'        '     BLANKS
*
*        DELIMITER WIDGETS
*
         BOUND     1W
DELIMS   EQU       $
         DATAB     X'20'           00 - BLANK CHAR
         DATAB     C','            02 - COMMAN CHAR
         DATAB     CR              04 - CARRAIGE RETURN
         DATAB     C'='            03 - EQUAL SIGN
         DATAB     NEWLINE         05 - NEW LINE
         DATAB     C'('            06 - LEFT PAREN
         DATAB     C')'            07 - RIGHT PAREN
         DATAB     C'";'           08 - SEMI-COLON
         DATAB     C'!'            09 - EXCLAMATION POINT
         DATAB     C'"%'           10 - PERCENT
         DATAB     C'$'            11 - DOLLAR SIGN
DELIM#   EQU       $-DELIMS        COUNT IN TABLE
         BOUND     1W
*
*        ROUTINES TO HANDLER ABOVE DELIMITERS
*
ACTIONS  EQU       $
         ACH       STRING3         00 - BLANKS
         ACH       STRING2         02 - COMMAS
         ACH       STRING4         04 - CARRAIGE RETURNS
         ACH       STRING2         03 - EQUAL SIGNS
         ACH       STRING2         05 - NEW LINES
         ACH       STRING2         06 - LEFT PAREN
         ACH       STRING2         07 - RIGHT PAREN
         ACH       STRING2         08 - SEMI-COLON
         ACH       STRING6         09 - EXCLAMATION POINT
         ACH       STRING2         10 - PERCENT
         ACH       STRING5         11 - DOLLAR SIGN
************************************************************************
         END
