/*
 *      LLLIO2.H
 */

/*     struct tags for fcb,fat and fpt building    */
struct fcbbit {    /* control bits */
    unsigned nowait :        1;
    unsigned noerr  :        1;
    unsigned dfi    :        1;
    unsigned nst    :        1;
    unsigned ran    :        1;
    unsigned bl     :        1;
    unsigned exp    :        1;
    unsigned iec    :        1;
    unsigned dfd    :        1;
    unsigned specctl:        4;
    unsigned racc   :       19;
    };

struct fattag {  /* fat structure */
    unsigned open   :        1;   /* word 0 of FAT */
    unsigned opron  :        1;
    unsigned  perm  :        1;
    unsigned  bbuf  :        1;
    unsigned unfor  :        1;   /* dft.stb */
    unsigned volmr  :        1;
    unsigned  rom   :        1;
    unsigned  tsm   :        1;
    unsigned acf    :        8;
    unsigned cdtx   :       16; /* cdt index */

    unsigned blbuff :        1;   /* word 1 of FAT */
    unsigned   mapa :        1;
    unsigned        :        1;
    unsigned   null :        1;
    unsigned  fatus :        1;
    unsigned  tsmio :        1;
    unsigned        :        2;
    char      nas;
    unsigned udtx   :       16; /* udt index */
    int               vnam;
    int           pos;
    int           eom;
    int           eof;
    int           cseg[2];
    int           attr;
    int           ablk[6];
    int           dftaccs;
};

/*  defines for attr  */

#define UNBLASS 0x10000000

struct fcbtag {  /* FCB structure */
    unsigned   :4      ;
    unsigned opcode :4 ;
    char         lfc[3];
    char           *tcw;
    struct fcbbit  cntl;
    int         devstat;
    int            recl;
    int             ioq;
    int          errrtn;
    char       *fataddr;
    char       *bufaddr;
    int         excount;
    int          exracc;
    int          statw1;
    int          statw2;
    int          nwnorm;
    int         nwerrtn;
    char       *blkbuff;
};
struct fpttag  {
    unsigned           :     8;
    char       lfc[3]         ;
    struct fptflgs { /* FPT flag bits */
        unsigned       :     1;
        unsigned  mult :     1;
        unsigned       :     1;
        unsigned  open :     1;
        unsigned  nuse :     1;
        unsigned  psyc :     1;
        unsigned  pfpt :     1;
        unsigned       :     1;
        };
     };
