#include "@system(include_sys)timeb.h"
/*
 * Everything in this file is a routine implementing a system call.
 */
/*
 * return the current time (mpx system binary format)
 */
gtime(it)
int *it[];  /* 2wd array, wd 1= days since 1/1/1960 */
/*            wd 2= time in .1 ms since midnight */
{
    int reg[8],cc;
    reg[1]=( (int) &it[0] | 0x01000000);
    cc = mpxsvc (0x2050,reg,reg);
}
/*
 * New time entry-- return TOD with milliseconds, timezone,
 * DST flag
 */
#define TIMEZONE (5*60); /* default to EST  */
#define DSTFLAG 1; /* Daylight savings time applicable here */
#define TIMEDIF 0xe45; /* 3653 days from 1960 to 1970 */
ftime(t)
struct timeb *t;
{
    int mpxtime[2];
    gtime(mpxtime);
    t->time =((mpxtime[0]-3653)*86400)+(mpxtime[1]/10000);
    t->millitm =  (mpxtime[1]/10) - ((mpxtime[1]/10000)*1000);
    t->timezone = TIMEZONE;
    t->dstflag = DSTFLAG;
    if(t->mnemonic != (char *)0)*t->mnemonic = '\0';
}
/*
 * Return time in secs from Jan 1, 1970
*/
time(tloc)
int  *tloc;
{
    int mpxtime[2],secs;
    gtime(mpxtime);
    secs =((mpxtime[0]-3653)*86400)+(mpxtime[1]/10000);
    if (tloc != 0) *tloc=secs ;
    return (secs);
}
/*
 * Set the time
 */
stime(t)
    struct timeb t;
{
    /*    this routine does nothing   */
}
/*
 * Set file times
 */
utime(file,timep)
    char  *file;
    int   timep[];
{
    /*    this routine does nothing   */
}
/*
 * Change owner and group of a file
 */
chown(file,owner,group)
    char  *file;
    int   owner,group;
{
    /*    this routine does nothing   */
    return (0); /* return o.k. status */
}
chdir(path)
char *path;
{
    int reg[8],cc;
    reg[1]= (strlen(path)<<24) | (int)  (&path);
    reg[4]=0;   /* no project change  */
    reg[5]=0;   /* no key */
    reg[7]=0;   /* no cnp */
    cc=mpxsvc(0x2027,reg,reg);
    if (reg[7] != 0 ) return (-1) ;
    return (0);
}
times(buf)
int buf[];
{
    int reg[8],cc;
    cc = mpxsvc (0x102d,reg,reg);
    buf[0]=reg[7]/16667; /* conv micro-sec to 1/60 secs */
    buf[1]=0;  /* no system time  */
    buf[2]=0;  /* no child time  */
    buf[3]=0;  /* no child system time  */
}
getpid()    /* get program number*/
{
    int reg[8],data[9],cc;
    reg[5]=0x80000000 ;
    reg[7]=(int)(&data[0]);
    cc = mpxsvc(0x1064,reg,reg);
    return (data[0]);/*return tak number */
}
