#ident	"@(#)Makefile:make.sed	$Revision$"

# Make parameters when running on Unix

DISK1 = system
RTE = /usr/rte/bin
DISK3 = nasa3
RSX_DIR = com_src
NAME = sed

PREFIX = nb
INCLUDE = /system/$(PREFIX)include
BIN = /system/bin
CPFLAGS = -M -I/rsx/cheaders
CC = $(BIN)/$(PREFIX)cc
CFLAGS = -G -QC
#CFLAGS = 
FFLAGS = -G
LDFLAGS = -Y$(NAME)map
MAKEFILE = make.$(NAME)

OBJECTS = sedlib.o\
	buffin.o\
	sed.o

HDRS =

SRCS = sedlib.f\
	buffin.s\
	sed.f

MAIN = sed.e

all:	$(MAIN)
	$(BIN)/echo $(MAIN) is Re-Built

.s.o:
	$(CC) $(CFLAGS) -c $<

sed.o:
	$(RTE)/ncd $(DISK3) $(RSX_DIR)
	if [ ! -f sed.f ]; then co -q sed.f; fi
	$(RTE)/rteput -a sed.f
	$(RTE)/tsm nbcc $(FFLAGS) -c sed.f
	$(RTE)/rteget sed.o
	$(RTE)/tsm delete sed.f
	if [ ! -w sed.f ]; then rm -f sed.f; fi

sedlib.o:
	$(RTE)/ncd $(DISK3) $(RSX_DIR)
	if [ ! -f sedlib.f ]; then co -q sedlib.f; fi
	$(RTE)/rteput -a sedlib.f
	$(RTE)/tsm nbcc $(FFLAGS) -c sedlib.f
	$(RTE)/rteget sedlib.o
	$(RTE)/tsm delete sedlib.f
	if [ ! -w sedlib.f ]; then rm -f sedlib.f; fi

$(MAIN):	$(MAKEFILE) $(OBJECTS)
	$(BIN)/cmprs -O$(NAME)_objs $(OBJECTS)
	$(RTE)/ncd $(DISK3) $(RSX_DIR)
	$(RTE)/rteput $(NAME)_objs
	if [ ! -f rsx.$(NAME) ]; then co -q rsx.$(NAME); fi
	if [ ! -f $(NAME).cat ]; then co -q $(NAME).cat; fi
	$(RTE)/rteput -a -tabs rsx.$(NAME) $(NAME).cat
	$(RTE)/tsm make -f rsx.$(NAME)
	$(RTE)/rteget -a $(NAME)map
	$(RTE)/rteget $(MAIN)
	if [ ! -w rsx.$(NAME) ]; then rm -f rsx.$(NAME); fi
	if [ ! -w $(NAME).cat ]; then rm -f $(NAME).cat; fi

clean:
	$(BIN)/rm -f $(OBJECTS) $(NAME)_objs
	$(BIN)/rm -f $(SRCS)
	$(BIN)/rm -f $(HDRS)
	if [ ! -w $(NAME).cat ]; then rm -f $(NAME).cat; fi
	$(BIN)/rm -f $(NAME)map
	$(RTE)/ncd $(DISK3) $(RSX_DIR)
	if [ ! -f rsx.$(NAME) ]; then co -q rsx.$(NAME); fi
	$(RTE)/rteput -a -tabs rsx.$(NAME)
	$(RTE)/tsm make -f rsx.$(NAME) clean
	if [ ! -w rsx.$(NAME) ]; then rm -f rsx.$(NAME); fi

clobber: clean
	$(BIN)/rm -f $(MAIN)
	$(RTE)/ncd $(NASA3) $(RSX_DIR)
	if [ ! -f rsx.$(NAME) ]; then co -q rsx.$(NAME); fi
	$(RTE)/rteput -a -tabs rsx.$(NAME)
	$(RTE)/tsm make -f rsx.$(NAME) clobber
	if [ ! -w rsx.$(NAME) ]; then rm -f rsx.$(NAME); fi

depend: $(SRCS) $(HDRS) $(MAKEFILE)
	$(BIN)/dodep $(CPFLAGS) $(MAKEFILE) $(SRCS) >dep.out
	$(BIN)/mv dep.out $(MAKEFILE)

install: all
	$(RTE)/ncd $(DISK1) system
	$(RTE)/rteput $(MAIN)
	$(RTE)/tsm \@$(DISK1)\(bin\)chtyp ca $(MAIN)
	$(RTE)/ncd $(DISK3) system
	$(RTE)/rteput $(MAIN)
	$(RTE)/tsm \@$(DISK1)\(bin\)chtyp ca $(MAIN)
	$(BIN)/echo $(MAIN) Installed on $(DISK3)

# DO NOT DELETE THIS LINE -- the dependencies begin here
