   00001                                * PRE FILE FOR NON-EXTENDED MODE OF MPX-32 REV 3  RELEASE 3.6   MPX_NON
   00072                                C.3227   SETT
   00073                                C.TRACF  SETF
   00074                                C.MEMO   SETF
   00075                                BOPT_MPX SETF
   00076                                C.FWMID  SETF                                                   EMMM-35A
   00077                                C.DPMODE SETF                                                   EMMM-35B
   00078                                C.DPDEV  SETF                                                   EMMM-35B
   00079                                MPX_SVC  SET       6                                            ECAL-35
   00080                                C.MPXOUT SETF                                                   EOUT-35
   00081                                *.EXTD35 SETT                                           E2CCM35 EIPU360
   00082                                *.SEAR   SETF                                           E2CCM35 EIPU360
   00083                                *.RISCFL SETT                                          E2CCM35A EIPU360
   00084                                *.INITF  SETF                                          E2CCM35B EIPU360
   00085                                *.SEGRFL SETF                                          E2CCM35A E2SEG35
   00086                                *.SEGRFL SETT                                           E2SEG35 EIPU360
   00087                                *.BRSTK  SETT                                          E2CCM35C EIPU360
   00088                                *.BUFIO  SETT                                           S920301 EIPU360
   00089                                         REIS                                                   EOUT-35
   00090                                         LIST      NOMAC
   00091   P00000                                M.SETREV  3.6,2                                        EIPU360
   00092                                         LIST      MAC
   00093                                *        DISKUT    PROGRAM CDISK
   00094                                ************************************************************************
   00095                                *
   00096                                *   THIS PROGRAM ALLOWS THE USER TO EXAMINE AND CHANGE ANYTHING ON
   00097                                *   A DISK PACK.
   00098                                *
   00099                                *   ACTIVATION SEQUENCE:   TSM>CDISK
   00100                                *
   00101                                ************************************************************************
   00102                                         LIST      NODATA,NOMAC,NOREP
   00103                                         PROGRAM   CDISK
  
   00105   P00000                                M.EQUS
   00106   P00000                                M.DFT.
   00107   P00000                                M.FCB.
   00108   P00000                                M.UDT.
   00109   P00000                                M.RR.TEQ
   00110                                         EXT       AUTODISK,AUTOFLAG                           032991RLW
  
   00112   P00000                       START    EQU       $
   00113   P00000  C806104C                      SVC       1,X'4C'         GET PROGRAM OPTION WORD
   00114   P00004  27F3                          TBR       R7,31           CHECK FOR OPTION ONE
   00115   P00008  F0800011   P00010             BNS       ST1             NO SKIP
   00116   P0000C  99880AFC   P00AFC             SBM       3,FLAG          SET FLAG FOR ALOC/DEALOC SLO OUTPUT
   00117   P00010                       ST1      EQU       $
   00118   P00010  2773                          TBR       R7,30           CHECK FOR NO SUPPRESSION
   00119   P00014  F080001D   P0001C             BNS       ST2             NO SKIP
   00120   P00018  9B080AFC   P00AFC             SBM       6,FLAG          SET FLAG FOR NO SUPPRESSION
   00121   P0001C                       ST2      EQU       $
   00122   P0001C  AF800B30   P00B30             LW        R7,HELLOTCW     TCW FOR "TYPE ?" MESSAGE
   00123   P00020  F88007CB   P007CA             BL        OPCOM1          SEND MESSAGE TO 'UT'
   00124   P00024                       NEXTCMND EQU       $
   00125   P00024  AF800B24   P00B24             LW        R7,CMDINTCW     TCW FOR 'COMMAND=' MESSAGE
   00126   P00028  AF000B5C   P00B5C             LW        R6,OPINTCW      ADDR & BYTE COUNT FOR OPER INPUT
   00127   P0002C  F88007DD   P007DC             BL        OPCOM2          OUTPUT MESSAGE AND WAIT FOR INPUT
   00128   P00030                                M.TSCAN                   GET FIRST INPUT ARGUMENT
   00129   P00034  2ED0                          TRR       R5,R5           ANY INPUT ?
   00130   P00038  EE000055   P00054             BEQ       NOCMD           NO, BRANCH TO BAD COMMAND LOGIC
   00131   P0003C  0C90                          ZR        R1              INITIALIZE COMMAND TABLE INDEX
   00132   P0003E      7310                      SRL       R6,16           LOOK AT FIRST TWO CHARS INPUT
   00133   P00040                       CMDCHECK EQU       $
   00134   P00040  93200A2C   P00A2C             CAMW      R6,CMDTABL,X1   MATCH WITH ENTRY IN COMMAND TABLE ?
   00135   P00044  EE000061   P00060             BEQ       PROCCMD         YES, GO PROCESS COMMAND
   00136   P00048  2293                          ABR       R1,29           NO, INCREMENT INDEX TO NEXT CMD IN TABL
   00137   P0004C  C8850038                      CI        R1,CMDTABLL     DID WE RUN OUT THE BOTTOM OF TABLE ?
   00138   P00050  ED800041   P00040             BLT       CMDCHECK        NO, GO BACK FOR ANOTHER TRY
   00139   P00054                       NOCMD    EQU       $
   00140   P00054  AF800B1C   P00B1C             LW        R7,BADCMTCW     TCW FOR INVALID COMMAND MESSAGE
   00141   P00058  F88007CB   P007CA             BL        OPCOM1          TELL OPERATOR THE COMMAND WAS NO GOOD
   00142   P0005C  EC00001D   P0001C             BU        ST2             START OVER AT 'TYPE ?'
   00143   P00060                       PROCCMD  EQU       $
   00144   P00060  F8B00A65   P00A64             BL        *CMDVECTR,X1    GO TO APPROPRIATE ROUTINE FOR THIS CMD
   00145   P00064  EC000025   P00024             BU        NEXTCMND        START OVER AT 'COMMAND='
   00147                                ************************************************************************
   00148                                *               SUBROUTINE  DISPLAY
   00149                                ************************************************************************
   00150                                *   THIS ROUTINE DISPLAYS THE CONTENTS OF THE HOLDING BUFFER ON
   00151                                *   THE USER'S CRT.
   00152                                *
   00153                                *   INPUT REGS--  NONE
   00154                                *
   00155                                *   OUTPUT REGS-- NONE
   00156                                ************************************************************************
   00157   P00068                       DISPLAY  EQU       $
   00158   P00068  D4000A10   P00A10             STW       R0,SAVER0
   00159   P0006C  A5080AFC   P00AFC             TBM       2,FLAG          READ OR WRITE OCCURRED ON THIS UNIT ?
   00160   P00070  EC80007D   P0007C             BS        SECNUMOK        YES, THEN A SECTOR NUM HAS BEEN DEFINED
   00161   P00074  AF000A0A   P00A08             LD        R6,UNKNOWN      NO, PUT 'UNKNOWN' IN DISPLAY TO OPER
   00162   P00078  EC000089   P00088             BU        SECTOUT         SKIP THE CONV TO ASCII
   00163   P0007C                       SECNUMOK EQU       $
   00164   P0007C  AE800AB0   P00AB0             LW        R5,SECNUM       GET CURRENTLY ACTIVE SECTOR NUMBER
   00165   P00080                                M.CONBAH                  CONV SECTOR TO ASCII
   00166   P00084  87000AF8   P00AF8             ANMW      R6,ZERTOBLK     CONV 2 MSB (BYTES) FROM ZERO TO BLANK
   00167   P00088                       SECTOUT  EQU       $
   00168   P00088  D70012E2   P012E0             STD       R6,SECDISP      PUT SECTOR NUM IN ERROR MESSAGE
   00169   P0008C  CB80000D                      LI        R7,X'0D'        CARRIAGE RETURN
   00170   P00090  D78812D0   P012D0             STB       R7,SECNM        PUT CARRIAGE CONTROL CHAR IN CRT MESG
   00171   P00094  AF800B68   P00B68             LW        R7,SECNMTCW     TCW FOR 'SECTOR NUMBER =' MESSAGE
   00172   P00098  F88007CB   P007CA             BL        OPCOM1          SEND INFO TO 'UT'
   00173   P0009C  0D20                          ZR        R2              INITIALIZE OFFSET INTO HOLDING BUFFER
   00174   P0009E                       DOALINE  EQU       $
   00175   P000A0  F88007B1   P007B0             BL        CLRLINE         CLEAR LINE BUFFER FOR NEXT LINE
   00176   P000A4  34800C54   P00C54             LA        R1,LINE         ADDR OF LINE TO RECEIVE ASCII
   00177   P000A8  35800C88   P00C88             LA        R3,LINE+52      PART OF LINE CONTAINING DUMP ANNOTATION
   00178   P000AC  CA00FFFC                      LI        R4,-4           TELL BILDLINE TO MAKE DISPLAY 4 WIDE
   00179   P000B0  AF800B28   P00B28             LW        R7,DISPTCW      TCW FOR DISPLAYING ONE LINE OF INFO
   00180   P000B4  F88006E9   P006E8             BL        BILDLINE        BUILD ONE LINE OF DISPLAY FROM BUFF
   00181   P000B8  A6080AFC   P00AFC             TBM       4,FLAG          IS SUPPRESSION FLAG SET ?
   00182   P000BC  EC8000CD   P000CC             BS        ENDTST          YES, SKIP LINE OUTPUT
   00183   P000C0  F88007CB   P007CA             BL        OPCOM1          SEND THE LINE TO 'UT'
   00184   P000C4  A7A8000C    0000C             TBM       7,FCB.SFLG,X1   DID OPER TERM AT 'ENTER CR FOR MORE' ?
   00185   P000C8  EC8000D5   P000D4             BS        DISPRTRN        YES, RETURN
   00186   P000CC                       ENDTST   EQU       $
   00187   P000CC  91000A1C   P00A1C             CAMW      R2,BUFFSIZE     FINISHED THE BUFFER ?
   00188   P000D0  ED80009F   P0009E             BLT       DOALINE         NO, GO BACK AND DO ANOTHER LINE
   00189   P000D4                       DISPRTRN EQU       $
   00190   P000D4  EC100A11   P00A10             BU        *SAVER0         RETURN
   00192                                ************************************************************************
   00193                                *               SUBROUTINE  DUMP
   00194                                ************************************************************************
   00195                                *   THIS ROUTINE DUMPS THE CONTENTS OF THE HOLDING BUFFER TO THE
   00196                                *   SLO DEVICE. IF ANY ARGUMENT IS SUPPLIED, NO SUPPRESSION WILL OCCUR.
   00197                                *
   00198                                *   INPUT REGS-- NONE     OUTPUT REGS-- NONE
   00199                                ************************************************************************
   00200   P000D8  D4000A10   P00A10    DUMP     STW       R0,SAVER0       SAVE R0
   00201   P000DC  CB800030                      LI        R7,X'30'        FORM CONTROL CHAR
   00202   P000E0  D78812D0   P012D0             STB       R7,SECNM        PUT IN MESSAGE TO LINE PRINTER
   00203   P000E4  9E880AFC   P00AFC             ZBM       5,FLAG          CLEAR FIRST TIME FLAG FOR DUPLICATES
   00204   P000E8  A5880AFC   P00AFC             TBM       3,FLAG          CHECK FLAG FOR SINGLE ALOCATION
   00205   P000EC  F08000F9   P000F8             BNS       DU01            NO SKIP
   00206   P000F0  9B880AFC   P00AFC             SBM       7,FLAG          SET ALLOCATED FLAG
   00207   P000F4  EC80011D   P0011C             BS        DU02            YES ALLOCATED
   00208   P000F8                       DU01     EQU       $
   00209   P000F8  CB800031                      LI        R7,X'31'        TOP OF FORM CONTROL CHAR
   00210   P000FC  D78812D0   P012D0             STB       R7,SECNM        PUT IN MESSAGE TO LINE PRINTER
   00211   P00100                                M.ASSN    SLORRS          ALLOC SLO FILE
   00212   P0010C  EC80019D   P0019C             BS        ALOCERR         SKIP ON ERROR
   00213   P00110                                M.OPENR   LINEPFCB
   00214   P0011C                       DU02     EQU       $
   00215   P0011C  A5080AFC   P00AFC             TBM       2,FLAG          READ OR WRITE OCCURRED ON THIS UNIT ?
   00216   P00120  EC80012D   P0012C             BS        SECVALOK        YES, BRANCH (USE SECTOR NUM AS IS)
   00217   P00124  AF000A0A   P00A08             LD        R6,UNKNOWN      USE 'UNKNOWN' IN PLACE OF SECTOR VALUE
   00218   P00128  EC000139   P00138             BU        SECOUT          SKIP CONVERSION
   00219   P0012C                       SECVALOK EQU       $
   00220   P0012C  AE800AB0   P00AB0             LW        R5,SECNUM       GET CURRENT SECTOR NUMBER
   00221   P00130                                M.CONBAH                  CONVERT TO ASCII
   00222   P00134  87000AF8   P00AF8             ANMW      R6,ZERTOBLK     CONV 2 MSB (BYTES) FROM ZERO TO BLANK
   00223   P00138                       SECOUT   EQU       $
   00224   P00138  D70012E2   P012E0             STD       R6,SECDISP      PUT ASCII IN OUTPUT MESSAGE
   00225   P0013C  AF800B68   P00B68             LW        R7,SECNMTCW     TCW FOR 'SECTOR NUMBER =' MESSAGE
   00226   P00140  348009D8   P009D8             LA        R1,LINEPFCB     ADDR FOR LINE PRINTER FCB
   00227   P00144  D7A00004    00004             STW       R7,FCB.TCW,X1   PUT TCW IN FCB
   00228   P00148  C8061032                      SVC       1,X'32'         WRITE TO LINE PRINTER
   00229   P0014C  0D20                          ZR        R2              INITIALIZE OFFSET INTO HOLDING BUFFER
   00230   P0014E                       NEXTLINE EQU       $
   00231   P00150  F88007B1   P007B0             BL        CLRLINE         CLEAR THE OUTPUT LINE
   00232   P00154  34800C54   P00C54             LA        R1,LINE         ADDR OF BUFF TO RECEIVE ASCII
   00233   P00158  35800CAC   P00CAC             LA        R3,LINE+88      PART OF LINE CONTAINING DUMP ANNOTATION
   00234   P0015C  CA00FFF8                      LI        R4,-8           TELL BILDLINE TO MAKE PRINTOUT 8 WIDE
   00235   P00160  AF800B44   P00B44             LW        R7,LPTCW        TCW TO OUTPUT ONE LINE TO LINE PRINTER
   00236   P00164  F88006E9   P006E8             BL        BILDLINE        BUILD ONE LINE OF DISPLAY FROM BUFF
   00237   P00168  A6080AFC   P00AFC             TBM       4,FLAG          IS SUPPRESSION FLAG SET ?
   00238   P0016C  EC80017D   P0017C             BS        ENDTEST         YES, SKIP LINE PRINTER OUTPUT
   00239   P00170  348009D8   P009D8             LA        R1,LINEPFCB     ADDR FOR LINE PRINTER FCB
   00240   P00174  D7A00004    00004             STW       R7,FCB.TCW,X1   PUT TCW IN FCB
   00241   P00178  C8061032                      SVC       1,X'32'         WRITE TO SLO
   00242   P0017C  91000A1C   P00A1C    ENDTEST  CAMW      R2,BUFFSIZE     HIT THE END OF BUFFER ?
   00243   P00180  ED80014F   P0014E             BLT       NEXTLINE        NO, GO BACK TILL DONE
   00244   P00184  A5880AFC   P00AFC             TBM       3,FLAG          CHECK FOR NO DASSIGN
   00245   P00188  EC800199   P00198             BS        DUMPRTRN
   00246   P0018C                                M.DASN    SLORRSP         DEASSSN SLO FILE
   00247   P00198  EC100A11   P00A10    DUMPRTRN BU        *SAVER0         RETURN
   00248   P0019C  AF800B14   P00B14    ALOCERR  LW        R7,ALOERTCW     TCW FOR SLO ALLOCATION PROBLEM
   00249   P001A0  F88007CB   P007CA             BL        OPCOM1          SEND ERROR MESSAGE TO OPERATOR
   00250   P001A4  EC100A11   P00A10             BU        *SAVER0         RETURN
  
  
   00252                                ************************************************************************
   00253                                *               SUBROUTINE   EXAMINE
   00254                                ************************************************************************
   00255                                *   THIS ROUTINE DISPLAYS THE CONTENTS OF THE HOLDING BUFFER A WORD
   00256                                *   AT A TIME AND ALLOWS THE USER TO MODIFY IT, IF DESIRED. THIS COMMAND
   00257                                *   HAS AN OPTIONAL ARGUMENT SPECIFYING WHICH BUFFER WORD TO START WITH.
   00258                                *
   00259                                *   INPUT REGS--  NONE
   00260                                *
   00261                                *   OUTPUT REGS-- NONE
   00262                                ************************************************************************
   00263   P001A8                       EXAMINE  EQU       $
   00264   P001A8  D4000A10   P00A10             STW       R0,SAVER0       SAVE R0
   00265   P001AC                                M.TSCAN                   GET BUFF LOCATION, IF ANY INPUT
   00266   P001B0  2DD0                          TRR       R5,R3           ASSUME NO ARGUMENT
   00267   P001B4  EE0001DB   P001DA             BEQ       DISPWORD        IF NO ARGUMENT, BRANCH
   00268   P001B8                                M.CONAHB                  CONVERT ARGUMENT TO BINARY
   00269   P001BC  2F60                          TRR       R6,R6           BAD ARGUMENT INPUT ?
   00270   P001C0  EE000279   P00278             BEQ       EXAMERR1        YES, INFORM OPER
   00271   P001C4  93800A1C   P00A1C             CAMW      R7,BUFFSIZE     IS ARGUMENT TO BIG?
   00272   P001C8  EE800285   P00284             BGE       EXAMERR2        YES, BRANCH
   00273   P001CC  0F60                          ZR        R6              CLEAR FOR UPCOMING DIVIDE
   00274   P001D0  CB040004                      DVI       R6,4            FORCE ADDRESS TO BE A
   00275   P001D4  CB030004                      MPI       R6,4                  MULTIPLE OF 4
   00276   P001D8  2DF0                          TRR       R7,R3           USE BUFFER OFFSET AS AN INDEX
   00277   P001DA                       DISPWORD EQU       $
   00278   P001DA      2EB0                      TRR       R3,R5           MOVE BUFFER OFFSET VALUE FOR CONV
   00279   P001DC                                M.CONBAH                  CONV TO ASCII HEX
   00280   P001E0  D7800CDC   P00CDC             STW       R7,EXADDR       PUT IN EXAMINE DISPLAY MESSAGE
   00281   P001E4  AEE01360   P01360             LW        R5,BUFF,X3      GET DATA VALUE AT THIS ADDR
   00282   P001E8                                M.CONBAH                  CONV TO ASCII HEX
   00283   P001EC  D7000CF2   P00CF0             STD       R6,EXVALU       PUT VALUE IN MESSAGE
   00284   P001F0  C880FFFC                      LI        R1,-4
   00285   P001F4                       DISP.1   EQU       $
   00286   P001F4  0E40                          ZR        R4
   00287   P001F6      7E48                      SLLD      R4,8
   00288   P001F8  CA050020                      CI        R4,G' '
   00289   P001FC  ED800209   P00208             BLT       DISP.2
   00290   P00200  CA05007E                      CI        R4,X'7E'
   00291   P00204  EF00020D   P0020C             BLE       DISP.3
   00292   P00208                       DISP.2   EQU       $
   00293   P00208  CA00005F                      LI        R4,G'_'
   00294   P0020C                       DISP.3   EQU       $
   00295   P0020C  D6280CE9   P00CE9             STB       R4,DISPA+4,X1
   00296   P00210  F48001F5   P001F4             BIB       R1,DISP.1
   00297   P00214                       DISPOUT  EQU       $
   00298   P00214  AF800B2C   P00B2C             LW        R7,EXDISTCW     TCW FOR EXAMINE DISPLAY
   00299   P00218  AF000B60   P00B60             LW        R6,EXINTCW
   00300   P0021C  F88007DD   P007DC             BL        OPCOM2          DISPLAY ADDR & DATA, WAIT FOR NEW VALUE
   00301   P00220                                M.TSCAN                   GET CHANGE DATA, IF ANY
   00302   P00224  2ED0                          TRR       R5,R5           ANY INPUT ?
   00303   P00228  EE00026D   P0026C             BEQ       CONTEXAM        NO, NO CHANGE DATA, GO TO NEXT ADDR
   00304   P0022C  AF000B00   P00B00             LW        R6,FLAG+1W      GET DATA
   00305   P00230  AF800B04   P00B04             LW        R7,FLAG+2W
   00306   P00234  2EE0                          TRR       R6,R5           PRESERVE OPER INPUT DURING CHECKS
   00307   P00236      7290                      SRL       R5,16           POSITION FIRST TWO CHARS FOR COMPARISON
   00308   P00238  CA854327                      CI        R5,G'C"''       EQUAL TO "C'" ?
   00309   P0023C  F2000249   P00248             BNE       CHECKX          NO, GO CHECK FOR 'X'
   00310   P00240  7F10                          SRLD      R6,16           YES, PUT ALL 4 ASCII BYTES IN SAME REG
   00311   P00244  EC000269   P00268             BU        NEWVAL          GO PUT NEW VALUE IN BUFF
   00312   P00248                       CHECKX   EQU       $
   00313   P00248  CA855820                      CI        R5,X'5820'      EQUAL TO 'X ' ?
   00314   P0024C  EE100A11   P00A10             BEQ       *SAVER0         YES, RETURN
   00315   P00250                                M.CONAHB                  NO, CONVERT TO BINARY
   00316   P00254  2F60                          TRR       R6,R6           VALID NUMERIC INPUT ?
   00317   P00258  F2000269   P00268             BNE       NEWVAL          YES, GO USE IT
   00318   P0025C  AF800B18   P00B18             LW        R7,BADATTCW     TCW FOR BAD DATA MESSAGE
   00319   P00260  F88007CB   P007CA             BL        OPCOM1          SEND MESSAGE TO 'UT'
   00320   P00264  EC000215   P00214             BU        DISPOUT         GIVE HIM ANOTHER CHANCE
   00321   P00268                       NEWVAL   EQU       $
   00322   P00268  D7E01360   P01360             STW       R7,BUFF,X3      REPLACE VALUE IN BUFF
   00323   P0026C                       CONTEXAM EQU       $
   00324   P0026C  22B3                          ABR       R3,29           INCR BUFF INDEX TO NEXT FULL WORD
   00325   P00270  91800A1C   P00A1C             CAMW      R3,BUFFSIZE     HIT END OF BUFFER ?
   00326   P00274  ED8001DB   P001DA             BLT       DISPWORD        NO, GO BACK AND DO NEXT LOC IN BUFFER
   00327   P00278                       EXAMERR1 EQU       $
   00328   P00278  AF800B3C   P00B3C             LW        R7,INVADTCW     TCW FOR INVALID ADDRESS MESSAGE
   00329   P0027C  F88007CB   P007CA             BL        OPCOM1          SEND MESSAGE TO 'UT'
   00330   P00280  EC100A11   P00A10             BU        *SAVER0         RETURN
   00331   P00284                       EXAMERR2 EQU       $
   00332   P00284  AF800B70   P00B70             LW        R7,TOBIGTCW     TCW FOR ADDRESS TO BIG MESSAGE
   00333   P00288  F88007CB   P007CA             BL        OPCOM1          SEND MESSAGE TO 'UT'
   00334   P0028C  EC100A11   P00A10             BU        *SAVER0         RETURN
  
  
   00336                                ************************************************************************
   00337                                *              SUBROUTINE    FILL
   00338                                ************************************************************************
   00339                                *   THIS ROUTINE ALLOWS THE USER TO FILL THE HOLDING BUFFER WITH ANY
   00340                                *   BIT PATTERN DESIRED. THE ARGUMENT CONSISTS OF 1 TO 8 NUMERIC HEX
   00341                                *   DIGITS (1,2FC,FFFFFFFF, ETC.) OR UP TO 4 ALPHA CHARACTERS
   00342                                *   PROCEEDED BY "C'"(C'ABCD,C'XY, ETC.)
   00343                                *
   00344                                *   INPUT REGS--  NONE
   00345                                *
   00346                                *   OUTPUT REGS-- NONE
   00347                                ************************************************************************
   00348   P00290                       FILL     EQU       $
   00349   P00290  D4000A10   P00A10             STW       R0,SAVER0       SAVE R0
   00350   P00294                                M.TSCAN                   GET THE FILL VALUE
   00351   P00298  0DB0                          ZR        R3              ZERO FOR STORE INDEX
   00352   P0029A      2FD0                      TRR       R5,R7           DID OPER INPUT AN ARGUMENT ?
   00353   P0029C  EE0002C9   P002C8             BEQ       FILLOOP         NO FILL WITH ZEROS
   00354   P002A0  AF000B00   P00B00             LW        R6,FLAG+1W      GET INPUT
   00355   P002A4  AF800B04   P00B04             LW        R7,FLAG+2W
   00356   P002A8  2EE0                          TRR       R6,R5           PRESERVE INPUT DURING CHECKS
   00357   P002AA      7290                      SRL       R5,16           POSITION FIRST TWO CHARS FOR COMPARISON
   00358   P002AC  CA854327                      CI        R5,X'4327'      EQUAL TO "C'" ?
   00359   P002B0  F20002BD   P002BC             BNE       FILLCONV        NO, GO DO CONVERSION
   00360   P002B4  7F10                          SRLD      R6,16           YES, MOVE ALL 4 ASCII BYTES TO ONE REG
   00361   P002B8  EC0002C9   P002C8             BU        FILLOOP         GO STRAIGHT TO FILL LOOP
   00362   P002BC                       FILLCONV EQU       $
   00363   P002BC                                M.CONAHB                  CONV INPUT TO HEX
   00364   P002C0  2F60                          TRR       R6,R6           VALID NUMERIC INPUT ?
   00365   P002C4  EE0002E1   P002E0             BEQ       FILLERR1        NO, INFORM OPER
   00366   P002C8                       FILLOOP  EQU       $
   00367   P002C8  D7E01360   P01360             STW       R7,BUFF,X3      PUT FILL VALUE IN BUFF
   00368   P002CC  22B3                          ABR       R3,29           INCR INDEX TO NEXT WORD IN BUFF
   00369   P002D0  91800A1C   P00A1C             CAMW      R3,BUFFSIZE     HIT END OF BUFFER ?
   00370   P002D4  F20002C9   P002C8             BNE       FILLOOP         NO, GO FILL SOME MORE
   00371   P002D8  9D080AFC   P00AFC             ZBM       2,FLAG          CLEAR READ OR WRITE DONE FLAG
   00372   P002DC  EC100A11   P00A10             BU        *SAVER0         RETURN
   00373   P002E0                       FILLERR1 EQU       $
   00374   P002E0  AF800B18   P00B18             LW        R7,BADATTCW     TCW FOR BAD DATA MESSAGE
   00375   P002E4  F88007CB   P007CA             BL        OPCOM1          SEND MESSAGE TO 'UT'
   00376   P002E8  EC100A11   P00A10             BU        *SAVER0         RETURN
  
  
   00378                                ************************************************************************
   00379                                *              SUBROUTINE    READ (AND WRITE)
   00380                                ************************************************************************
   00381                                *   THIS ROUTINE READS FROM DISK INTO THE HOLDING BUFFER (OR WRITES TO
   00382                                *   THE DISK FROM THE BUFFER). THIS COMMAND REQUIRES ONE ARGUMENT
   00383                                *   (IN HEX) TO SPECIFY THE DESIRED SECTOR.
   00384                                *
   00385                                *   INPUT REGS--  NONE
   00386                                *
   00387                                *   OUTPUT REGS-- NONE
   00388                                ************************************************************************
   00389   P002EC                       READ     EQU       $
   00390   P002EC  9C880AFC   P00AFC             ZBM       1,FLAG          CLEAR READ/WRITE FLAG (0=READ)
   00391   P002F0  EC0002F9   P002F8             BU        COMMON          GO TO COMMON LOGIC
   00392   P002F4                       WRITE    EQU       $
   00393   P002F4  98880AFC   P00AFC             SBM       1,FLAG          SET READ/WRITE FLAG (1=WRITE)
   00394   P002F8                       COMMON   EQU       $
   00395   P002F8  D4000A10   P00A10             STW       R0,SAVER0       SAVE R0
   00396   P002FC  A4080AFC   P00AFC             TBM       0,FLAG          HAS A DISK BEEN SELECTED ?
   00397   P00300  F08003A5   P003A4             BNS       IOERR4          NO, INFORM OPERATOR
   00398   P00304                                M.TSCAN                   GET ARGUMENT (SECTOR NUMBER)
   00399   P00308  2ED0                          TRR       R5,R5           DID OPERATOR SUPPLY AN ARGUMENT ?
   00400   P0030C  EE00038D   P0038C             BEQ       IOERR1          NO, TELL OPERATOR TO MEND HIS WAYS
   00401   P00310  2EE0                          TRR       R6,R5           PRESERVE OPERATOR INPUT DURING CHECKS
   00402   P00312      76C8                      SLC       R5,8            POSITION FIRST CHAR OF ARGUMENT
   00403   P00314  86800AA8   P00AA8             ANMW      R5,SAVELSB      ISOLATE LEAST SIG BYTE
   00404   P00318  AE000AB0   P00AB0             LW        R4,SECNUM       GET CURRENT SECTOR VALUE
   00405   P0031C  CA85004E                      CI        R5,X'4E'        FIRST CHAR OF INPUT EQUAL TO 'N' ?
   00406   P00320  F200032D   P0032C             BNE       CKSAME          NO, GO CHECK FOR 'S'
   00407   P00324  BA000AC0   P00AC0             ADMW      R4,SECTINCR     INCR SECTOR NUM TO NEXT VAL (SEC OR TRK
   00408   P00328  EC000341   P00340             BU        SETSECNM        GO STORE NEW SECTOR VALUE
   00409   P0032C                       CKSAME   EQU       $
   00410   P0032C  CA850053                      CI        R5,X'53'        EQUAL TO 'S' ?
   00411   P00330  EE000341   P00340             BEQ       SETSECNM        GO STORE NEW SECTOR VALUE
   00412   P00334  CA85004C                      CI        R5,X'4C'        EQUAL TO 'L' ?
   00413   P00338  F2000349   P00348             BNE       RDWRCONV        NO, GO CONV INPUT
   00414   P0033C  BE000AC0   P00AC0             SUMW      R4,SECTINCR     YES, BACK UP SECTOR VAL (SEC OR TRACK)
   00415   P00340                       SETSECNM EQU       $
   00416   P00340  2FC0                          TRR       R4,R7           NEED NEW SECTOR MOVED FOR LIMIT CHECKS
   00417   P00344  EC000355   P00354             BU        READTEST        GO VALIDATE NEW SECTOR VALUE
   00418   P00348                       RDWRCONV EQU       $
   00419   P00348                                M.CONAHB                  CONV ASCII INPUT TO HEX
   00420   P0034C  2F60                          TRR       R6,R6           VALID NUMERIC INPUT ?
   00421   P00350  EE000395   P00394             BEQ       IOERR2          NO, TELL OPERATOR
   00422   P00354                       READTEST EQU       $
   00423   P00354  93800A9C   P00A9C             CAMW      R7,ENDOFDSK     IS SECTOR VAL TOO BIG FOR THIS DISK ?
   00424   P00358  EE80039D   P0039C             BGE       IOERR3          YES, GO INFORM OPERATOR
   00425   P0035C  2FF0                          TRR       R7,R7           IS SECTOR VALUE BELOW ZERO ?
   00426   P00360  ED80039D   P0039C             BLT       IOERR3          YES, INFORM OPERATOR
   00427   P00364  D7800AB0   P00AB0             STW       R7,SECNUM       REPLACE OLD SECTOR VAL WITH NEW
   00428   P00368  34800940   P00940             LA        R1,DISKFCB      ADDR OF DISK I/O FCB
   00429   P0036C  D7A00028    00028             STW       R7,FCB.ERAA,X1  PUT NEW RANDOM ACCESS SECTOR IN FCB
   00430   P00370  A4880AFC   P00AFC             TBM       1,FLAG          ARE WE DOING A READ ?
   00431   P00374  EC800381   P00380             BS        DOWRITE         NO, BRANCH
   00432   P00378  C8061031                      SVC       1,X'31'         DO A READ
   00433   P0037C  EC000385   P00384             BU        CHEKSTAT        GO CHECK I/O STATUS
   00434   P00380                       DOWRITE  EQU       $
   00435   P00380  C8061032                      SVC       1,X'32'         DO A WRITE
   00436   P00384                       CHEKSTAT EQU       $
   00437   P00384  F88007F5   P007F4             BL        STATCHEK        CHECK I/O STATUS
   00438   P00388  EC100A11   P00A10             BU        *SAVER0         RETURN
   00439   P0038C                       IOERR1   EQU       $
   00440   P0038C  AF800B48   P00B48             LW        R7,NOADDTCW     TCW FOR NO ADDRESS SPECIFIED
   00441   P00390  EC0003C1   P003C0             BU        ERRCOM          GO TO COMMON ERROR LOGIC
   00442   P00394                       IOERR2   EQU       $
   00443   P00394  AF800B3C   P00B3C             LW        R7,INVADTCW     TCW FOR INVALID ADDRESS MESSAGE
   00444   P00398  EC0003C1   P003C0             BU        ERRCOM          GO TO COMMON ERROR LOGIC
   00445   P0039C                       IOERR3   EQU       $
   00446   P0039C  AF800B70   P00B70             LW        R7,TOBIGTCW     TCW FOR ADDR IS TOO BIG MESSAGE
   00447   P003A0  EC0003C1   P003C0             BU        ERRCOM          GO TO COMMON ERROR LOGIC
   00448   P003A4                       IOERR4   EQU       $
   00449   P003A4  AF800B4C   P00B4C             LW        R7,NODSKTCW     TCW FOR NO DISK SPECIFIED MESSAGE
   00450   P003A8  EC0003C1   P003C0             BU        ERRCOM          GO TO COMMON ERROR LOGIC
   00451   P003AC                       IOERR5   EQU       $
   00452   P003AC  AF800B50   P00B50             LW        R7,NOSIZTCW     TCW FOR NO SIZE SPECIFIED MESSAGE
   00453   P003B0  EC0003C1   P003C0             BU        ERRCOM          GO TO COMMON ERROR LOGIC
   00454   P003B4                       IOERR6   EQU       $
   00455   P003B4  AF800B54   P00B54             LW        R7,INVSZTCW     TCW FOR INVALID SIZE MESSAGE
   00456   P003B8  EC0003C1   P003C0             BU        ERRCOM          GO TO COMMON ERROR LOGIC
   00457   P003BC                       IOERR7   EQU       $
   00458   P003BC  AF800B58   P00B58             LW        R7,INVSNTCW     TCW FOR NEGATIVE SIZE MESSAGE
   00459   P003C0                       ERRCOM   EQU       $
   00460   P003C0  F88007CB   P007CA             BL        OPCOM1          SEND MESSAGE TO 'UT'
   00461   P003C4  EC100A11   P00A10             BU        *SAVER0         RETURN
  
  
   00463                                ************************************************************************
   00464                                *              SUBROUTINE    SECTOR (TRACK)
   00465                                ************************************************************************
   00466                                *   THIS ROUTINE CONTROLS THE LENGTH OF I/O OPERATIONS (SECTOR OR TRACK)
   00467                                *   AND UPDATES INFO FOR STATUS MESSAGES.
   00468                                *
   00469                                *   INPUT REGS--  NONE
   00470                                *
   00471                                *   OUTPUT REGS-- NONE
   00472                                ************************************************************************
   00473   P003C8                       SECTOR   EQU       $
   00474   P003C8  AD800AB4   P00AB4             LW        R3,SECSNDSK     NUMBER OF SECTORS ON WHOLE DISK
   00475   P003CC  AE0009FA   P009F8             LD        R4,SECT         ASCII FOR 'SECTOR'
   00476   P003D0  CB000001                      LI        R6,1            NUMBER OF SECTORS PER I/O
   00477   P003D4  AF800AC4   P00AC4             LW        R7,SECTSIZE     NUMBER OF BYTES IN ONE SECTOR
   00478   P003D8  EC0003F5   P003F4             BU        STOREVAL        GO SET BUFFSIZE
   00479   P003DC                       TRACK    EQU       $
   00480   P003DC  AD800AB4   P00AB4             LW        R3,SECSNDSK     NUMBER OF SECTORS ON WHOLE DISK
   00481   P003E0  BD800AB8   P00AB8             SUMW      R3,SECSNTRK     BACK UP ONE TRACK
   00482   P003E4  23B3                          ABR       R3,31           MAKE END OF DSK 1 PAST STRT OF LAST TRK
   00483   P003E8  AE000A02   P00A00             LD        R4,TRAC         ASCII FOR 'TRACK'
   00484   P003EC  AF000AB8   P00AB8             LW        R6,SECSNTRK     NUMBER OF SECTORS PER I/O
   00485   P003F0  AF800AEC   P00AEC             LW        R7,TRAKSIZE     NUMBER OF BYTES IN ONE TRACK
   00486   P003F4                       STOREVAL EQU       $
   00487   P003F4  D5800A9C   P00A9C             STW       R3,ENDOFDSK     STORE VALUE FOR END OF DISK TEST
   00488   P003F8  D600132A   P01328             STD       R4,STATUS3      PUT I/O MODE IN STATUS MESSAGE
   00489   P003FC  D7000AC0   P00AC0             STW       R6,SECTINCR     SET SECTOR INCREMENT TO PROPER VALUE
   00490   P00400  D7800A1C   P00A1C             STW       R7,BUFFSIZE     SET BUFFSIZE TO PROPER MODE
   00491   P00404  34800940   P00940             LA        R1,DISKFCB      ADDR OF DISK I/O FCB
   00492   P00408  D7A00024    00024             STW       R7,FCB.EQTY,X1  PUT BYTE COUNT IN FCB
   00493   P0040C  2800                          TRSW      R0              RETURN
   00494   P0040E      0002                      NOP
  
  
  
  
   00497                                ************************************************************************
   00498                                *              SUBROUTINE  SETSEC
   00499                                ************************************************************************
   00500                                *   THIS ROUTINE CONTROLS THE LENGTH OF I/O OPERATIONS FOR SECTOR
   00501                                *
   00502                                *   INPUT REGS--  NONE
   00503                                *
   00504                                *   OUTPUT REGS-- NONE
   00505                                ************************************************************************
   00506   P00410                       SETSEC   EQU       $
   00507   P00410  D4000A10   P00A10             STW       R0,SAVER0       SAVE R0
   00508   P00414                                M.TSCAN                   GET ARGUMENT (SECTOR NUMBER)
   00509   P00418  2ED0                          TRR       R5,R5           DID OPERATOR SUPPLY AN ARGUMENT ?
   00510   P0041C  EE0003AD   P003AC             BEQ       IOERR5          NO, TELL OPERATOR TO MEND HIS WAYS
   00511   P00420                                M.CONADB                  CONV ASCII DECIMAL INPUT TO HEX
   00512   P00424  2F60                          TRR       R6,R6           VALID NUMERIC INPUT ?
   00513   P00428  EE0003B5   P003B4             BEQ       IOERR6          NO, TELL OPERATOR
   00514   P0042C  2FF0                          TRR       R7,R7           IS SECTOR VALUE BELOW ZERO ?
   00515   P00430  ED8003BD   P003BC             BLT       IOERR7          YES, INFORM OPERATOR
   00516   P00434  D7800AC4   P00AC4             STW       R7,SECTSIZE     REPLACE OLD SECTOR VAL WITH NEW
   00517   P00438  D7800A1C   P00A1C             STW       R7,BUFFSIZE     USE THIS LENGTH
   00518   P0043C  EC100A11   P00A10             BU        *SAVER0         RETURN
  
  
   00520                                ************************************************************************
   00521                                *               SUBROUTINE CHECK
   00522                                ************************************************************************
   00523                                *   THIS ROUTINE READ DISK FROM INPUT START SECTOR TO INPUT END SECTOR
   00524                                *
   00525                                *   INPUT REGS--  NONE
   00526                                *
   00527                                *   OUTPUT REGS-- NONE
   00528                                ************************************************************************
   00529   P00440                       CHECK    EQU       $                                           061692RLW
   00530   P00440  D4000A10   P00A10             STW       R0,SAVER0       SAVE RETURN ADDRESS         061692RLW
   00531   P00444  A4080AFC   P00AFC             TBM       0,FLAG          HAS A DISK BEEN SELECTED ?  061692RLW
   00532   P00448  F08003A5   P003A4             BNS       IOERR4          NO, INFORM OPERATOR         061692RLW
   00533   P0044C  34800940   P00940             LA        R1,DISKFCB      GET DISK FCB ADDRESS        061692RLW
   00534   P00450  ADA00024    00024             LW        R3,FCB.EQTY,X1  SAVE TRANSFERR QUANTY       061692RLW
   00535   P00454                                M.TSCAN                   GET START SECTOR ADDRESS    061692RLW
   00536   P00458  2ED0                          TRR       R5,R5           ANY INPUT                   061692RLW
   00537   P0045C  EE00038D   P0038C             BEQ       IOERR1          NO ERROR                    061692RLW
   00538   P00460  2EE0                          TRR       R6,R5                                       061692RLW
   00539   P00462      7298                      SRL       R5,24           GET FIRST CHARACTER         061692RLW
   00540   P00464  CA850053                      CI        R5,G'S'         CHECK FOR START             061692RLW
   00541   P00468  F2000475   P00474             BNE       CH.01           NO SKIP                     061692RLW
   00542   P0046C  0FF0                          ZR        R7              YES SET TO ZERO             061692RLW
   00543   P00470  EC000489   P00488             BU        CH.02                                       061692RLW
   00544   P00474                       CH.01    EQU       $                                           061692RLW
   00545   P00474  CA850041                      CI        R5,G'A'         CHECK FOR ALL               061692RLW
   00546   P00478  EE00052D   P0052C             BEQ       CH.20           YES SKIP                    061692RLW
   00547   P0047C                                M.CONAHB                  CONVERT TO BINARY           061692RLW
   00548   P00480  2F60                          TRR       R6,R6           CHECK FOR ERROR             061692RLW
   00549   P00484  EE00038D   P0038C             BEQ       IOERR1          YES SKIP                    061692RLW
   00550   P00488                       CH.02    EQU       $                                           061692RLW
   00551   P00488  D7800AC8   P00AC8             STW       R7,STSEC        SAVE STARTING SECTOR ADDRESS061692RLW
   00552   P0048C                                M.TSCAN                   GET ENDING SECTOR ADDRESS   061692RLW
   00553   P00490  2ED0                          TRR       R5,R5           ANY INPUT                   061692RLW
   00554   P00494  EE00038D   P0038C             BEQ       IOERR1          NO ERROR                    061692RLW
   00555   P00498  2EE0                          TRR       R6,R5                                       061692RLW
   00556   P0049A      7298                      SRL       R5,24           GET FIRST CHARACTER         061692RLW
   00557   P0049C  CA850045                      CI        R5,G'E'         CHECK FOR END               061692RLW
   00558   P004A0  F20004AD   P004AC             BNE       CH.03           NO SKIP                     061692RLW
   00559   P004A4  AF800AB4   P00AB4             LW        R7,SECSNDSK     GET ENDING SECTOR OF DISK   061692RLW
   00560   P004A8  EC0004C5   P004C4             BU        CH.04                                       061692RLW
   00561   P004AC                       CH.03    EQU       $                                           061692RLW
   00562   P004AC                                M.CONAHB                  CONVERT TO BINARY           061692RLW
   00563   P004B0  2F60                          TRR       R6,R6           CHECK FOR ERROR             061692RLW
   00564   P004B4  EE00038D   P0038C             BEQ       IOERR1          YES SKIP                    061692RLW
   00565   P004B8  93800AC8   P00AC8             CAMW      R7,STSEC        CHECK IF SECOND ARG LESS    070792RLW
   00566   P004BC  ED0004C5   P004C4             BGT       CH.04           THAN START SECTOR NUMBER    070792RLW
   00567   P004C0  BB800AC8   P00AC8             ADMW      R7,STSEC        YES ADD START SEC NO        070792RLW
   00568   P004C4                       CH.04    EQU       $                                           061692RLW
   00569   P004C4  D7800ACC   P00ACC             STW       R7,SPSEC        SAVE STOP SECTOR ADDRESS    061692RLW
   00570   P004C8  0F60                          ZR        R6                                          061692RLW
   00571   P004CC  AF800AC8   P00AC8             LW        R7,STSEC        GET STARTING SECTOR ADDRESS 061692RLW
   00572   P004D0  D7A00028    00028             STW       R7,FCB.ERAA,X1  PUT IN FCB                  061692RLW
   00573   P004D4  C7000AB8   P00AB8             DVMW      R6,SECSNTRK     DEVIDE BY SECTORS PER TRK   061692RLW
   00574   P004D8  2EE0                          TRR       R6,R5           REMAINDER                   061692RLW
   00575   P004DC  EE0004FD   P004FC             BEQ       CH.07           NONE SKIP                   061692RLW
   00576   P004E0  BE800AB8   P00AB8             SUMW      R5,SECSNTRK                                 061692RLW
   00577   P004E4  AF800AC4   P00AC4             LW        R7,SECTSIZE     GET BYTES PER SECTOR        061692RLW
   00578   P004E8  D7A00024    00024             STW       R7,FCB.EQTY,X1  PUT IN FCB                  061692RLW
   00579   P004EC                       CH.06    EQU       $                                           061692RLW
   00580   P004EC  C8061031                      SVC       1,X'31'         READ                        061692RLW
   00581   P004F0  F88007F5   P007F4             BL        STATCHEK        GO CHECK STATUS             061692RLW
   00582   P004F4  A3A8002B    0002B             ABM       31,FCB.ERAA,X1  INCRMENT SECTOR ADDRESS     061692RLW
   00583   P004F8  F68004ED   P004EC             BIB       R5,CH.06        LOOP TO END OF TRK          061692RLW
   00584   P004FC                       CH.07    EQU       $                                           061692RLW
   00585   P004FC  AF800AEC   P00AEC             LW        R7,TRAKSIZE     GET BYTES PER TRACK         061692RLW
   00586   P00500  D7A00024    00024             STW       R7,FCB.EQTY,X1  PUT IN FCB                  061692RLW
   00587   P00504  AF000AB8   P00AB8             LW        R6,SECSNTRK     GET SECTORS PER TRACK       061692RLW
   00588   P00508                       CH.08    EQU       $                                           061692RLW
   00589   P00508  C8061031                      SVC       1,X'31'         READ                        061692RLW
   00590   P0050C  F88007F5   P007F4             BL        STATCHEK        GO CHECK STATUS             061692RLW
   00591   P00510  AFA00028    00028             LW        R7,FCB.ERAA,X1  GET CURRENT SECTOR ADDR     061692RLW
   00592   P00514  3BE0                          ADR       R6,R7           INCRMENT TO NEXT TRACK      061692RLW
   00593   P00518  D7A00028    00028             STW       R7,FCB.ERAA,X1  PUT IN FCB                  061692RLW
   00594   P0051C  93800ACC   P00ACC             CAMW      R7,SPSEC        CHECK FOR END               061692RLW
   00595   P00520  ED800509   P00508             BLT       CH.08           NO LOOP                     061692RLW
   00596   P00524  D5A00024    00024             STW       R3,FCB.EQTY,X1  RESTORE QUANITY             061692RLW
   00597   P00528  EC100A11   P00A10             BU        *SAVER0         RETURN                      061692RLW
   00598   P0052C                       CH.20    EQU       $                                           061692RLW
   00599   P0052C  F8200028    00028             ZMW       FCB.ERAA,X1     CLEAR STARTING SECTOR       061692RLW
   00600   P00530  AF800AB4   P00AB4             LW        R7,SECSNDSK     GET TOTAL NUMBER OF SECTORS 061692RLW
   00601   P00534  D7800ACC   P00ACC             STW       R7,SPSEC        SAVE                        061692RLW
   00602   P00538  EC0004FD   P004FC             BU        CH.07                                       061692RLW
  
  
   00604                                ************************************************************************
   00605                                *               SUBROUTINE  UNIT
   00606                                ************************************************************************
   00607                                *   THIS ROUTINE VALIDATES THE DISK DRIVE ARGUMENT AND IF IT IS
   00608                                *   OK, A FILE THE SIZE OF THE WHOLE DISK IS ALLOCATED AND OPENED.
   00609                                *
   00610                                *   INPUT REGS--  NONE
   00611                                *
   00612                                *   OUTPUT REGS-- NONE
   00613                                ************************************************************************
   00614   P0053C                       UNIT     EQU       $
   00615   P0053C  D4000A10   P00A10             STW       R0,SAVER0       SAVE R0
   00616   P00540                                M.TSCAN                   GET UNIT ARGUMENT
   00617   P00544  2ED0                          TRR       R5,R5           ARGUMENT PRESENT ?
   00618   P00548  EE000575   P00574             BEQ       UNITERR         NO, TELL OPERATOR
   00619   P0054C  D7000AF4   P00AF4             STW       R6,UNITASCI     SAVE ASCII FOR UNIT
   00620   P00550                                M.CONAHB                  CONVERT ASCII TO HEX BINARY
   00621   P00554  2F60                          TRR       R6,R6           VALID NUMERIC INPUT ?
   00622   P00558  EE000575   P00574             BEQ       UNITERR         NO, TELL OPERATOR
   00623   P0055C  AD800B38    00B38             LW        R3,C.UDTA       ADDR OF FIRST UDT
   00624   P00560  B6000C39    00C38             LNH       R4,C.UDTN       NUMBER OF UDTS LINKED TO SYSTEM
   00625   P00564                       UDTCHECK EQU       $
   00626   P00564  93E00007    00006             CAMH      R7,UDT.CHAN,X3  SEE IF OPER INPUT MATCHES CHAN & SUBADD
   00627   P00568  EE000581   P00580             BEQ       UDTMATCH        YES, GO DO FURTHER CHECKS
   00628   P0056C  C9810040                      ADI       R3,UDT.SIZE     ADJUST POINTER TO NEXT UDT
   00629   P00570  F6000565   P00564             BIB       R4,UDTCHECK     GO BACK TILL NO MORE UDTS
   00630   P00574                       UNITERR  EQU       $
   00631   P00574  AF800B40   P00B40             LW        R7,INVALTCW     TCW FOR INVALID DEVICE
   00632   P00578                       ASSIGNER EQU       $
   00633   P00578  F88007CB   P007CA             BL        OPCOM1          SEND MESSAGE TO OPERATOR
   00634   P0057C  EC100A11   P00A10             BU        *SAVER0         RETURN
   00635   P00580                       UDTMATCH EQU       $
   00636   P00580  1872                          SBR       R7,16
   00637   P00584  D78009AB   P009AA             STH       R7,DISKRRS1+9H
   00638   P00588  A4680004    00004             TBM       UDT.ONLI,UDT.STAT,X3
   00639   P0058C  F080068D   P0068C             BNS       OFFLINE         UNIT IS OFFLINE
   00640   P00590  AF680005    00005             LB        R6,UDT.DTC,X3   GET DEVICE TYPE FROM UDT
   00641   P00594  EE000575   P00574             BEQ       UNITERR         LESS THAN 1 ?
   00642   P00598  CB050003                      CI        R6,3            DISKS HAVE CODES 1 TO 3 INCLUSIVE
   00643   P0059C  ED000575   P00574             BGT       UNITERR         IF NOT A DISK BRANCH
   00644   P005A0  AFE00001    00000             LH        R7,UDT.UDTI,X3  GET ASSOCIATED UDT INDEX
   00645   P005A4  D7800AF0   P00AF0             STW       R7,UDTI         STORE AWAY FOR ALLOCATION
   00646   P005A8  AFE00014    00014             LW        R7,UDT.SECS,X3  TOTAL NUMBER OF SECTORS ON THIS DISK
   00647   P005AC  F20005D9   P005D8             BNE       NOINIT          SKIP IF ALREADY INITIALIZED 032991RLW
   00648   P005B0  7F08                          SRLD      R6,8            DEVICE TYPE CODE TO BYTE 0  032991RLW
   00649   P005B2      1870                      SBR       R7,0                                        032991RLW
   00650   P005B4  8B8009AB   P009AA             ORMH      R7,DISKRRS1+9H  OR IN DEVICE ADDRESS        032991RLW
   00651   P005B8  99080000   X00000             SBM       2,AUTOFLAG      SET FLAG FOR AUTODISK       032991RLW
   00652   P005BC  F8800001   X00000             BL        AUTODISK        GET DISK INFORMATION        032991RLW
   00653   P005C0  F08005D5   P005D4             BNS       DISKOK          GOOD RETURN                 041296RLW
   00654   P005C4  CB800200                      LI        R7,512          SET SECTOR SIZE TO 512      041296RLW
   00655   P005C8  D7800AC4   P00AC4             STW       R7,SECTSIZE                                 041296RLW
   00656   P005CC  AF800A20   P00A20             LW        R7,NOSEC512                                 041296RLW
   00657   P005D0  D7E00014    00014             STW       R7,UDT.SECS,X3  SET UP UDT                  041296RLW
   00658   P005D4                       DISKOK   EQU       $                                           041296RLW
   00659   P005D4  AFE00014    00014             LW        R7,UDT.SECS,X3  TOTAL NUMBER OF SEDTORS     032991RLW
   00660   P005D8                       NOINIT   EQU       $                                           032991RLW
   00661   P005D8  D7800AB4   P00AB4             STW       R7,SECSNDSK     SAVE TOTAL SECTORS
   00662   P005DC  D7800A9C   P00A9C             STW       R7,ENDOFDSK     SET END OF DISK SECTOR VALUE
   00663                                ***      LH        R7,UDT.SSIZ,X3  SIZE OF ONE SECTOR(IN WORDS) ON DISK
   00664                                ***      SLL       R7,2            NEED SIZE IN BYTES
   00665                                ***      STW       R7,SECTSIZE     SAVE SECTOR SIZE
   00666   P005E0  AF800AC4   P00AC4             LW        R7,SECTSIZE     USE DEFAULT SECTOR SIZE     022196RLW
   00667   P005E4  AEE80011    00011             LB        R5,UDT.SPT,X3   NUMBER OF SECTORS PER TRACK
   00668   P005E8  D6800AB8   P00AB8             STW       R5,SECSNTRK     SAVE SECTORS PER TRACK
   00669   P005EC  4350                          MPR       R5,R6           CALCULATE TRACK SIZE IN BYTES
   00670   P005F0  D7800AEC   P00AEC             STW       R7,TRAKSIZE     SAVE TRACK SIZE
   00671   P005F4  AFE0001B    0001A             LH        R7,UDT.NHDS,X3  GET NUMBER OF HEADS         061192RLW
   00672   P005F8  4350                          MPR       R5,R6           GET NO. OF SECTORS PER CYL  061192RLW
   00673   P005FC  D7800ABC   P00ABC             STW       R7,SECCYL       SAVE                        061192RLW
   00674   P00600  AE00132A   P01328             LD        R4,STATUS3      GET CURRENT I/O MODE
   00675   P00604  92000A02   P00A00             CAMD      R4,TRAC         EQUAL TO 'TRACK   ' ?
   00676   P00608  EE000611   P00610             BEQ       SETBUFSZ        YES, BRANCH
   00677   P0060C  AF800AC4   P00AC4             LW        R7,SECTSIZE     NO, USE SECTOR SIZE FOR TRANSFER CNT
   00678   P00610                       SETBUFSZ EQU       $
   00679   P00610  D7800A1C   P00A1C             STW       R7,BUFFSIZE     USE THIS UNIT'S LENGTHS
   00680   P00614  98080AFC   P00AFC             SBM       0,FLAG          FIRST TIME TO PROCESS A UNIT COMMAND ?
   00681   P00618  F0800629   P00628             BNS       SKIPDEAL        YES, SKIP THE DEALLOCATE
   00682   P0061C                                M.DASN    DISKRRSP        DEASSIGN DISK
   00683   P00628                       SKIPDEAL EQU       $
   00684   P00628  AE800AF0   P00AF0             LW        R5,UDTI
   00685   P0062C  D6880986   P00986             STB       R5,DISKRRS+RR.UDTI
   00686   P00630  F8000990   P00990             ZMW       DISKRRS+RR.STBLK
   00687   P00634  AF800AB4   P00AB4             LW        R7,SECSNDSK
   00688   P00638  D7800994   P00994             STW       R7,DISKRRS+RR.NBLKS
   00689   P0063C                                M.ASSN    DISKRRS,IMEDCNP
   00690   P00648  F0800665   P00664             BNS       OKALOC
   00691   P0064C                                M.ASSN    DISKRRS1,IMEDCNP
   00692   P00658  F0800665   P00664             BNS       OKALOC
   00693   P0065C  AF800B74   P00B74             LW        R7,ASSERTCW     ASSIGN ERROR TCW
   00694   P00660  EC000579   P00578             BU        ASSIGNER
   00695   P00664                       OKALOC   EQU       $
   00696   P00664                                M.OPENR   DISKFCB,IMEDCNP
   00697   P00670  AF800A1C   P00A1C             LW        R7,BUFFSIZE     GET SIZE OF TRANSFERS DESIRED
   00698   P00674  D7A00024    00024             STW       R7,FCB.EQTY,X1  PUT TRANSFER COUNT IN FCB
   00699   P00678  AF800AF4   P00AF4             LW        R7,UNITASCI     ASCII FOR NEW UNIT JUST SELECTED
   00700   P0067C  D7801300   P01300             STW       R7,STATUS1      PUT IT IN STATUS MESSAGE
   00701   P00680  D78012F4   P012F4             STW       R7,SECUNIT      PUT IT IN DISPLAY AND DUMP HEADER
   00702   P00684  9D080AFC   P00AFC             ZBM       2,FLAG          CLEAR READ OR WRITE DONE FLAG
   00703   P00688  EC100A11   P00A10             BU        *SAVER0         RETURN
   00704   P0068C                       OFFLINE  EQU       $
   00705   P0068C  AF800B7C   P00B7C             LW        R7,OFFTCW       GET OFFLINE MESSAGE TCW
   00706   P00690  EC000579   P00578             BU        ASSIGNERR
  
  
   00708                                ************************************************************************
   00709                                *              SUBROUTINE    STATUS
   00710                                ************************************************************************
   00711                                *   THIS ROUTINE DISPLAYS STATUS FOR THE USER. INFO CONSISTS OF CURRENT
   00712                                *   DISK UNIT, CURRENT SECTOR VALUE AND CURRENT I/O MODE.
   00713                                *
   00714                                *   INPUT REGS--  NONE
   00715                                *
   00716                                *   OUTPUT REGS-- NONE
   00717                                ************************************************************************
   00718   P00694                       STATUS   EQU       $
   00719   P00694  D4000A10   P00A10             STW       R0,SAVER0       SAVE R0
   00720   P00698  A4080AFC   P00AFC             TBM       0,FLAG          CHECK FOR DISK ASSIGNED
   00721   P0069C  F08006A9   P006A8             BNS       STAT.EX         NO SKIP
   00722   P006A0  34800940   P00940             LA        R1,DISKFCB      GET ADDRESS OF DISK FCB
   00723   P006A4  F8800815   P00814             BL        SKIPINOP        GO READ STATUS FROM DISK
   00724   P006A8                       STAT.EX  EQU       $
   00725   P006A8  EC100A11   P00A10             BU        *SAVER0         RETURN
   00727                                ************************************************************************
   00728                                *               SUBROUTINE  EXIT
   00729                                ************************************************************************
   00730                                *   THIS ROUTINE CLOSES AND DEALLOCATES THE TEMPORARY DISK FILE, THEN
   00731                                *   EXITS.
   00732                                *
   00733                                *   INPUT REGS--  NONE
   00734                                *
   00735                                *   REGISTERS MODIFIED-- R1,R2,R5,R7
   00736                                *
   00737                                *   OUTPUT REGS-- NONE
   00738                                ************************************************************************
   00739   P006AC                       EXIT     EQU       $
   00740   P006AC  A4080AFC   P00AFC             TBM       0,FLAG          IS ANY DISK UNIT ACTIVE ?
   00741   P006B0  F08006C1   P006C0             BNS       WEGONE          NO, SKIP DEALLOCATION
   00742   P006B4                                M.DASN    DISKRRSP        DEASSIGN DISK
   00743   P006C0                       WEGONE   EQU       $
   00744   P006C0                                M.EXIT                    EXIT
  
  
   00746                                ************************************************************************
   00747                                *               SUBROUTINE  HELP
   00748                                ************************************************************************
   00749                                *   THIS ROUTINE DISPLAYS ALL THE AVAILABLE COMMANDS TO THE USER.
   00750                                *
   00751                                *   INPUT REGS--  NONE
   00752                                *
   00753                                *   OUTPUT REGS-- NONE
   00754                                ************************************************************************
   00755   P006C4                       HELP     EQU       $
   00756   P006C4  D4000A10   P00A10             STW       R0,SAVER0       SAVE R0
   00757   P006C8  AE000AE8   P00AE8             LW        R4,TCWMASK      MASK TO CLEAR 12 MSBS
   00758   P006CC  36801220   P01220             LA        R5,HELPEND      ADDR OF END OF HELP MESSAGE
   00759   P006D0  AF800B34   P00B34             LW        R7,HELPTCW      TCW FOR HELP MESSAGES
   00760   P006D4                       HELPOUT  EQU       $
   00761   P006D4  F88007CB   P007CA             BL        OPCOM1          SEND ONE LINE OF HELP INFO TO 'UT'
   00762   P006D8  CB810050                      ADI       R7,80           INCR BUFFER ADDR BY ONE LINE
   00763   P006DC  2F78                          TRRM      R7,R6           MOVE ADDR PART OF TCW
   00764   P006DE      1350                      CAR       R5,R6           RUN OUT OF HELP INFO ?
   00765   P006E0  ED8006D5   P006D4             BLT       HELPOUT         NO, KEEP SHOVELING IT OUT
   00766   P006E4  EC100A11   P00A10             BU        *SAVER0         RETURN
   00768                                ************************************************************************
   00769                                *               SUBROUTINE  BILDLINE
   00770                                ************************************************************************
   00771                                *   THIS ROUTINE BUILDS AN OUTPUT LINE OF CHARACTERS FROM THE CONTENTS
   00772                                *   OF THE HOLDING BUFFER. THE CALLING ROUTINE SPECIFIES THE NUMBER OF
   00773                                *   COLUMNS AND IF THE OUTPUT IS FOR THE LINE PRINTER, SUPPRESSION OF
   00774                                *   DUPLICATE DATA IS PROVIDED.
   00775                                *
   00776                                *   INPUT REGS--  R2 = OFFSET INTO HOLDING BUFFER
   00777                                *                 R4 = NUMBER OF COLUMNS TO BUILD
   00778                                *
   00779                                *   REGISTERS MODIFIED-- NONE
   00780                                *
   00781                                *   OUTPUT REGS-- R2 = UPDATED OFFSET INTO HOLDING BUFFER
   00782                                ************************************************************************
   00783   P006E8                       BILDLINE EQU       $
   00784   P006E8  DC000900   P00900             STF       R0,SAVEF1       SAVE ALL REGS
   00785   P006EC  D6000AA4   P00AA4             STW       R4,NUMCOLS      SAVE NUMBER OF COLS OF DUMP FOR LATER
   00786   P006F0  2E44                          TRN       R4,R4           MAKE POSITIVE
   00787   P006F2      2EA0                      TRR       R2,R5           GET CURRENT OFFSET IN BUFFER
   00788   P006F4  D6080B12   P00B12             STB       R4,SAMECHK      SAVE
   00789   P006F8                                M.CONBAH                  CONV TO ASCII
   00790   P006FC  D7A00000    00000             STW       R7,0,X1         PUT ASCII FOR BUFF OFFSET IN OUT LINE
   00791   P00700                       GETNXTWD EQU       $
   00792   P00700  AEC01360   P01360             LW        R5,BUFF,X2      GET A DATA WORD FROM HOLDING BUFFER
   00793   P00704  92C0135C   P0135C             CAMW      R5,BUFF-1W,X2   EQUAL TO LAST DATA WORD ?
   00794   P00708  F2000711   P00710             BNE       DATACONV        NO, DON'T INCR COUNTER
   00795   P0070C  A3880B11   P00B11             ABM       7,SAMECNT       YES, KEEP TRACK OF DUPLICATES
   00796   P00710                       DATACONV EQU       $
   00797   P00710                                M.CONBAH                  CONV TO ASCII HEX
   00798   P00714  C8810006                      ADI       R1,6            ADJUST INDEX IN LINE BUFF 6 BYTES
   00799   P00718  CA00FFFC                      LI        R4,-4           SET COUNTER TO DO 1 WORD (4 BYTES)
   00800   P0071C                       STUFAWRD EQU       $
   00801   P0071C  7748                          SLC       R6,8            MOVE A CHAR TO LEAST SIG BYTE
   00802   P0071E      77C8                      SLC       R7,8            MOVE A CHAR TO LEAST SIG BYTE
   00803   P00720  D7280000    00000             STB       R6,0,X1         PUT CHAR IN OUT LINE
   00804   P00724  D7A80004    00004             STB       R7,4,X1         PUT CHAR IN OUT LINE
   00805   P00728  AEC81360   P01360             LB        R5,BUFF,X2      GET A BYTE FROM SAME DATA WORD
   00806   P0072C  CA850020                      CI        R5,X'20'        VALUE LESS THAN PRINTABLE ASCII ?
   00807   P00730  ED80073D   P0073C             BLT       UNDRLINE        YES, SUBSTITUTE AN UNDERLINE CHAR
   00808   P00734  CA85007E                      CI        R5,X'7E'        VALUE GREATER THAN PRINTABLE ASCII ?
   00809   P00738  EF000741   P00740             BLE       OKCHAR          NO, IT'S OK
   00810   P0073C                       UNDRLINE EQU       $
   00811   P0073C  CA80005F                      LI        R5,X'5F'        CODE FOR ASCII UNDERLINE
   00812   P00740                       OKCHAR   EQU       $
   00813   P00740  D6E80000    00000             STB       R5,0,X3         PUT ASCII IN DUMP ANNOTATION AREA OF LI
   00814   P00744  2393                          ABR       R1,31           ADJUST LINE INDEX BY 1 BYTE
   00815   P00746      23A3                      ABR       R2,31           ADJUST BUFF INDEX BY 1 BYTE
   00816   P00748  23B3                          ABR       R3,31           ADJUST ANNOTATION INDEX BY 1 BYTE
   00817   P0074C  F600071D   P0071C             BIB       R4,STUFAWRD     GO BACK TILL 1 WORD (4 BYTES) IS DONE
   00818   P00750  A3880AA7   P00AA7             ABM       31,NUMCOLS      INCR NUM OF COLUMNS TO DO
   00819   P00754  F2000701   P00700             BNE       GETNXTWD        IF HAVEN'T DONE ALL COLS, GO BACK
   00820   P00758  AF00091C   P0091C             LW        R6,SAVEF1+7W    GET TCW IN SAVED REGS
   00821   P0075C  A7080AFC   P00AFC             TBM       6,FLAG          IS NO SUPPRESSION FLAG SET ?
   00822   P00760  EC800791   P00790             BS        BILDRTRN        YES, RETURN
   00823   P00764  AF880B11   P00B11             LB        R7,SAMECNT      GET DUPLICATE COUNT
   00824   P00768  93880B12   P00B12             CAMB      R7,SAMECHK      WHOLE LINE OF SAME STUFF ?
   00825   P0076C  EE00077D   P0077C             BEQ       SUPPTEST        YES, GO TO SUPPRESSION LOGIC
   00826   P00770  9E080AFC   P00AFC             ZBM       4,FLAG          CLEAR OUTPUT SUPPRESSION FLAG
   00827   P00774  9E880AFC   P00AFC             ZBM       5,FLAG          CLEAR FIRST TIME FLAG
   00828   P00778  EC000791   P00790             BU        BILDRTRN        RETURN
   00829   P0077C                       SUPPTEST EQU       $
   00830   P0077C  AF800B64   P00B64             LW        R7,SAMETCW      TCW FOR ' **SAME** ' MESSAGE
   00831   P00780  D780091C   P0091C             STW       R7,SAVEF1+7W    PUT TCW IN SAVED REGS FOR RETURN
   00832   P00784  9A880AFC   P00AFC             SBM       5,FLAG          SET FIRST TIME FLAG
   00833   P00788  F0800791   P00790             BNS       BILDRTRN        IF FIRST TIME, SKIP SUPPRESSION LOGIC
   00834   P0078C  9A080AFC   P00AFC             SBM       4,FLAG          SET SUPPRESSION FLAG
   00835   P00790                       BILDRTRN EQU       $
   00836   P00790  F8080B11   P00B11             ZMB       SAMECNT         RESET DUPLICATE COUNTER
   00837   P00794  D5000908   P00908             STW       R2,SAVEF1+2W    RETURN NEW BUFF INDEX TO CALLING ROUTIN
   00838   P00798  91000A1C   P00A1C             CAMW      R2,BUFFSIZE     LAST WORD OF BUFF ?
   00839   P0079C  ED8007A9   P007A8             BLT       SKPSUPCL        NO, DON'T RESET SUPPRESSION FLAG
   00840   P007A0  9E080AFC   P00AFC             ZBM       4,FLAG          CLEAR SUPPRESSION FLAG
   00841   P007A4  D700091C   P0091C             STW       R6,SAVEF1+7W    PUT TCW IN SAVED REGS FOR RETURN
   00842   P007A8                       SKPSUPCL EQU       $
   00843   P007A8  CC000900   P00900             LF        R0,SAVEF1       RESTORE ALL REGS
   00844   P007AC  2800                          TRSW      R0              RETURN
   00845   P007AE      0002                      NOP
  
   00847                                ************************************************************************
   00848                                *               SUBROUTINE  CLRLINE
   00849                                ************************************************************************
   00850                                *   THIS ROUTINE FILLS THE OUTPUT LINE BUFFER WITH BLANKS.
   00851                                *
   00852                                *   INPUT REGS--  NONE
   00853                                *
   00854                                *   REGISTERS MODIFIED-- NONE
   00855                                *
   00856                                *   OUTPUT REGS-- NONE
   00857                                ************************************************************************
   00858   P007B0                       CLRLINE  EQU       $
   00859   P007B0  DC000900   P00900             STF       R0,SAVEF1       SAVE ALL REGS
   00860   P007B4  C980FF7C                      LI        R3,-132         INIT COUNTER TO DO 132 BYTES
   00861   P007B8  CB800020                      LI        R7,X'20'        ASCII BLANK
   00862   P007BC                       STUFBLNK EQU       $
   00863   P007BC  D7E80CD8   P00CD8             STB       R7,LINE+132,X3  PUT A BLANK IN NEXT BYTE OF LINE BUF
   00864   P007C0  F58007BD   P007BC             BIB       R3,STUFBLNK     INCR INDEX TILL 132 BLANKS ARE STUFFED
   00865   P007C4  CC000900   P00900             LF        R0,SAVEF1       RESTORE ALL REGS
   00866   P007C8  2800                          TRSW      R0              RETURN
  
  
   00868                                ************************************************************************
   00869                                *               SUBROUTINE  OPCOM1 AND OPCOM2
   00870                                ************************************************************************
   00871                                *   OPCOM1 SENDS A MESSAGE (DEFINED BY THE INPUT TCW ARGUMENT)
   00872                                *   TO THE OPERATOR.
   00873                                *
   00874                                *   OPCOM2 SENDS A MESSAGE (DEFINED BY THE INPUT TCW ARGUMENT)
   00875                                *   TO THE OPERATOR AND WAITS FOR HIS REPLY.
   00876                                *
   00877                                *   INPUT REGS--  R7= TCW FOR A MESSAGE TO GO TO THE OPERATOR
   00878                                *
   00879                                *   REGISTERS MODIFIED-- R1,R7
   00880                                *
   00881                                *   OUTPUT REGS-- NONE
   00882                                ************************************************************************
   00883   P007CA                       OPCOM1   EQU       $
   00884   P007CC  34800920   P00920             LA        R1,OPCOMFCB     OPERATOR COMMUNICATION FCB (LFC = UT)
   00885   P007D0  D7A00004    00004             STW       R7,FCB.TCW,X1   PUT TCW IN FCB
   00886   P007D4  C8061032                      SVC       1,X'32'         SEND MESSAGE TO OPERATOR ('UT')
   00887   P007D8  EC0007F1   P007F0             BU        OPCOMRTN        RETURN
   00888   P007DC                       OPCOM2   EQU       $
   00889   P007DC  34800920   P00920             LA        R1,OPCOMFCB     OPERATOR COMMUNICATION FCB (LFC = UT)
   00890   P007E0  D7A00004    00004             STW       R7,FCB.TCW,X1   PUT TCW IN FCB
   00891   P007E4  C8061032                      SVC       1,X'32'         SEND MESSAGE TO OPERATOR ('UT')
   00892   P007E8  D7200004    00004             STW       R6,FCB.TCW,X1   PUT TCW IN FCB
   00893   P007EC  C8061031                      SVC       1,X'31'         READ FROM UT
   00894   P007F0                       OPCOMRTN EQU       $
   00895   P007F0  2800                          TRSW      R0              RETURN
   00896   P007F2      0002                      NOP
  
  
   00898                                ************************************************************************
   00899                                *              SUBROUTINE    STATCHEK
   00900                                ************************************************************************
   00901                                * THIS ROUTINE CHECKS FOR BAD STATUS FOLLOWING DISK I/O
   00902                                * COMPLETION. IF STATUS IS BAD THEN A SENSE COMMAND IS SENT TO THE DISK
   00903                                * PROCESSOR TO OBTAIN DETAIL STATUS, WHICH IS PRESENTED TO THE OPERATOR
   00904                                *
   00905                                *   INPUT REGS--  R1 = ADDR OF ACTIVE FCB
   00906                                *
   00907                                *   REGISTERS MODIFIED--  NONE
   00908                                *
   00909                                *   OUTPUT REGS-- NONE
   00910                                ************************************************************************
   00911   P007F4                       STATCHEK EQU       $
   00912   P007F4  D4000900   P00900             STW       R0,SAVEF1       SAVE R0
   00913   P007F8  A4A8000C    0000C             TBM       1,FCB.SFLG,X1   ANY I/O ERROR ?
   00914   P007FC  F08008E1   P008E0             BNS       NOERROR         NO, RETURN
   00915   P00800  A628000C    0000C             TBM       4,FCB.SFLG,X1   DEVICE INOPERABLE ?
   00916   P00804  F0800815   P00814             BNS       SKIPINOP        NO, SKIP INOP MESSAGE
   00917   P00808  AF800B38   P00B38             LW        R7,INOPTCW      TCW FOR DISK INOP MESSAGE
   00918   P0080C  F88007CB   P007CA             BL        OPCOM1          SEND MESSAGE TO 'UT'
   00919   P00810  EC100901   P00900             BU        *SAVEF1         RETURN
   00920   P00814                       SKIPINOP EQU       $
   00921   P00814  DC000900   P00900             STF       R0,SAVEF1       SAVE REGISTERS
   00922   P00818  AE200022    00020             LD        R4,FCB.ERWA,X1  SAVE BUFFER ADDRESS AND BYTE COUNT
   00923   P0081C  83800AD8   P00AD8             LEAR      R7,SENSSTAR     ABSOLUTE ADDR OF WHERE TO PUT SENSE DAT
   00924   P00820  AF080AD0   P00AD0             LB        R6,SENSIOCD     SAVE OPCODE OUT OF SENSE IOCD
   00925   P00824  D7800AD0   P00AD0             STW       R7,SENSIOCD     PUT ABSOLUTE ADDR IN SENSE IOCD
   00926   P00828  D7080AD0   P00AD0             STB       R6,SENSIOCD     PUT OPCODE BACK
   00927   P0082C  37800AD0   P00AD0             LA        R7,SENSIOCD     GET SENSE IOCD ADDR
   00928   P00830  D7A00020    00020             STW       R7,FCB.ERWA,X1  PUT IT IN FCB
   00929   P00834  99280008    00008             SBM       2,FCB.GCFG,X1   SET PHYCIAL IOCD
   00930   P00838  C8061025                      SVC       1,X'25'         GET SENSE DATA FROM DISK PROCESSOR
   00931   P0083C  9D280008    00008             ZBM       2,FCB.GCFG,X1
   00932   P00840  D6200022    00020             STD       R4,FCB.ERWA,X1  RESTORE ORIGINAL BUFFER ADDR IN FCB
   00933   P00844  AE800AD8   P00AD8             LW        R5,SENSSTAR     GET SENSE STAR REG (CYL,TRK,SEC INFO)
   00934   P00848  C806102B                      SVC       1,X'2B'         CONVERT TO ASCII HEX FOR DISPLAY
   00935   P0084C  D7000C1C   P00C1C             STW       R6,BADSTAT1     PUT IT IN ERROR MESSAGE
   00936   P00850  D7800C20   P00C20             STW       R7,BADSTAT1+1W
   00937   P00854  AE800ADC   P00ADC             LW        R5,SENSSTAR+1W  GET SENSE BUFFER REG
   00938   P00858  C806102B                      SVC       1,X'2B'         CONVERT TO ASCII HEX FOR DISPLAY
   00939   P0085C  D7000C28   P00C28             STW       R6,BADSTAT2     PUT IT IN ERROR MESSAGE
   00940   P00860  D7800C2C   P00C2C             STW       R7,BADSTAT2+1W
   00941   P00864  AE800AE0   P00AE0             LW        R5,SENSSTAR+2W  GET SUBCHANNEL TARGET REGISTER
   00942   P00868  C806102B                      SVC       1,X'2B'         CONVERT TO ASCII HEX FOR DISPLAY
   00943   P0086C  D7000C34   P00C34             STW       R6,BADSTAT3     PUT IT IN ERROR MESSAGE
   00944   P00870  D7800C38   P00C38             STW       R7,BADSTAT3+1W
   00945   P00874  AE800AE4   P00AE4             LW        R5,SENSSTAR+3W  GET DRIVE ATTRIBUTE REGISTER
   00946   P00878  C806102B                      SVC       1,X'2B'         CONVERT TO ASCII HEX FOR DISPLAY
   00947   P0087C  D7000C40   P00C40             STW       R6,BADSTAT4     PUT IT IN ERROR MESSAGE
   00948   P00880  2D10                          TRR       R1,R2           SAVE FCB ADDRESS            061192RLW
   00949   P00884  A4A8000C    0000C             TBM       1,FCB.SFLG,X1   CHECK FOR ERROR
   00950   P00888  F0800895   P00894             BNS       STATONLY        NO SKIP
   00951   P0088C  AF800B20   P00B20             LW        R7,BADSTTCW     TCW FOR CHAN PROG ERROR MESSAGE
   00952   P00890  F88007CB   P007CA             BL        OPCOM1          SEND MESSAGE TO 'UT'
   00953   P00894                       STATONLY EQU       $
   00954   P00894  AE800AD9   P00AD8             LH        R5,SENSSTAR     GET CYL FIELD               061192RLW
   00955   P00898  C2000ABC   P00ABC             MPMW      R4,SECCYL                                   061192RLW
   00956   P0089C  AF880ADA   P00ADA             LB        R7,SENSSTAR+1H  GET TRK FIELD               061192RLW
   00957   P008A0  C3000AB8   P00AB8             MPMW      R6,SECSNTRK                                 061192RLW
   00958   P008A4  3AF0                          ADR       R7,R5                                       061192RLW
   00959   P008A8  BA880ADB   P00ADB             ADMB      R5,SENSSTAR+3                               061192RLW
   00960   P008AC  A4C8000C    0000C             TBM       1,FCB.SFLG,X2   CHECK FOR ERROR             061192RLW
   00961   P008B0  EC8008C1   P008C0             BS        NODEC           YES SKIP                    061192RLW
   00962   P008B4  2ED0                          TRR       R5,R5           CHECK FOR ZERO              061192RLW
   00963   P008B8  EE0008C1   P008C0             BEQ       NODEC                                       061192RLW
   00964   P008BC  CA820001                      SUI       R5,1            BACK UP ONE SECTOR          061192RLW
   00965   P008C0                       NODEC    EQU       $                                           061192RLW
   00966   P008C0                                M.CONBAH                  CONVERT TO ASCII            061192RLW
   00967   P008C4  D7001312   P01310             STD       R6,STATUS2      PUT SEC NUM IN STATUS MEG   061192RLW
   00968   P008C8  AF800B6C   P00B6C             LW        R7,STATTCW      TCW FOR STATUS MESSAGE      061192RLW
   00969   P008CC  F88007CB   P007CA             BL        OPCOM1          SEND STATUS MESSAGE TO 'UT' 061192RLW
   00970   P008D0  AF800B78   P00B78             LW        R7,STATTCW1     GET TCW FOR STATUS MESSAGE
   00971   P008D4  F88007CB   P007CA             BL        OPCOM1          OUTPUT MESSAGE
   00972   P008D8  CC000900   P00900             LF        R0,SAVEF1       RESTORE REGISTERS           061692RLW
   00973   P008DC  EC100901   P00900             BU        *SAVEF1         RETURN
   00974   P008E0                       NOERROR  EQU       $
   00975   P008E0  99080AFC   P00AFC             SBM       2,FLAG          SET READ OR WRITE DONE FLAG
   00976   P008E4  EC100901   P00900             BU        *SAVEF1         RETURN
   00978                                ************************************************************************
   00979                                *      DATA    DEFINITIONS
   00980                                ************************************************************************
  
   00982   P00900  00000000             SAVEF1   REZ       1F
   00983   P00920  00555420             OPCOMFCB GEN       32/G'UT ',224/0
   00984   P00940  00492F4F             DISKFCB  GEN       32/G'I/O',34/1,5/5,185/0,32/W(BUFF),224/0
   00985   P00980  00492F4F             DISKRRS  GEN       32/G'I/O',8/5,8/6,19/1,14/1,21/1,90/0
   00986   P00998  00492F4F             DISKRRS1 GEN       32/G'I/O',8/3,8/6,54/1,27/1,7/1,56/0
   00987   P009B0  004C504F             SLORRS   GEN       32/G'LPO',8/2,8/4,16/100,2/1,33/1,2/1,27/0
   00988   P009C0  00000000             IMEDCNP  GEN       75/5,117/0
   00989   P009D8  004C504F             LINEPFCB GEN       32/G'LPO',12/DISPL,20/B(DISP),192/0
   00990   P009F8  53454354             SECT     DATAD     C'SECTOR  '
   00991   P00A00  54524143             TRAC     DATAD     C'TRACK   '
   00992   P00A08  20554E4B             UNKNOWN  DATAD     C' UNKNOWN'
   00993   P00A10  00000000             SAVER0   REZ       1W
   00994   P00A14  00000980   P00980    DISKRRSP ACW       DISKRRS
   00995   P00A18  000009B0   P009B0    SLORRSP  ACW       SLORRS
   00996   P00A1C  00000300             BUFFSIZE DATAW     768             USE STANDARD 192W SECTOR AS DEFAULT
   00997   P00A20  003F6A50             NOSEC512 DATAW     4155984         NUMBER OF SECTORS WHEN USING 512 BYTES
   00998   P00A24  00000000             BUFOFSET DATAW     0
   00999   P00A28  00FFFFFF             CLRMSB   DATAW     X'FFFFFF'
   01000   P00A2C  00004348             CMDTABL  DATAW     G'CH'           CHECK DISK
   01001   P00A30  00004449                      DATAW     G'DI'           DISPLAY HOLDING BUFF TO 'UT'
   01002   P00A34  00004455                      DATAW     G'DU'           DUMP HOLDING BUFF TO LINE PRINTER
   01003   P00A38  00004558                      DATAW     G'EX'           EXAMINE CONTENTS OF HOLDING BUFFER
   01004   P00A3C  00004649                      DATAW     G'FI'           FILL HOLDING BUFFER WITH A BIT PATTERN
   01005   P00A40  00005245                      DATAW     G'RE'           READ FROM DISK
   01006   P00A44  00005345                      DATAW     G'SE'           SET SECTOR MODE (I/O IN SECTOR INCREMEN
   01007   P00A48  00005354                      DATAW     G'ST'           DISPLAY STATUS TO 'UT'
   01008   P00A4C  00005452                      DATAW     G'TR'           SET TRACK MODE (I/O IN TRACK INCREMENT)
   01009   P00A50  0000554E                      DATAW     G'UN'           DEFINE DISK UNIT FOR I/O
   01010   P00A54  00005752                      DATAW     G'WR'           WRITE TO DISK
   01011   P00A58  00005353                      DATAW     G'SS'           SET SECTOR SIZE
   01012   P00A5C  00005820                      DATAW     G'X '           EXIT
   01013   P00A60  00003F20                      DATAW     G'? '           HELP INFO
   01014    00038                       CMDTABLL EQU       $-CMDTABL
   01015   P00A64                       CMDVECTR EQU       $
   01016   P00A64  00000441   P00440             ACH       CHECK
   01017   P00A68  00000069   P00068             ACH       DISPLAY
   01018   P00A6C  000000D9   P000D8             ACH       DUMP
   01019   P00A70  000001A9   P001A8             ACH       EXAMINE
   01020   P00A74  00000291   P00290             ACH       FILL
   01021   P00A78  000002ED   P002EC             ACH       READ
   01022   P00A7C  000003C9   P003C8             ACH       SECTOR
   01023   P00A80  00000695   P00694             ACH       STATUS
   01024   P00A84  000003DD   P003DC             ACH       TRACK
   01025   P00A88  0000053D   P0053C             ACH       UNIT
   01026   P00A8C  000002F5   P002F4             ACH       WRITE
   01027   P00A90  00000411   P00410             ACH       SETSEC
   01028   P00A94  000006AD   P006AC             ACH       EXIT
   01029   P00A98  000006C5   P006C4             ACH       HELP
   01030   P00A9C  00000000             ENDOFDSK DATAW     0
   01031   P00AA0  4E4F4E45             NONE     DATAW     C'NONE'
   01032   P00AA4  00000000             NUMCOLS  DATAW     0
   01033   P00AA8  000000FF             SAVELSB  DATAW     X'FF'
   01034   P00AAC  00000000             SAVESECT DATAW     0
   01035   P00AB0  00000000             SECNUM   DATAW     0
   01036   P00AB4  00000000             SECSNDSK DATAW     0
   01037   P00AB8  00000000             SECSNTRK DATAW     0
   01038   P00ABC  00000000             SECCYL   DATAW     0                                           061192RLW
   01039   P00AC0  00000001             SECTINCR DATAW     1
   01040   P00AC4  00000300             SECTSIZE DATAW     768                                         022196RLW
   01041   P00AC8  00000000             STSEC    DATAW     0                                           061692RLW
   01042   P00ACC  00000000             SPSEC    DATAW     0                                           061692RLW
   01043   P00AD0  04000000             SENSIOCD DATAW     X'04000000'      SENSE IOCD,  NO CC
   01044   P00AD4  0000000E                      DATAW     X'0000000E'
   01045   P00AD8  00000000             SENSSTAR DATAW     0,0,0,0
   01046   P00AE8  0007FFFF             TCWMASK  DATAW     X'7FFFF'
   01047   P00AEC  00000000             TRAKSIZE DATAW     0
   01048   P00AF0  00000000             UDTI     DATAW     0
   01049   P00AF4  4E4F4E45             UNITASCI DATAW     C'NONE'
   01050   P00AF8  EFEFFFFF             ZERTOBLK DATAW     X'EFEFFFFF'
   01051   P00AFC  00                   FLAG     DATAB     0               *FLAG BITS 0= UNIT SELECTED FLAG
   01052                                *                                  *          1= READ/WRITE FLAG (0=READ
   01053                                *                                  *          2= I/O OCCURRED ON UNIT
   01054                                *                                  *          3= OPTION ONE FLAG
   01055                                *                                  *          4= DUPLICATE LINE MODE
   01056                                *                                  *          5= 1ST PASS OF DUPLIC MODE
   01057                                *                                  *          6= NO SUPPRES OF DUPL LINE
   01058                                *                                  *          7= SLO FILE ASSIGNED
   01059   P00AFD    000000             OPIN     REZ       20
   01060   P00B11    00                 SAMECNT  DATAB     0
   01061   P00B12      00               SAMECHK  DATAB     0
   01062   P00B14                                BOUND     1W
   01063   P00B14  01C80B80   P80B80    ALOERTCW GEN       12/ALPROBL,20/B(ALPROB)
   01064   P00B18  01080BBA   P80BBA    BADATTCW GEN       12/BADATAL,20/B(BADATA)
   01065   P00B1C  01180BCA   P80BCA    BADCMTCW GEN       12/BADCMDL,20/B(BADCMD)
   01066   P00B20  01980BF0   P80BF0    BADSTTCW GEN       12/BADSTATL,20/B(BADSTAT)
   01067   P00B24  00C80C44   P80C44    CMDINTCW GEN       12/CMDINL,20/B(CMDIN)
   01068   P00B28  05080C53   P80C53    DISPTCW  GEN       12/80,20/B(DISP)
   01069   P00B2C  02480CD8   P80CD8    EXDISTCW GEN       12/EXDISPL,20/B(EXDISP)
   01070   P00B30  02280CFC   P80CFC    HELLOTCW GEN       12/HELLOL,20/B(HELLO)
   01071   P00B34  05080D20   P80D20    HELPTCW  GEN       12/80,20/B(HELPMES)
   01072   P00B38  01581220   P81220    INOPTCW  GEN       12/INOPL,20/B(INOP)
   01073   P00B3C  01181235   P81235    INVADTCW GEN       12/INVADL,20/B(INVAD)
   01074   P00B40  01081246   P81246    INVALTCW GEN       12/INVALL,20/B(INVAL)
   01075   P00B44  08580C53   P80C53    LPTCW    GEN       12/133,20/B(DISP)
   01076   P00B48  01681256   P81256    NOADDTCW GEN       12/NOADDL,20/B(NOADD)
   01077   P00B4C  0138126C   P8126C    NODSKTCW GEN       12/NODSKL,20/B(NODSK)
   01078   P00B50  0138127F   P8127F    NOSIZTCW GEN       12/NOSIZL,20/B(NOSIZ)
   01079   P00B54  01481292   P81292    INVSZTCW GEN       12/INVSZL,20/B(INVSZ)
   01080   P00B58  01A812A6   P812A6    INVSNTCW GEN       12/INVSNL,20/B(INVSN)
   01081   P00B5C  01480AFD   P80AFD    OPINTCW  GEN       12/20,20/B(OPIN)
   01082   P00B60  01180B00   P80B00    EXINTCW  GEN       12/17,20/B(FLAG+1W)
   01083   P00B64  00E812C0   P812C0    SAMETCW  GEN       12/SAMEL,20/B(SAME)
   01084   P00B68  028812D0   P812D0    SECNMTCW GEN       12/SECNML,20/B(SECNM)
   01085   P00B6C  038812F8   P812F8    STATTCW  GEN       12/STATL,20/B(STAT)
   01086   P00B70  02C81330   P81330    TOBIGTCW GEN       12/TOBIGL,20/B(TOBIG)
   01087   P00B74  01E80B9C   P80B9C    ASSERTCW GEN       12/ASSERL,20/B(ASSER)
   01088   P00B78  03880C0C   P80C0C    STATTCW1 GEN       12/STAT1L,20/B(STAT1)
   01089   P00B7C  01380BDB   P80BDB    OFFTCW   GEN       12/OFFML,20/B(OFFM)
   01090   P00B80  0D0A4341             ALPROB   DATAB     C'"M"JCAN NOT ALLOCATE SLO FILE.'
   01091    0001C                       ALPROBL  EQU       $-ALPROB
   01092   P00B9C  0D0A4552             ASSER    DATAB     C'"M"JERROR IN ASSIGNING DISK UNIT'
   01093    0001E                       ASSERL   EQU       $-ASSER
   01094   P00BBA      0D0A             BADATA   DATAB     C'"M"JBAD DATA VALUE'
   01095    00010                       BADATAL  EQU       $-BADATA
   01096   P00BCA      0D0A             BADCMD   DATAB     C'"M"JINVALID COMMAND'
   01097    00011                       BADCMDL  EQU       $-BADCMD
   01098   P00BDB        0D             OFFM     DATAB     C'"M"JDEVICE IS OFFLINE'
   01099    00013                       OFFML    EQU       $-OFFM
   01100   P00BF0                                BOUND     1D
   01101   P00BF0  0D0A4449             BADSTAT  DATAB     C'"M"JDISK I/O ERROR OCCURRED'
   01102    00019                       BADSTATL EQU       $-BADSTAT
   01103   P00C0C  0D0A2053             STAT1    DATAW     C'"M"J SENSE DATA = '
   01104   P00C1C  00000000             BADSTAT1 DATAW     0,0
   01105   P00C24  20202020                      DATAW     C' '
   01106   P00C28  00000000             BADSTAT2 DATAW     0,0
   01107   P00C30  20202020                      DATAW     C' '
   01108   P00C34  00000000             BADSTAT3 DATAW     0,0
   01109   P00C3C  20202020                      DATAW     C' '
   01110   P00C40  00000000             BADSTAT4 DATAW     0
   01111    00038                       STAT1L   EQU       $-STAT1
   01112   P00C44  0D0A434F             CMDIN    DATAB     C'"M"JCOMMAND = '
   01113    0000C                       CMDINL   EQU       $-CMDIN
   01114   P00C50                                BOUND     1W
   01115   P00C50  202020                        DATAB     C'   '
   01116   P00C53        20             DISP     DATAB     C' '
   01117   P00C54  00000000             LINE     REZ       132
   01118    00085                       DISPL    EQU       $-DISP
   01119   P00CD8                                BOUND     1D
   01120   P00CD8  2020200D             EXDISP   DATAB     C'   "M'
   01121   P00CDC  20202020             EXADDR   DATAB     C'      =  '
   01122   P00CE5    202020             DISPA    DATAB     C'      =  "@"@'
   01123   P00CF0  20202020             EXVALU   DATAB     C'         =  '
   01124    00024                       EXDISPL  EQU       $-EXDISP
   01125   P00CFC  0D0A464F             HELLO    DATAB     C'"M"JFOR A LIST OF COMMANDS, TYPE "'?"''
   01126    00022                       HELLOL   EQU       $-HELLO
   01127   P00D20                                BOUND     1W
   01128   P00D20  0D0A2020             HELPMES  DATAB     C'"M"J               COMMAND SUMMARY            '
   01129   P00D4C  20202020                      DATAB     C'               ARGUMENTS IN HEX     '
   01130   P00D70  20274348                      DATAB     C' "'CH"'    CHECK READ DISK                    '
   01131   P00D9C  20202020                      DATAB     C'      2  ARG- START,END OR S,E OR A '
   01132   P00DC0  20202020                      DATAB     C'                                            '
   01133   P00DEC  20202020                      DATAB     C'              OR START,NUMBER       '
   01134   P00E10  20274449                      DATAB     C' "'DI"'    DISPLAYS HOLDING BUFFER TO CRT     '
   01135   P00E3C  20202020                      DATAB     C'      NO ARGUMENT                   '
   01136   P00E60  20274455                      DATAB     C' "'DU"'    DUMP HOLDING BUFFER TO LINE PRINTER'
   01137   P00E8C  20202020                      DATAB     C'      NO ARG (ANY ARG MEANS NO SUPP)'
   01138   P00EB0  20274558                      DATAB     C' "'EX"'    EXAMINE CONTENTS OF HOLDING BUFFER '
   01139   P00EDC  20202020                      DATAB     C'      1  ARG- BUFFER ADDR (OPTIONAL)'
   01140   P00F00  20274649                      DATAB     C' "'FI"'    FILL HOLDING BUFF WITH BIT PATTERN '
   01141   P00F2C  20202020                      DATAB     C'      1  ARG- FILL VALUE (OPTIONAL) '
   01142   P00F50  20275245                      DATAB     C' "'RE"'    READ FROM DISK TO HOLDING BUFFER   '
   01143   P00F7C  20202020                      DATAB     C'      1  ARG- SECTOR VALUE OR N,L,S '
   01144   P00FA0  20275345                      DATAB     C' "'SE"'    SET SECTOR MODE (I/O IN SECTORS)   '
   01145   P00FCC  20202020                      DATAB     C'      NO ARG                        '
   01146   P00FF0  20275354                      DATAB     C' "'ST"'    DISPLAY STATUS TO CRT              '
   01147   P0101C  20202020                      DATAB     C'      NO ARG                        '
   01148   P01040  20275452                      DATAB     C' "'TR"'    SET TRACK MODE  (I/O IN TRACKS)    '
   01149   P0106C  20202020                      DATAB     C'      NO ARG                        '
   01150   P01090  2027554E                      DATAB     C' "'UN"'    CHOOSE DISK UNIT FOR I/O           '
   01151   P010BC  20202020                      DATAB     C'      1  ARG- DISK DRIVE ID         '
   01152   P010E0  20275752                      DATAB     C' "'WR"'    WRITE TO DISK FROM HOLDING BUFFER  '
   01153   P0110C  20202020                      DATAB     C'      1  ARG- SECTOR VALUE OR N,L,S '
   01154   P01130  20275353                      DATAB     C' "'SS"'    SET SECTOR SIZE                    '
   01155   P0115C  20202020                      DATAB     C'      1  ARG- SECTOR SIZE IN DECMIAL'
   01156   P01180  20275820                      DATAB     C' "'X "'    EXIT                               '
   01157   P011AC  20202020                      DATAB     C'      NO ARG                        '
   01158   P011D0  20273F20                      DATAB     C' "'? "'    DISPLAYS LIST OF COMMANDS          '
   01159   P011FC  20202020                      DATAB     C'      NO ARG                        '
   01160   P01220                       HELPEND  EQU       $
   01161   P01220  0D0A4449             INOP     DATAB     C'"M"JDISK IS INOPERABLE.'
   01162    00015                       INOPL    EQU       $-INOP
   01163   P01235    0D0A49             INVAD    DATAB     C'"M"JINVALID ADDRESS'
   01164    00011                       INVADL   EQU       $-INVAD
   01165   P01246      0D0A             INVAL    DATAB     C'"M"JINVALID DEVICE'
   01166    00010                       INVALL   EQU       $-INVAL
   01167   P01256      0D0A             NOADD    DATAB     C'"M"JNO ADDRESS SPECIFIED'
   01168    00016                       NOADDL   EQU       $-NOADD
   01169   P0126C  0D0A4E4F             NODSK    DATAB     C'"M"JNO DISK SPECIFIED'
   01170    00013                       NODSKL   EQU       $-NODSK
   01171   P0127F        0D             NOSIZ    DATAB     C'"M"JNO SIZE SPECIFIED'
   01172    00013                       NOSIZL   EQU       $-NOSIZ
   01173   P01292      0D0A             INVSZ    DATAB     C'"M"JINVALID SIZE VALUE'
   01174    00014                       INVSZL   EQU       $-INVSZ
   01175   P012A6      0D0A             INVSN    DATAB     C'"M"JSIZE ENTERED IS NEGATIVE'
   01176    0001A                       INVSNL   EQU       $-INVSN
   01177   P012C0  20202020             SAME     DATAB     C'    ** SAME **'
   01178    0000E                       SAMEL    EQU       $-SAME
   01179   P012D0                                BOUND     1D
   01180   P012D0  31534543             SECNM    DATAB     C'1SECTOR NUMBER ='
   01181   P012E0  20202020             SECDISP  DATAB     C'        '
   01182   P012E8  20202020                      DATAB     C'     UNIT = '
   01183   P012F4  4E4F4E45             SECUNIT  DATAB     C'NONE'
   01184    00028                       SECNML   EQU       $-SECNM
   01185   P012F8  0D0A554E             STAT     DATAB     C'"M"JUNIT= '
   01186   P01300  4E4F4E45             STATUS1  DATAB     C'NONE'
   01187   P01304  20202020                      DATAB     C'    SECTOR= '
   01188   P01310  20554E4B             STATUS2  DATAB     C' UNKNOWN'
   01189   P01318  20202020                      DATAB     C'      I/O MODE= '
   01190   P01328  53454354             STATUS3  DATAB     C'SECTOR  '
   01191    00038                       STATL    EQU       $-STAT
   01192   P01330  0D0A4144             TOBIG    DATAB     C'"M"JADDRESS TOO BIG (OR BELOW ZERO), TRY AGAIN'
   01193    0002C                       TOBIGL   EQU       $-TOBIG
   01194                                *  FCB  DEFINITIONS
   01195   P0135C                                BOUND     1W
   01196   P01360                                BOUND     1F
   01197   P01360  00000000             BUFF     REZ       8640W
   01198   P09A60             P00000             END       START
*  0000  ERRORS IN CDISK
  
  P0019C    ALOCERR   *00248   00212
  P00B14    ALOERTCW  *01063   00248
  P00B80    ALPROB    *01090   01063   01091
   0001C    ALPROBL   *01091   01063
  P00B9C    ASSER     *01092   01087   01093
   0001E    ASSERL    *01093   01087
  P00B74    ASSERTCW  *01087   00693
  P00578    ASSIGNER  *00632   00694   00706
  X5E000    AUTODISK  *00110   00652
  X5EFF0    AUTOFLAG  *00110   00651
  P00BBA    BADATA    *01094   01064   01095
   00010    BADATAL   *01095   01064
  P00B18    BADATTCW  *01064   00318   00374
  P00BCA    BADCMD    *01096   01065   01097
   00011    BADCMDL   *01097   01065
  P00B1C    BADCMTCW  *01065   00140
  P00BF0    BADSTAT   *01101   01066   01102
  P00C1C    BADSTAT1  *01104   00935   00936
  P00C28    BADSTAT2  *01106   00939   00940
  P00C34    BADSTAT3  *01108   00943   00944
  P00C40    BADSTAT4  *01110   00947
   00019    BADSTATL  *01102   01066
  P00B20    BADSTTCW  *01066   00951
  P006E8    BILDLINE  *00783   00180   00236
  P00790    BILDRTRN  *00835   00822   00828   00833
  P01360    BUFF      *01197   00281   00322   00367   00792   00793   00805   00984
  P00A1C    BUFFSIZE  *00996   00187   00242   00271   00325   00369   00490   00517   00679   00697   00838
  J00000    C.DPDEV   *00078  *00091
   00CC2    C.SMTS    *00105   00105
   00B38    C.UDTA    *00105   00623
   00C38    C.UDTN    *00105   00624
  P00474    CH.01     *00544   00541
  P00488    CH.02     *00550   00543
  P004AC    CH.03     *00561   00558
  P004C4    CH.04     *00568   00560   00566
  P004EC    CH.06     *00579   00583
  P004FC    CH.07     *00584   00575   00602
  P00508    CH.08     *00588   00595
  P0052C    CH.20     *00598   00546
  P00440    CHECK     *00529   01016
  P00248    CHECKX    *00312   00309
  P00384    CHEKSTAT  *00436   00433
  P0032C    CKSAME    *00409   00406
  P007B0    CLRLINE   *00858   00175   00231
  P00040    CMDCHECK  *00133   00138
  P00C44    CMDIN     *01112   01067   01113
   0000C    CMDINL    *01113   01067
  P00B24    CMDINTCW  *01067   00125
  P00A2C    CMDTABL   *01000   00134   01014
   00038    CMDTABLL  *01014   00137
  P00A64    CMDVECTR  *01015   00144
  P002F8    COMMON    *00394   00391
  P0026C    CONTEXAM  *00323   00303
  P00710    DATACONV  *00796   00794
  P00940    DISKFCB   *00984   00428   00491   00533   00696   00722
  P005D4    DISKOK    *00658   00653
  P00980    DISKRRS   *00985   00685   00686   00688   00689   00994
  P00998    DISKRRS1  *00986   00637   00650   00691
  P00A14    DISKRRSP  *00994   00682   00742
  P00C53    DISP      *01116   00989   01068   01075   01118
  P001F4    DISP.1    *00285   00296
  P00208    DISP.2    *00292   00289
  P0020C    DISP.3    *00294   00291
  P00CE5    DISPA     *01122   00295
   00085    DISPL     *01118   00989
  P00068    DISPLAY   *00157   01017
  P00214    DISPOUT   *00297   00320
  P000D4    DISPRTRN  *00189   00185
  P00B28    DISPTCW   *01068   00179
  P001DA    DISPWORD  *00277   00267   00326
  P0009E    DOALINE   *00174   00188
  P00380    DOWRITE   *00434   00431
  P000F8    DU01      *00208   00205
  P0011C    DU02      *00214   00207
  P000D8    DUMP      *00200   01018
  P00198    DUMPRTRN  *00247   00245
  P00A9C    ENDOFDSK  *01030   00423   00487   00662
  P0017C    ENDTEST   *00242   00238
  P000CC    ENDTST    *00186   00182
  P003C0    ERRCOM    *00459   00441   00444   00447   00450   00453   00456
  P00CDC    EXADDR    *01121   00280
  P00278    EXAMERR1  *00327   00270
  P00284    EXAMERR2  *00331   00272
  P001A8    EXAMINE   *00263   01019
  P00CD8    EXDISP    *01120   01069   01124
   00024    EXDISPL   *01124   01069
  P00B2C    EXDISTCW  *01069   00298
  P00B60    EXINTCW   *01082   00299
  P006AC    EXIT      *00739   01028
  P00CF0    EXVALU    *01123   00283
   00024    FCB.EQTY  *00107   00492   00534   00578   00586   00596   00698
   00028    FCB.ERAA  *00107   00429   00572   00582   00591   00593   00599
   00020    FCB.ERWA  *00107   00922   00928   00932
   00008    FCB.GCFG  *00107   00929   00931
   0000C    FCB.SFLG  *00107   00184   00913   00915   00949   00960
   00004    FCB.TCW   *00107   00227   00240   00885   00890   00892
  P00290    FILL      *00348   01020
  P002BC    FILLCONV  *00362   00359
  P002E0    FILLERR1  *00373   00365
  P002C8    FILLOOP   *00366   00353   00361   00370
  P00AFC    FLAG      *01051   00116   00120   00159   00181   00203   00204   00206   00215   00237   00244
                       00304   00305   00354   00355   00371   00390   00393   00396   00430   00531   00680
                       00702   00720   00740   00821   00826   00827   00832   00834   00840   00975   01082
  P00700    GETNXTWD  *00791   00819
  P00CFC    HELLO     *01125   01070   01126
   00022    HELLOL    *01126   01070
  P00B30    HELLOTCW  *01070   00122
  P006C4    HELP      *00755   01029
  P01220    HELPEND   *01160   00758
  P00D20    HELPMES   *01128   01071
  P006D4    HELPOUT   *00760   00765
  P00B34    HELPTCW   *01071   00759
  P009C0    IMEDCNP   *00988   00689   00691   00696
  P01220    INOP      *01161   01072   01162
   00015    INOPL     *01162   01072
  P00B38    INOPTCW   *01072   00917
  P01235    INVAD     *01163   01073   01164
   00011    INVADL    *01164   01073
  P00B3C    INVADTCW  *01073   00328   00443
  P01246    INVAL     *01165   01074   01166
   00010    INVALL    *01166   01074
  P00B40    INVALTCW  *01074   00631
  P012A6    INVSN     *01175   01080   01176
   0001A    INVSNL    *01176   01080
  P00B58    INVSNTCW  *01080   00458
  P01292    INVSZ     *01173   01079   01174
   00014    INVSZL    *01174   01079
  P00B54    INVSZTCW  *01079   00455
  P0038C    IOERR1    *00439   00400   00537   00549   00554   00564
  P00394    IOERR2    *00442   00421
  P0039C    IOERR3    *00445   00424   00426
  P003A4    IOERR4    *00448   00397   00532
  P003AC    IOERR5    *00451   00510
  P003B4    IOERR6    *00454   00513
  P003BC    IOERR7    *00457   00515
  P00C54    LINE      *01117   00176   00177   00232   00233   00863
  P009D8    LINEPFCB  *00989   00213   00226   00239
  P00B44    LPTCW     *01075   00235
  P00268    NEWVAL    *00321   00311   00317
  P00024    NEXTCMND  *00124   00145
  P0014E    NEXTLINE  *00230   00243
  P01256    NOADD     *01167   01076   01168
   00016    NOADDL    *01168   01076
  P00B48    NOADDTCW  *01076   00440
  P00054    NOCMD     *00139   00130
  P008C0    NODEC     *00965   00961   00963
  P0126C    NODSK     *01169   01077   01170
   00013    NODSKL    *01170   01077
  P00B4C    NODSKTCW  *01077   00449
  P008E0    NOERROR   *00974   00914
  P005D8    NOINIT    *00660   00647
  P00A20    NOSEC512  *00997   00656
  P0127F    NOSIZ     *01171   01078   01172
   00013    NOSIZL    *01172   01078
  P00B50    NOSIZTCW  *01078   00452
  P00AA4    NUMCOLS   *01032   00785   00818
  P0068C    OFFLINE   *00704   00639
  P0044A    OFFM       01089   01099
   00013    OFFML     *01099   01089
  P00B7C    OFFTCW    *01089   00705
  P00664    OKALOC    *00695   00690   00692
  P00740    OKCHAR    *00812   00809
  P007CA    OPCOM1    *00883   00123   00141   00172   00183   00249   00319   00329   00333   00375   00460
                       00633   00761   00918   00952   00969   00971
  P007DC    OPCOM2    *00888   00127   00300
  P00920    OPCOMFCB  *00983   00884   00889
  P007F0    OPCOMRTN  *00894   00887
  P00AFD    OPIN      *01059   01081
  P00B5C    OPINTCW   *01081   00126
  P00060    PROCCMD   *00143   00135
   00000    R0        *00105   00158   00200   00264   00349   00395   00493   00507   00530   00615   00719
                       00756   00784   00843   00844   00859   00865   00866   00895   00912   00921   00972
   00001    R1        *00105   00131   00136   00137   00176   00226   00232   00239   00284   00296   00428
                       00491   00533   00722   00798   00814   00884   00889   00948
   00002    R2        *00105   00173   00187   00229   00242   00787   00815   00837   00838   00948
   00003    R3        *00105   00177   00233   00266   00276   00278   00324   00325   00351   00368   00369
                       00474   00480   00481   00482   00487   00534   00596   00623   00628   00816   00860
                       00864
   00004    R4        *00105   00178   00234   00286   00287   00288   00290   00293   00295   00404   00407
                       00414   00416   00475   00483   00488   00624   00629   00674   00675   00757   00785
                       00786   00786   00788   00799   00817   00922   00932   00955
   00005    R5        *00105   00129   00129   00164   00220   00266   00278   00281   00302   00302   00306
                       00307   00308   00313   00352   00356   00357   00358   00399   00399   00401   00402
                       00403   00405   00410   00412   00509   00509   00536   00536   00538   00539   00540
                       00545   00553   00553   00555   00556   00557   00574   00576   00583   00617   00617
                       00667   00668   00669   00672   00684   00685   00758   00764   00787   00792   00793
                       00805   00806   00808   00811   00813   00933   00937   00941   00945   00954   00958
                       00959   00962   00962   00964
   00006    R6        *00105   00126   00132   00134   00161   00166   00168   00217   00222   00224   00269
                       00269   00273   00274   00275   00283   00299   00304   00306   00310   00316   00316
                       00354   00356   00360   00364   00364   00401   00420   00420   00476   00484   00489
                       00512   00512   00538   00548   00548   00555   00563   00563   00570   00573   00574
                       00587   00592   00619   00621   00621   00640   00642   00648   00669   00672   00763
                       00764   00801   00803   00820   00841   00892   00924   00926   00935   00939   00943
                       00947   00957   00967
   00007    R7        *00105   00114   00118   00122   00125   00140   00169   00170   00171   00179   00201
                       00202   00209   00210   00225   00227   00235   00240   00248   00271   00276   00280
                       00298   00305   00318   00322   00328   00332   00352   00355   00367   00374   00416
                       00423   00425   00425   00427   00429   00440   00443   00446   00449   00452   00455
                       00458   00477   00485   00490   00492   00514   00514   00516   00517   00542   00551
                       00559   00565   00567   00569   00571   00572   00577   00578   00585   00586   00591
                       00592   00593   00594   00600   00601   00626   00631   00636   00637   00644   00645
                       00646   00649   00650   00654   00655   00656   00657   00659   00661   00662   00666
                       00670   00671   00673   00677   00679   00687   00688   00693   00697   00698   00699
                       00700   00701   00705   00759   00762   00763   00790   00802   00804   00823   00824
                       00830   00831   00861   00863   00885   00890   00917   00923   00925   00927   00928
                       00936   00940   00944   00951   00956   00958   00968   00970
  P00348    RDWRCONV  *00418   00413
  P002EC    READ      *00389   01021
  P00354    READTEST  *00422   00417
   00014    RR.NBLKS  *00109   00688
   00010    RR.STBLK  *00109   00686
   00006    RR.UDTI   *00109   00685
  P012C0    SAME      *01177   01083   01178
  P00B12    SAMECHK   *01061   00788   00824
  P00B11    SAMECNT   *01060   00795   00823   00836
   0000E    SAMEL     *01178   01083
  P00B64    SAMETCW   *01083   00830
  P00900    SAVEF1    *00982   00784   00820   00831   00837   00841   00843   00859   00865   00912   00919
                       00921   00972   00973   00976
  P00AA8    SAVELSB   *01033   00403
  P00A10    SAVER0    *00993   00158   00190   00200   00247   00250   00264   00314   00330   00334   00349
                       00372   00376   00395   00438   00461   00507   00518   00530   00597   00615   00634
                       00703   00719   00725   00756   00766
  P00ABC    SECCYL    *01038   00673   00955
  P012E0    SECDISP   *01181   00168   00224
  P012D0    SECNM     *01180   00170   00202   00210   01084   01184
   00028    SECNML    *01184   01084
  P00B68    SECNMTCW  *01084   00171   00225
  P00AB0    SECNUM    *01035   00164   00220   00404   00427
  P0007C    SECNUMOK  *00163   00160
  P00138    SECOUT    *00223   00218
  P00AB4    SECSNDSK  *01036   00474   00480   00559   00600   00661   00687
  P00AB8    SECSNTRK  *01037   00481   00484   00573   00576   00587   00668   00957
  P009F8    SECT      *00990   00475
  P00AC0    SECTINCR  *01039   00407   00414   00489
  P003C8    SECTOR    *00473   01022
  P00088    SECTOUT   *00167   00162
  P00AC4    SECTSIZE  *01040   00477   00516   00577   00655   00666   00677
  P012F4    SECUNIT   *01183   00701
  P0012C    SECVALOK  *00219   00216
  P00AD0    SENSIOCD  *01043   00924   00925   00926   00927
  P00AD8    SENSSTAR  *01045   00923   00933   00937   00941   00945   00954   00956   00959
  P00610    SETBUFSZ  *00678   00676
  P00410    SETSEC    *00506   01027
  P00340    SETSECNM  *00415   00408   00411
  P00628    SKIPDEAL  *00683   00681
  P00814    SKIPINOP  *00920   00723   00916
  P007A8    SKPSUPCL  *00842   00839
  P009B0    SLORRS    *00987   00211   00995
  P00A18    SLORRSP   *00995   00246
  P00ACC    SPSEC     *01042   00569   00594   00601
  P00010    ST1       *00117   00115
  P0001C    ST2       *00121   00119   00142
  P00000    START     *00112   01198
  P012F8    STAT      *01185   01085   01191
  P006A8    STAT.EX   *00724   00721
  P00C0C    STAT1     *01103   01088   01111
   00038    STAT1L    *01111   01088
  P007F4    STATCHEK  *00911   00437   00581   00590
   00038    STATL     *01191   01085
  P00894    STATONLY  *00953   00950
  P00B6C    STATTCW   *01085   00968
  P00B78    STATTCW1  *01088   00970
  P00694    STATUS    *00718   01023
  P01300    STATUS1   *01186   00700
  P01310    STATUS2   *01188   00967
  P01328    STATUS3   *01190   00488   00674
  P003F4    STOREVAL  *00486   00478
  P00AC8    STSEC     *01041   00551   00565   00567   00571
  P0071C    STUFAWRD  *00800   00817
  P007BC    STUFBLNK  *00862   00864
  P0077C    SUPPTEST  *00829   00825
   00A00    T.BROFF   *00105   00105   00105   00105   00105   00105   00105   00105   00105   00105   00105
                       00105   00105   00105   00105   00105   00105   00105   00105   00105   00105   00105
                       00105   00105   00105   00105   00105
  P00AE8    TCWMASK   *01046   00757
  P01330    TOBIG     *01192   01086   01193
   0002C    TOBIGL    *01193   01086
  P00B70    TOBIGTCW  *01086   00332   00446
  P00A00    TRAC      *00991   00483   00675
  P003DC    TRACK     *00479   01024
  P00AEC    TRAKSIZE  *01047   00485   00585   00670
   0002A    UDT.ARTI  *00108   00108
   00028    UDT.BIT2  *00108   00108
   00024    UDT.CBLK  *00108   00108   00108
   00002    UDT.CDTI  *00108   00108
   00006    UDT.CHAN  *00108   00108   00626
   00008    UDT.DQEA  *00108   00108   00108   00108   00108   00108
   00005    UDT.DTC   *00108   00108   00640
   00034    UDT.FIOQ  *00108   00108   00108
   00010    UDT.FLGS  *00108   00108
   00030    UDT.HIST  *00108   00108   00108   00108
   0003D    UDT.IOCT  *00108   00108
   0003C    UDT.LPR1  *00108   00108
   00012    UDT.MBX   *00108   00108
   00009    UDT.MD    *00108   00108
   0001A    UDT.NHDS  *00108   00108   00671
   00000    UDT.ONLI  *00108   00638
   0000C    UDT.PCHN  *00108   00108
   0000D    UDT.PSUB  *00108   00108
   00020    UDT.PTOV  *00108   00108   00108   00108
   00014    UDT.SECS  *00108   00646   00657   00659
   0001C    UDT.SERN  *00108   00108   00108   00108
   0002C    UDT.SIHA  *00108   00108
   00040    UDT.SIZE  *00108   00628
   00011    UDT.SPT   *00108   00108   00667
   00018    UDT.SSIZ  *00108   00108
   00004    UDT.STAT  *00108   00108   00638
   00007    UDT.SUBA  *00108   00108
   00014    UDT.TAU   *00108   00108   00108
   00000    UDT.UDTI  *00108   00108   00644
  P00564    UDTCHECK  *00625   00629
  P00AF0    UDTI      *01048   00645   00684
  P00580    UDTMATCH  *00635   00627
  P0073C    UNDRLINE  *00810   00807
  P0053C    UNIT      *00614   01025
  P00AF4    UNITASCI  *01049   00619   00699
  P00574    UNITERR   *00630   00618   00622   00641   00643
  P00A08    UNKNOWN   *00992   00161   00217
  P006C0    WEGONE    *00743   00741
  P002F4    WRITE     *00392   01026
   00001    X1        *00105   00134   00144   00184   00227   00240   00295   00429   00492   00534   00572
                       00578   00582   00586   00591   00593   00596   00599   00698   00790   00803   00804
                       00885   00890   00892   00913   00915   00922   00928   00929   00931   00932   00949
   00002    X2        *00105   00792   00793   00805   00960
   00003    X3        *00105   00281   00322   00367   00626   00638   00640   00644   00646   00657   00659
                       00667   00671   00813   00863
  P00AF8    ZERTOBLK  *01050   00166   00222
  B5D060    M.ASSN    *00211
