/************************************************************************
*									*
*		genflt.c						*
*									*
*************************************************************************/

static short	fexp;
static short	binexp;
static short	fr[8];
static long	fvhigh,fvlow;

fconin(p) reg NODE *p; {
	reg int	i;
	reg int	j;

	fexp = getwd();			/* read decimal exponent	*/
	for( i=0; i<8; i++ ) fr[i] = getchar() & 0xff;	/* get fraction	*/
/*DEB*/if(debug)fdump("fconin");
	flpack();			/* pack it up to long form	*/
	p->nodeval = fvhigh;
	p->nodevl2 = fvlow;
}

flpack(){			/* pack up a floating point number	*/
	reg int	i,j;
	short	fsgn;

	binexp = 0;
	fvhigh = fvlow = 0;
	for( i=0; i<8; i++ ) if( fr[i] ) break;
	if( i == 8 ) return;				/* true zero */
	fsgn = 0;
	if( fr[7] & 0x80 ){				/* negative number */
		for( i=0; i<8; i++ ) fr[i] ^= 0xff;
		incf();
		fsgn++;
	}
	norm();
	j = 0;
	while( fexp < 0 ){	/* reduce decimal exponent		*/
/*DEB*/if(debug>5)fdump("red1");
		j = div10();
		fexp++;
		norm();
	}
	if( j >= 5 ){ incf(); norm(); }
	while( fexp > 0 ){
/*DEB*/if(debug>5)fdump("inc1");
		j = mul10();
		fexp--;
		if( j ) frsh8(), fr[7] = j, binexp += 8;
		norm();
	}
/*DEB*/if(debug>5)fdump("now clang");
	fclang(fsgn);
}

fclang(sign){

	reg int	i;
	reg int	j;

	j = 5;
	if( ieee ) j = 9;			/* IEEE */
#ifdef TIFLOAT
	if( tifloat ) j = 10, binexp++;		/* TI	*/
#endif
	if( j >= 8 ) frsh8(), j -= 8;
	for( i=0; i<j; i++ ) frsh();
/*DEB*/if(debug>5)fdump("clang1");
	incf();
	frsh();
	j = fr[7] & 0xfe;
#ifdef TIFLOAT
	if( tifloat ) j = fr[6] & 0xf0; else
#endif
	if( ieee ) j = fr[6] & 0xe0;
	if( j ) frsh(), binexp++;
/*DEB*/if(debug>5)fdump("clang4");
	for( i=3; i>=0; i-- ) fvlow = (fvlow << 8) | fr[i];
	for( i=7; i>=4; i-- ) fvhigh = (fvhigh << 8) | fr[i];
#ifdef TIFLOAT
	if( ieee || tifloat ){
#else
	if( ieee ){
#endif
		binexp += 1085;
		fvhigh &= 0x000fffffL;		/* clear out 12 bits */
		if( binexp <= 0 ) goto retz;
		if( binexp >= 2047 ) goto reth1;
		fvhigh |= (long)binexp << 20;
	} else {
		fvhigh &= 0x00ffffffL;		/* clear out 8 bits */
		binexp += 126;
		if( binexp < 0 ) goto retz;
		if( binexp > 127 ) goto reth;
		fvhigh |= (long)binexp << 24;
	}
ssgn:	if( !sign ) return;
#ifdef TIFLOAT
	if( ieee || tifloat )		/* IEEE or TI*/
#else
	if( ieee )			/* IEEE */
#endif
		fvhigh ^= 0x80000000L;
	else {
		fvhigh = ~fvhigh;
		if( (fvlow = -fvlow) == 0 ) fvhigh++;
	}
	return;
retz:	fvhigh = fvlow = 0;
	MSG("1floating constant underflow");
	return;
reth1:	fvhigh = 0x7ff00000L;
	fvlow = 0;
	goto rethm;
reth:	fvhigh = 0x7fffffffL;
	fvlow = 0xffffffffL;
rethm:	MSG("1floating constant overflow");
	goto ssgn;
}

norm(){

	reg int	i,j=0;
/*DEB*/if(debug>5)fdump("norm");
	while( fr[7] == 0 ){
		for( i=6; i>=0; i-- ) fr[i+1] = fr[i];
		fr[0] = 0;
		binexp -= 8;
	}
	while( fr[7] <= 63 ){
		for( i=0; i<8; i++ ) j |= fr[i] << 1, fr[i] = j & 0xff, j >>= 8;
		binexp--;
	}
	while( fr[7] > 127 ) frsh(), binexp++;
}


frsh8(){
	reg int	i,j=0;
	for( i=0; i<7; i++ ) fr[i] = fr[i+1];
	fr[7] = 0;
}

frsh(){

	reg int	i,j=0;
	for( i=7; i>= 0; i-- ) j |= fr[i], fr[i] = j >> 1, j = (j << 8) & 0x100;
}

mul10(){

	reg int	i,j=0;
	for( i=0; i<8; i++ ) j += fr[i] * 10, fr[i] = j & 0xff, j >>= 8;
	return j;
}

div10(){

	reg int	i,j=0;

	for( i=7; i>=0; i-- ) j <<= 8, j |= fr[i], fr[i] = j/10, j %= 10;
	return j;
}

incf(){		/* increment */

	reg int	i;

	for( i=0; i<8; i++ ) if( fr[i] = (fr[i] + 1) & 0xff) return;
}

fcvtf(p)reg NODE *p;{			/* convert to single */

	reg int	i;
	long	sign;

	if( p->nodeval == 0 && p->nodevl2 == 0 ) return;	/* 0 == 0 */
#ifdef TIFLOAT
	if( !ieee && !tifloat ){
#else
	if( !ieee ){
#endif
		p->nodevl2 = 0;
		return;
	}
/*DEB*/ deb("fcvtf: %lx %lx ->",p->nodeval,p->nodevl2);
	if( p->nodevl2 & 0x10000000L  ){	/* round		*/
		p->nodevl2 = (p->nodevl2 + 0x10000000L) & 0xe0000000L;
		if( p->nodevl2 == 0 ){		/* increment top half	*/
			if( (p->nodeval & 0xfffffL) == 0xfffffL ){
				if( (p->nodeval & 0x7ff00000L) == 0x7fe00000L )
					goto exover;
				p->nodeval = (p->nodeval & 0xfff00000L) +
							0x100000L;
#ifdef TIFLOAT
				if( tifloat ) p->nodeval |= 0x80000L;
#endif
			} else
				p->nodeval++;
		}
	}
	if( (p->nodeval & 0x7ff00000L) <= 0x38000000L ){
		MSG("1Exponent underflow in double to float conversion");
		p->nodeval = 0;
	} else
	if( (p->nodeval & 0x7ff00000L) >= 0x47f00000L ){
exover:		MSG("1Exponent overflow in double to float conversion");
		p->nodeval = (p->nodeval & 0x80000000L) | 0x7f800000L;
	} else {
#ifndef BADCOMPILER
		p->nodeval = (((p->nodeval - 0x38000000L) << 3) & 0x7fffffffL) |
			((p->nodevl2 >> 29) & 7L) |
			(p->nodeval & 0x80000000L);
	}
#else
	} else {
		reg int	i;
		long	sign;

		sign = p->nodeval & 0x80000000L; /* save sign		*/
		i = p->nodevl2 >> 29;		/* get three bits	*/
		i &= 7;
		p->nodeval -= 0x38000000L;	/* change exponent bias	*/
		p->nodeval <<= 3;		/* make room for 3 bits */
		p->nodeval += i;		/* put in bottom 3 bits */
		p->nodeval &= 0x7fffffffL;	/* clean sign position	*/
		p->nodeval |= sign;		/* insert sign		*/
	}
#endif
	p->nodevl2 = 0;
/*DEB*/ deb(" %lx\n",p->nodeval);
}


#ifdef ITOF

itof( p )reg NODE *p;{			/* convert to float */

	reg int	i;
	reg int	signl;
	long	sign;

	sign = 0;
	if( p->nodeval == 0 ){
		p->nodevl2 = 0;
		goto pret;
	}
	if( p->nodeval < 0 ) sign++, p->nodeval = -p->nodeval;
	for( i=0; i<4; i++ ) fr[i] = p->nodeval & 0xff, p->nodeval >>= 8;
	for( ; i<8; i++ ) fr[i] = 0;
	fexp = binexp = 0;
	norm();
	fclang(sign);
	p->nodeval = fvhigh;
	p->nodevl2 = fvlow;
pret:	p->nodetyp = TYREAL|(8<<5);
}
#endif

#ifdef FTOI
ftoi( p ) reg NODE *p; {		/* float to int */

	reg int	i;
	reg int	sign;
	long	v;

	if( p->nodeval == 0 ){
		p->nodevl2 = 0;
		p->nodetyp = deflong;
		return;
	}
	if( p->nodeval < 0 ){
		sign++;
		if( ieee || tifloat ) p->nodeval &= 0x7fffffffL; else {
			p = p->nodeval = ~p->nodeval;
			if( (p->nodevl2 = -p->nodevl2) == 0 ) p->nodeval++;
		}
	}
	if( varlen( p->nodetyp ) == 8 ){	/* from double */
		v = p->nodevl2;
		for( i=0;i<4;i++) fr[i] = v & 0xff, v >>= 8;
		v = p->nodeval;
		for( ;i<8;i++) fr[i] = v & 0xff, v >>= 8;
		fr[7] = 0;
#ifdef TIFLOAT
		if( tifloat ){
			i = ((p->nodeval >> 20) & 0x7ff) - 1074;
			fr[6] &= 0xf;
		} else
#endif
		if( ieee ){
			i = ((p->nodeval >> 20) & 0x7ff) - 1075;
			fr[6] &= 0xf;
			fr[6] |= 0x10;
		} else {
			i = ((p->nodeval >> 24) & 0x7f) - 120;
			fr[6] = 1;
		}
	} else {
		v = p->nodeval;
		for( i=0;i<4;i++) fr[i] = v & 0xff, v >>= 8;
		for(;i<8;i++) fr[i] = 0;
		fr[3] = 0;
#ifdef TIFLOAT
		if( tifloat ){
			i = ((p->nodeval >> 23) & 0x7f) - 145;
			fr[2] &= 0x7f;
		} else
#endif
		if( ieee ){
			i = ((p->nodeval >> 23) & 0x7f) - 146;
			fr[2] |= 0x80;
		} else {
			i = ((p->nodeval >> 24) & 0x7f) - 88;
			fr[3] = 1;
		}
	}
	p->nodetyp = deflong;
	if( i < -56 ){				/* no significance at all */
		p->nodeval = 0;
		return;
	}
	while( i <= -8 ) frsh8(), i += 8;
	while( i < 0 ) frsh(), i++;
	if( i >= 31 || fr[7] || fr[6] || fr[5] || fr[4] ) goto shi;
	while( i > 0 ){
		flsh();
		if( fr[4] ) goto shi;
		i--;
	}
	for( i=3; i>=0; i-- ) v <<= 8, v |= fr[i];
	p->nodeval = v;
ssgn:	if( sign ) p->nodeval = -p->nodeval;
	return;
shi:	p->nodeval = 0x7fffffff;
	goto ssgn;
}
#endif
fdump(s)char *s;{
	reg int	i;
	dprt("fd(%s)fexp = %d binexp = %d ",s,fexp,binexp);
	dprt(" %4x %4x ",fvhigh,fvlow);
	for( i=7; i>= 0; i-- ){
		if( fr[i] < 0 || fr[i] > 255 ) dprt(" !!");
		dprt(" %2x",fr[i] );
	}
	dprt( "\n" );
}
