/************************************************************************
*									*
*		getalgn.c - find appropriate alignment for data	*
*									*
************************************************************************/

#include "standard.h"
#include "ulsmch.h"
#include "aaux.h"

/* Routine to locate and return appropriate alignment for an item	*/

extern struct ulsmch	u;
extern AUXTAB		aux[];

getalgn(typword)reg unsigned short typword;{
	reg AUXTAB	*ap;
	reg int		align;

top:	align = varlen( typword );
	ap = aux + auxx( typword );
	switch( typword & TYMASK ){

case TYMORE:	typword = ap->typword;
		goto top;

case TYSTRUCT:
case TYUNION:	align = (ap->typword >> 12) & 0xf;
		if( align == 0xf )
			align = (aux[ap->typword & 0xfff].typword >> 8) & 0xff;
		return align;

case TYPTR:	while( (ap->typword & TYMASK) == TYMORE )
			ap = aux + auxx(ap->typword);
		if( ap->auxword == 0 ) return u.ptralign;
		/* else this pointer is an array base, fall through */

case TYARRAY:
case TYENUM:	return getalgn(ap->typword);

case TYINT:	if( align <= u.charsize ) return u.charalign;
		if( align <= u.shortsize ) return u.shortalign;
		return u.longalign;

case TYCMPX:
case TYREAL:	if( align <= u.floatsize ) return u.floatalign;
		return u.doubalign;

case TYDEC:	return u.decalign;

case TYSET:	return u.setalign;

	}
	MSG("7bad type in getalgn: %x",typword);
	return 0;
}
