/************************************************************************
*									*
*		getsize.c - return size of a type			*
*									*
************************************************************************/

#include "uccio.h"
#include "standard.h"
#include "ulsmch.h"
#include "aaux.h"

extern struct ulsmch	u;		/* the machine definition	*/
extern AUXTAB		aux[];

long

getardim(typword){

	/* because the array dimension is no longer simple to get at
	   this routine will return it.  typword had better by TYARRAY */

	long		dim;
	register	attr;

	attr = aux[auxx(typword)].auxword;	/* get first dim entry */
	if( (attr & 0x8000) == 0x8000 ){
		if( (attr & 0xffff) == 0xffff ) return -1L;
		attr &= 0xfff;
		dim = aux[attr].typword;
		dim = (dim << 16) | aux[attr].auxword;
	} else
		dim = attr & 0x7fff;
	return dim;
}


long
getsize(typword)register unsigned short typword;{

	register		attr;
	register AUXTAB		*ap;
	register		bty;
	long			dim;

top:	ap = aux + auxx(typword);	/* point to next entry */
	switch( typword & TYMASK ){

case TYMORE:	typword = ap->typword;
		goto top;

case TYLOG:	return (long)u.intsize;

case TYSET:
case TYINT:
case TYREAL:
case TYCMPX:
case TYDEC:	return (long)varlen( typword );

case TYSTRUCT:
case TYUNION:	attr = ap->typword;
		if( ap->auxword == 0 )
			MSG("2taking size of undefined struct/union");
		if( (attr & 0xf000) != 0xf000 ) return (long)(attr & 0xfff);
		ap = aux + (attr & 0xfff);
		return ((long)(ap->typword & 0xff)<<16)|ap->auxword;

case TYPTR:	attr = 0;
		typword = ap->typword;
		bty = typword & TYMASK;
		if( bty == TYMORE ){
			ap = aux + auxx(typword);
			attr = ap->auxword;
			typword = ap->typword;
			bty = typword & TYMASK;
		}
		if( attr & ATFAR ) return 4L;	/* special for 8086 */
		while( bty == TYARRAY || bty == TYMORE ){
			ap = aux + auxx(ap->typword);
			typword = ap->typword;
			bty = typword & TYMASK;
		}
		attr = u.ptrsize;
		if( bty == TYINT ){
			if( varlen(typword) == u.charsize ) attr = u.cptrsize;
		} else
		if( bty == TYFCN ) attr = u.fptrsize; else
		if( bty == TYVOID ){
			if( u.fptrsize > attr ) attr = u.fptrsize;
			if( u.cptrsize > attr ) attr = u.cptrsize;
		}
		return (long)attr;

case TYARRAY:	dim = getardim(typword);
		if( dim == -1L ) return 0L;
		return getsize(ap->typword) * dim;

case TYENUM:	typword = truetype(ap->typword);
		return (long)varlen(typword);

case TYFLD:	return getsize( ap->auxword );

case TYFCN:     MSG("2taking size of a function");
		return 0;

case TYVOID:	return 0;
	}
	MSG("7strange type in getsize (%d)" ,typword & TYMASK);
	return	(long)u.charsize;
}

/* the following returns the final element size of an array as an long */

long
elemsize(typword)register unsigned short typword;{

	register	bty;

	while( (bty = typword & TYMASK) == TYARRAY || bty == TYMORE )
		typword = aux[auxx(typword)].typword;
	return getsize( typword );
}

/* the following returns the size in BITS */

long
getbsize(typword)register unsigned short typword;{

	long	dim;

	while( (typword & TYMASK) == TYMORE )
		typword = aux[auxx(typword)].typword;
	if( (typword & TYMASK) == TYFLD )
		return (aux[auxx(typword)].typword >> 8) & 0xff;
	if( (typword & TYMASK) == TYARRAY ){
		dim = getardim(typword);
		if( dim == -1L ) return 0L;
		return getbsize(aux[auxx(typword)].typword) * dim;
	}
	return getsize(typword) * u.bytesize;
}
