/************************************************************************
*									*
*		putcon.c - output an Icode constant			*
*									*
************************************************************************/

#include "uccio.h"

/* for the format, see the uls internals document
   this routine returns the number of bytes emitted for statistics
   collection purposes if desired.

   Note: This routine cannot handle constants longer than a long
   on the host machine.  Moreover, the number of bytes in a long
   must be stated in the following define
*/

#define LONG	4

putcon(n,f) long n; register FILE *f;{
	register	toklen,i;
	long		n2;
	char		bytes[LONG+2];

	toklen = 0;
	n2 = n;
	bytes[2] = bytes[1] = 0;
	do bytes[toklen] = n, n >>= 8; while( ++toklen < LONG && n != 0 );

	if( toklen < 3 ){
		if( n2 > 16383 ) toklen = 3; else
		if( n2 > 127 ) toklen = 2, bytes[1] |= 0x80;
	}
	if( toklen >= 3 ){		/* if we now have three or more */
		bytes[toklen] = 0xc0 + toklen;	/* add a control byte	*/
		toklen++;
	}
	for( i=toklen-1; i>= 0; i-- ) putc( bytes[i], f );
	return toklen;
}
