/* read or write a block of data (replaces fread/fwrite)	*/

#include "uccio.h"

wrblk(fd,buffer,count) FILE *fd; char *buffer; int count; {
	register char	*ap;
	register char	*bp;
	register char	*cp;
	register	i;

	ap = buffer;
	if( fd->_ucba == NULL ){	/* unbuffered, just do a put */
		while( --count >= 0 ){
			i = *ap & 0xff;
			if( putc( i, fd ) < 0 ) return EOF;
			ap++;
		}
		return 0;
	}
	while( count > 0 ){
		if( fd->_ucct == 0 ){
			i = *ap & 0xff;
			if( _ucput( i, fd ) < 0 ) return EOF;
			ap++;
			count--;
		} else {
			bp = fd->_ucpt;
			i = count;
			if( i > fd->_ucct ) i = fd->_ucct;
			cp = bp + i;
			fd->_ucct -= i;
			count -= i;
			fd->_ucpt = cp;
			while( bp < cp ) *bp++ = *ap++;
		}
	}
	return 0;
}

rdblk(fd,buffer,count) FILE *fd; char *buffer; int count; {

	register char	*ap;
	register char	*bp;
	register char	*cp;
	register	i;

	ap = buffer;
	if( fd->_ucba == NULL ){	/* unbuffered, do a get	*/
		while( --count >= 0 ){
			i = getc(fd);
			if( i < 0 ) return EOF;
			*ap++ = i;
		}
		return 0;
	}
	while( count > 0 ){
		if( fd->_ucct == 0 ){
			i = _ucget( fd );
			if( i < 0 ) return EOF;
			*ap++ = i;
			count--;
		} else {
			bp = fd->_ucpt;
			i = count;
			if( count > fd->_ucct ) i = fd->_ucct;
			cp = bp + i;
			fd->_ucct -= i;
			count -= i;
			fd->_ucpt = cp;
			while( bp < cp ) *ap++ = *bp++;
		}
	}
	return 0;
}

cpblk( fdout, fdin, count ) register FILE *fdout, *fdin; int count; {
	/* copy count bytes from one file to another */
	register	i;

	while( count > 0 ){
		i = count;
		if( i > fdin->_ucct ) i = fdin->_ucct;
		if( i == 0 ){
			i = getc( fdin );
			if( i < 0 ) return EOF;
			if( putc( i, fdout ) < 0 ) return EOF;
			count--;
		} else {
			if( wrblk( fdout, fdin->_ucpt, i ) < 0 ) return EOF;
			count -= i;
			fdin->_ucct -= i;
			fdin->_ucpt += i;
		}
	}
	return 0;
}
