/*
$Header: standard.h,v 5.3 87/12/30 12:23:29 rmm Rel $
*/
#define reg	register
#define regstr	register struct
#define uns	unsigned
#define ushort	unsigned short
#define typwd	unsigned short
#define CHARPTR char *
#define VOID void

/*	standard defines -- used all over			*/

#define FALSE	0
#define TRUE	1

/* token classes */

#define UNKCLASS 0
#define ASGNCLASS 1
#define BINOPCLASS 2
#define STMTCLASS 3
#define TYPECLASS 4
#define STCLCLASS 5
#define ATTRCLASS 6

#define tokclass(op)	(tokdat[op]&07)
#define numsons(op)	((tokdat[op]>>3)&3)

/* for use in statement processing */

#define CNTSAVE 0x80
#define BRKSAVE 0x40
#define LABTYP	0x20

/*	definition of type and storage class constants		*/

#define TYMASK		017	/* the type field in the word */
#define TYUNK		((typwd)0)	/* unknown type */
#define TYLOG		((typwd)1)	/* truth value type */
#define TYINT		((typwd)2)	/* integer type */

/*	for integer types, the length is in the left byte of the
	type word in bytes, shifted left one bit, with the low order
	bit == 0 for signed, ==1 for unsigned
*/

#define TYPTR		((typwd)3)	/* pointer to type */
#define TYREAL		((typwd)4)	/* floating point type */
#define TYCMPX		((typwd)5)	/* complex type */

/*	for real types, the length is in the left byte of the type word
	in bytes, FLOAT == 4 (usually) and DOUBLE == 8 (usually)
*/

#define TYDEC		((typwd)6)	/* decimal type */

/*	for decimal types, the length is in the left byte of the type
	word in the same fashion as for TYINT
*/

#define TYFLD		((typwd)7)	/* field type */

/* and the complex types */

#define TYENUM		((typwd)8)	/* enumerated type */
#define TYSTRUCT	((typwd)9)	/* structure type */
#define TYUNION		((typwd)10)	/* union type */
#define TYARRAY		((typwd)11)	/* array of ... type */
#define TYFCN		((typwd)12)	/* function returning ... type */
#define TYVOID		((typwd)13)	/* void */
#define TYSET		((typwd)14)	/* set type for PASCAL */
#define TYMORE		((typwd)15)	/* get type word from aux	*/

/* macro for getting part of type word */

#ifdef _
/* the following have been changed from macros to functions and are now
   in libuls in predicate.c */

#define bt(typword) ((typword)&TYMASK)
#define rbt(typword) (bt(typword)==TYMORE?bt(aux[auxx(typword)].auxword):bt(typword))
#define isint(typword) (bt(typword)==TYINT)
#define islog(typword) (bt(typword)==TYLOG)
#define isptr(typword) (bt(typword)==TYPTR)
#define isreal(typword) (bt(typword)==TYREAL)
#define isdec(typword) (bt(typword)==TYDEC)
#define isfcn(typword) (bt(typword)==TYFCN)
#define isuns(typword) ((typword)&UFLAG)
#define isstruct(typword) (bt(typword)==TYSTRUCT)
#define isunion(typword) (bt(typword)==TYUNION)
#define isstun(typword) (isstruct(typword)||isunion(typword))
#define isarray(typword) (bt(typword)==TYARRAY)
#define isfield(typword) (bt(typword)==TYFLD)
#define isenum(typword) (bt(typword)==TYENUM)
#endif

#define mbt(typword) ((typword)&TYMASK)
#define ismore(typword) (((typword) & TYMASK)==TYMORE)
#define varlen(typword) ((typword)>>5)
#define uvarlen(typword) ((typword)>>4)
#define bitlen(typword) (((int)getsize(typword))*u.bytesize)
#define auxx(typword) ((typword)>>4)

/* other predicates	*/

#define isbitop(op)	((op)>=AND&&(op)<=EOR)
#define isrelop(op)	((op)>=EQUAL&&(op)<=GEQ)
#define isshfop(op)	((op)>=LSH&&(op)<=RSH)
#define isaddop(op)	((op)>=PLUS&&(op)<=MINUS)

		/* miscellaneous numbers	*/

#define UFLAG		0x10	/* flag for unsigned INTs in left part	*/
#define AUXMASK         0xfff	/* mask to get aux field from typword	*/
#define AUXSHIFT        4	/* same for shift			*/
#define WDSHIFT         16	/* word shift				*/
#define WDMASK          0xffff	/* word mask				*/
#define LWDMASK         0xffffL	/* word mask				*/
#define BYTSHIFT        8	/* byte shift				*/
#define BYTMASK         0xff	/* byte mask				*/
#define SSMASK          0xfff	/* struct size in aux.typword field	*/
#define ALSHIFT         12	/* struct align field shift		*/
#define ALMASK          0xf	/* same for mask			*/
#define LENSHIFT        5	/* length field shift in typword	*/

		/* and the storage classes */

#define SCUNK		0	/* unknown or undefined storage class */
#define SCEXTERN	1	/* declared external		*/
#define SCEXTDEF	2	/* external by default		*/
#define SCISTAT		3	/* static, inside a function	*/
#define SCPARAM		4	/* actual parameter		*/
#define SCAUTO		5	/* automatic			*/
#define SCENUM		6	/* var is enum element		*/
#define SCOTHER		7	/* other, such as pagezero, ublock, etc */
#define SCREG		8	/* register storage class	*/
#define SCSTRING	9	/* string data			*/
#define SCTEMP		10	/* temporary storage area	*/

	/* the following are used only for symbol table printing */

#define SCMOS		11	/* member of structure		*/
#define SCMOU		12	/* member of union		*/
#define SCSTAG		13	/* structure tag		*/
#define SCUTAG		14	/* union tag			*/
#define SCETAG		15	/* enumeration tag		*/
#define SCTYDF		16	/* typedef			*/

/*	evaluation types					*/

#define FOREFFECT	1	/* for side effects only	*/
#define FORCOND		2	/* for condition code only	*/
#define FORRET		3	/* for returned value		*/
#define FORSWITCH	4	/* for switch value		*/
#define FORVAL		5	/* for any value		*/
#define FORLVAL		6	/* for any lvalue		*/
#define	FORSIZE		7	/* in sizeof()			*/
#define	FORARG		8	/* parameter to function	*/
#define FORINIT		9	/* for compile time value	*/
#define FORADDR		10	/* produce address only		*/
#define FORGO		11	/* evaluate for GOTO address	*/
#define FORTYPE		12	/* for type info only		*/

/*	attribute codes used with TYMORE			*/

#define ATCONST		0x01	/* variable declared const	*/
#define ATVOL		0x02	/* variable declared volatile	*/
#define ATNEAR		0x04	/* variable declared near	*/
#define ATFAR		0x08	/* variable declared far	*/
#define ATPGZ		0x10	/* variable declared pagezero	*/

/*	other codes used in the flag field of a symbol */

#define INITTED		0x01	/* variable has been initialized */
#define LOCAL		0x02	/* variable has been declared "static" */

/*	the following are used for enums or members of structures only */

#define AMBIG		0x04	/* enum or mos is ambiguous */

/*	the following are used for non-functions only	*/

#define REGHINT		0x08	/* storage class REG specified	*/
#define	ADRTAKEN	0x10	/* has had address taken	*/
#define WASUSED		0x20	/* was accessed			*/
#define WASSET		0x40	/* was stored into		*/
#define ALLOCATED	0x80	/* has been allocated (p3)	*/

/*	the following are used for functions only	*/

#define RETVAL		0x04	/* function returned a value	*/
#define RETVOID		0x08	/* function returned a void	*/
#define GOTVAL		0x10	/* value expected from function */
#define GOTVOID		0x20	/* void expected from function	*/
