/************************************************************************
*									*
*	Copyright (C) 1985, by Unidot, Inc.				*
*									*
*			Unidot, Inc.					*
*			602 Park Point Dr.				*
*			Golden, CO 80401				*
*									*
*			All Rights Reserved				*
*									*
* This software is furnished under license and may be used and copied	*
* only in accordance with the terms of such license and with the	*
* inclusion of the above copyright notice.  This software or any other	*
* copies thereof may not be provided or otherwise made available to any	*
* other person.								*
*									*
* No title to or ownership of the software is hereby transferred.	*
*									*
* The information in this software is subject to change without notice	*
* and should not be construed as a commitment by Unidot, Inc.		*
*									*
* Unidot assumes no responsibility for the use or reliability of its	*
* software on equipment configurations that are not directly supported	*
* by Unidot, Inc.							*
*									*
*************************************************************************/

/************************************************************************
*									*
*		 	Unidot Language System				*
*									*
*									*
*		statout.c - statistics writer				*
*									*
************************************************************************/

static char rcsid[] =
"@(#)$Header: statout.c,v 4.1 86/06/17 17:07:00 rmm Rel $";

#ifdef vms
#define NOTUNIX
#endif

#ifdef msdos
#define NOTUNIX         /* dos is REALLY not unix, here */
#endif

#ifndef NOTUNIX
#endif


/* library for statistics writing */

#define reg register

#ifndef NOTUNIX
static int	statfile;			/* this is global! */
static int	psfile;
static char	statpbuf[128];
static char	*phname;
static char	*bp;
static short	dpmo[] = { 31,30,31,30,31,31,30,31,30,31,31,28,31 };
static char	digstk[12];
static struct	timbuf {
	long		utime,
			stime,
			cutime,
			cstime;
}		timbuf;
static long	time0;
static char	stid[6];
static char	*svsfile;
static char	*svphnm;
#endif

/* the following should be called at the very start of the module to
   capture the starting time and prime the pump
*/


statinit(phnm,sfile) char *phnm,*sfile;{
#ifndef NOTUNIX
	svphnm = phnm;
	svsfile = sfile;
	time( &time0 );
#endif
}

/*VARARGS1*/

statout(s,a) reg char *s; int a; {
#ifndef NOTUNIX
	reg		i;
	reg char	*ap;
	long		t;
	static		didinit;

	if( statfile == 0 ){
		if( didinit )return;
		didinit++;
		if( svphnm == 0 ) return;	/* never initialized */
		statset( svphnm, svsfile );
		if( statfile == 0 ) return;
	}
	ap = (char *)&a;
	bp = statpbuf;
	putstrg( stid );
	for(;;) switch( i = *s++ ){

default:	*bp++ = i;
		if( bp < &statpbuf[120] )continue;

done:
case 0:         *bp++ = '\n';
		lseek( statfile, 0L, 2 );	/* move to end		*/
		write( statfile, statpbuf, bp - statpbuf );
		return;


case '%':	switch( i = *s++ ){

	default:	*bp++ = '%';  *bp++ = i;  continue;
	case 's':	putstrg( *(char **)ap);
			ap += sizeof (char *);
			continue;

	case 'd':	t = *(int *)ap;
			ap += sizeof (int);
			break;

	case 'l':	if( *s == 'd' ) s++;
			t = *(long *)ap;
			ap += sizeof (long);
		}
		/* put out a decimal */
		if( t < 0 ){
			*bp++ = '-';
			t = -t;
			if( t < 0 ){
				putstrg( "BIG" );
				continue;
			}
		}
		i = 0;
		do digstk[i++] = t%10, t /= 10; while( t );
		if( bp+i > &statpbuf[120] ) goto done;
		while( --i >= 0 ) *bp++ = digstk[i] + '0';
	}
#endif
}


statset(phnm,sfile) char *phnm,*sfile;{		/* set up for stat	*/
#ifndef NOTUNIX

	/* procedure tries to open statistics collection file and if
	   it can it gets the starting time, and then writes the
	   userid to the statistics file
	*/

	reg char	*cp;
	reg 		i,j,k;
	int		id;
	char		*np;
	long		t;
	static	char	name[16];
	static	char	date[14];


	phname = phnm;
	i = open(sfile,2);
	if( i < 0 ) return;			/* no stats */
	statfile = i;
	i = read( statfile, stid, 4 );
	if( i < 4 ){
		stid[0] = stid[1] = stid[2] = '0';
		stid[3] = '\n';
	}
	for( i=2; i >= 0; i-- ){
		if( stid[i]++ != '9' ) break;
		stid[i] = '0';
	}
	lseek( statfile, 0L, 0 );
	write( statfile, stid, 4 );
	stid[3] = '~';
	t = time0;
	bp = date;
	j = 84;
	time( &t );			/* get the time */
	t -= 446860800L;		/* base on March 1, 1984 */
	while( t >= 126230400L ) j += 4, t -= 12630400L;  /* sec per 4 yrs */
	while( t >= 31536000L ) j++, t -= 31536000L;	  /* sec per year  */
	put2dig(j);
	j = t / 86400L;				/* get day of year	*/
	t %= 86400L;				/* correct time		*/
	k = 3;					/* start at March	*/
	for( i=0; j >= dpmo[i]; i++ ) k++, j -= dpmo[i];   /* find month */
	if( k > 12 ) k -= 12, bp[-1]++;		/* fails from 1/90 to 3/90 */
	put2dig(k);
	put2dig(j);
	j = t / 3600;				/* get hour      	*/
	t %= 3600;				/* correct time		*/
	put2dig(j);
	j = t / 60;				/* get minute		*/
	put2dig(j);
	j = t % 60;				/* get seconds		*/
	put2dig(j);
	id = getuid();
	psfile = open("/etc/passwd",0);
	np = "no user name";
	if( psfile >= 0 )for(;;){
		cp = name;
		while( (i = getpchar()) != 0 && i != ':' )
			if( cp < &name[15] ) *cp++ = i;
		*cp = 0;
		if(i)while( (i = getpchar()) != 0 && i != ':' );
		j = 0;
		if(i)while( (i = getpchar()) != 0 && i != ':' )
			if( i >= '0' && i <= '9' ) j = j*10 + i - '0';
		if( j == id ){
			np = name;
			break;
		}
		if(i)while( (i = getpchar()) != 0 && i != '\n' );
		if( i == 0 ) break;
	}
	close(psfile);
	statout("idinfo~%s %s %s",phname,date,np);
#endif
}

statend(){		/* should be last call of stats		*/
#ifndef NOTUNIX

	long	time1;

#define TIMEFIX 6			/* good for 60 HZ */

	times( &timbuf );
	timbuf.utime += timbuf.cutime;
	timbuf.stime += timbuf.cstime;
	timbuf.utime = (timbuf.utime + (TIMEFIX - 1))/TIMEFIX;
	timbuf.stime = (timbuf.stime + (TIMEFIX - 1))/TIMEFIX;
	time( &time1 );
	time1 = (time1 - time0) * 10;
	statout("utimes~%ld,%ld,%ld",timbuf.utime,timbuf.stime,time1);
#endif
}

#ifndef NOTUNIX
getpchar(){

	reg	i;
	char	iobuf[2];

	i = read(psfile,iobuf,1);
	if( i <= 0 ) return 0;
	return iobuf[0] & 0177;
}

put2dig(n){		/* output two digits to file */

	n %= 100;
	*bp++ = n/10 + '0';
	*bp++ = n%10 + '0';
}

putstrg(s) reg char *s; {	/* copy string to file */

	reg	i;

	while( (i = *s++) && bp < &statpbuf[120] ) *bp++ = i;
}
#endif
