/************************************************************************
*									*
*		uccio.h - IO header for compiler special io		*
*									*
************************************************************************/

#define	BUFSIZ	512		/* this is machine specific		*/

extern	struct	_ucciobuf {
	char	*_ucpt,
		*_ucba;
	short	_ucct;
	short   _ucsz;
	char	_ucfi;
	char	_ucmd;
}	_ucciob [];		/* allocated in uccio.c			*/


#ifndef NULL
#define	NULL		0
#endif
#define	FILE		struct _ucciobuf
#define	EOF		(-1)

#define R_MODE		0x01		/* file opened for reading	*/
#define W_MODE		0x02		/* file opened for writing	*/
#define V_MODE		0x04		/* file is virtual		*/
#define R_LAST		0x08		/* last op was read		*/
#define W_LAST		0x10		/* last op was write		*/
#define P_MODE          0x20            /* file is a node pipe          */
#define L_MODE          0x40            /* file is line buffered        */

#define _IONBF          1               /* setvbuf request unbuffered       */
#define _IOLBF          2               /* setvbuf request line buffered    */
#define _IOFBF          3               /* setvbuf request full buffered    */


#define	stdin		(&_ucciob[0])
#define	stdout		(&_ucciob[1])
#define	stderr		(&_ucciob[2])
#define	getc(p)		(--(p)->_ucct>=0? *(p)->_ucpt++&0xff:_ucget(p))
#define	getchar()	getc(stdin)
#ifndef UNSIGNCHAR
#define putc(x,p)	(--(p)->_ucct>=0?((*(p)->_ucpt++=(x))&0xff):_ucput((x),p))
#else
#define putc(x,p)	(--(p)->_ucct>=0?((unsigned char)(*(p)->_ucpt++=(x))):_ucput((x),p))
#endif
#define	putchar(x)	putc(x,stdout)
#define fileno(x)	((x)->_ucfi)

FILE			*fopen();
long			ftell();
