/************************************************************************
*									*
*		Unidot Fortran 77 Runtime Support			*
*									*
*		original concept by Dennis R. Allison			*
*		additional dialog by William L. English			*
*		major rewrite by Robert M. McClure			*
*									*
*		uf77io.c						*
*									*
*									*
*	Copyright (C) 1985, by Unidot, Inc.				*
*									*
*			Unidot, Inc.					*
*			602 Park Point Dr.				*
*			Golden, CO 80401				*
*									*
*			All Rights Reserved				*
*									*
* This software is furnished under license and may be used and copied	*
* only in accordance with the terms of such license and with the	*
* inclusion of the above copyright notice.  This software or any other	*
* copies thereof may not be provided or otherwise made available to any	*
* other person.								*
*									*
* No title to or ownership of the software is hereby transferred.	*
*									*
* The information in this software is subject to change without notice	*
* and should not be construed as a commitment by Unidot, Inc.		*
*									*
* Unidot assumes no responsibility for the use or reliability of its	*
* software on equipment configurations that are not directly supported	*
* by Unidot, Inc.							*
*									*
*************************************************************************/

static char rcsid[] =
"@(#)$Header: uf77io.c,v 4.1 86/06/17 17:07:34 rmm Rel $";

/*		General Definitions and Includes			*/

/* for debugging kill STATICS! */

#define STATIC 

#ifdef vms
#define NOTUNIX
#define BADEXIT 0
#define GOODEXIT 1
#include <setjmp.h>
#endif

#ifdef msdos
#define NOTUNIX
/* incomplete*/
#endif

#ifndef NOTUNIX
#define BADEXIT 1
#define GOODEXIT 0
#include <setjmp.h>
#endif

#include "uf77io.h"

#define reg	register
#define uns	unsigned
#define ushort	unsigned short
#define NULL	0

#define INTSIZ	4		/* this should be the size of a Fortran
				   integer				*/

/* FORTRAN I/O assignments */

#define sysin		5	/* FORTRAN standard input unit		*/
#define sysout		6	/* FORTRAN standard output unit		*/
#define syspunch	7	/* FORTRAN standard punch unit		*/


/* possible errors: these values are jammed into iostatus		*/

#define ERR_NONE	0	/* no errors				*/
#define ERR_OPEN	1	/* cannot open file			*/
#define ERR_IO		2	/* read/write/seek fails		*/
#define ERR_EOF		3	/* end of file encountered		*/
#define ERR_FNUM	4	/* bad file number			*/
#define ERR_FMDE	5	/* bad file mode			*/
#define ERR_SIZE	6	/* error in data transfer size		*/
#define ERR_FMTA	10	/* unbalanced parens in format		*/
#define ERR_FMTB	11	/* nesting too deep			*/
#define ERR_FMTC	12	/* illegal format specifier		*/
#define ERR_FMTD	13	/* missing separator in format		*/
#define ERR_FMTE	14	/* illegal char in format		*/
#define ERR_DEF		15	/* redefinition of file			*/
#define ERR_REC		16	/* record number error			*/
#define ERR_DATA	17	/* error in input data			*/
#define ERR_CONF	18	/* io start while  iogoing		*/
#define ERR_LSTIO	19	/* badly formatted listio input		*/

#define	FIRSTREC	1	/* first record in a logical record	*/
#define LASTREC		2	/* last record in a logical record	*/
#define EOFREC		4	/* this record is an end of file marker */

/*	Format Conversion Definitions					*/

#define FMTNST		6	/* the nesting level of formats	*/
/*			Internal Structures				*/



/*	a maximum of NFILES files numbered 0..NFILES-1 are allowed.
	each has a descriptor.  (Actually file NFILES is used for
	internal IO).							*/

#define FTNFILE struct ftnfile
#define NFILES	16

#define badfile(n)	((n)<0 || (n)>=NFILES)
#define isopen(fp)	((fp)->fmode & (MOD_REA|MOD_WRI))


FTNFILE {
	long	*fposn;		/* associated variable for random files	*/
	char	*fname;		/* the file name.  default if nil	*/
				/* also used for memory pointer		*/
	ushort	fdesc;		/* the Unix file descriptor		*/
	ushort	frecln;		/* record length in bytes if applicable	*/
	ushort	frecno;		/* next record to read			*/
	ushort	frecmx;		/* maximum record number in file	*/
	ushort	fmode;		/* file mode determines legal transfers */
}
	files[NFILES+1];

/*	Binary files are constructed of fixed length physical records
	one or more of which constitute a logical record.

	Binary file physical records have the format

	<header>
	<254 bytes>

	control words are inserted on the fly during writes and checked
	during reads so commmon read and write routines can be used.	*/

struct binrec {
	char	flgh;
	char	cnth;
	char	data[254];
}	r;

	/* formatted lines are read and written using the data area	*/
/*	structures used in format operations				*/

STATIC struct {
	char*	fptr;		/* head of format at this level		*/
	int	rcnt;		/* repeat count at this level		*/
}
	fary[FMTNST],
	*fmtsp;

#define DESCRIPT struct descript

DESCRIPT {
	char	*cptr;		/* pointer to start of string	*/
	ushort	csize;		/* size of string		*/
};

#define COMPLEX8 struct cx8
#define COMPLEX16 struct cx16

COMPLEX8 { float	re4, im4; };
COMPLEX16 { double	re8, im8; };

short	sysmap[] = {		/* default mapping of files	*/
	0,1,2			/* stdin, stdout, and stderr	*/
};
/*		General Variables				*/


/*	The following longjmp buffers are used for end-of-file and
	error-reporting respectively					*/

jmp_buf	_F77EOJ,		/* end of file jump			*/
	_F77ERJ;		/* error jump				*/

STATIC long

	*iostatp,		/* pointer to iostatus return		*/
	ival;			/* integer output value			*/

STATIC short

	blkmod,			/* if non-zero, blanks are zeroes	*/
	sgnmod,			/* if 1, plus sign is not optional	*/
	curds,			/* the current file			*/
	curop,			/* current io operation code		*/
	fmtcod,			/* the current format code		*/
	lstio,			/* non-zero if doing list io		*/
	iogoing,		/* non-zero in middle of io		*/
	iostatus,		/* error status: error is jammed in	*/
	jmpctl,			/* non-zero if err/eof cause jumps	*/
	repcnt,			/* repeat count				*/
	ewidth,			/* element width			*/
	fwidth,			/* fraction width			*/
	xwidth,			/* exponent width			*/
	expon,			/* normalized exponent			*/
	fsign,			/* floating point sign			*/
	sgnsiz,			/* size of sign field			*/
	scale;			/* current scale factor			*/

STATIC double

	fval;			/* floating point output value		*/

STATIC char

	*fmtp,			/* the format pointer			*/
	*format,		/* for error printing only		*/
	*lp,			/* ptr to next char in output		*/
	*lph,			/* high water in output			*/
	fnames[128],		/* room for file names			*/
	*fnmp = fnames;		/* pointer to next free cell		*/


STATIC long seek();		/* internal version that error checks	*/
extern long lseek();

STATIC
char	*getname();

STATIC
FTNFILE	*getfp();		/* checks and returns a file ptr	*/

long	__IOSTA;		/* default place for status		*/
/*		General Information					*/

/*

	routines that may be called from a Fortran program have
	names of the form "_F77XXX" where the X's are upper case.
	Since there is no way of expressing a leading underscore
	in Fortran, there is guaranteed no collisions.

	Routines that are used only internally have traditional
	lower case names, and are all marked STATIC.

	Externally callable routines are these:

	_F77STT	-	The kickoff routine
	_F77BIO -	starts an IO operation
	_F77IIO -	starts an IO operation on internal file
	_F77EIO -	ends an IO operation
	_F77OPN -	opens a file
	_F77CLS -	closes a file
	_F77INQ -	inquires about a file
	_F77REW -	rewinds a file
	_F77ENF -	writes an end of file mark
	_F77BKS -	backspaces in a file
	_F77DEF -	defines a file (IBM style)
	_F77EOJ -	end of file jump buffer (not a routine)
	_F77ERJ -	error jump buffer (not a routine)
*/
/*		BINDING FILE NAMES TO FORTRAN INTERNAL NAMES		*/

/*
 	Every FORTRAN program takes parameters which define its file 
	bindings. For example:

		a.out  8=/tmp/foo 9=mylist

	assigns unit 8 to /tmp/foo and unit 9 to mylist.
	Files which are not assigned are given default names of the 
	form ftnXX when they are referenced.  No validity check is 
	made until the file is acutally referenced.  

	The main program calls _F77STT immediately open entry

 */


_F77STT( argc, argv ) int argc; char **argv; {

	reg char	*p,
			*q;
	reg		n;
	reg		errflag;

	while( --argc > 0 ){
		p = q = *++argv;
		n = 0;
		while( *p>='0' && *p<='9' ) n = 10*n + *p++ - '0';
		if( badfile(n) || p == q )
			fatal( "bad file assignment: %s", q );
		files[n].fname = ++p;
	}
	write(2,"running\n",8);
}
/*			DEFINEFILE FOR RANDOM FILES			*/


/*	Random files need additional descriptor information to 
	be stored away in the files array.  The is done via a runtime
	call to the procedure _deffile					*/


_F77DEF( ds, iostat, errflg, nr, rs, fm, avp ) 
	long	ds;		/* Fortran data set number		*/
	long	*iostat;	/* status return place			*/
	int	errflg;		/* 01 == eof jump, 02 == err jump	*/
	long	nr;		/* maximum number of records		*/
	long	rs;		/* record size in bytes			*/
	long	fm;		/* random transfer mode			*/
	long*	avp;		/* pointer to associated variable	*/
{
	reg FTNFILE	*fp;	/* current file block			*/

	/* check for valid file, mode, etc */

	fp = getfp( ds, iostat, errflg );
	if( fp->fmode != 0 ) errex( ERR_DEF );	/* duplicate	*/
	fp->fmode = fm;
	fp->frecln = rs;		/* file record size, ignore max	*/
	fp->fposn = avp;		/* set associated variable	*/
	fp->frecno = 1;			/* first record			*/
}
/*		STARTING AND TERMINATING AN I/O OPERATION		*/


/*	All input/output sequences which transfer data begin with a call
	to _F77BIO and end with a call to _F77EIO.

	The former routine verifies and sets up the state information
	while while the latter does cleanup.

	The values of mode passed to _F77BIO are in uf77io.h		*/


_F77BIO( ds, iostat, errflg, opn, fmt, recnum )
	long	ds;		/* the FORTRAN ds number		*/
	long	*iostat;	/* status return place			*/
	int	errflg;		/* 01 == eof jump, 02 == err jump	*/
	int	opn;		/* the operation to be performed	*/
	char*	fmt;		/* the format if used			*/
	long	recnum;		/* record number for random files	*/
{

	reg FTNFILE	*fp;
	reg char	*p;
	reg		mo;
	reg		i;

	/* first check data set number and set up global state data */

	if( iogoing ) errex( ERR_CONF );
	iogoing = 1;
	fp = getfp( ds, iostat, errflg );
	curop = i = opn;		/* save the operation		*/
	curds = ds;			/* and the data set number	*/
	r.flgh = FIRSTREC;		/* mark control as first rec	*/
	if( !isopen(fp) ){			/* not open		*/
		p = fp->fname;
		if( !p ){
			i = curds;
			if( i >= sysin && i <= syspunch ){
				fp->fdesc = sysmap[ i - sysin ];;
				if( fp->fmode == 0 )
					fp->fmode = MOD_SEQ|MOD_FMT;
				goto opened;
			}
			p = getname(i);
		}
		if( curop & IOWRITE ){
			i = open( p, 1 );	/* open for write	*/
			if( i < 0 ){
				close(creat(p,0666)); /* UNIX nonsense	*/
				i = open( p, 1 );
			}
		} else {
			i = open( p, 0 );	/* open for read	*/
		}
		if( i < 0 ) errex( ERR_OPEN );	/* open failed		*/
		fp->fdesc = i;
opened:		fp->fmode |= curop & IOWRITE ? MOD_WRI : MOD_REA;
	}
	mo = fp->fmode & ~(MOD_REA|MOD_WRI);
	if( mo == 0 ){			/* no mode yet			*/
		mo = MOD_SEQ;			/* sequential IO	*/
		if( i & FMTIO ) mo |= MOD_FMT;
		if( i & BINIO ) mo |= MOD_UNF;
		fp->fmode |= mo;
	}
	if( mo & MOD_SEQ && i & RNDIO		||
	    mo & MOD_INT && i & RNDIO		||
	    mo & MOD_RND && !(i & RNDIO)	||
	    mo & MOD_FMT && i & BINIO		||
	    mo & MOD_UNF && !(i & FMTIO) )	goto fmde;

	if( mo & MOD_RND ){
		if( recnum < 1 ||
		    fp->frecmx && recnum > fp->frecmx ) errex( ERR_REC );
		fp->frecno = recnum;
		seek( fp->fdesc, (long)fp->frecln * (recnum-1), 0);
	}
	lph = lp = r.data;			/* set scanner		*/
	lstio = curop & LSTIO;			/* set lstio flag	*/
	if( curop & IOREAD ) getrec();		/* get initial record	*/
	fmtsp = &fary[0];			/* set up format stack	*/
	fmtsp->fptr = fmtp = format = fmt;	/* save format pointer	*/
	fmtcod = repcnt = scale = 0;		/* inialize fmt vars	*/
	blkmod = mo & MOD_BLZ;
	sgnmod = 0;
	if( curop & IOWRITE && fmtp ){
		nextfe(0);
		if( fmtcod ) repcnt = repcnt < 2 ? 2 : repcnt+1;
	}
	return;

fmde:	errex( ERR_FMDE );
}

/*	_F77IIO initiates an operation on an internal file.  Basically,
	it simply sets up the status just like F77BIO			*/


_F77IIO( memp, iostat, errflg, opn, fmt, recmx )

	DESCRIPT	*memp;		/* descriptor for file		*/
	long		*iostat;	/* return location for status	*/
	int		errflg;		/* error return control		*/
	int		opn;		/* the operation to performed	*/
	char*		fmt;		/* the format if used		*/
	long		recmx;		/* record number for random file*/
{

#ifdef JJJJ
	reg FTNFILE	*fp;

	if( iogoing ) errex( ERR_CONF );
	ifgoing = 1;
	fp = files + NFILES;		/* use magic block		*/
	curds = NFILES;
	curop = opn;
	iostatus = 0;
	if( iostatp = iostat ) *iostatp = 0;
	fp->fmode = MOD_SEQ;
	if( opn & FMTIO ) fp->fmode |= MOD_FMT;
	if( opn & BINIO ) fp->fmode |= MOD_UNF;
	fp->fname = memp->cptr;		/* point to start		*/
	fp->frecln = memp->csize/recmx;	/* indicate record length	*/
	fp->frecmx = recmx;		/* number of records		*/
	fmtsp = &fary[0];			/* set up format stack	*/
	fmtsp->fptr = fmtp = format = fmt;	/* save format pointer	*/
	fmtcod = repcnt = scale = 0;		/* inialize fmt vars	*/
	if( curop & IOWRITE && fmtp ){
		nextfe(0);
		if( fmtcod ) repcnt = repcnt < 2 ? 2 : repcnt+1;
	}
#endif
}
/*	the end io procedure updates the state information if the 
	input/output operation was error free by flushing buffers
	and revising the positioning data.  if errors occur the 
	error value is returned to the FORTRAN program.			*/

_F77EIO(){

	reg FTNFILE	*fp;
	reg		i;

	fmtcod = iogoing = 0;
	fp = files + curds;
	if( curop & IOWRITE ){
		r.flgh |= LASTREC;
		putrec();
	}
	if( fp->fposn ) *fp->fposn = fp->frecno;
}
/*	_F77OPN is called to open a unit 				*/


_F77OPN( ds, iostat, errflg, filen, status, access_, form, recl, blank )

	long		ds;		/* the fortran data set number	*/
	long		*iostat;	/* error reporting field	*/
	int		errflg;		/* handling of errors		*/
	DESCRIPT	*filen;		/* the file name (or NULL)	*/
	DESCRIPT	*status;	/* the status of the file	*/
	DESCRIPT	*access_;	/* how it will be used		*/
	DESCRIPT	*form;		/* is it formatted		*/
	long		recl;		/* length of a record		*/
	DESCRIPT	*blank;		/* blank mode			*/
{


	reg FTNFILE	*fp;
	reg char	*ap,
			*bp;
	reg		statcode;

#ifdef JJJJ
	fp = getfp( ds, iostat, errflg );
	if( isopen(fp) ) errex( ERR_OPEN );	/* already open		*/
	fp->fmode = 0;
	if( fp->frecno <= 1 ) fp->frecno = 1;
	fp->frecmx = 0;
	fp->fname = 0;
	if( filen ){
		fp->fname = fnmp;
		ap = filen->cptr;
		bp = ap + filen->csize;
		while( fnmp < &fnames[255] && ap < bp ){
			if( *ap != ' ' ) *fnmp++ = *ap;
			ap++;
		}
		*fnmp++ = '0';
		if( fnmp >= &fnames[256] ) fatal("file name overflow");
	}
	if( access_ ){
		if( access_->cptr[0] == 'F' ) fp->fmode |= MOD_FMT;
		if( access_->cptr[0] == 'U' ) fp->fmode |= MOD_UNF;
	}
	if( blank && blank->cptr[0] == 'Z' ) fp->fmode |= MOD_BLZ;
	statcode = 'U';
	if( status ) statcode = status->cptr[0];
	if( statcode == 'S' ) fp->fmode |= MOD_SCR;

	/* discussion:  we will defer the actual open until the first
	   read or write since we don't know at this point which it
	   will be, and we would prefer to have files open only in
	   the correct mode.  The only slight complication is that
	   an error message might come at the wrong place.  However,
	   we will now check that "OLD" files exist and "NEW" file
	   do not!
	*/

	ap = getname( ds );
	if( statcode == 'N' && access(ap,0) == 0 ) errex( ERR_OPEN );
	if( statcode == 'O' && access(ap,0) != 0 ) errex( ERR_OPEN );
#endif
}
/*	_F77CLS is called to close an open file				*/

_F77CLS( ds, iostat, errflg, status )

	long		ds;		/* fortran data set number	*/
	long		*iostat;	/* return point for  iostatus	*/
	int		errflg;		/* error control		*/
	DESCRIPT	*status;	/* KEEP or DELETE		*/
{

	reg FTNFILE	*fp;

	jmpctl = errflg;
	if( badfile(ds) ) errex( ERR_FNUM );
	if( iostat ) *iostat = iostatus;
	if( !isopen(fp) ) return;
	if( fp->fmode & MOD_SCR || status && status->cptr[0] == 'D' )
		unlink( getname(ds) );
	close( fp->fdesc );
	fp->fmode &= ~(MOD_REA|MOD_WRI);
	fp->frecno = 0;			/* this is a real close		*/
}
/*	_F77ENF is called to write an end of file onto a file.  	*/


_F77ENF( ds, iostat, errflg ) long ds; long *iostat; int errflg;{

	reg FTNFILE	*fp;

	fp = getfp(ds,iostat,errflg);
	if( !(fp->fmode & MOD_WRI) ) errex( ERR_IO ); /* EOF illegal	*/
	fp->frecno++;			/* an EOF counts as a record	*/
	if( fp->fmode & MOD_UNF ){	/* EOF's on binary files	*/
		r.flgh = EOFREC;
		r.cnth = 0;
		if( write(fp->fdesc, (char *)&r, 255) != 256 ) errex( ERR_IO );
		return;
	}
	if( fp->fmode & MOD_SEQ ){
		fp->fmode &= ~MOD_WRI;		/* mark not open	*/
		close( fp->fdesc );
	}
}
/*	_F77INQ implements the Fortran inquire function.  ThE routine
	has numerous arguments, most of which will be null at any
	call.  It should probably be broken up into several calls, but
	this seems simpler at the moment.  There are two instances:
	inquire by unit and inquire by name.  Inquire by name
	is distinguished by a non-null filen.
*/


_F77INQ( dsn, filen, iostat, errflg, exist, opened, number, named, name,
	 access_, sequential, direct, form, formatted, unformatted, recl,
	 nextrec, blank )

	long		dsn;		/* Data set number		*/
	DESCRIPT	*filen;		/* Data set name		*/
	long		*iostat;	/* status return cell		*/
	int		errflg;		/* error control		*/
	long		*exist;		/* logical for existence	*/
	long		*opened;	/* is it open?			*/
	long		*number;	/* number of the unit		*/
	long		*named;		/* is it named?			*/
	DESCRIPT	*name;		/* if so what is the name	*/
	DESCRIPT	*access_;	/* SEQUENTIAL or DIRECT		*/
	DESCRIPT	*sequential;	/* YES or NO			*/
	DESCRIPT	*direct;	/* YES, NO, or UNKNOWN		*/
	DESCRIPT	*form;		/* FORMATTED or UNFORMATTED	*/
	DESCRIPT	*formatted;	/* YES, NO, or UNKNOWN		*/
	DESCRIPT	*unformatted;	/* YES, NO, or UNKNOWN		*/
	long		*recl;		/* record length		*/
	long		*nextrec;	/* next record number		*/
	DESCRIPT	*blank;		/* NULL or ZERO			*/
{

	reg FTNFILE	*fp;
	reg char	*p;
	reg char	*q;
	reg		i;
	char		nbuf[64];	/* name copied here		*/

#ifdef JJJJ
	if( exist ) *exist = 0;
	if( number ) *number = -1;
	if( named ) *named = 0;
	if( recl ) *recl = 0;
	if( nextrec ) *nextrec = 0;
	if( opened ) *opened = 0;
	if( iostat ) *iostat = ERR_FNUM;	/* just in case		*/
	if( filen ){				/* lookup file name	*/
		i = filen->csize;
		p = filen->cptr;
		q = nbuf;
		while( --i >= 0 && q < &nbuf[63] ) *q++ = *p++;
		*q = 0;
		for( i=0; i<NFILES; i++ )
			if( (p = files[i].fname) && strcmp( nbuf, p ) == 0 )
				goto found;
		return;
found:		dsn = i;
	} else
	if( badfile(dsn) && exist ) return;	/* already set false	*/
	fp = getfp(dsn,iostat,errflg);
	if( exist ) *exist = 1;
	if( number ) *number = dsn;
	if( opened && isopen(fp) ) *opened = 1;
	if( named && fp->fname ) *named = 1;
	if( recl ) *recl = fp->frecln;
	if( nextrec ) *nextrec = fp->frecno;
	if( name && fp->fname ) setdesc( name, fp->fname );
	setdesc( access_, fp->fmode & MOD_RND ? "DIRECT" : "SEQUENTIAL" );
	setdesc( sequential, fp->fmode & MOD_SEQ ? "YES" : "NO" );
	setdesc( direct, fp->fmode & MOD_RND ? "YES" : "NO" );
	setdesc( direct, fp->fmode & MOD_FMT ? "FORMATTED" : "UNFORMATTED" );
	setdesc( formatted, fp->fmode & MOD_FMT ? "YES" : "NO" );
	setdesc( unformatted, fp->fmode & MOD_UNF ? "YES" : "NO" );
	setdesc( blank, fp->fmode & MOD_BLZ ? "ZERO" : "NULL" );
#endif
}


STATIC setdesc( x, s ) DESCRIPT *x; reg char *s; {

	reg char	*p;
	reg		n;

	if( x == NULL ) return;		/* no descriptor supplied	*/
	p = x->cptr;
	n = x->csize;
	while( *s && --n >= 0 ) *p++ = *s++;
	while( --n >= 0 ) *p++ = ' ';
}
/*	_F77REW positions the file at the beginning by the simple artifice
	of setting the file position pointer to zero.  Out of range files
	are ignored.							 */


_F77REW( dsn, iostat, errflg ) long dsn; long *iostat; int errflg; {

	reg FTNFILE *fp;

	fp = getfp(dsn,iostat,errflg);
	if( !isopen(fp) == 0 ) errex( ERR_IO );
	close( fp->fdesc );		/* close the file		*/
	fp->fmode &= ~(MOD_REA|MOD_WRI);
}
/*	_F77BKS positions the file at the previous record (if it 
	exists).  Backspacing a file which is not open or a file
	which is at its beginning has no effect.  Backspace works 
	on all file types.  Just what constitutes a record depends
	upon the mode of the file.

	Formatted files are scanned backwards for the second
	newline, then forward over the newline as a record is
	always terminated by a newline.  Thus partial records
	are ignored.  

	Binary records use their internal flag structure.

	Random records are moved to the previous record			*/


_F77BKS( dsn, iostat, errflg ) long dsn; long *iostat; int errflg;{

	reg FTNFILE	*fp;
	reg		i;
	char		ch[2];
	long		position;

#ifdef JJJJ
	fp = getfp( dsn, iostat, errflg );
	if( !isopen(fp) ) errex( ERR_IO );
	if( fp->frecno <= 1 ) return;
	fp->frecno--;
	if( fp->fmode & MOD_RND ) return;	/* no work to do	*/
	position = lseek( fp->fdesc, 0L, 2 );
	if( position == -1 ) errex( ERR_IO );
	if( fp->fmode & MOD_UNF ){
		do {
			position -= 256;
			seek( fp->fdesc, position, 0 );
			if( read( fp->fdesc, &r, 256 ) != 256 ) errex( ERR_IO );
		} while( (r.flgh & (EOFREC|FIRSTREC)) == 0);
		seek( fp->fdesc, position, 0 );
		return;
	}

	/* the style must be sequential, but there are two forms:
		fixed length and variable length terminated with a
		new line						*/
	if( fp->frecln ){		/* fixed length records	*/
		position = (fp->frecno - 1) * fp->frecln;
		seek(fp->fdesc,position,0);
		return;
	}
	for( i=0; i<2; i++ ) do {
		seek( fp->fdesc, --position, 0);
		read( fp->fdesc, ch, 1 );
	} while( position >= 0 && ch[0] != '\n');
	if( ch[0] == '\n' ) position++;
	seek( fp->fdesc, position, 0 );
	return;
#endif
}
/*	ERROR REPORTING -- Messages to stderr		*/


STATIC
errex( n ) reg n;{

	reg	i;

	iostatus = n;
	i = jmpctl;
	jmpctl = 0;		/* one jump per customer only	*/
	if( n == ERR_EOF ){
		if( i & 0x1 ) longjmp( _F77EOJ, ERR_EOF );
	} else {
		if( i & 0x2 ) longjmp( _F77ERJ, iostatus );
	}
	switch( n ){
case ERR_OPEN:	fatal("cannot open file");
case ERR_IO:	fatal("read/write/seek failure");
case ERR_EOF:	fatal("end of file");
case ERR_FNUM:	fatal("bad file number");
case ERR_FMDE:	fatal("bad file mode");
case ERR_SIZE:	fatal("error in data transfer size");
case ERR_FMTA:	fatal("unbalanced parens in format");
case ERR_FMTB:	fatal("nesting too deep");
case ERR_FMTC:	fatal("illegal format specifier");
case ERR_FMTD:	fatal("missing separator in format");
case ERR_FMTE:	fatal("illegal char in format");
case ERR_DEF:	fatal("duplicate define for file");
case ERR_REC:	fatal("illegal record number");
case ERR_DATA:	fatal("illegal character input data");
case ERR_CONF:	fatal("can't do IO while IO in progress");
case ERR_LSTIO:	fatal("incorrect listio input");
default:	fatal("strange iostatus: %d",iostatus);
	}
}


/* the following displays part of the format when printing an error	*/

STATIC
fmterr(s) char *s; {	/* make up a string for displaying the error */

	char		fmtdisp[32];
	reg char	*p;
	reg char	*q;

	p = fmtp-15;
	q = fmtdisp;
	if( p < format ) p = format;
	while( p < fmtp ) *q++ = *p++;
	*q++ = ' ';
	*q++ = '^';
	*q++ = ' ';
	fmtp += 10;
	while( p < fmtp && q < &fmtdisp[30] &&
		*p >= ' ' && *p <= 0176 ) *q++ = *p++;
	*q = 0;
	fatal(s,fmtdisp);
}
/*	fatal message printer (mini printf)			*/

STATIC
fatal( fmt , a ) reg char *fmt;{

	reg char	*fst;
	reg		c;

	fst = fmt;
	for(;;) switch( c = *fmt++ ){

case 0:		if( fst != --fmt ) write( 2,fst,fmt-fst);
		if( fmt[-1] != '\n' ) write(2,"\n",1);
		exit(BADEXIT);

case '%':	if( fst != fmt ) write( 2,fst,fmt-fst);
		c = *fmt++;
		fst = ++fmt;
		switch( c ){

	case 'd':	errputd( a );		continue;
	case 's':	c = strlen( (char *)a );
			write( 2,(char *)a,c);
		}
default:	continue;
	}
}

STATIC 
errputd( n ) reg n;{

	char	c[2];
	if( n < 0 ){
		write( 2,"-",1 );
		n = -n;
	}
	if( n > 9 ) errputd( n/10 );
	c[0] = (n % 10 ) + '0';
	write( 2, c , 1 );
}
/*	MISC ROUTINES FOR I/O SETUP AND VERIFICATION  */

/*	files are opened at their first use.  random files are 
	always opened for reading and writing if they exist.
	in other cases, an initial write operation causes any
	file of the same name to be elided.  an initial read
	causes the file to be preserved.  All files are opened
	for both reading and writing.					*/


STATIC char *
getname(n){		/* routine to produce the "name" of a file	*/

	reg FTNFILE	*fp;
	static char proto[] = "ftnXX";

	fp = files + n;
	if( fp->fname ) return fp->fname;

	proto[3] = (n >= 10) ? '1' : '0';
	proto[4] = (n % 10) + '0';

	return proto;
}

/* the following is a substitute for the standard cleanup supplied in
   stdio.  Fortran programs are basically incompatible with using stdio.
   One should never mix the two.  It is permissible to link fortran
   subroutines that do not do IO with C programs, or to link C subprograms
   that do not do IO with Fortran Main programs.			*/

_cleanup(){		/* this closes the files		*/

	reg		i;

	for( i=0; i<NFILES; i++ )
		if( files[i].fmode & MOD_SCR ) unlink( getname(i) );
}
STATIC FTNFILE *
getfp( dsn, iostat, errflg ) long dsn; long *iostat; short errflg; {

	iostatus = 0;
	iostatp = iostat;
	if( iostat ) *iostat = 0;
	jmpctl = errflg;
	if( badfile(dsn) ) errex( ERR_FNUM );
	return files + dsn;
}

long
seek( unit, pos, co ) long pos; {

	extern long lseek();

	if( lseek( unit, pos, co ) == -1 ) errex( ERR_IO );
}
/*	   LOWEST LEVEL DATA TRANSFER ROUTINES 			*/


/*	These routines do character at a time input/output and are used
 	by the higher level routines below.

	putrec forces the contents of the current buffer out and 
	resets the pointers as needed. 

	getrec fills the buffer with data from the file and 
	loads the pointers to reflect this transfer..			*/


STATIC
putrec(){

	reg FTNFILE	*fp;
	reg		i;

	fp = files + curds;
	i = lph - r.data;		/* data length			*/
	fp->frecno++;			/* count the record		*/
	if( curop & BINIO ){		/* write a binary record	*/
		r.cnth = i;		/* 0 is permissible here	*/
		outrec( fp, &r, 256 );	/* write the record		*/
		r.flgh = 0;		/* and clear the flag byte	*/
	} else {
		if( fp->frecln ){	/* fixed length records		*/
			lp = r.data + fp->frecln;
			while( lph < lp ) *lph++ = ' ';
			i = fp->frecln;
		} else
		if( i < 254 && fmtcod != ':' ) r.data[i++] = '\n';
		outrec( fp, r.data, i );
	}
	lp = lph = r.data;
}

STATIC
outrec( fp, buf, len ) reg FTNFILE *fp; reg char *buf; {

	reg char	*mp;
	reg		n;

	if( fp->fmode & MOD_INT ){	/* internal file operation	*/
		mp = fp->fname;
		n = len;
		while( --n >= 0 ) *mp++ = *buf++;
		fp->fname = mp;
		return len;
	}
	if( write( fp->fdesc, buf, len ) != len ) errex( ERR_IO );
}


STATIC
getrec(){

	reg FTNFILE	*fp;
	reg		i;

	fp = files + curds;
	if( fp->frecmx && fp->frecno > fp->frecmx ) errex( ERR_EOF );
	fp->frecno++;
	lp = r.data;			/* set pointer to data start	*/
	lph = lp + fp->frecln;		/* end for fixed length io	*/
	if( fp->fmode & MOD_INT ){	/* internal file transfer	*/
		if( curop & BINIO ){
			copyin( &r, fp->fname, 256 );
			lph = lp + (r.cnth & 0xff);
			return;
		}
		copyin( lp, fp->fname, fp->frecln );
		return;
	}
	if( curop & BINIO ){		/* binary read			*/
		i = read( fp->fdesc, &r, 256 );
		if( i < 0 ) errex( ERR_IO );
		if( i == 0 || r.flgh & EOFREC ) errex( ERR_EOF );
		lph = lp + (r.cnth & 0xff);
		return;
	}
	if( fp->frecln ){		/* fixed length read		*/
		i = read( fp->fdesc, lp, fp->frecln );
		if( i == 0 ) errex( ERR_EOF );
		if( i != fp->frecln ) errex( ERR_IO );
		return;
	}
	i = read( fp->fdesc, lp, 254 );
	if( i == 0 ) errex( ERR_EOF );
	if( i < 0 ) errex( ERR_IO );
	lph = lp + i;
}



copyin( to, from, len ) reg char *to, *from; reg len; {

	while( --len >= 0 ) *to++ = *from++;
}

STATIC
gtc(){

	if( lp >= lph ) getrec();		/* get more data	*/
	return *lp++ & 0xff;
}

STATIC
ugtc( ch ){

	*--lp = ch;
}

STATIC  
ptc( ch ){

	if( lp >= &r.data[254] ) putrec();	/* write the record	*/
	*lp++ = ch;
	if( lp > lph ) lph = lp;
}
/*		UNFORMATTED DATA TRANSFER ROUTINES			*/


/*	The raw data transfer routines get a pointer to the object
	to be transfered and its size in bytes.  Buffers are assumed
	correctly setup at entry and are left in a valid state.		*/


STATIC
gt( obj, size ) reg char *obj; reg size; {

	while( --size >= 0 ) *obj++ = gtc();
}


STATIC
pt( obj, size ) reg char *obj; reg size;{

	while( --size >= 0 ) ptc( *obj++ );
}
/*		FORTRAN FORMAT PACKAGE			*/

/*	FORTRAN formatted I/O is baroque in the C environment.
	The approach here simulates the needed coroutine
	mechanisms with procedures and external state.

	Reading and writing are handled in a similiar
	fashion with substantial common code.

	Prior to any data transmission, an initialization
	routine is called to setup some state variables 
	and to transmit any implicit information.

	As data is transmitted by type specific calls and
	is converted according to the current format.

	The interpretation cycle processes internal 
	specifications (X,H,T) and then transmits data
	in accordance to external specifications.
	Processing stops when there are no more elements
	in the I/O-list.

	the normal error response is to stop processing
	the current list except for fill overflows

FORMAT nesting control:

	groups withing FORMAT statements can be nested up to FMTNST levels.
	interpretation of nesting within a group is described below.  the
	`fary' structure below is used to control interpretation of the
	format.  when a group is encountered it's repeat count is stacked
	and the group repeated until the repeat count is complete.  a
	missing repeat count is taken to be a repeat count of one.  
	there are two special cases.  if there are more data items than
	format items and a group appears then processing continues at
	the most recently closed group.  Further data transmission closes
	the record and forces a complete rescan.
*/
/* nextfe  -- get next format element
 
   this routine advances to the format of the next data item to
   be transmitted.  as a side effect it processes the internal
   format fields.  If el is 0, this is simply an administrative call */

STATIC
nextfe(el){

	reg		c;
	reg		i;
	reg		loop;


	fsign = expon = 0;		/* just in case			*/
	if( lstio ){
		if( fmtcod != '/' ) fmtcod = el;
		fwidth = ewidth = 99;
		xwidth = 0;
		return;	/* no format used		*/
	}
	if( fmtcod && --repcnt > 0 ) return;  	/* use old fmtcod	*/
	loop = 0;
	for(;;){
		repcnt = scanint();
		c = nextfc();
		if( c == 'P' ){			/* actually a scale factor */
			scale = repcnt;
			repcnt = scanint();
			c = nextfc();
		}
		fmtcod = c;
		switch( fmtcod ) {

case ':':		if( el ) continue;
			repcnt = 0;
			return;

case '\'':		if( curop & IOREAD )
				fmterr("'...' not legal for input");
more:			while( *fmtp != '\'' ) ptc( *fmtp++ );
			fmtp++;
			if( *fmtp == '\'' ){
				ptc( *fmtp++ );
				goto more;
			}
			continue;

case '\0':		/* NUL => error in format */
			fatal("no terminating ')' in format");
			
case '/':		fmtend();	/* skip to next newline		*/
			if( curop & IOREAD ) getrec();
			continue;

case '(':		if( fmtsp >= &fary[FMTNST] )
				fmterr("too many ('s in format");
			fmtsp->rcnt = repcnt;
			fmtsp->fptr = fmtp;	/* do not include paren	*/
			if( fmtsp == &fary[1] )
				fary[0].fptr = fmtp;	/* special case	*/
			fmtsp++; 
			continue;


case ')':		fmtcod = 0;
			if( fmtsp == &fary[1] ){ /* outside bracket	*/
				fmtp = (fmtsp-1)->fptr;
				if( el == 0 ) return;
				fmtend();	/* move to next record	*/
				if( loop++ ) fmterr("no format element");
				continue;
			}
			if( --(fmtsp-1)->rcnt > 0 ){	/* repeat again	*/
				fmtp = (fmtsp-1)->fptr;
				continue;
			}
			fmtsp--;
			continue;

case 'A': case 'I':
case 'L': case 'Z':	setfew();
			if( fwidth >= 0 && fmtcod != 'I')
				fmterr("illegal field specification");
			return;

case 'D': case 'E':
case 'F': case 'G':	setfew();
			if( fwidth < 0 ) fmterr("no width specified");
			return;

case 'T':		i = ewidth;
			c = nextfc();
			if( c == 'R' ) i += lp-r.data; else
			if( c == 'L' ) i = lp-r.data -i; else
			fmtsp--;
			lp = r.data + i;
			if( lp < r.data ) lp = r.data;
			if( lp > lph ){
				if( lp > &r.data[254] ) lp = &r.data[254];
				if( curop & IOWRITE )
					while( lph < lp ) *lph++ = ' ';
				else
					lp = lp;
			}
			continue;

case 'B':		i = *fmtp++;
			blkmod = 0;
			if( i == 'n' || i == 'N' ) continue;
			blkmod = 1;
			if( i == 'z' || i == 'Z' ) continue;
			fmterr("not BN or BZ");

case 'S':		i = *fmtp++;
			sgnmod = 1;
			if( i == 'p' || i == 'P' ) continue;
			sgnmod = 0;
			if( i == 's' || i == 'S' ) continue;
			fmtp--;
			continue;

case 'X':		if( repcnt < 1 ) repcnt = 1;
			if( curop & IOREAD ){
				while( --repcnt && lp < lph && *lp != '\n')
					lp++;
				continue;
			}
			while( --repcnt >= 0)
				if( lp >= lph && lp < &r.data[254] )
					*lp++ = ' ';
			if( lp > lph ) lph = lp;
case ' ': case ',':	continue;

default:		/* illegal character */
			fmterr("illegal character in format");
		}
	}
}


STATIC
setfew() {	/* set element and fraction widths */

	ewidth = scanint();
	if( ewidth <= 0 ) fmterr("non-positive element width");
	xwidth = fwidth = -1;
	if( *fmtp == '.' ) {
		fmtp++;
		fwidth = scanint();
		if( *fmtp == 'E' || *fmtp == 'e' ){
			fmtp++;
			xwidth = scanint();
		}
	}
}

STATIC int 
scanint(){ 	/* scan integer from format */

	reg	n,
		c,
		sign;

	n = sign = 0;
	c = nextfc();
	if( c == '-' ) {
		sign++;
		c = nextfc();
	}
	while( c <='9' && c >= '0' ) {
		n = n * 10 + (c - '0');
		c = nextfc();
	}
	if( sign ) n = -n;
	fmtp--;			/* back up over delimiter */
	return n;
}

STATIC int
nextfc(){ 	/* next non-blank format character */

	reg	i;

	while( *fmtp == ' ' ) fmtp++;
	i = *fmtp++;
	if( i >= 'a' && i <= 'z' ) i += 'A' - 'a';
	return i;
}


STATIC
fmtend(){	/* close a formatted record			*/

	if( curop & IOREAD) lp = lph = r.data; else putrec();
}
/*		conversion routines				*/


STATIC double
pow10( n ) reg n; {			/* returns 10**n */

	reg		k;
	double		x,
			y;

	x = 1.0;
	y = 10.0;
	k = (n<0)?-n:n;
	while( k ){
		if( k & 01 ) x = x * y;
		y = y * y;
		k >>= 1;
	}
	if( n < 0 ) x = 1.0/x;
	return x;
}

STATIC double
norm(){

	sgnsiz = 0;
	if( sgnmod||fsign ) sgnsiz = 1;
	if( fval < 0.0 ){
		fsign = sgnsiz = 1;
		fval = -fval;
	}
	while( fval >= 1.0e10 ){ expon += 10; fval /= 1.0e10; }
	while( fval >= 1.0 ){ expon++; fval /= 10.; }
	while( fval < .1e-10 ){ expon -= 10; fval *= 1.0e10; }
	while( fval < .1 ){ expon--; fval *= 10.; }
}

STATIC
round( n ){		/* round to n digits		*/

	if( n <= 0 || n > 15 ) return;
	fval += 0.5 * pow10( -n );
	norm();
}

STATIC
digout( n )reg n;{		/* output n digits from fval		*/

	reg	i;

	while( --n >= 0 ){
		fval *= 10.0;
		i = fval;
		if( i < 0 || i > 9 ){
			i = '*';
			fval = 0.0;
		} else {
			fval = fval - i;
			i += '0';
		}
		ptc( i );
	}
}

STATIC
blkout( n ) reg n;{		/* output n blanks			*/

	while( --n >= 0 ) ptc( ' ' );
}


STATIC
zerout( n ) reg n; {		/* output n zeroes		*/

	while( --n >= 0 ) ptc( '0' );
}

STATIC
starout(){			/* fill field with stars	*/

	reg	i;

	i = ewidth;
	while( --i >= 0 ) ptc( '*' );
}
/*	the E format output conversion routine		*/

STATIC
econv(){

	reg	digtoleft;
	reg	digtoright;
	reg	zertoleft;
	reg	zertoright;
	reg	blktoleft;
	reg	posused;

	digtoleft = zertoleft = zertoright = blktoleft = 0;
	if( scale <= 0 ){
		if( -scale >= fwidth ) goto stars;
		zertoleft = 1;		/* one zero to left of point	*/
		zertoright = -scale;
		digtoright = fwidth + scale;
	} else {
		if( scale >= fwidth+2 ) goto stars;
		digtoleft = scale;
		digtoright = fwidth - scale - 1;
	}
	if( lstio ) digtoright = 12 - digtoleft;
	if( fval != 0.0 ){
		norm();
		round( digtoleft+digtoright );
		expon += scale;
	}
	if( xwidth < 1 ){
		xwidth = 2;
		if( expon < -99 || expon > 99 ) xwidth = 3;
	}
	if( lstio ){
		blkout( 2 - sgnsiz );
	} else {
		posused = zertoleft + sgnsiz + zertoright +
				digtoleft + digtoright + xwidth + 3;
		if( posused > ewidth ) goto stars;
		blkout( ewidth - posused );
	}
	if( sgnsiz ) ptc( fsign ? '-' : '+' );
	zerout( zertoleft );
	digout( digtoleft );
	ptc( '.' );
	zerout( zertoright );
	digout( digtoright );
	ptc( fmtcod == 'D' ? 'D' : 'E' );
	ptc( expon >= 0 ? '+' : '-' );
	if( expon < 0 ) expon = -expon;
	if( xwidth > 2 ) ptc( expon/100 + '0' );
	expon %= 100;
	if( xwidth > 1 ) ptc( expon/10 + '0' );
	expon %= 10;
	ptc( expon + '0' );
	return;

stars:	starout();
}
/*	the F format output conversion routine			*/

STATIC
fconv(){

	reg	digtoleft;
	reg	digtoright;
	reg	zertoleft;
	reg	zertoright;
	reg	blktoleft;
	reg	posused;

	digtoleft = zertoleft = zertoright = blktoleft = 0;
	if( fval != 0.0 ){
		norm();
		expon += scale;
		round( fwidth + expon );
	}
	if( expon > 0 ){
		digtoleft = expon;
		digtoright = fwidth;
	} else {
		zertoleft = 1;
		zertoright = -expon;
		if( zertoright > fwidth ) zertoright = fwidth;
		digtoright = fwidth - zertoright;
	}
	if( lstio ){
		digtoright = 12 - digtoleft;
		ewidth = 2 - sgnsiz;
		posused = 0;
		if( lp >= &r.data[64] ) putrec();
	} else
		posused = zertoleft + sgnsiz + zertoright +
			digtoleft + digtoright + 1;
	if( posused > ewidth ) goto stars;
	blkout( ewidth - posused );
	if( sgnsiz ) ptc( fsign ? '-' : '+' );
	zerout( zertoleft );
	digout( digtoleft );
	ptc( '.' );
	zerout( zertoright );
	digout( digtoright );
	if( lstio ) blkout( 5 );
	return;
stars:	starout();
}
/*	G format, I format, and Z format output			*/



STATIC
gconv(){		/* g conversion			*/

	if( lstio ){
		if( fval == 0.0 ){ ival = 0; iconv(); return; }
		norm();
		round( 14 );	/* round to 14 digits */
		if( expon < 6 && expon > -2 ) fconv(); else econv();
		return;
	}
	if( fval == 0.0 ){ fconv();  return; }
	norm();
	if( expon < 0 || expon >= fwidth ) econv(); else fconv();
}



STATIC
iconv(){

	reg	i,
		toobig,
		neg,
		j;
	char	digit[20];

	if( fwidth > ewidth ) fmterr("too many 0's specified");
	i = toobig = neg = 0;
	if( ival < 0 && (neg++, (ival = -ival)) < 0 )
		ival--, toobig++;			/* special case */
	sgnsiz = neg|sgnmod;
	do  digit[i++] = ival % 10, ival /= 10; while( ival );
	if( lstio ){
		if( lp >= &r.data[64] ) putrec();	/* write record	*/
		j = 3 - sgnsiz - i;
		if( j < 1 ) j = 1;
		blkout( j );
	} else {
		if( fwidth >= 0 ){
			while( i > fwidth && digit[i-1] == 0 ) i--;
			while( i < fwidth ) digit[i++] = 0;
		}
		if( i + sgnsiz > ewidth ){ starout(); return; }
		blkout( ewidth - i - sgnsiz );
	}
	if( sgnsiz ) ptc( neg ? '-' : '+' );
	if( toobig ) digit[0]++;
	while( --i >= 0 ) ptc( digit[i] + '0' );
}

STATIC
zconv( n ) long n; {

	reg	dgx,
		i;

	/* NOT YET */

	/* this was deleted in order to find a good way of specififying
	   the manner of packing nibbles in storage			*/
}
/* 		FORMATTED DATA TRANSMISSION ROUTINES			*/

/*	The routines below are called by the program to transmit
	data in accordance with the format.   Each transfers a 
	value of the specified type to or from the formatted data
	stream

	below are general routines followed by globally accessable
	routines which are type specific.  output is handled first,
	then input.							*/



STATIC
putf(){		/*	putf -- output floating value			*/

	switch( fmtcod ){

case 'D':
case 'E':	econv();				return;

case 'F':	fconv();				return;

case 'G':	gconv();				return;

case 'I':	ival = fval;
		iconv();				return;

case 'Z':	zconv( &fval );				return;

	}
	fmterr("illegal format for floating output");
}


STATIC
puti(){		/*	puti -- output integer value		*/

	switch( fmtcod ){

case 'D':
case 'E':
case 'F':
case 'G':	fval = ival; putf();			return;

case 'I':	iconv();				return;

case 'Z':	zconv( &ival );				return;
	}
	fmterr("illegal format for integer output");
}


putl(){		/*		put logical value		*/

	reg	i;

	nextfe('L');
	i = ewidth;
	if( fmtcod != 'L' || i < 1 ) errex( ERR_FMTC );
	while( --i > 0 ) ptc( ' ' );
	ptc( ival ? 'T' : 'F' );
}
/*		FORMATTED INPUTS				*/

STATIC
getexp(n){		/* get an exponent		*/

	reg	i;
	reg	c;
	reg	sign;
	reg	signfound;
	reg	excount;

	expon = 0;
	excount = sign = signfound = 0;
	for( i=0; i<n; i++ ){
		c = gtc();
		if( c == '\n' ){
			ugtc(c);
			break;
		}
		if( c == '+' || c == '-' ){
			if( signfound ) errex( ERR_DATA );
			signfound++;
			if( c == '-' ) sign++;
			continue;
		}
		if( c == ' ' ){
			if( lstio ) break;
			if( !blkmod ) continue;
			c = '0';
		}
		if( c < '0' || c > '9' ){ errch( c ); break; }
		excount++;
		expon = expon * 10 + c - '0';
	}
	if( sign ) expon = -expon;
	if( excount == 0 ) errex( ERR_DATA );
}


STATIC
getf(x)double *x;{			/* get floating point		*/

	reg		i,
			c,
			td,
			signfound,
			pointfound;

	switch( fmtcod ){

default:	fmterr("illegal format for integer input");

case 'I':	geti( &ival ); *x = ival;			return;
case 'L':	*x = getl();					return;
case 'Z':	getz( (char *) x, ewidth);			return;

case 'D':
case 'E':
case 'F':
case 'G':	break;

	}
	expon = 0;
	fsign = 0;
	signfound = 0;
	pointfound = 0;
	td = 0;
	fval = 0.0;
	if( sepskip() ) return;
	for( i=0; i<ewidth; i++ ){
		c = gtc();
		if( c == '\n' ){ ugtc(c); break; }
		if( c == ' ' ){
			if( lstio ) break;
			if( !blkmod ) continue;
			c = '0';
		}
		if( c == '.' ){
			if( pointfound ) errex( ERR_DATA );
			pointfound++;
			continue;
		}
		if( c == '+' || c == '-' ){
			if( signfound ) errex( ERR_DATA );
			signfound++;
			if( c == '-' ) fsign++;
			continue;
		}
		if( c == 'e' || c == 'E' || c == 'd' || c == 'D' ){
			getexp( ewidth - ++i );
			break;
		}
		if( c < '0' || c > '9' ){ errch( c ); break; }
		fval = fval * 10.0 + (c - '0');
		if( pointfound ) td++;
	}
	if( !pointfound && !lstio ) td = fwidth;
	expon -= td;
	if( expon ) fval *= pow10( expon );
	if( fsign ) fval = -fval;
	fsign = 0;
	expon = 0;
	*x = fval;
}


STATIC
geti( x ) long *x; {	/*		geti -- read integer		*/

	reg		i,
			c,
			sign,
			sgnfound;

	
	switch( fmtcod ){

default:	fmterr("illegal format for integer input");

case 'D':
case 'E':
case 'F':
case 'G':	getf(&fval); ival = fval;			return;

case 'I':	sgnfound = sign = 0;
		ival = 0;
		if( sepskip() ) return;
		for( i = 0; i < ewidth; i++ ){
			c = gtc();
			if( c == '\n' ){
				ugtc(c);
				break;
			}
			if( c == '+' || c == '-' ){
				if( sgnfound++ ) fmterr("too many signs");
				if( c == '-' ) sign++;
				continue;
			}
			if( c == ' ' ){
				if( lstio ) break;
				if( !blkmod ) continue;
				c = '0';
			}
			if( c > '9' || c < '0' ){ errch( c ); break; }
			ival = ival * 10 + c - '0';
		}
		if( sign ) ival = -ival;
		*x = ival;
		return;

case 'Z':	getz( (char *) x, ewidth);			return;
	}

}

STATIC
getl(){			/* read logical			*/

	reg	i,j,k;

	nextfe('L');
	if( fmtcod != 'L' || ewidth < 1 ) errex( ERR_FMTC );
	i = ewidth;
	k = 0;
	while( --i >= 0 && ((j = gtc()) == ' ' || j == '.') );
	if( j == 't' || j == 'T' ) k++;
	while( j != '\n' && --i ) j = gtc();
	if( j == '\n' ) ugtc(j);
	return k;
}

STATIC
getz( x , sz ) char *x; int sz; {	/* read hex		*/
	/* NOT YET */
}

STATIC
sepskip(){			/* separator skipper for LSTIO */

	reg	c;

	if( !lstio ) return 0;
	if( fmtcod == '/' ) return 1;
	while( (c = gtc()) == ' ' || c == '\t' || c == '\n' );
	if( c == ',' )
		while( (c = gtc()) == ' ' || c == '\t' || c == '\n' );
	if( c == '/' ){
		fmtcod = c;
		return 1;
	}
	ugtc( c );
	return 0;
}

errch( c ){		/* check a character for termination */

	if( lstio && c == '/' ){
		fmtcod = '/';
		return;
	}
	errex( ERR_DATA );
}

cpxstt(){

	if( lstio ){
		if( lp >= &r.data[52] ) putrec();
		ptc( ' ' );
		ptc( '(' );
	}
}

cpxend(){

	if( lstio ){ ptc( ' ' ); ptc( ')' ); }
}

cpxin(){
	if( sepskip() ) return;
	if( gtc() != '(' ) errex( ERR_LSTIO );
}

cpxcma(){
	if( sepskip() || gtc() != ',' ) errex( ERR_LSTIO );
}
cpxrp(){
	if( sepskip() || gtc() != ')' ) errex( ERR_LSTIO );
}
/*		User Transfer routines called for each item	*/

/* unformatted transfers	*/

_GUCH( x, n ) DESCRIPT *x; {

	reg char	*p;
	p = x->cptr;
	while( --n >= 0 ){ gt( p, x->csize ); p += x->csize; }
}

_GUI2( x, n ) short *x;long n;{ while(--n>= 0){gt( (char*) x, 2 ); x++;}}

_GUI4( x, n ) long* x;long n;{ while(--n>=0){gt( (char*) x, 4 ); x++;}}

_GUF4( x, n ) float* x;long n;{ while(--n>=0){gt( (char*) x, 4 ); x++;}}

_GUF8( x, n ) double *x;long n;{ while(--n>=0){gt( (char*) x, 8 ); x++;}}

_GUL1( x, n ) char *x;long n;{ while(--n>=0){gt( (char*) x, 1 ); x++;}}

_GUL4( x, n ) long *x;long n;{ while(--n>=0){gt( (char*) x, 4 ); x++;}}

_GUC8( x, n ) COMPLEX8 *x;long n;{
	while(--n>=0){gt((char *)&x->re4,4); gt((char *)&x->im4,4); x++;}}

_GUC16( x, n ) COMPLEX16 *x;long n;{
	while(--n>=0){gt((char *)&x->re8,8); gt((char *)&x->im8,8); x++;}}

_PUCH( x, n ) DESCRIPT *x; long n;{
	reg char *p;
	p = x->cptr;
	while(--n>=0){ pt( p, x->csize ); p+=x->csize;}}

_PUI2( x, n ) short* x; long n;{ while(--n>=0){ pt( (char*) x, 2 ); x++;}}

_PUI4( x, n ) long* x; long n;{ while(--n>=0){ pt( (char*) x, 4 ); x++;}}

_PUF4( x, n ) float* x; long n;{ while(--n>=0){ pt( (char*) x, 4 ); x++;}}

_PUF8( x, n ) double *x; long n;{ while(--n>=0){ pt( (char*) x, 8 ); x++;}}

_PUL1( x, n ) char *x; long n;{ while(--n>=0){ pt( (char*) x, 1 ); x++;}}

_PUL4( x, n ) long *x; long n;{ while(--n>=0){ pt( (char*) x, 4 ); x++;}}

_PUC8( x, n ) COMPLEX8 *x; long n;{
	while(--n>=0){ pt((char * )&x->re4,4); pt((char *)&x->im4,4); x++;}}

_PUC16( x, n ) COMPLEX16 *x; long n;{
	while(--n>=0){ pt((char *)&x->re8,8); pt((char *)&x->im8,8); x++;}}
/*		formatted transfers			*/

_GFCH( x, n ) reg DESCRIPT *x; long n;{

	reg char	*p;
	reg		i;
	reg		j;
	reg		k;

	p = x->cptr;
	while( --n>=0 ){
		nextfe('A');
		sepskip();
		if( fmtcod == '/' ){
			for( i=0; i<x->csize; i++ ) *p++ = ' ';
			continue;
		}
		if( lstio ){
			if( gtc() != '\'' ) errex( ERR_LSTIO );
			i = 0;
			for(;;){
				k = gtc();
				if( k != '\'' || (k = gtc()) == '\'' ){
					if( i++ < x->csize ) *p++ = k;
					continue;
				}
				ugtc(k);
				return;
			}
		}
		if( fmtcod != 'A' ) errex( ERR_FMTC );
		i = ewidth;
		while( --i >= x->csize ) gtc(); /* skip to right part of field*/
		j = x->csize - ++i;
		while( --i >= 0 ) *p++ = gtc();
		while( --j >= 0 ) *p++ = ' ';
	}
}

_GFI4( x, n ) long *x; long n;{ while(--n>=0){ nextfe('I'); geti( x ); x++;}}

_GFI2( x, n ) short *x; long n;{
	long u; while(--n>=0){ _GFI4( &u, 1L ); *x = u; x++;}}

_GFF8(x, n) double *x; long n;{ while(--n>=0){ nextfe('G'); getf( x ); x++;}}

_GFF4( x, n ) float *x; long n;{
	double u; while(--n>=0){ _GFF8( &u, 1L ); *x = u; x++;}}

_GFC8( x, n ) COMPLEX8 *x; long n;{
	while(--n>=0){
		cpxin();
		_GFF4( &x->re4, 1L );
		cpxcma();
		_GFF4( &x->im4, 1L ); x++;
		cpxrp();
	}}

_GFC16( x, n ) COMPLEX16 *x; long n;{
	while(--n>=0){ 
		cpxin();
		_GFF8( &x->re8, 1L );
		cpxcma();
		_GFF8( &x->im8, 1L );
		cpxrp();
		x++;
	}}

_GFL4( x, n ) long *x; long n;{ while(--n>=0){nextfe('L' );*x = getl(); x++;}}

_GFL1( x, n ) char *x; long n;{ while(--n>=0){nextfe('L' );*x = getl(); x++;}}

_PFCH( x, n ) reg DESCRIPT *x; long n;{

	reg char	*p;
	reg		i;

	if( lstio ){
		if( lp+x->csize > &r.data[72] ) putrec();
		ptc( '\'' );
	}
	while(--n>=0){
		nextfe(1);
		i = ewidth;
		p = x->cptr;
		while( --i >= x->csize ) ptc( ' ' );
		while( i-- >= 0 ){
			if( *p == '\'' ) ptc( '\'' );
			ptc( *p++ );
		}
	}
	if( lstio ) ptc( '\'' );
}

STATIC
intout(x) long x;{ nextfe('I'); ival = x; puti(); }

_PFI2( x, n ) short *x; long n;{ while(--n>=0){ intout((long)*x); x++;}}

_PFI4( x, n ) long *x; long n;{ while(--n>=0){ intout(*x); x++;}}

STATIC
fltout(x) double x; {  nextfe('G'); fval = x; putf(); }

_PFF8( x, n ) double *x; long n;{ while(--n>=0){ fltout(*x); x++;}}

_PFF4( x, n ) float *x; long n;{ while(--n>=0){ fltout(*x); x++;}}

_PFC8( x, n ) COMPLEX8 *x; long n;{
	while(--n>=0){
		cpxstt();
		_PFF4( &x->re4, 1L ); _PFF4( &x->im4, 1L ); x++;
		cpxend();
	}}

_PFC16( x, n ) COMPLEX16 *x; long n;{
	while(--n>=0){
		cpxstt();
		_PFF8( &x->re8, 1L ); _PFF8( &x->im8, 1L ); x++;
		cpxend();
	}}

_PFL4( x, n )  long *x; long n;{
	while(--n>=0){ nextfe('L'); ival = *x; putl(); x++;}}

_PFL1( x, n ) char *x; long n;{
	while(--n>=0){ nextfe('L'); ival = *x; putl(); x++;}}

_PFSTR( x ) reg char *x; {

	reg char *y;

	y = x;
	while( *y ) y++;
	if( lp + (y-x) > &r.data[72] ) putrec();
	while( *x ) ptc( *x++);
}
