/* the following structures are for the purpose of defining the
   characteristics of different machines for the purpose of
   compiling C, Fortran, Pascal, and Modula II.  the schema is
   the following:

   A machine file consists of an array of structures, each of
   which describes one compiling model.  That is, it is specific
   not only to the processor, but also to the options that are
   selected for that model, such as (for the 8086) small, middle,
   large model, etc.  The call to the first pass of the compiler
   is examined for a postfixed series of characters which defines
   the machine for which compiling is to be done.  The command line
   may further have an argument of the form: -Mc, where c is any
   ASCII character (typically taken from the set '1', '2', etc),
   with the default being '0'.  The file "ulsmch", "/lib/ulsmch", or
   "/usr/lib/ulsmch" is searched for the proper postfix name (or the
   first entry if no postfix) together with the correct compiling
   model key letter.  The first array so found determines the
   keys for compiling, together with defaults for defines and for
   includes.

*/

/*
$Header: ulsmch.h,v 5.6 88/05/14 10:04:16 rmm Rem $
*/

struct ulsmch {
	char	magic;		/* magic byte				*/
	char	procst;		/* processes performed so far		*/
	char	procst2;	/* extension to above			*/
	char	thislen;	/* length of this structure		*/
	char	flag1;		/* flag byte 1				*/
	char	flag2;		/* flag byte 2				*/
	char	flag3;		/* flag byte 3				*/
	char	flag4;		/* flag byte 4				*/
	char	flag5;		/* flag byte 5				*/
	char	flag6;		/* flag byte 6				*/
	char	flag7;		/* flag byte 7				*/
	char	flag8;		/* flag byte 8				*/
	char	mchname[9];	/* target processor name		*/
	char	syst[7];	/* target system			*/
	char	key[6];		/* the postfix key			*/
	char	model;		/* the model key letter			*/
	char	bytesize;	/* size of a byte in bits		*/
	char	charsize;	/* size of a character in bytes		*/
	char	shortsize;	/* size of a short in bytes		*/
	char	intsize;	/* size of an int in bytes		*/
	char	longsize;	/* size of a long in bytes		*/
	char	ptrsize;	/* size of an ordinary pointer		*/
	char	ptrarith;	/* length of pointer arithmetic		*/
	char	cptrsize;	/* size of a char *			*/
	char	fptrsize;	/* size of a ptr to funct		*/
	char	lblsize;	/* size of a goto address		*/
	char	floatsize;	/* size of a float in bytes		*/
	char	doubsize;	/* size of a double in bytes		*/
	char	ftnint;		/* size of a fortran int		*/
	char	ftnflt;		/* size of a fortran float		*/
	char	ftnlog;		/* size of a fortran logical		*/
	char	charalign;	/* alignment of a character		*/
	char	shortalign;	/* alignment of a short			*/
	char	ptralign;	/* alignment of a pointer		*/
	char	longalign;	/* alignment of a long			*/
	char	floatalign;	/* alignment of a float			*/
	char	doubalign;	/* alignment of a double		*/
	char	stralign;	/* min alignment of a struct		*/
	char	stkalign;	/* min alignment of stack		*/
	char	decalign;	/* alignment of a decimal		*/
	char	setalign;	/* alignment of a set			*/
	char	extalign;	/* general external alignment		*/
	char	parintlen;	/* min lng of int parameter		*/
	char	parfltlen;	/* min lng of float param		*/
	char	fldmax;		/* max length of field in bits		*/
	char	shfsize;	/* length of a shift value in bytes 	*/
	char	longorder[8];	/* byte order of longs			*/
	char	shortorder[8];	/* byte order of shorts			*/
	char	linswitch;	/* linear search limit			*/
	char	sparswitch;	/* sparse switch limit			*/
	char	binswitch;	/* binary search limit			*/
	char	symlen;		/* length of ordinary symbols		*/
	char	ppsymlen;	/* length of pre-pro symbols		*/
	char	xsymlen;	/* external symbol length		*/
	char	regvar1;	/* # of reg variables of type 1		*/
	char	regvar2;	/* # of reg variables of type 2		*/
	char	regvar3;	/* # of reg variables of type 3		*/
	char	regcnt1;	/* # of reg's of type 1			*/
	char	regcnt2;	/* # of reg's of type 2			*/
	char	regcnt3;	/* # of reg's of type 3			*/
	char	creguse;	/* regs used by a char var		*/
	char	sreguse;	/* regs used by a short var		*/
	char	lreguse;	/* regs used by a long var		*/
	char	freguse;	/* regs used by a float var		*/
	char	dreguse;	/* regs used by a double var		*/
	char	cptruse;	/* regs used by a char *		*/
	char	fptruse;	/* regs used by a (*f)()		*/
	char	ptruse;		/* regs used by any other ptr		*/
	char	optlevel;	/* optimization level			*/
	char	warnlevel;	/* warning level			*/
	char	aggrmax;	/* maximum aggregate size		*/
	char	strumax;	/* maximum permitted struct size	*/
	char	argmax;		/* max size of argument without warning	*/
	char	setmax;		/* max set size				*/
	char	nearext;	/* size of 'near' externals		*/
	char	ftnstyle;	/* style of fortran input		*/
	char	fltconv;	/* rounding mode of floating point	*/
	char	errlim;		/* error limit				*/
	char	enulen;		/* minimum length of enumeration	*/
	char	flgother;	/* used variously by code generator	*/
	char	addrunit;	/* natural address unit in bytes	*/
	char	ptrshape;	/* pointer compatibility tests		*/
	char	ldoubsize;	/* size of a long double in bytes	*/
	char	llongsize;	/* size of a long long in bytes		*/
	char	flag9;		/* flag byte 9				*/
	char	flaga;		/* flag byte 10				*/
	char	ptrshp2;	/* more pointer shapes			*/
	char	farpsize;	/* size of FAR pointer			*/
	char	nearpsize;	/* size of NEAR pointer			*/
	char	fldrnd;		/* rounding for field max length (bits)	*/
	char	flduty;		/* base field size in bits		*/
	char	fldpad;		/* padding value in bits for fields	*/
	char	unused[3];	/* to make structure 128 bytes		*/
};

/* magic byte	*/

#define MAGIC	0xd1		/* this should change regularly		magic*/

/* processing status bytes, procst and procst2	*/

#define	UCLEX	0x01		/* has been through C lexer		procst*/
#define	UCPARSE	0x02		/* has been through C parser		procst*/
#define	UF77	0x04		/* has been through F77 parser		procst*/
#define	UPAS	0x08		/* has been through Pascal parser	procst*/
#define	UMODII	0x10		/* has been through Modula II parser	procst*/
#define	UOPT	0x20		/* has been through Optimizer		procst*/
#define UPLEX	0x40		/* has been through Pascal lexer	procst*/

/* flag byte 1 */

#define	UCHAR	0x01		/* chars are default unsigned		1*/
#define ARGRTL	0x02		/* args evaluated right to left		1*/
#define FLDRTL	0x04		/* field packed right to left		1*/
#define NOINCR	0x08		/* no INCR's are emitted		1*/
#define NEARFAR 0x10		/* enable near/far keywords		1*/
#define CONVOL	0x20		/* enable const/volatile		1*/
#define PAGEZ	0x40		/* enable pagezero keyword		1*/
#define DECOK	0x80		/* enable decimal keyword		1*/

/* flag byte 2 */

#define XUPPER	0x01		/* externs are upper case only		2*/
#define EBCIN	0x02		/* input is EBCDIC			2*/
#define EBCSTR	0x04		/* map strings to EBCDIC		2*/
#define EBCOUT	0x08		/* map assembly output to EBCDIC	2*/
#define NOFLOAT	0x10		/* no floating point			2*/
#define HDFLOAT	0x20		/* use hardware floating point		2*/
#define NAROFLT	0x40		/* use narrow float if possible		2*/
#define NOFLTOP	0x80		/* don't 'optimize' float ops		2*/

/* flag byte 3 */

#define BUILTIN	0x01		/* make abs,min,max builtins		3*/
#define COMNEST	0x02		/* permit nesting of comments		3*/
#define STRUPAD	0x04		/* align within strutures		3*/
#define LONGLNG	0x08		/* permit long-long			3*/
#define INCLREP	0x10		/* permit replacement in include lines	3*/
#define STRGREP	0x20		/* permit replacement in strings	3*/
#define KUNUEXT	0x40		/* delete unreference externals		3*/
#define LINTFIL	0x80		/* produce lint data only		3*/

/* flag byte 4 */

#define PROFILE 0x01		/* produce profiling code		4*/
#define ASMOK	0x02		/* asm builtin is legal			4*/
#define ONECASE 0x04		/* convert fortran input to upper case	4*/
#define ONETRIP 0x08		/* DO loops like F66			4*/
#define XLIST	0x10		/* produce interlisted code		4*/
#define IBMEBC	0x20		/* use IBM's version of EBCDIC		4*/
#define ARRCHK	0x40		/* produce array checking code		4*/
#define NOIMPL	0x80		/* remove Fortran implicits		4*/

/* flag byte 5 */

#define SAVECOM	0x01		/* pre-processor is to save comments	5*/
#define SYMLIST	0x02		/* list symbol table flag		5*/
#define STKPROB	0x04		/* software stack probes are generated	5*/
#define VERBOSE 0x08		/* be talky about everything		5*/
#define DOWNCST	0x10		/* insert all down-sizing casts		5*/
#define KEEPENU	0x20		/* don't converts enums to ints for gen	5*/
#define KEEPPTR	0x40		/* don't converts ptrs to ints for gen	5*/
#define NOBITOP	0x80		/* generator can't handle TSTBIT/SETBIT	5*/

/* flag byte 6 */

#define ROSTRNG 0x01		/* strings to read only space		6*/
#define ROINITV	0x02		/* all initialized vars to read only	6*/
#define EBCMSG	0x04		/* messages output in EBCDIC		6*/
#define	NOCXTYP	0x08		/* don't output complex type to gen	6*/
#define PPCOMSP	0x10		/* a comment is a space for the prepro	6*/
#define DEBUGDT	0x20		/* produce full output for a debugger	6*/
#define NONARRO	0x40		/* do not do narrowing			6*/
#define ALTCSEQ 0x80		/* use alternative calling sequence	6*/

/* flag byte 7 */

#define F77IDIV 0x01		/* generate F77 integer divides		7*/
#define F77RND	0x02		/* generate F77 or Pascal rounds	7*/
#define PTRSEGM 0x04		/* pointers are segmented		7*/
#define NOHEADR	0x08		/* suppress header generation		7*/
#define SOFTTYP	0x10		/* be permissive about ptrs and enums	7*/
#define ROCONST 0x20		/* put constants in read only memory	7*/
#define FORMREP 0x40		/* do formal replacements in strings	7*/
#define FULLDBG 0x80		/* output full debugging information	7*/

/* flag byte 8 */

#define CODGEN0 0x01		/* first assignable code gen flag	8*/
#define CODGEN1 0x02		/* second assignable code gen flag	8*/
#define CODGEN2 0x04		/* third assignable code gen flag	8*/
#define CODGEN3 0x08		/* fourth assignable code gen flag	8*/
#define CODGEN4 0x10		/* fifth assignable code gen flag	8*/
#define CODGEN5 0x20		/* sixth assignable code gen flag	8*/
#define CODGEN6 0x40		/* seventh assignable code gen flag	8*/
#define CODGEN7 0x80		/* eigth assignable code gen flag	8*/

/* flag byte 9 */

#define UNALGNM 0x01		/* unaligned mem access is ok		9*/
#define KEEPQC	0x02		/* keep the ? : operators		9*/
#define KEEPAO	0x04		/* keep the && and || operators		9*/
#define BITADDR	0x08		/* pointers have bit addresses		9*/
#define ANSI	0x10		/* obey all ANSI rules			9*/
#define F77AUTO	0x20		/* f77 locals to automatic		9*/
#define XMULDIV	0x40		/* funny multiply/divide operations	9*/
#define TRACE	0x80		/* insert trace information in code	9*/

/* flag byte a */

#define NOMDOPT	0x01		/* do not change % to and		a*/
#define TRIGRPH	0x02		/* process ANSI trigraphs		a*/
#define UNSRSH	0x04		/* right shifts are UNSIGNED!		a*/
#define NOBITPAD 0x08		/* do NOT pad bit fields		a*/
#define USEFLDTY 0x10		/* observe field type			a*/
#define PARALEL	0x20		/* run compiler phases in parallel	a*/


/*	note: CODEGEN0 is assigned as follows for the 8086:
		0 = output funny types for Xenix C externals
		1 = do not output funny types for Xenix (Whitesmith model)
*/

#define PTRSHF	0		/* position of default pointer shape	*/
#define CPTRSHF	2		/* position of char pointer shape	*/
#define FPTRSHF	4		/* position of func pointer shape	*/

#define FARPSHF	0		/* position of far ptr shape in ptrshp2	*/
#define NEARSHF	0		/* position of near ptr shape (ptrshp2)	*/

/* there are four two bit fields in the ptrshape byte.  For determining
   the possibility of comparing two pointers we compare the two bit fields.
   If they are the same, a compare is possible, otherwise an error	*/
