/************************************************************************
*									*
*		writeu.c - machine description structure writer		*
*									*
************************************************************************/

#include "uccio.h"
#include "uls.h"
#include "ulsmch.h"

/*	this writes the ulsmch structure and certain arguments in the
	XARG style
*/

writeu(up,f,stt,keys) struct ulsmch *up; FILE *f; char *stt,*keys;{
	/* up	points to the ulsmch structure to be written
	   f	is the relevant file pointer
	   stt	points to the start of a region of XARG strings, which
		are null terminated in the readu style.
	   keys is a strings containing those key letters for which
		an XARG should be emitted
	*/
	register	i;
	register char	*p;
	register	j;

	i = sizeof( struct ulsmch );		/* length of struct	*/
	p = (char *)up;				/* point to start	*/
	while( --i >= 0 ){			/* loop for ulsmch	*/
		putc( *p, f );			/* copy a character	*/
		p++;
	}
	p = stt;				/* point to XARG's	*/
	while( (*p++ & 0xff) == XARG ){		/* main loop		*/
		i = *p++ & 0xff;		/* get count		*/
		j = 0;
		if( *p >= '1' && *p <= '9' )
			j = --*p;		/* decrement pass #	*/
		if( j || among( *p, keys ) ){
			putc( XARG, f );	/* put the XARG		*/
			putc( i, f );		/* and the count	*/
			while( --i >= 0 ){	/* and the data		*/
				putc( *p, f );
				p++;
			}
		} else {
			p += i;			/* move around string	*/
		}
		if( *p == 0 ) p++;		/* skip terminator	*/
	}
}
