/* allocvect.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	Allocation Vector Module
 */

#ifndef ALLOCV
#define ALLOCV

#ifndef lint
/*	@(#) (Gould) $Header: allocvect.h,v 5.5 89/05/12 12:49:09 pcc Rel-3_0 $		  */
/* static char ALLOCV_SCCSID[] = "@(#)	allocvect.h	9.1	of 86/02/14"; */
#endif

/*
 *	This module implements the AllocVector data type that is used
 *	for handling the allocation of temporaries and variables to
 *	registers.
 *
 *	An allocation vector is an ordered list of pairs (b, s).  S is
 *	a set of variables or temporaries with disjoint lifetimes, that
 *	is, all the elements of s can safely store the same storage.
 *	B is the benefit gained by putting all the members of s into
 *	a register: it is the sum of the individual benefits.
 *
 *	The list is ordered in decreasing order of benefit.
 */

/*
 *	Imported Types
 */

# include <longset.h>
# include <cost.h>

typedef struct AE {
	CostType benefit;		/* sum of benefits over s */
	LongSet s;		/* identifiers that can share storage */
	struct AE *next;	/* next in list */
} AllocElement;

typedef AllocElement *AllocationVector;

/* 
 *	Vector Operations
 */

extern AllocationVector CreateVector();	/* create a one-element vector */
extern void		VectorFree();	/* Recover storage for a vector */
extern void		VectorSum();	/* element-wise sum and union */
extern void		VectorMerge();	/* ordered merge of two vectors */
extern void		PrintVector();	/* Debug: print out a vector */

#endif
