/* blocks.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/* 
 *	Basic Block
 */

#ifndef BBLOCK
#define BBLOCK

#ifndef lint
/*	@(#) (Gould) $Header: blocks.h,v 5.5 89/05/12 12:49:27 pcc Rel-3_0 $		  */
/* static char BLOCK_SCCSID[] = "@(#)	blocks.h	15.3	of 86/11/29"; */
#endif

/*
 *	A Basic Block is a list of program instructions that satisfy
 *	certain criteria: entered only at the top, exit only at the
 *	bottom, no internal transfers of control.
 *
 */

#include <instruct.h>			/* Import Instruction */
#include <longset.h>			/* Import Long Sets */
#include <dag.h>			/* Import DAG Nodes */
#include <bool.h>			/* Import Boolean */

typedef struct BBlock {
	FlowIndex FGindex;		/* Index in flow graph */
	BlockNumber blocknum;		/* Block Number */
	InstrList code;			/* List of instructions for block */
	struct BBlock *next;		/* next Basic Block */

	DAG_Node Dag;			/* DAG for this block */

	struct {
		LongSet Gen;		/* Definitions generated here */
		LongSet Kill;		/* Definitions killed here */
		LongSet In;		/* Defintions reaching here */
		LongSet Out;		/* Definitions leaving here */
	} ud;

	struct {
		LongSet Def;		/* Identifiers defined here */
		LongSet PDef;		/* Identifiers possibly defined here */
		LongSet Use;		/* Identifiers used before def here */
		LongSet In;		/* Identifiers live at start of block */
		LongSet Out;		/* Identifiers live at end of block */
	} ld;

	struct {
		LongSet Gen;		/* Available expr. generated here */
		LongSet Comp;		/* Available expr. computed here */
		LongSet Kill;		/* Available expr. killed here */
		LongSet In;		/* Available expr. reaching here */
		LongSet Out;		/* Available expr. leaving here */
	} av;

	struct {
		LongSet Pos;		/* Set of possible GCSE's */
	} gcse;

	struct {
		LongSet PUse;		/* Possible exposed uses */
	} du;

	Boolean reachable;		/* Is this block reachable? */
	Boolean in_loop;		/* Is this block in the current loop */
	Boolean exit;			/* Is this block a loop exit? */
	Boolean eligible;		/* Are definitions in this block
					 * eligible for loop invariant motion
					 */
	Boolean known_indir_stores;	/* This block has indirect stores to
					 * known places */
	Boolean unknown_indir_stores;	/* This block has indirect stores to
					 * unknown places */
} BasBlock, *BasicBlock;

/*	Export
 */

extern void BuildBlocks();		/* Construct the Basic Blocks	*/
extern void PrintBlocks();		/* Print out the Basic Blocks	*/
extern void FreeBlock();		/* Free a basic block */
extern void LinkBlock();		/* Link basic block bnew on the list
					 * just after b */
extern BasicBlock CreateBlock();	/* Create a new basic block */

extern BasicBlock FirstBlock, CurrentBlock, FinalBlock;
extern int NumBlocks;
extern int NumEntryPoints;

#endif
