/* dagsymbol.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	Symbol Table Manager
 */

#ifndef DAGSYM

#define DAGSYM

#ifndef lint
/*	@(#) (Gould) $Header: dagsymbol.h,v 5.5 89/05/12 12:50:10 pcc Rel-3_0 $		  */
/* static char DAGS_SCCSID[] = "@(#)	dagsymbol.h	15.3	of 86/11/27"; */
#endif


/*
 *	See: Aho and Ullman, Principles of Compiler Design, Section 12.3
 */

#include <longset.h>
#include <tree.h>
#include <identifier.h>
#include <dag.h>

#define	FirstId		2		/* First valid identifier */
extern Identifier MaxIdentifier;	/* Last valid identifier */
#ifdef	INLINER
extern Identifier LastRegId;	/* Last of registers automatically declared */
#endif	/* INLINER */

/*
 *	Exported data types
 */

/*
 *	List of definition points for an object (currently, only temps
 *	of various kinds).
 *	Exported to allow traversals easily.
 */

typedef struct Tdefs {
	struct Tdefs *next;	/* next in list (NULL terminated) */
	DAG_Node def;		/* node that defines this object */
} TempDefType, *TempDefList;

/*
 *	Exported Operations
 */

/*
 *	Symbol Table Routines
 */

extern Operator   IdOp();		/* What is operator for id */
extern Identifier IdLookUp();		/* Look up a (namespace, id) pair */
extern Identifier EnterSymbol();	/* add a symbol to the table */
extern Identifier Pass1Symbol();	/* add a symbol from pass1 to the table
					 * (really just has extra debugging) */
extern char *SaveIdText();	/* Squirrel away identifier text */
extern char *	IdText();	/* Look up the text of an identifier */
extern DAG_Node	NodeID();	/* node associated with a variable */
extern void	SetNodeID();	/* Associate a node with a variable */
extern void	SetAddressed();	/* Record fact that &id seen */
extern void	ParamAddressed(); /* Record fact that &param seen */
extern Boolean  WasAddressed(); /* Was address of id taken (for locals) */
extern void	SetAllocated();	/* Record PCO allocation status */
extern Boolean	IsAllocated();	/* Has PCO allocated this yet? */
extern Boolean  HasAllocation();/* Does the object have an allocation?  */
extern void	SetNotPromotable();	/* object may not be reallocated */
extern Boolean	MayNotPromote(); /* Is reallocation prohibited? */
extern void	SetBenefit();	/* Set benefit to particular value */
extern void	ChangeBenefit(); /* Change Benefit for this id seen */
extern int	Benefit(); 	/* What is current benefit ? */
extern void	SetIdTree();	/* Attach "prototype" tree */
extern void	SetLeafRef();	/* Remember the last leaf reference */
extern LongSet	InitDefs();	/* Initialize all defs of a variable */
extern LongSet	InitUses();	/* Initialize all uses of a variable */
extern void	InitSymManager();	/* Start module */
extern void	InitTable();	/* Initialize the table */
extern void	ResetTable();	/* Reset the table for next basic block */
extern void	PrintTable();	/* Debug: Print the symbol table */
extern DAG_Node LastKilled();	/* Last node that killed an id */
extern void	SetLastKiller();/* Set last node that killed id */
extern DAG_Node	LeafRef();	/* Last reference to leaf node */
extern TreeNode IdTree();	/* Tree that references this id */
extern TWORD	SymType();	/* Get the type of this symbol */
extern TWORD	GetActualType();/* Get the actual type of this symbol */
extern CONSZ	IdCookie();	/* Id's unique (within space) id cookie */

extern void AddTempDef(/* Identifier id; DAG_Node n */); /* add to list */
extern TempDefList GetTempDefs(/* Identifier id */);	/* Get list */
extern void DeleteTempDef(/* Identifier id; TempDefList p */); /* Remove */

extern void	MarkTransparent();/* mark a symbol as being transparent */
extern void	UndoTransparent();/* undo MarkTransparent() */
extern Boolean	IsTransparent();/* has this been marked as transparent */

#ifdef FORT
extern void	SetCommonBlock();	/* Set common block number. */
extern CONSZ	InCommonBlock();	/* Get common block number, if exists */

extern void	SetType();	/* Update the type of this symbol */
extern Identifier ShadowLookUp(); /* Find shadow id for this id */
extern void	SetShadowId();	/* Set shadow id for both id's given */
extern void	SetCopyEligible(); /* Set id eligible for copy in/out */
extern Boolean	IsCopyEligible(); /* Is id eligible for copy in/out */
#endif

extern LongSet	GetDefs();	/* Get all defs of a variable */
extern LongSet	GetUses();	/* Get all uses of a variable */
extern Boolean	UsedFirst();	/* Was this id used before it was set? */
extern void	SetUsedFirst();	/* Record whether or not symbol set before use*/

/* NeedsSpace Operators */

extern void	EmptyNeeds(/*id*/);	/* set NeedsSpace to a new null set */
extern void	AddNeeds(/*flowindex,id*/);	/* add a block to a NeedSpace */
extern void	FreeNeeds(/*id*/);	/* free a NeedsSpace */
extern LongSet	Needs(/*id*/);		/* return NeedsSpace */
extern void	SetFirstNeed(/*id*/);	/* calculate FirstNeed */
extern int	FirstNeed(/*id*/);	/* return pre-calculated FirstNeed */

#endif
