/* deadstore.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	Removal of stores into dead variables
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: deadstore.c,v 5.5 89/05/12 12:50:17 pcc Rel-3_0 $";
/* static char ID[] = "@(#)deadstore.c	15.4	of 86/10/14"; */
#endif

/*	Import
 */

# include <deadstore.h>
# include <assert.h>
# include <blocks.h>
# include <dag.h>
# include <dagsymbol.h>
# include <delay.h>
# include <duchain.h>
# include <erroro.h>
# include <flow.h>
# include <identifier.h>
# include <livedead.h>
# include <longset.h>
# include <prune.h>
# include <udchain.h>

int DSDebug = 0;
int NoUnusedVars = 0;

/*	Export
 */

/*	Import
 */

/*	Private
 */

LongSet LDTemp, UDTemp, DUTemp;		/* Temporary sets of various types */

static void TryReclaim();
static Boolean TryUnused();

/*
 * Removal of dead stores
 */

void
DeadStores()
{
	BasicBlock b;
	int i;
	Boolean change, workdone;

	if( NoUnusedVars )
/**/		return;

	LDTemp = CreateSet((int)(MaxIdentifier+1));
	DUTemp = CreateSet(DUSetSize);
	UDTemp = CreateSet(UDSetSize);

	do{
		change = False;
		for( b = FirstBlock; b != NULL; b = b->next )
		    if( b->reachable )
		    {
			workdone = False;
			Difference(LDTemp, b->ld.PDef, b->ld.Out);
			for( i = FirstElement(LDTemp); i != NoElement;
			     i = NextElement(i, LDTemp) )
			{
				/* Elements of the set PDef-Out represent
				 * identifiers with definitions in this
				 * block that are not required elsewhere.
				 * Make sure that the thing defined is not
				 * needed in another function, then make a
				 * call to try to get rid of the definition
				 */
				switch(IdOp((Identifier)i))
				{
				case STATNAME:
				case PNAME:
				case LNAME:
				case REG:
					if(!WasAddressed((Identifier)i))
						workdone |= TryUnused((Identifier)i, b);
					break;
				}
			}
			if( workdone )
			{
				change = True;
				DelayBlock(b);
				LDWalk(b);
				UDSecondWalk(b, False);
			}
		    }

		if(change)
		{
			LDDataFlow();
			UDDataFlow();
		}
	} while(change);

	DestroySet(LDTemp);
	DestroySet(DUTemp);
	DestroySet(UDTemp);
}

static Boolean
TryUnused(id, b)
	Identifier id;
	BasicBlock b;
{
	LongSet suses, sdefs;
	DAG_Node d;
	int i;
	AttachedID aid;
	Boolean workdone = False;

	suses = GetUses(id);
	assert(suses != NULL && b->du.PUse != NULL);

	/* Treat STATNAMES specially.  They can only be referenced in this
	 * function, and if they aren't, then there is no need to worry about
	 * what might happen in a recursive call.  Otherwise, the programmer
	 * might be relying on a recursive call to set the variable.
	 */

	if( IdOp(id) == STATNAME && Cardinality(suses) != 0)
	{
		if( DSDebug > 1 )
		{
			printf("Abandon %d as unused var in block %d - STATNAME used elsewhere\n",
				id, b->blocknum);
		}
/**/		return False;
	}

	/* If this id has appeared as a leaf in the block, don't bother trying
	 * to sort out what's happening.  This avoids problems with stickiness,
	 * though it also cuts off our ability to recognize i=i+1 when i is
	 * dead.  We should not lose much by this.
	 */

	Intersection(DUTemp, b->du.PUse, suses);
	if( Cardinality(DUTemp) != 0 )
	{
		if( DSDebug > 1 )
		{
			printf("Abandon %d as unused variable in block %d - appears as leaf\n",
					id, b->blocknum);
		}
/**/		return False;
	}

	if( DSDebug )
	{
		printf("Remove %d as an unused variable in block %d\n", id,
				b->blocknum);
	}

	/* Now look for all definitions in the block clobber them.
	 * note that if some definitions hide others, we will catch them
	 * next time through.  (You have to work very hard to make this
	 * happen!).
	 */

	sdefs = GetDefs(id);
	assert(sdefs != NULL && b->ud.Gen != NULL);
	Intersection(UDTemp, b->ud.Gen, sdefs);

	for( i=FirstElement(UDTemp); i!=NoElement; i=NextElement(i,UDTemp))
	{
		/* First, make sure that the att. id is on this node.
		 * Then, try to delete it.  If it went away, fine.
		 * If not, remember this.
		 *
		 * Life here would be made much easier if we could access
		 * the routine used in dag.c to do this.
		 */

		d = UDDagPtrs[i];
		for( aid = d->attached; aid != NULL; aid = aid->next )
			if( aid->id == id )
		/**/		break;

		assert(aid != NULL);
		DeleteID(id, d, d->in_degree == 0);

		for( aid = d->attached; aid != NULL; aid = aid->next )
			if( aid->id == id )
		/**/		break;

		if( aid == NULL )
		{
			if( DSDebug > 1 )
				printf("Remove %d from node %x\n", id, d);
			workdone = True;
			DelMember(i, sdefs);
			DelMember(i, b->ud.Gen);
			if( d->in_degree == 0 && d->delay_count == 0 )
				PruneTree(d, NotConditional, True);
		}
		else
		{
			if( DSDebug > 1 )
				printf("Could not remove %d from node %x\n",
						id, d);
		}
	}

	return workdone;
}

void
ReclaimUnusedVars(params)
	InstrList *params;
{
	LongSet sdefs;
	Identifier id;
	TreeNode t;

	for( id = FirstId; id <= MaxIdentifier; id++ )
	{
		t = IdTree(id);
		if( t == NULL || t->in.op != REG || !IsRegVar(t->tn.rval) )
	/**/		continue;

		sdefs = GetDefs(id);
		assert(sdefs != NULL);
		if( Cardinality(sdefs) == 1 )
			TryReclaim(id, t, params);
	}
}

/* The register "id" has only a single def - the initial dummy one.
 * Try to reclaim it
 */

static void
TryReclaim(id, t, params)
	Identifier id;		/* The register we are trying to reclaim */
	TreeNode t;		/* IdTree(id) */
	InstrList *params;	/* Parameter list */
{
	Identifier idlook;
	TreeNode tlook;
	int i;
	LongSet suses;

	suses = GetUses(id);
	assert(suses != NULL);

	/*
	 * First, look for uses that still exist in code.  (This is probably
	 * a programmer error, but give the programmer the benefit of the
	 * doubt.)
	 */

	for(i = FirstElement(suses); i != NoElement; i = NextElement(i,suses))
	{
		if( DUDagPtrs[i]->op != LEAFNOP )
		{
			if( DSDebug )
				printf("Register for id %d not reclaimed - use at %x\n", id, DUDagPtrs[i]);
/**/			return;
		}
	}

	/* We've got a winner - a REG that has exactly one def and no surviving
	 * uses.  Try to reclaim it.
	 */

	for( idlook = FirstId; idlook <=MaxIdentifier; idlook++ )
	{
		if( idlook == id )
	/**/		continue;

		tlook = IdTree(idlook);
		if( tlook == NULL || tlook->in.op != REG )
	/**/		continue;

		if( t->tn.rval == tlook->tn.rval )
		{
			/* different vars, same reg.  Trouble. */
			if( DSDebug )
				printf("Reg id %d not reclaimed - conflict with %d\n",id, idlook);
/**/			return;
		}
	}

	PccFreeUserReg(t);
	DemoteReg(params, t);
}
