/* delay.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	Check Delayed Stores
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: delay.c,v 5.5 89/05/12 12:50:22 pcc Rel-3_0 $";
/* static char ID[] = "@(#)delay.c	15.4	of 86/10/23"; */
#endif

/*	Import
 */

# include <assert.h>
# include <activity.h>
# include <bool.h>
# include <identifier.h>
# include <dag.h>
# include <blocks.h>
# include <delay.h>

int DelayDebug = 0;

/*
 *	Forward
 */

static Boolean CheckNode();
static void DoDelay();
static void CheckSpecial();

/*	Export
 */

/*
 *	Private
 */


/*
 *	This:
 *
 *	  1) eliminates "backward" delayed stores.
 *	  2) for other delayed stores, puts a pointer in the appropriate
 *	     node, and removes the delayed store from the attached id list.
 *	  3) For leaves, removes the identifier itself (the "redundant"
 *	     store).
 */

void
CheckDelay()
{
	BasicBlock b;

	for (b=FirstBlock; b != NULL; b = b->next) {
		if( b->reachable )
			DelayBlock(b);
	}
}

void
DelayBlock(b)
	BasicBlock b;
{
	(void) ActivityDag(b->Dag, CheckNode);
	if (DelayDebug) {
		printf("\nAfter delays processed in block # %d\n\n",
			b->blocknum);
		PrintGraph(b->Dag);
	}
}

static Boolean
CheckNode(n)
	DAG_Node n;
{
	AttachedID aid, aid_next;

	/* Note: This routine runs the DecrementActivity algorithm in
	 * order to figure out when backward stores need to be delayed.
	 * Since part of its job is to compute the number of forward
	 * delayed stores, it is possible for the activity count of
	 * a node to go to zero, and then be increased when delayed
	 * stores are discovered.  For this reason, care must be taken
	 * when taking action when the activity count goes to zero.
	 *
	 * The action taken here is safe.  It checks to see if a delayed
	 * store can wait until after the tree that contains it, or if
	 * a carrier (or temp) must be used and the actual assignment
	 * done before the tree is put out.  The decision depends only
	 * on whether there is a delayed store waiting on this node,
	 * and on what the root node of the tree is.
	 *
	 * That decision is not affected by whether or not there are
	 * delayed stores that need the value of this node, and
	 * that is the only source of error in the activity count.
	 *
	 */

	UpdateActivity(n, CheckSpecial);

	aid = n->attached;
	while (aid != NULL) {
		aid_next = aid->next;
		DoDelay(aid, n);
		aid = aid_next;
	}
	return False;
}

static void
DoDelay(aid, n)
	AttachedID aid;
	DAG_Node n;
{
	DAG_Node leaf;			/* the leaf we'll need again */
	AttachedID temp_id;		/* temp to carry it */

	leaf = aid->leaf_ref;
	if (leaf != NULL && leaf->activity > 0 && leaf->order < n->order) {

		/*
		 *  Backwards delayed store
		 *  We'll need the value of "leaf" after it is stored into
		 *  at n.  If "leaf" is anonymous, build a temporary for
		 *  it.
		 */

		if (leaf->attached == NULL) {
			/* Create a temporary */
			temp_id = MakeTemp(leaf, 'd', leaf->type);
			if (DelayDebug) {
				printf("Temp %d for backwards delay created at %d\n",
					temp_id, leaf->order);
			}
		}
	} else
	if (leaf != NULL && leaf->order > n->order) {

		/*
		 * Forward delayed store
		 */

		if (DelayDebug)
			printf("Store into %d delayed until %d\n",
				leaf->leaf_id, leaf->order);
		leaf->delayed = n;
		assert(n->in_cond == NotConditional);	/* no delays */
		assert(leaf->in_cond == NotConditional);
		leaf->special_delay |= aid->sticky;	/* one way */
		++(n->delay_count);
		leaf->UDIndex = aid->UDIndex;		/* save UD info */
		DeleteID(leaf->leaf_id, n, True);
	}
}

static void
CheckSpecial(n)				/* Check if a delay must be special */
	DAG_Node n;
{

	/*
	 *	If the node that causes this node to become inactive
	 *	is CBRANCH or FORCE, then the delay cannot wait until
	 *	after the root, we'll have to force a temp.
	 */

	if (n->delayed != NULL) {
		n->special_delay |= (ActRoot->op == CBRANCH ||
				ActRoot->op == FORCE);
		if (DelayDebug) {
			if (n->special_delay) {
				printf("Node %d special @ node %d\n",
					n->order, ActRoot->order);
			}
		}
	}
}
