/* erroro.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	This module is responsible for reporting error messages to
 *	the user.  Most involve errors in the optimizer itself,
 *	or the intermediate file, but there are few user-level
 *	warnings.
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: erroro.c,v 5.5 89/05/12 12:50:30 pcc Rel-3_0 $";
/* static char ERR_SCCSID[] = "@(#)	erroro.c	15.1	of 86/09/29"; */
#endif

/*
 *	Imported
 */

/*
 *	There does not seem to be an include file for exit!
 */

extern void exit();

# include <stdio.h>
# include <erroro.h>
# include <opt.h>
# include <option.h>

static void
ErrorMessage(s, a, b, c)
	char *s;
	int a, b, c;
{
	fprintf(stderr, s, a, b, c);
	fprintf(stderr, "\n");
}

/* VARARGS1 */

void
ResourceExhausted(s, a, b, c)
	char *s;		/* message format */
	int a, b, c;		/* possibly not passed */
{
	fprintf(stderr, "Resource exhaustion optimizing %s(): ", ftnname);
	ErrorMessage(s, a, b, c);
	exit(4);
}

/* VARARGS1 */

void
InternalFault(s, a, b, c)
	char *s;		/* message format */
	int a, b, c;		/* possibly not passed */
{
	fprintf(stderr, "Internal fatal error optimizing %s(): ", ftnname);
	ErrorMessage(s, a, b, c);
	(void) abort();
	exit(3);			/* abort returned !! */
}

/* VARARGS1 */

void
ExternalFault(s, a, b, c)
	char *s;		/* message format */
	int a, b, c;		/* possibly not passed */
{
	fprintf(stderr, "External Fault optimizing %s(): ", ftnname);
	ErrorMessage(s, a, b, c);
	exit(2);
}

/* VARARGS1 */

void
UserError(s, a, b, c)
	char *s;		/* message format */
	int a, b, c;		/* possibly not passed */
{
	ErrorMessage(s, a, b, c);
	exit(1);
}

/* VARARGS1 */

void
Warning(s, a, b, c)
	char *s;
	int a, b, c;
{
	if (WarningOption) {
		fprintf(stderr, "Warning: ");
		ErrorMessage(s, a, b, c);
	}
}

void
WarnNoOpt(t, s)			/* Warn about no transformations */
	char * t;		/* text of message (printf format) */
	char * s;		/* optional string parameter */
{
	if (WarningOption) {
		fprintf(stderr,"Warning: function %s() ", ftnname);
		fprintf(stderr, t, s);
		fprintf(stderr, "; no intermediate optimization done.\n");
	}
}
