/* refcount.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: refcount.c,v 5.5 89/05/12 12:52:40 pcc Rel-3_0 $";
/* static char ID[] = "@(#)refcount.c	15.2	of 86/09/29"; */
#endif

/*
 * Reference Count Module
 *
 * This scans the DAG setting the refs field in each node to reflect the
 * number of edges that actually represent computation references, that is,
 * references that will be made when evaluating the tree.  For example, the
 * edges from the PLUS in ADDR PLUS ICON are not computation references,
 * since evaluating that tree does not require a run-time reference to the
 * ADDR or ICON.
 *
 * In addition, we sometimes pretend that an edge is not a computational
 * reference in situations where there is no advantage to putting something
 * in a register.  A common example is a left or right shift by a constant.
 * On most machines, the code is less efficient if the constant is put in a
 * register.
 */

#include <assert.h>
#include <blocks.h>
#include <cmanifest.h>
#include <dag.h>
#include <flow.h>
#include <refcount.h>
#include <target.h>
#include <erroro.h>

/* This macro defines DAG nodes that represent type paintdowns done by pass 1.
 * Because these nodes are only place-holders, their references are accrued
 * to their child.
 *
 * NB#1: this ignores the possibility RefType() might say that these nodes do
 * not reference their children.  If this ever happens on any machine (it
 * shouldn't), a call to RefType would have to be added here.
 *
 * NB#2: Routines like those for loop invariant code motion and global
 * common subexpressions that update reference counts and attach identifiers
 * willy-nilly may cause this macro to give inconsistent results in
 * pathological cases.
 */

#define TransparentConversion(d) (((d)->op==OCONVLEAF || (d)->op==OCONVTREE) \
				&& (d)->attached==NULL && (d)->delay_count==0)

void
InitRefs()
{
	BasicBlock b;

	for( b = FirstBlock; b != NULL; b = b->next )
		BlockRefs(b);
}

void
BlockRefs(b)
	BasicBlock b;
{
	DAG_Node d;

	for( d = b->Dag; d != NULL; d = d->next)
	{
		d->refs = 0;
		d->visited = False;
		if( d->in_degree == 0 )
			IncDescendants(d);
	}
}

void
IncDescendants(d)
	DAG_Node d;
{
	if( !d->prev_valid_carrier )
	{
		if( TransparentConversion(d) )
		{
			d->u.in.left->refs += d->refs;
			d->refs = 0;
			IncDescendants(d->u.in.left);
		}
		else
		if( !d->visited && !RefSpecial(d) )
		{
			switch( optype(d->op) )
			{
			default:
				InternalFault("refcount.c: Bad optype for op %d",
					d->op);
				break;

			case LTYPE:
				break;

			case UTYPE:
				d->u.in.left->refs++;
				IncDescendants(d->u.in.left);
				break;

			case BITYPE:
				d->u.in.right->refs++;
				IncDescendants(d->u.in.right);
				d->u.in.left->refs++;
				IncDescendants(d->u.in.left);
				break;
			}
		}
	}
	d->visited = True;
}

/*
 *	Adjust the reference count on "d".
 *	For now, we must re-do the entire basic block
 */

void
AdjustRefs(d)
	DAG_Node d;
{
	assert(d->FGindex != NullFlow);

	BlockRefs(FlowGraph[d->FGindex].block);
}
