/* storage.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	Storage Statistics
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: storage.c,v 5.5 89/05/12 12:52:46 pcc Rel-3_0 $";
/* static char STORES_SCCSID[] = "@(#)	storage.c	15.1	of 86/11/13"; */
#endif

#ifdef STORESTATS

/*
 *	This entire module disappears if we aren't collecting these stats
 */

# include <stdio.h>
# include <storage.h>

/*
 *	Legible string for each billing type 
 */

static char * names[] =
       {
	"",	/* No stats */
	"Alloc Vects",
	"Blocks     ",
	"DAG Nodes  ",
	"Sets       ",
	"Set Vects  ",
	"Sym. Table ",
	"DU ptrs    ",
	"UD ptrs    ",
	"Flowgraph  ",
	"DFN table  ",
	"Preds.     ",
	"Flowexits  ",
	"Instructs  ",
	"Inst. text ",
	"Labels     ",
	"LoopTable  ",
	"BlockTable ",
	"Invariants ",
	"LoopTemps  ",
	"Tree Nodes ",
	"Att. ids   ",
	"Id. Text   ",
	"Avail. Expr",
	"GlCommSubEx",
	"Temp Defs. "
       };

StoreData StoreStat[s_NumCats];		/* array of statistics */

void
PrintMemStats()
{
	int c;
	int total;

	fprintf(stderr, "\nStorage Statistics\n");
	total = 0;
	for (c = s_NoStats+1; c < s_NumCats; ++c) {
		fprintf(stderr, "%s space: %7d hwm: %7d\n", names[c],
			StoreStat[c].space, StoreStat[c].hwm);
		total += StoreStat[c].space;
	}
	fprintf(stderr, "\nTotal Billed Storage: %d\n", total);
}

void
InitStoreStats()
{
	int c;

	for (c = s_NoStats; c < s_NumCats; ++c) {
		StoreStat[c].space = 0;
		StoreStat[c].hwm = 0;
	}
}
#endif
