/* storage.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	Interface to UNIX storage management
 */

#ifndef STORE
#define STORE

#ifndef lint
/*	@(#) (Gould) $Header: storage.h,v 5.5 89/05/12 12:52:50 pcc Rel-3_0 $		  */
/* static char STORE_SCCSID[] = "@(#)	storage.h	15.1	of 86/11/13"; */
#endif

#ifdef FASTMALLOC

# include <malloc.h>

#else
extern	char *	malloc();	/* Get space */
extern  char *	realloc();	/* change size of space */
extern  char *	calloc();	/* Allocate an array */
extern  void	free();		/* Return space to system */
#endif

/*
 *	Performance Parameters
 *
 *	These defines control the granularity of allocation for various
 *	data structures.  Each defines the number of objects of the
 *	associated type that are allocated if the free list is empty.
 *	Larger sizes should generally increase speed, and also decrease
 *	space associated with malloc(3) link info.  On the other hand,
 *	larger sizes will increase storage requirements for small functions.
 */

#define AidChunk	100		/* Attached Identifiers */
#define TempDefChunk	100		/* Temp definition pointers */
#define	BlockChunk	20		/* Basic Blocks */
#define DagChunk	50		/* DAG Nodes */
#define InstrChunk	50		/* Instructions */
#define LTEChunk	20		/* Loop Temporaries */
#define PredChunk	50		/* Predecessor nodes */
#define SetChunk	100		/* Sets */
#define TreeChunk	100		/* Tree Nodes */

/*
 *	This describes the smallest amount of storage to allocate for
 *	storing identifier text strings.  Only one identifier is
 *	stored in each chunk, but it may be undesirable to allocate and
 *	deallocate 2 and 3 character storage areas.
 */

#define MinIdSpace	10

/*
 *	The following presents the optimizer's interface to
 *	UNIX storage management.  If STORESTATS is defined,
 *	then statistics on storage use will be collected.
 */

/*
 *	Each category of storage that can be allocated has a name
 *	that is used for "billing".
 */

#define s_NoStats	0		/* Don't keep statistics for this */
#define s_AllocVects	1		/* Allocation Vectors */
#define s_Blocks	2		/* Basic blocks */
#define s_DagNodes	3		/* Dag Nodes */
#define s_Sets		4		/* Long Sets */
#define s_SetV		5		/* Long Set bit vectors */
#define s_Symbol	6		/* Symbol table */
#define s_DUptrs	7		/* DUDagPtrs */
#define s_UDptrs	8		/* UDDagPtrs */
#define s_FlowGraph	9		/* FlowGraph */
#define	s_DFN		10		/* DFN */
#define s_Pred		11		/* Flow graph Preds */
#define s_FlowExits	12		/* Flow exits */
#define s_Instruct	13		/* Instructions */
#define s_Text		14		/* Instruction text */
#define s_Labels	15		/* Label table */
#define s_LoopTable	16		/* LoopTable */
#define s_BlckTable	17		/* Block Table */
#define s_Invariants	18		/* save invariants */
#define s_Templist	19		/* Loop temporararies */
#define s_Trees		20		/* Tree Nodes */
#define s_Aids		21		/* Attached ids */
#define s_IdText	22		/* Identifier Text */
#define s_AvailExpr	23		/* Available Expressions */
#define s_GlComm	24		/* Global Common Subexpressions */
#define s_TempDefs	25		/* Temporary definition records */
#define s_NumCats	26		/* Number of categories */

#ifdef STORESTATS

typedef struct store_data {
	int space;	/* 	current space allocated */
	int hwm;	/*	high water mark of something */
} StoreData;

/*
 *	Where the stats are stored 
 */

extern StoreData 	StoreStat[];		/* array */
extern void		InitStoreStats();	/* Set 'em up */
extern void 		PrintMemStats();	/* Print 'em out */

/*
 *	Get storage for one object of type
 */

#define GetStorage(c, type) \
	( \
		StoreStat[c].space += (sizeof (type)), \
		(type *) malloc((sizeof (type))) \
	)


/*
 *	Make an array of n elements of type 
 */

#define GetArray(c, n, type) \
	( \
		StoreStat[c].space += ((n) * sizeof (type)), \
		(type *) calloc((unsigned) (n), sizeof (type)) \
	)

/*
 *	Expand an array a from "old" elements to "new" elements of type
 */

#define Reallocate(c, a, old, s, type) \
	( \
		StoreStat[(c)].space += (((s)-(old)) * (sizeof (type))), \
		(type *) realloc(a, ((s) * (sizeof (type)))) \
	)


/*
 *	Some storage managers still call malloc and free.  They use
 *	these routines to maintain statistics
 */

#define IncreaseSpace(c, s)	StoreStat[c].space += (s)

/*
 *	Decrease allocated space and update high water mark
 */

#define DecreaseSpace(c, s) \
	{ \
		if (StoreStat[c].hwm < StoreStat[c].space) \
			StoreStat[c].hwm = StoreStat[c].space; \
		StoreStat[c].space -= (s); \
	}

#else /* STORESTATS */

/*
 *	If no stats are collected, these definitions are used
 */

#define GetStorage(c, type)	((type *) malloc((sizeof (type))))

#define GetArray(c, n, type) \
	((type *) calloc((unsigned) (n), (sizeof (type))))

#define Reallocate(c, a, old, s, type) \
	(type *) realloc(a, ((s) * (sizeof (type))))

#define IncreaseSpace(c, s)

#define DecreaseSpace(c, s)

#endif /* STORESTATS */

#endif
