/* tree.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	Interface to trees module
 */


#ifndef TREES

#define TREES

#ifndef lint
/*	@(#) (Gould) $Header: tree.h,v 5.5 89/05/12 12:53:20 pcc Rel-3_0 $		  */
/* static char TREES_SCCSID[] = "@(#)	tree.h	15.1	of 86/11/27"; */
#endif

/*
 *	This structure is for the type NODE, the typedef appears in
 *	manifest.  (It's NOT my fault!)
 */

#include <cmanifest.h>
#include <bool.h>
#include <ops.h>

union ndu {

	struct {
		Operator op;
		TWORD type;
		char *identifier;	/* storage owned by symbol table */
		int junk;		/* DANGER! for stn variant */
		NODE *left;
		NODE *right;
		}in; /* interior node */
	
	struct {
		Operator op;
		TWORD type;
		char *identifier;
		int junk;		/* DANGER! for stn variant */
		CONSZ lval;
		int rval;
		}tn; /* terminal node */

	struct {
		Operator op;
		TWORD type;
		char *identifier;
		int junk;		/* DANGER! */
		double dval;
		}fpn;	/* floating point node */
	
	struct {
		Operator op;
		TWORD type;
		int label;  /* for use with branching */
		}bn; /* branch node */

	struct {
		Operator op;
		TWORD type;

		/* DANGER! Machine Dependent Storage layout.
		 * Warning ... These node may also accesss left and right,
		 * via the "in" variant.
		 * stsize and stalign overlay the identifier and
		 * junk fields. 
		 */

		int stsize;  /* sizes of structure objects */
		int stalign;  /* alignment of structure objects */
		}stn; /* structure node */

	};

typedef NODE *TreeNode;
typedef struct NLIST {
	NODE n;
	struct NLIST *next;
} TNode, *NodeList;

/*
 *	Exported Operations
 */

extern TreeNode TreeAllocate();			/* Allocate a tree Node */
extern void	TreeFree();			/* Free a tree Node */
extern void	TreeInit();			/* Free all trees */
extern TreeNode CopyTree();			/* Copy a tree */
extern int	eprint();			/* Print a tree */
extern Boolean  CanBeLNAME();			/* can t be an LNAME */
extern void	DoOffset();		/* NAME+offset to *,+,ADDR,ICON */

/*
 *	Tree re-arrangement
 */

extern TreeNode	PreTree();			/* input pre-processing */
extern void	RewriteNAME();			/* convert NAME to * ADDR */
extern TreeNode	FixType(/* TreeNode t */);
	/* Undo painted type conversions on certain types of leaves. */
extern TreeNode	FinalOpt();			/* output post-processing */
#endif
