
     NAME
          fread, fwrite - binary input/output

     SYNTAX
          #include <stdio.h>

          int fread (ptr, size, nitems, stream)
          char *ptr;
          int size, nitems;
          FILE *stream;

          int fwrite (ptr, size, nitems, stream)
          char *ptr;
          int size, nitems;
          FILE *stream;

     DESCRIPTION
          Fread copies, into an array pointed to by ptr, nitems items
          of data from the named input stream, where an item of data
          is a sequence of bytes (not necessarily terminated by a null
          byte) of length size.  Fread stops appending bytes if an
          end-of-file or error condition is encountered while reading
          stream, or if nitems items have been read.  Fread leaves the
          file pointer in stream, if defined, pointing to the byte
          following the last byte read if there is one.  Fread does
          not change the contents of stream.

          Fwrite appends at most nitems items of data from the array
          pointed to by ptr to the named output stream.  Fwrite stops
          appending when it has appended nitems items of data or if an
          error condition is encountered on stream.  Fwrite does not
          change the contents of the array pointed to by ptr.

          The argument size is typically sizeof(*ptr) where the
          pseudo-function sizeof specifies the length of an item
          pointed to by ptr.  If ptr points to a data type other than
          char it should be cast into a pointer to char.

     SEE ALSO
          read.m, write.m, fopen.m, getc.m, gets.m,
          printf.m, putc.m, puts.m, scanf.m

     DIAGNOSTICS
          Fread and fwrite return the number of items read or written.
          If size or nitems is non-positive, no characters are read or
          written and 0 is returned by both fread and fwrite.

          (printed 07/30/92 - J B Systems)

