
     NAME
          math - math functions and constants

     SYNTAX
          #include <math.h>

     DESCRIPTION
          This file contains declarations of all the functions in the
          Math Library, as well as various functions in the C Library
          that return floating-point values.

          It defines the structure and constants used by the
          matherr() error-handling mechanisms, including the
          following constant used as an error-return value:

          HUGE                The maximum value of a single-precision
                              floating-point number.

          The following mathematical constants are defined for user
          convenience:

          M_E                 The base of natural logarithms (e).

          M_LOG2E             The base-2 logarithm of e.

          M_LOG10E            The base-10 logarithm of e.

          M_LN2               The natural logarithm of 2.

          M_LN10              The natural logarithm of 10.

          M_PI                The ratio of the circumference of a
                              circle to its diameter.  (There are also
                              several fractions of its reciprocal and
                              its square root.)

          M_SQRT2             The positive square root of 2.

          M_SQRT1_2           The positive square root of 1/2.

          For the definitions of various machine-dependent
          ``constants,'' see the description of the <values.h> header
          file.

     FILES
          <math.h>

     SEE ALSO
          matherr.m, values.m

          (printed 07/30/92 - J B Systems)

