/*
	@(#)machdep.c	1.8	(8/7/84 12:45:19)
*/
#ifdef PM68K
#define NONBOARD	128	/* number of on board pages of memory */
#define NOFFBOARD	256	/* number of off board pages of memory */
#endif
#ifdef CD68K
#define NONBOARD	256	/* number of on board pages of memory */
#define NOFFBOARD	0	/* number of off board pages of memory */
#endif


/*
 * machdep - set up machine dependent stand alone code
 */
#ifdef VERS7
#include <sys/unistar.h>
#endif
#ifdef SYSV
#include <sys/config.h>
#include <sys/mmu.h>
#endif
#include <setjmp.h>

int *	nofault = 0;		/* No-memory-fault safety location */

catchbus ()			/* Catch bus errors */
{
	if (nofault)
		longjmp (nofault, 1);
	else
		nofault = *((int **) 1);	/* Force odd address trap */
}

/*
 * machdep()
 *	set up memory map
 */

machdep()
{
	register short *addr;
	register long *laddr;
	register short i;

				/* Initialize segment map */
	addr = (short *)SEGBASE;
	for (i = 0; i < NSEGMAP-1; i++) {
		*addr = (rwxrwx + i) | ASOBRAM;
		addr = (short *)((long) addr + SEGINCR);
	}
	*addr = (rwxrwx + i) | ASMBIO;/* last seg for multibus io	*/

				/* Initialize page map for on-board RAM */
	addr = (short *)PAGEBASE;
	for (i = 0; i < NONBOARD; i++) {
		*addr = i | PAGEVALID;
		addr = (short *)((long) addr + PAGEINCR);
	}
				/* Initialize page map for MULTIBUS I/O */
	addr = (short *)(PAGEBASE + ((NPREGS - NMBUSIOP) * PAGEINCR));
	for (i = 0; i < NMBUSIOP; i++) {
		*addr = i | PAGEVALID;
		addr = (short *)((long) addr + PAGEINCR);
	}
	/* Clear 64K of multibus memory */
	/*****************************************************************
	for (laddr = (long *)0x40000; laddr < (long *)(0x40000+0x10000); )
		*laddr++ = 1;
	*****************************************************************/
	/* Set up to catch bus traps */
	*((long *) 0x08) = (long) catchbus;
}

/*
	 * copy(from, to, nbytes)
	 *	copy from one buffer to another
	 * note that the routine assumes that from/to/nbytes are multiples of 4
	bcopy(from, to, nbytes)
	register long *from, *to;
	register long nbytes;
	{
		nbytes >>= 2;
		do {
			*to++ = *from++;
		} while (--nbytes);
	}
*/

/*
 * iocheck - check for an I/O device at given address
 *
 *	If value is positive or zero, it is written to the given (byte)
 *	address.  If value is negative, the (byte) address is read and
 *	the contents are discarded.  The return value is positive if the
 *	address exists, -1 if not.  If the address was read, the return
 *	value is the value read.
 */
iocheck(addr, value)
unsigned char * addr;
int value;
{
	register int *saved_jb;
	register int i;
	jmp_buf jb;

	saved_jb = nofault;
	if (!setjmp(jb)) {
		nofault = jb;
		if (value < 0)
			i = *addr;
		else {
			i = 0;
			*addr = value;
		}
	} else
		i = -1;
	nofault = saved_jb;
	return(i);
}
