/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
 * @(#)config.h 9.11 88/02/10	
 */

#ifndef timerisset
struct timeval {
    long	tv_sec;		/* seconds */
    long	tv_usec;	/* and microseconds */
};

#define	timerisset(tvp)		((tvp)->tv_sec || (tvp)->tv_usec)
#define	timercmp(tvp, uvp, cmp)	\
	((tvp)->tv_sec cmp (uvp)->tv_sec || \
	 (tvp)->tv_sec == (uvp)->tv_sec && (tvp)->tv_usec cmp (uvp)->tv_usec)
#define	timerclear(tvp)		(tvp)->tv_sec = (tvp)->tv_usec = 0
#endif
#ifdef SYSVREF
#include <memory.h>

#define u_char 	unchar
#define u_short ushort
#define u_int	uint
#define u_long	ulong

#define MAX_FDS		256
#ifndef EWOULDBLOCK
#define EWOULDBLOCK 	999
#endif
#ifndef bcopy
#define bcopy(s1, s2, len) { \
    register char *s__s = (char *)(s1); \
    register char *s__d = (char *)(s2); \
    register int n__n; \
    if ((n__n = len) > 0 && s__s != s__d) { \
        if (s__d < s__s || (s__s + n__n) <= s__d) { \
	    memcpy(s__d, s__s, n__n); \
        } else { \
            register char *s__se = s__s + n__n - 1; \
	    register char *s__de = s__d + n__n - 1; \
            do \
                *s__de-- = *s__se--; \
            while (--n__n); \
    }}};
#endif
#ifndef bzero
#define bzero(s, n)		memset(s, '\0', n)
#endif
#define bcmp(s1, s2, n)		memcmp(s1, s2, n)
#define getdtablesize() 	20
#define getwd(s)		(char *)getcwd(s, 200)
#define random()		(long)rand()
#define srandom(seed)		(long)srand(seed)
#define rindex(s, c)		(char *)strrchr(s, c)
#define osi_init()      	initialize_sysVOSI()
#else
#define osi_init()		initialize_bsdOSI()
#endif

