%
% This file is a product of Sun Microsystems, Inc. and is provided for
% unrestricted use provided that this legend is included on all tape
% media and as a part of the software program in whole or part.  Users
% may copy or modify this file without charge, but are not authorized to
% license or distribute it to anyone else except as part of a product
% or program developed by the user.
%
% THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
% WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
% PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
%
% This file is provided with no support and without any obligation on the
% part of Sun Microsystems, Inc. to assist in its use, correction,
% modification or enhancement.
%
% SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
% INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
% OR ANY PART THEREOF.
%
% In no event will Sun Microsystems, Inc. be liable for any lost revenue
% or profits or other special, indirect and consequential damages, even
% if Sun has been advised of the possibility of such damages.
%
% Sun Microsystems, Inc.
% 2550 Garcia Avenue
% Mountain View, California  94043
%

%
% "@(#)go6.cps 9.3 88/01/18
%
% Copyright (c) 1988 by Sun Microsystems, Inc.
%

% Constants needed in both C & PostScript:
C: #define BOARD_SIZE	19
C: #define ERASE_CMD	0
C: #define FILL_CMD	1

% tag values (see function call defs...)
#define DONE_TAG	1
#define DAMAGE_TAG	2
#define BLACK_TAG	3
#define WHITE_TAG	4
#define MENU_TAG	5

cdef initialize()
/BOARD_SIZE  19 def			% number of lines drawn
/BOARD_MAX   18 def			% BOARD_SIZE - 1
/STONE_SIZE  .80 def			% stone diameter 
/BLACK_EVENT /LeftMouseButton  def		% place black stone
/WHITE_EVENT /MiddleMouseButton  def		% place white stone
/ERASE_CMD   0 def		% erase board
/FILL_CMD    1 def		% fill with stones

% define colors
/black_color     0 0 0 rgbcolor def	% black
/white_color     1 1 1 rgbcolor def	% white
/board_color    .9 .69 .28 rgbcolor def	% Wood color
/line_color        black_color def		% line color
/outline_color   black_color def   

/repair { % - => - (repair the board)
    DAMAGE_TAG tagprint 		% send tag to client
    uniquecid dup typedprint		% send id to client
    [exch cidinterest] forkeventmgr	% launch waiting process
    waitprocess pop		% clear stack
} def

/draw_board { % - => - (draw the playing surface)
    board_color setcolor clippath fill
    line_color setcolor
    0 1 BOARD_MAX {		% draw the lines
        dup 0 moveto 0 BOARD_MAX rlineto
        0 exch moveto BOARD_MAX 0 rlineto
    } for
    stroke		% stroke board path
    pause
} def

/stone { % outline_color stone_color x y => - (draw stone)
    STONE_SIZE 2 div 0 360 arc		% set stones path
    gsave 		% save context
       setcolor fill		% fill with stone_color
    grestore		% restore context
    setcolor stroke		% stroke restored stone path
    pause		% allow other processes
		%  to execute
} def

/cross { % x y => - (draw cross)
10 dict begin		% begin local dictionary
    /y exch def		% save as local var
    /x exch def		% save as local var

    % clear the stone
    x .5 sub y .5 sub 1 1 rectpath
    board_color setcolor fill

    % draw the two cross strokes, carfully adjusting for edge locations:
    x .5 sub 0 max y moveto x .5 add BOARD_MAX min y lineto     % horiz stroke
    x y .5 sub 0 max moveto x y .5 add BOARD_MAX min lineto     % vert stroke
    line_color setcolor 
    stroke		% stroke cross
    pause		% allow other processes 
		%  to execute
end		% end local dictionary
} def

/checkloc { % float => int (convert location to legal board location)
    0 max BOARD_MAX min round
} def

/placestone { % event tag => - (place stone at event's x,y)
    ClientCanvas setcanvas		% set current canvas
    tagprint uniquecid dup typedprint	% send tag & id to client
    exch		% uniquecid event
    begin		% begin local dictionary
       XLocation checkloc YLocation checkloc	% round location
    end		% end local dictionary
    typedprint typedprint		% send x,y to client
    [exch cidinterest1only] forkeventmgr	% create eventmgr
    waitprocess pop		% wait for events
} def

/downeventinterest {/DownTransition ClientCanvas eventmgrinterest} def

/startinput { % - => - (Wait for input)
    /ButtonMgr [
        BLACK_EVENT {BLACK_TAG placestone} downeventinterest
        WHITE_EVENT {WHITE_TAG placestone} downeventinterest
    ] forkeventmgr store
} def

/makewin { %  - => - (builds a go window)
      /GoWindow DefaultWindow		% create a subclass
      dictbegin		% begin instance variables
           /FrameLabel ( 3rd Go board ) def	% label window
           /ButtonMgr null def		% create instance
      dictend		% end instance variables
      classbegin		% begin class definitions
           /PaintClient { repair } def		% define client canvas image
           /PaintIcon { repair } def		% define icon image
           /DestroyClient {		% override method
                 ButtonMgr killprocess		% kill ButtonMgr
                 DONE_TAG tagprint		% inform client
           } def
           /flipiconic { % - => - (Redraw current state for icon)
                 /flipiconic super send		% alter superclass
                 Iconic? IconCanvas /Retained get and {/paint self send} if
           } def
           /ForkFrameEventMgr {		% alter class method
                 /ForkFrameEventMgr super send
                 startinput		% start ButtonMgr
           } def 
           /ClientPath { % x y w h => - (define client path)
                 4 2 roll translate
                 BOARD_SIZE div exch BOARD_SIZE div exch scale
                 .5 .5 translate
                 -.5 -.5 BOARD_SIZE BOARD_SIZE rectpath
           } def
           /IconPath {ClientPath} def
           /ClientMenu  [		% define dedicated menu
                 (Erase Board)   {MENU_TAG tagprint ERASE_CMD typedprint}
                 (Fill Board)    {MENU_TAG tagprint FILL_CMD typedprint}
           ] /new DefaultMenu send def	% install menu
       classend def		% end class definitions

       /win framebuffer /new GoWindow send def	% cliche
       /reshapefromuser win send		% resize window
       /map win send		% draw it
} def
% end initialize()

%  function call definitions
cdef done() => DONE_TAG()			       % inform client 
cdef get_damage(int id) => DAMAGE_TAG(id)		       % inform client 
cdef get_black(int id, int x, int y) => BLACK_TAG(id, y, x)	   % inform client
cdef get_white(int id, int x, int y) => WHITE_TAG(id, y, x)	   % inform client
cdef get_menu(int cmd) => MENU_TAG(cmd)		       % inform client
cdef draw_board(int id)			       % draw the go board
     id {draw_board} sendcidevent
cdef black_stone(int id, int x, int y)		       % draw  black stone
     id {outline_color black_color x y stone} sendcidevent
cdef white_stone(int id, int x, int y)		       % draw  white stone
     id {outline_color white_color x y stone} sendcidevent
cdef cross(int id, int x, int y)			       % draw  cross
     id {x y cross} sendcidevent
cdef repaired(int id)			       % close channel
     id {exit} sendcidevent
cdef repaint()			       % repaint go board
     /paintclient win send
cdef execute () makewin			       % execute program
