/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef lint
static	char sccsid[] = "@(#)ico.c 9.4 88/01/18 Copyright 1985 Sun Micro";
#endif

/*
 * Copyright (c) 1985 by Sun Microsystems, Inc.
 */


/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/******************************************************************************
 * Description
 *	Display a wire-frame rotating icosahedron, with hidden lines removed
 *
 * Arguments:
 *	-r		display on root window instead of creating a new one
 *	=wxh+x+y	X geometry for new window (default 600x600 centered)
 *	host:display	X display on which to run
 *****************************************************************************/



#ifdef undef
#include "Xlib.h"
#include "Xatom.h"
#define DisplayWidth(scr) ((_XlibCurrentDisplay->screens[scr]).width)
#define DisplayHeight(scr) ((_XlibCurrentDisplay->screens[scr]).height)
#include <stdio.h>
#else
#ifdef SYSVREF
#include <stropts.h>
#include <poll.h>
#endif
#ifdef REF
#include <sys/types.h>
#include <ref/config.h>
#endif
/* NeWS conversion code */
#include "ico.h"
#include "math.h"
#include "psio.h"

#ifdef SYSVREF
#define index(s, c)             (char *)strchr(s, c)
#endif

typedef struct {
    short       x1,
                y1,
                x2,
                y2;
}           Segment;
typedef struct {
    short       x,
                y;
}           Point;
int         resize;
int         errno;
#endif


typedef struct {
    double      x,
                y,
                z;
}           Point3D;

typedef double Transform3D[4][4];

Transform3D xform;
Transform3D r1;
Transform3D r2;
float       zrot,
            ndelta;
int         icoW,
            icoH;

/* extern GC XCreateGC(); */
extern long time();
#ifndef SYSVREF
extern long random();
#endif



/******************************************************************************
 * Description
 *	Main routine.  Process command-line arguments, then bounce a bounding
 *	box inside the window.  Call DrawIco() to redraw the icosahedron.
 *****************************************************************************/

main(argc, argv)
    int         argc;
    char      **argv;
{
    char       *display = NULL;
    char       *geom = NULL;
    int         useRoot = 0;
    int         jaghack = 0;
    int         screensave = 0;
    int         WhiteOnBlack = 0;
    int         last_cnt = 0;

    /* Window win; */
    int         win,
                gc;		/* NeWS */
    int         winX,
                winY,
                winW,
                winH;
    /* XSetWindowAttributes xswa; */

    /* GC gc; */

    double      icoX,
                icoY,
                icoDeltaX,
                icoDeltaY,
                icoGrav,
                icoPush;

    /* XEvent xev; */


    /* Process arguments: */

    while (*++argv) {
	if (**argv == '=')
	    geom = *argv;
	else if (index(*argv, ':'))
	    display = *argv;
	else if (!strcmp(*argv, "-r"))
	    useRoot = 1;
	else if (!strcmp(*argv, "-j"))
	    jaghack = 1;
	else if (!strcmp(*argv, "-s")) {
	    screensave = 1;
	    WhiteOnBlack = 1;
	}
	else if (!strcmp(*argv, "-v"))
	    WhiteOnBlack = 1;
    }


    if (ps_open_PostScript(0) == 0) {
	fprintf(stderr, "Can't contact NeWS server.\n");
	exit(1);
    }
    if (WhiteOnBlack)
	ps_whiteonblack();
    else
	ps_blackonwhite();
    if (jaghack)
	ps_hackwindow();
    else if (screensave)
	ps_screensavewindow();
    else
	ps_createwindow();
    ps_startico();		/* NeWS */
    ps_restart(&winW, &winH);	/* NeWS */
    winX = winY = 0;		/* NeWS */

#ifdef undef			/* boilerplate */
    /* Set up window parameters, create and map window if necessary: */

    if (useRoot) {
	win = RootWindow(0);
	winX = 0;
	winY = 0;
	winW = DisplayWidth(0);
	winH = DisplayHeight(0);
    }
    else {
	winW = 600;
	winH = 600;
	winX = (DisplayWidth(0) - winW) >> 1;
	winY = (DisplayHeight(0) - winH) >> 1;
	if (geom)
	    XParseGeometry(geom, &winX, &winY, &winW, &winH);

	xswa.event_mask = 0;
	xswa.background_pixel = BlackPixel(0);
	win = XWindow(RootWindow(0), winX, winY, winW, winH, 0,
		      DefaultDepth(0), InputOutput, DefaultVisual(0),
		      CWEventMask | CWBackPixel, &xswa);
	XChangeProperty(win, AName, AString, 8,
			PropModeReplace, "Ico", 3);
	XMapWindow(win);
    }


    /* Set up a graphics context: */

    gc = XCreateGC(win, 0, NULL);
    XSetForeground(gc, WhitePixel(0));
#endif

    /* Get the initial position, size, and speed of the bounding-box: */

    icoW = icoH = 150;
    srandom((int) time(0) % 231);
    icoX = ((winW - icoW) * (random() & 0xFF)) >> 8;
    icoY = ((winH - icoH) * (random() & 0xFF)) >> 8;
    icoDeltaX = 9;
    icoDeltaY = 9;
    icoGrav =.1;
    icoPush = 0;
    ps_seticodims(icoW, icoH);

    /* Bounce the box in the window: */

    while (!psio_error(PostScript)) {
	int         prevX;
	int         prevY;
	prevX = icoX;
	prevY = icoY;
	if (PostScript->cnt < last_cnt) {
	    while (1) {
		if (PostScriptInput->cnt <= 0) {
#ifndef SYSVREF
		    static int  T[2];
		    int         mask = 1 << psio_fileno(PostScriptInput);
		    register    n;
#else
		    struct pollfd	mask[1];

		    mask[0].fd = psio_fileno(PostScriptInput);
		    mask[0].events = POLLIN;
#endif

#ifndef SYSVREF
		    if ((n = select(32, &mask, 0, 0, T)) != 1)
#else
		    if (poll(mask, 1, 0) != 1)
#endif
		    {
			break;
		    }
		}
		if (ps_resize()) {
		    register lastH = winH;
		    ps_restart(&winW, &winH);
		    icoY += winH-lastH;
		}
		else if (psio_error(PostScriptInput))
		    exit(0);
		else {
		    fprintf(stderr, "Bogus token from server\n");
		    abort(0);
		}
	    }
	}
	last_cnt = PostScript->cnt;

	icoX += icoDeltaX;
	if (icoDeltaX < 0 ? icoX < 0 : icoX + icoW > winW) {
	    icoX -= (icoDeltaX * 2);
	    BounceRotate(icoDeltaY, -icoDeltaX);
	    icoDeltaX = -icoDeltaX;
	}
	icoY += icoDeltaY;
	icoDeltaY -= icoGrav;
	if (icoDeltaY < 0 ? icoY < 0 : icoY + icoH > winH) {
	    icoY -= (icoDeltaY * 2);
	    BounceRotate(icoDeltaX, icoDeltaY);
	    icoDeltaY = -icoDeltaY;
	    if (icoDeltaY < 0)
		icoDeltaY = 0;
	}
	drawIco(win, gc, (int) icoX, (int) icoY, icoW, icoH, prevX, prevY);
    }
}



/******************************************************************************
 * Description
 *	Undraw previous icosahedron (by erasing its bounding box).
 *	Rotate and draw the new icosahedron.
 *
 * Input
 *	win		window on which to draw
 *	gc		X11 graphics context to be used for drawing
 *	icoX, icoY	position of upper left of bounding-box
 *	icoW, icoH	size of bounding-box
 *	prevX, prevY	position of previous bounding-box
 *****************************************************************************/

drawIco(win, gc, icoX, icoY, icoW, icoH, prevX, prevY)
/* Window win; */
/* GC gc; */
    int         icoX,
                icoY,
                icoW,
                icoH;
    int         prevX,
                prevY;
{
    static int  initialized = 0;
    static Point3D v[] =	/* icosahedron vertices */
    {
	{0.00000000, 0.00000000, -0.95105650},
	{0.00000000, 0.85065080, -0.42532537},
	{0.80901698, 0.26286556, -0.42532537},
	{0.50000000, -0.68819095, -0.42532537},
	{-0.50000000, -0.68819095, -0.42532537},
	{-0.80901698, 0.26286556, -0.42532537},
	{0.50000000, 0.68819095, 0.42532537},
	{0.80901698, -0.26286556, 0.42532537},
	{0.00000000, -0.85065080, 0.42532537},
	{-0.80901698, -0.26286556, 0.42532537},
	{-0.50000000, 0.68819095, 0.42532537},
	{0.00000000, 0.00000000, 0.95105650}
    };
    static int  f[] =		/* icosahedron faces (indices in v) */
    {
	0, 2, 1,
	0, 3, 2,
	0, 4, 3,
	0, 5, 4,
	0, 1, 5,
	1, 6, 10,
	1, 2, 6,
	2, 7, 6,
	2, 3, 7,
	3, 8, 7,
	3, 4, 8,
	4, 9, 8,
	4, 5, 9,
	5, 10, 9,
	5, 1, 10,
	10, 6, 11,
	6, 7, 11,
	7, 8, 11,
	8, 9, 11,
	9, 10, 11
    };
#	define NV (sizeof(v) / sizeof(v[0]))
#	define NF (sizeof(f) / (3 * sizeof(f[0])))

    static Point3D xv[2][NV];
    static int  buffer;
    register int p0;
    register int p1;
    register int p2;
    register Point *pv2;
    Segment    *pe;
    char        drawn[NV][NV];
    register Point3D *pxv;
    static double wo2,
                ho2;
    Point       v2[NV];
    Segment     edges[30];
    register int i;
    register int *pf;


    /* Set up points, transforms, etc.:  */

    if (!initialized) {
	zrot = 3.0 * 3.146 / 180;
	FormatRotateMat('z', zrot, r1);
	FormatRotateMat('y', 3 * 3.1416 / 180.0, r2);
	ConcatMat(r2, r1, xform);

	bcopy((char *) v, (char *) xv[0], NV * sizeof(Point3D));
	buffer = 0;

	wo2 = icoW / 2.0;
	ho2 = icoH / 2.0;

	initialized = 1;
    }


    /* Switch double-buffer and rotate vertices: */

    buffer = !buffer;
    PartialNonHomTransform(NV, xform, xv[!buffer], xv[buffer]);


    /* Convert 3D coordinates to 2D window coordinates: */

    pxv = xv[buffer];
    pv2 = v2;
    for (i = NV - 1; i >= 0; --i) {
	pv2->x = (int) ((pxv->x + 1.0) * wo2);
	pv2->y = (int) ((pxv->y + 1.0) * ho2);
	++pxv;
	++pv2;
    }


    /* Accumulate edges to be drawn, eliminating duplicates for speed: */

    pxv = xv[buffer];
    pv2 = v2;
    pf = f;
    pe = edges;
    bzero(drawn, sizeof(drawn));
    for (i = NF - 1; i >= 0; --i) {
	p0 = *pf++;
	p1 = *pf++;
	p2 = *pf++;

	/* If facet faces away from viewer, don't consider it: */
	if (pxv[p0].z + pxv[p1].z + pxv[p2].z < 0.0)
	    continue;

	if (!drawn[p0][p1]) {
	    drawn[p0][p1] = 1;
	    drawn[p1][p0] = 1;
	    pe->x1 = pv2[p0].x;
	    pe->y1 = pv2[p0].y;
	    pe->x2 = pv2[p1].x;
	    pe->y2 = pv2[p1].y;
	    ++pe;
	}
	if (!drawn[p1][p2]) {
	    drawn[p1][p2] = 1;
	    drawn[p2][p1] = 1;
	    pe->x1 = pv2[p1].x;
	    pe->y1 = pv2[p1].y;
	    pe->x2 = pv2[p2].x;
	    pe->y2 = pv2[p2].y;
	    ++pe;
	}
	if (!drawn[p2][p0]) {
	    drawn[p2][p0] = 1;
	    drawn[p0][p2] = 1;
	    pe->x1 = pv2[p2].x;
	    pe->y1 = pv2[p2].y;
	    pe->x2 = pv2[p0].x;
	    pe->y2 = pv2[p0].y;
	    ++pe;
	}
    }

    ps_startlines();
    {
	int         lx = -1,
	            ly = -1;
	while (--pe >= edges) {
	    if (pe->x1 != lx || pe->y1 != ly)
		ps_moveto(pe->x1, pe->y1);
	    ps_lineto(pe->x2, pe->y2);
	    lx = pe->x2;
	    ly = pe->y2;
	}
    }
    ps_kickit(icoX, icoY);
}


BounceRotate(para, perp)
    double      para,
                perp;
{
    zrot = atan((perp < 0 ? -para : para) / icoW);
    FormatRotateMat('z', zrot, r1);
    ConcatMat(r2, r1, xform);
}

/******************************************************************************
 * Description
 *	Concatenate two 4-by-4 transformation matrices.
 *
 * Input
 *	l		multiplicand (left operand)
 *	r		multiplier (right operand)
 *
 * Output
 *	*m		Result matrix
 *****************************************************************************/

ConcatMat(l, r, m)
    register Transform3D l;
    register Transform3D r;
    register Transform3D m;
{
    register int i;
    register int j;
    register int k;

    for (i = 0; i < 4; ++i)
	for (j = 0; j < 4; ++j)
	    m[i][j] = l[i][0] * r[0][j]
		+ l[i][1] * r[1][j]
		+ l[i][2] * r[2][j]
		+ l[i][3] * r[3][j];
}



/******************************************************************************
 * Description
 *	Format a matrix that will perform a rotation transformation
 *	about the specified axis.  The rotation angle is measured
 *	counterclockwise about the specified axis when looking
 *	at the origin from the positive axis.
 *
 * Input
 *	axis		Axis ('x', 'y', 'z') about which to perform rotation
 *	angle		Angle (in radians) of rotation
 *	A		Pointer to rotation matrix
 *
 * Output
 *	*m		Formatted rotation matrix
 *****************************************************************************/

FormatRotateMat(axis, angle, m)
    char        axis;
    double      angle;
    register Transform3D m;
{
    double      s,
                c;
    double      sin(),
                cos();

    IdentMat(m);

    s = sin(angle);
    c = cos(angle);

    switch (axis) {
    case 'x':
	m[1][1] = m[2][2] = c;
	m[1][2] = s;
	m[2][1] = -s;
	break;
    case 'y':
	m[0][0] = m[2][2] = c;
	m[2][0] = s;
	m[0][2] = -s;
	break;
    case 'z':
	m[0][0] = m[1][1] = c;
	m[0][1] = s;
	m[1][0] = -s;
	break;
    }
}



/******************************************************************************
 * Description
 *	Format a 4x4 identity matrix.
 *
 * Output
 *	*m		Formatted identity matrix
 *****************************************************************************/

IdentMat(m)
    register Transform3D m;
{
    register int i;
    register int j;

    for (i = 3; i >= 0; --i) {
	for (j = 3; j >= 0; --j)
	    m[i][j] = 0.0;
	m[i][i] = 1.0;
    }
}



/******************************************************************************
 * Description
 *	Perform a partial transform on non-homogeneous points.
 *	Given an array of non-homogeneous (3-coordinate) input points,
 *	this routine multiplies them by the 3-by-3 upper left submatrix
 *	of a standard 4-by-4 transform matrix.  The resulting non-homogeneous
 *	points are returned.
 *
 * Input
 *	n		number of points to transform
 *	m		4-by-4 transform matrix
 *	in		array of non-homogeneous input points
 *
 * Output
 *	*out		array of transformed non-homogeneous output points
 *****************************************************************************/

PartialNonHomTransform(n, m, in, out)
    int         n;
    register Transform3D m;
    register Point3D *in;
    register Point3D *out;
{
    for (; n > 0; --n, ++in, ++out) {
	out->x = in->x * m[0][0] + in->y * m[1][0] + in->z * m[2][0];
	out->y = in->x * m[0][1] + in->y * m[1][1] + in->z * m[2][1];
	out->z = in->x * m[0][2] + in->y * m[1][2] + in->z * m[2][2];
    }
}
