
/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef lint
static	char sccsid[] = "@(#)tabs.c 1.2 88/01/18 Copyright 1987 Sun Micro";
#endif

/*
 *	Copyright (c) 1987 by Sun Microsystems, Inc.
 *	Steve Isaac 12/18/87
 *
 */

/* Copyright    Massachusetts Institute of Technology    1984	 */

/* tabs.c */

#ifndef lint
#endif	lint

#include "ptyx.h"
/*
 * This file presumes 32bits/word.  This is somewhat of a crock, and should be
 * fixed sometime.
 */

/*
 * places tabstops at only every 8 columns
 */
TabReset(tabs)
    Tabs        tabs;
{
    register int i;

    for (i = 0; i < TAB_ARRAY_SIZE; ++i)
	tabs[i] = 0;

    for (i = 0; i < MAX_TABS; i += 8)
	TabSet(tabs, i);
}


/*
 * places a tabstop at col
 */
TabSet(tabs, col)
    Tabs        tabs;
{
    tabs[col >> 5] |= (1 << (col & 31));
}

/*
 * clears a tabstop at col
 */
TabClear(tabs, col)
    Tabs        tabs;
{
    tabs[col >> 5] &= ~(1 << (col & 31));
}

/*
 * returns the column of the next tabstop (or MAX_TABS - 1 if there are no
 * more). A tabstop at col is ignored.
 */
TabNext(tabs, col)
    Tabs        tabs;
{
    extern Terminal term;
    register Screen *screen = &term.screen;

    for (++col; col < MAX_TABS; ++col)
	if (tabs[col >> 5] & (1 << (col & 31)))
	    return (col);

    return (MAX_TABS - 1);
}

/*
 * clears all tabs
 */
TabZonk(tabs)
    Tabs        tabs;
{
    register int i;

    for (i = 0; i < TAB_ARRAY_SIZE; ++i)
	tabs[i] = 0;
}
