/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef lint
static char sccsid[] = "@(#)say.c 9.2 88/01/18 Copyright 1987 Sun Micro";
#endif

/*
 * Copyright (c) 1987 by Sun Microsystems, Inc. 
 */

/*-
	Say some message in a window.
  
	say.c, Thu Jun 19 08:42:32 1986
  
		James Gosling,
		Sun Microsystems
 */

#include <ctype.h>
#include "say.h"

static	int         debug;

static	char       *lines[50];
static	char      **linep = lines;
static	int         pointsize = 80;
static	int         manipmenu;
static	int	    at_mouse;
static	int         x = -1,
		    y = -1;
static	int         width = 500,
		    height = 400;
static	int         time,
		    time2;
static	int         drop;
static	int         center = 1;
static	int         isprog;
static	int         stdinprog;
static	int         completionwait;
static	int         round;
static	int         skipwindow;
static	char       *banner = "Fan mail from a Flounder";
static	char       *programname;

static	int
parsepair(s, i1, i2)
    register char *s;
    int        *i1,
               *i2;
{
    register    n = 0;
    if (s == 0 || *s == 0)
	return -1;
    *i1 = 0;
    while (*s)
	if (isdigit(*s))
	    n = n * 10 + *s++ - '0';
	else if (*s == ',')
	    *i1 = n, n = 0, s++;
	else
	    return -1;
    *i2 = n;
    return 0;
}

static void
ack()
{
    ps_ack();
    ps_flush_PostScript();
    psio_getc(PostScriptInput);
}

static void
usage()
{
    fprintf(stderr,
	    "Usage: %s -bstring -c -p -P -r -sS -w -W -X,Y strings...\n",
	    programname);
}

main(argc, argv)
    char      **argv;
{
    programname = argv[0];
    while (--argc > 0)
	if ((++argv)[0][0] == '-')
	    switch (argv[0][1]) {
	    case 'b':
		banner = &argv[0][2];
		break;
	    case 'c':
		center = !center;
		break;
	    case 'd': /* Not documented */
		drop++;
		break;
	    case 'D': /* Not public */
		debug++;
		break;
	    case 'M': /* Not documented */
		at_mouse++;
		break;
	    case 'p':
		isprog++;
		break;
	    case 'P':
		isprog++;
		stdinprog++;
		break;
	    case 'r':
		round++;
		break;
	    case 's':
		pointsize = atoi(&argv[0][2]);
		break;
	    case 't': /* Not documented */
		time = atoi(&argv[0][2]);
		break;
	    case 'T': /* Not documented */
		time2 = atoi(&argv[0][2]);
		break;
	    case 'w':
		completionwait = 1;
		break;
	    case 'W':
		skipwindow++;
		break;
	    case '0':
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
	    case '8':
	    case '9':
		if (x < 0) {
		    if (parsepair(&argv[0][1], &x, &y) < 0) {
			fprintf(stderr, "%s: syntax error in %s\n",
				programname, argv[0]);
			usage();
			exit(0);
		    }
		}
		else if (parsepair(&argv[0][1], &width, &height) < 0) {
		    fprintf(stderr, "%s: syntax error in %s\n",
			    programname, argv[0]);
		    usage();
		    exit(0);
		}
		break;
	    default:
		fprintf(stderr, "%s: Illegal switch \"%s\"\n", programname, argv[0]);
		usage();
		exit(0);
	    }
	else
	    *linep++ = argv[0];
    if (linep == lines) {
	usage();
	exit(0);
    }
    if (ps_open_PostScript() == 0) {
	fprintf(stderr, "%s: Cannot connect to window server\n", programname);
	exit(0);
    }
    ps_title(banner);
    ps_initialize(pointsize);
    if (!isprog) {
	register char **str = lines;
	ps_startdef();
	while (str < linep)
	    ps_sendstr(*str++);
	ps_enddef();
    }
    else
	ps_nonstring(width, height);
    if (!skipwindow)
	if (x >= 0) {
	    if (round)
		ps_roundfixed(x, y);
	    else
		ps_squarefixed(x, y);
	}
	else if (at_mouse) {
	    if (round)
	        ps_roundatmouse();
	    else
	        ps_squareatmouse();
	}
	else {
	    if (round)
	        ps_round();
	    else
	        ps_square();
	}
    if (isprog) {
	register char **str = lines;
	while (str < linep)
	    psio_fprintf(PostScript, "%s ", *str++);
	if (stdinprog) {
	    register char c;
	    while ((c = getchar()) != EOF)
		psio_putc(c, PostScript);
	}
    }
    else {
	if (center)
	    ps_center();
/*-	ps_drawtext(); */
    }
    ack();
    if (time > 0)
	sleep(time);
    if (drop) {
	if (drop > 1)
	    ps_qdrop();
	else
	    ps_drop();
	ack();
    }
    if (time2) {
	sleep(time2);
	ack();
    }
    if (completionwait || (drop==0 && time==0 && time2==0))
	psio_getc(PostScriptInput);
}

