/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef lint
static	char sccsid[] = "@(#)setnewshost.c 9.4 88/01/18 SMI";
#endif

/*
 * Copyright (c) 1987 by Sun Microsystems, Inc.
 */

/*
 *
 * usage: setnewshost hostname
 *
 * Generates the proper string for the NEWSSERVER environment variable for the
 * given hostname and prints it to stdout.  For
 * more convenient use in csh, put the following alias into your .cshrc:
 *
 *	    alias sps 'setenv NEWSSERVER `setnewshost \!*`'
 *
 * System V Bourne Shell and Korn Shell users can put the following function
 * into their .profile:
 *
 *	    sps () {
 *		NEWSSERVER=`setnewshost $*`
 *		export NEWSSERVER
 *	    }
 *
 * (Note: SunOS 3.0 and later releases provide the System V Bourne shell as the
 * standard Bourne shell.)
 *
 * Example: if the host "terminus" is 192.9.97.61, then the command 
 * "setnewshost terminus" will produce the string:
 *
 *	    '3221840189.2000;terminus'
 */

#include <stdio.h>

extern int printf();
extern int fprintf();

#ifdef SYSVREF
#ifdef INTERLANTCP
#include <interlan/il_types.h>
#include <interlan/netdb.h>
#include <interlan/in.h>
#else
#include <sys/types.h>
#endif
#else
#include <sys/types.h>
#include <netdb.h>
#include <netinet/in.h>
#endif

extern void exit();

int
main(argc, argv)
	int argc;
	char **argv;
{
	register struct hostent *hp;
	
	if (argc != 2) {
		(void) fprintf(stderr, "usage: setnewshost hostname\n");
		exit(1);
	}

	if ((hp = gethostbyname(argv[1])) == NULL) {
		(void) fprintf(stderr, "setnewshost: %s: unknown host\n",
		    argv[1]);
		exit(1);
	}

	(void) printf("%lu.2000;%s\n", ntohl(*(u_long *)hp->h_addr), argv[1]);
	exit (0);
	/*NOTREACHED*/
}
