#include <stdlib.h>

#include "macros.h"
#include "macroop.h"
#include "memobj.h"

/*
 *
 */

DEFNOP(AUX_GROUP, DEFOP_AUX_GROUP);
DEFNOP(TEST_MISC_GROUP, DEFOP_TEST_MISC_GROUP);
DEFNOP(TEST_MODULE_GROUP, DEFOP_TEST_MODULE_GROUP);
DEFNOP(EQ_IMMED, DEFOP_EQ_IMMED);
DEFNOP(EQUALS_IMMED, DEFOP_EQUALS_IMMED);
DEFNOP(GREATERP_IMMED, DEFOP_GREATERP_IMMED);
DEFNOP(LESSP_IMMED, DEFOP_LESSP_IMMED);
DEFNOP(TEST_AREFI, DEFOP_TEST_AREFI);

DEFNOP(TEST, DEFOP_TEST);
DEFNOP(TEST_CAR, DEFOP_TEST_CAR);
DEFNOP(TEST_CDR, DEFOP_TEST_CDR);
DEFNOP(TEST_CADR, DEFOP_TEST_CADR);
DEFNOP(TEST_CDDR, DEFOP_TEST_CDDR);
DEFNOP(TEST_CAAR, DEFOP_TEST_CAAR);
DEFNOP(TEST_CDAR, DEFOP_TEST_CDAR);
DEFNOP(RETURN, DEFOP_RETURN);
   
DEFNOP(EQUALS, DEFOP_EQUALS);
DEFNOP(GREATERP, DEFOP_GREATERP);
DEFNOP(LESSP, DEFOP_LESSP);
DEFNOP(EQ, DEFOP_EQ);
DEFNOP(EQL, DEFOP_EQL);
DEFNOP(EQUAL, DEFOP_EQUAL);
DEFNOP(EQUALP, DEFOP_EQUALP);
DEFNOP(OP027, DEFOP_027);

DEFNOP(NUMBERP, DEFOP_NUMBERP);
DEFNOP(ARRAYP, DEFOP_ARRAYP);
DEFNOP(CLI_LISTP, DEFOP_CLI_LISTP);
DEFNOP(STRINGP, DEFOP_STRINGP);
DEFNOP(FIXNUMP, DEFOP_FIXNUMP);
DEFNOP(INTEGERP, DEFOP_INTEGERP);
DEFNOP(PLUSP, DEFOP_PLUSP);
DEFNOP(MINUSP, DEFOP_MINUSP);

DEFNOP(OP040, DEFOP_040);
DEFNOP(PUSH_MISC_GROUP, DEFOP_PUSH_MISC_GROUP);
DEFNOP(PUSH_MODULE_GROUP, DEFOP_PUSH_MODULE_GROUP);
DEFNOP(ADD_IMMED, DEFOP_ADD_IMMED);
DEFNOP(LDB_IMMED, DEFOP_LDB_IMMED);
DEFNOP(PUSH_NUMBER, DEFOP_PUSH_NUMBER);
DEFNOP(PUSH_NEG_NUMBER, DEFOP_PUSH_NEG_NUMBER);
DEFNOP(PUSH_AREFI, DEFOP_PUSH_AREFI);

DEFNOP(PUSH, DEFOP_PUSH);
DEFNOP(PUSH_CAR, DEFOP_PUSH_CAR);
DEFNOP(PUSH_CDR, DEFOP_PUSH_CDR);
DEFNOP(PUSH_CADR, DEFOP_PUSH_CADR);
DEFNOP(PUSH_CDDR, DEFOP_PUSH_CDDR);
DEFNOP(PUSH_CADDR, DEFOP_PUSH_CADDR);
DEFNOP(PUSH_CONS, DEFOP_PUSH_CONS);
DEFNOP(PUSH_GET, DEFOP_PUSH_GET);

DEFNOP(PLUS, DEFOP_PLUS);
DEFNOP(DIF, DEFOP_DIF);
DEFNOP(TIMES, DEFOP_TIMES);
DEFNOP(LOGAND, DEFOP_LOGAND);
DEFNOP(LOGXOR, DEFOP_LOGXOR);
DEFNOP(ONE_PLUS, DEFOP_ONE_PLUS);
DEFNOP(ONE_MINUS, DEFOP_ONE_MINUS);
DEFNOP(PUSH_AR_1, DEFOP_PUSH_AR_1);

DEFNOP(PUSH_LONG_FEF, DEFOP_PUSH_LONG_FEF);
DEFNOP(SELECT, DEFOP_SELECT);
DEFNOP(DISPATCH, DEFOP_DISPATCH);
DEFNOP(OP073, DEFOP_073);
DEFNOP(MAKE_STACK_CLOSURE, DEFOP_MAKE_STACK_CLOSURE);
DEFNOP(STACK_CLOSURE_DISCONNECT, DEFOP_STACK_CLOSURE_DISCONNECT);
DEFNOP(STACK_CLOSURE_UNSHARE, DEFOP_STACK_CLOSURE_UNSHARE);
DEFNOP(STACK_CLOSURE_DISCONNECT_FIRST, DEFOP_STACK_CLOSURE_DISCONNECT_FIRST);

DEFNOP(CALL_0_DEST_INDS, DEFCALLOP_CALL_0_DEST_INDS);
DEFNOP(CALL_0_DEST_PUSH, DEFCALLOP_CALL_0_DEST_PUSH);
DEFNOP(CALL_0_DEST_RETURN, DEFCALLOP_CALL_0_DEST_RETURN);
DEFNOP(CALL_0_DEST_TAIL_REC, DEFCALLOP_CALL_0_DEST_TAIL_REC);

DEFOP(CALL_1_DEST_INDS, DEFCALLOP_CALL_1_DEST_INDS);
int CALL_1_DEST_INDS::disassemble(e3MacroOpCodeEngine *e)
{
  cout << "CALL_1_DEST_INDS" << endl;
  e3MacroInstruction instr = e->currentInstruction();
  instr.dump(cout);
  instr.dumpMainOperands(cout);
  cout << flush << endl;

  return(2);
}

void CALL_1_DEST_INDS::execute(e3MacroOpCodeEngine *e)
{
  if (theTrace)
    {
      disassemble(e);
    }

  e3MacroInstruction instr = e->currentInstruction();
  /* One arg, dest = 0 = set indicators only. */

  e3Word operand = e->fetchOperand(instr);
  cout << endl << "Operand = " << operand << endl;

  cout
    << "e->myCurrentStackGroup = "
    << (int)e->myCurrentStackGroup.getBits()
    << " = "
    << e->myCurrentStackGroup
    << endl;

  /*
   * The saved stack group's pointer should point to a
   * standard array header of subtype stack group header.
   */

  memStackGroupArrayHeader stack_group_array_header(e->myCurrentStackGroup.getPointer());
  stack_group_array_header.dump(cout);

  /*
   * The discussion of functional object calling begins on 11-1 of SSDN2.
   */

  switch(operand.getDataType())
    {
    case E3_DTP_TRAP:
      E3ThrowError("CALL_1_DEST_INDS::execute -- bad DTP target of call = " << (int)operand.getDataType() << endl);
      break;

    case E3_DTP_LIST:		// Interpreted function par 11.2.2
    case E3_DTP_STACK_LIST:
      E3NotYetImplemented( "CALL_1_DEST_INDS::execute -- call to interpreted function.\n");
      break;

    case E3_DTP_SYMBOL:		// Indirect function par 11.2.3.1
      E3NotYetImplemented("CALL_1_DEST_INDS::execute -- call to indirect function.\n");
      break;

    case E3_DTP_ARRAY:		// Non-function par 11.2.4.1
      E3NotYetImplemented("CALL_1_DEST_INDS::execute -- call to non-function E3_DTP_ARRAY.\n");
      break;

    case E3_DTP_FIX:		// Par 11.2
    case E3_DTP_CHARACTER:
    case E3_DTP_SINGLE_FLOAT:
    case E3_DTP_SHORT_FLOAT:
      E3ThrowError("CALL_1_DEST_INDS::execute -- bad DTP target of call = " << (int)operand.getDataType() << endl);
      break;

    case E3_DTP_INSTANCE:	// Indirect function par 11.2.3.3
      E3NotYetImplemented("CALL_1_DEST_INDS::execute -- call to E3_DTP_INSTANCE\n");
      break;

    case E3_DTP_EXTENDED_NUMBER: // Par 11.2
      E3ThrowError("CALL_1_DEST_INDS::execute -- bad DTP target of call  = " << (int)operand.getDataType() << endl);
      break;

    case E3_DTP_LOCATIVE:	// Interpreted function par 11.2.2
      E3NotYetImplemented("CALL_1_DEST_INDS::execute -- unimplemented call to interpreted function.\n");
      break;

    case E3_DTP_FUNCTION:	// Compiled function par 11.2.1
      cout << "FOO!!!!!!!!!!!!!!!\n";
      {
	e3WordAddr new_function_address = operand.getPointer();
	memFEFHeader new_function_fef(new_function_address);
	cout << "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n";
	e->dumpMemory(new_function_address, 50);
	new_function_fef.dump(cout);
	abort();
	exit(0);
      }
      break;

    case E3_DTP_CLOSURE:	// Indirect function par 11.2.3.2
    case E3_DTP_LEXICAL_CLOSURE:
      E3NotYetImplemented("CALL_1_DEST_INDS::execute -- unimplemented call to indirect function.\n");
      break;

    case E3_DTP_U_ENTRY:	// Par 11.2.4.3
      E3NotYetImplemented("CALL_1_DEST_INDS::execute -- unimplemented call to U-ENTRY.\n");
      break;

    case E3_DTP_STACK_GROUP:	// Non-function par 11.2.4.1
      E3NotYetImplemented("CALL_1_DEST_INDS::execute -- unimplemented call to E3_DTP_STACK_GROUP.\n");
      break;

    case E3_DTP_GC_FORWARD:
    case E3_DTP_EXTERNAL_VALUE_CELL_POINTER:
    case E3_DTP_ONE_Q_FORWARD:
      E3NotYetImplemented("CALL_1_DEST_INDS::execute -- unimplemented DTP target of call = " << (int)operand.getDataType() << endl);
      break;

      /* $$$$$$$$$$ Not sure what to do with these! */
    case E3_DTP_HEADER_FORWARD:
    case E3_DTP_BODY_FORWARD:
    case E3_DTP_SYMBOL_HEADER:
    case E3_DTP_HEADER:
    case E3_DTP_ARRAY_HEADER:
    case E3_DTP_INSTANCE_HEADER:
    case E3_DTP_FEF_HEADER:
    case E3_DTP_SELF_REF_POINTER:
    case E3_DTP_GC_YOUNG_POINTER:
      E3FatalError("CALL_1_DEST_INDS::execute -- can I call DTP????? = " << (int)operand.getDataType() << endl);
      break;

    case E3_DTP_FREE:
    case E3_DTP_NULL:
    case E3_DTP_ONES_TRAP:
      E3ThrowError("CALL_1_DEST_INDS::execute -- bad DTP target of call  = " << (int)operand.getDataType() << endl);
      break;

    default:
      E3FatalError("CALL_1_DEST_INDS::execute -- bad DTP target of call = " << (int)operand.getDataType() << endl);
      break;
    }
}

DEFNOP(CALL_1_DEST_PUSH, DEFCALLOP_CALL_1_DEST_PUSH);
DEFNOP(CALL_1_DEST_RETURN, DEFCALLOP_CALL_1_DEST_RETURN);
DEFNOP(CALL_1_DEST_TAIL_REC, DEFCALLOP_CALL_1_DEST_TAIL_REC);

DEFNOP(CALL_2_DEST_INDS, DEFCALLOP_CALL_2_DEST_INDS);
DEFNOP(CALL_2_DEST_PUSH, DEFCALLOP_CALL_2_DEST_PUSH);
DEFNOP(CALL_2_DEST_RETURN, DEFCALLOP_CALL_2_DEST_RETURN);
DEFNOP(CALL_2_DEST_TAIL_REC, DEFCALLOP_CALL_2_DEST_TAIL_REC);

DEFNOP(CALL_3_DEST_INDS, DEFCALLOP_CALL_3_DEST_INDS); // 0114
DEFNOP(CALL_3_DEST_PUSH, DEFCALLOP_CALL_3_DEST_PUSH);
DEFNOP(CALL_3_DEST_RETURN, DEFCALLOP_CALL_3_DEST_RETURN);
DEFNOP(CALL_3_DEST_TAIL_REC, DEFCALLOP_CALL_3_DEST_TAIL_REC);

DEFNOP(CALL_4_DEST_INDS, DEFCALLOP_CALL_4_DEST_INDS);
DEFNOP(CALL_4_DEST_PUSH, DEFCALLOP_CALL_4_DEST_PUSH);
DEFNOP(CALL_4_DEST_RETURN, DEFCALLOP_CALL_4_DEST_RETURN);
DEFNOP(CALL_4_DEST_TAIL_REC, DEFCALLOP_CALL_4_DEST_TAIL_REC);
DEFNOP(CALL_5_DEST_INDS, DEFCALLOP_CALL_5_DEST_INDS);
DEFNOP(CALL_5_DEST_PUSH, DEFCALLOP_CALL_5_DEST_PUSH);
DEFNOP(CALL_5_DEST_RETURN, DEFCALLOP_CALL_5_DEST_RETURN);
DEFNOP(CALL_5_DEST_TAIL_REC, DEFCALLOP_CALL_5_DEST_TAIL_REC);

DEFNOP(CALL_6_DEST_INDS, DEFCALLOP_CALL_6_DEST_INDS);
DEFNOP(CALL_6_DEST_PUSH, DEFCALLOP_CALL_6_DEST_PUSH);
DEFNOP(CALL_6_DEST_RETURN, DEFCALLOP_CALL_6_DEST_RETURN);
DEFNOP(CALL_6_DEST_TAIL_REC, DEFCALLOP_CALL_6_DEST_TAIL_REC);
DEFNOP(CALL_N_DEST_INDS, DEFCALLOP_CALL_N_DEST_INDS);
DEFNOP(CALL_N_DEST_PUSH, DEFCALLOP_CALL_N_DEST_PUSH);
DEFNOP(CALL_N_DEST_RETURN, DEFCALLOP_CALL_N_DEST_RETURN);
DEFNOP(CALL_N_DEST_TAIL_REC, DEFCALLOP_CALL_N_DEST_TAIL_REC);

DEFNOP(POP, DEFOP_POP);
DEFNOP(MOVEM, DEFOP_MOVEM);
DEFNOP(SETE_CDR, DEFOP_SETE_CDR);
DEFNOP(SETE_CDDR, DEFOP_SETE_CDDR);
DEFNOP(SETE_1_PLUS, DEFOP_SETE_1_PLUS);
DEFNOP(SETE_1_MINUS, DEFOP_SETE_1_MINUS);
DEFNOP(OP0146, DEFOP_0146);
DEFNOP(PUSH_CDR_STORE_CAR_IF_CONS, DEFOP_PUSH_CDR_STORE_CAR_IF_CONS);

DEFNOP(PUSH_LOC, DEFOP_PUSH_LOC);
   /* Binding. */
DEFNOP(BIND_NIL, DEFOP_BIND_NIL);
DEFNOP(BIND_T, DEFOP_BIND_T);
DEFNOP(BIND_POP, DEFOP_BIND_POP);
DEFNOP(BIND_CURRENT, DEFOP_BIND_CURRENT);
   /* Setting. */
DEFNOP(SET_NIL, DEFOP_SET_NIL);
DEFNOP(SET_T, DEFOP_SET_T);
DEFNOP(SET_ZERO, DEFOP_SET_ZERO);

DEFNOP(BR_NIL_ELSE_POP, DEFBRANCHOP_BR_NIL_ELSE_POP);
DEFNOP(BR_NOT_NIL_ELSE_POP, DEFBRANCHOP_BR_NOT_NIL_ELSE_POP);
DEFNOP(BR_NIL, DEFBRANCHOP_BR_NIL);
DEFNOP(BR_NOT_NIL, DEFBRANCHOP_BR_NOT_NIL);
DEFNOP(BR_ATOM, DEFBRANCHOP_BR_ATOM);
DEFNOP(BR_NOT_ATOM, DEFBRANCHOP_BR_NOT_ATOM);
DEFNOP(BR_ZEROP, DEFBRANCHOP_BR_ZEROP);
DEFNOP(BR_NOT_ZEROP, DEFBRANCHOP_BR_NOT_ZEROP);

DEFNOP(BR_SYMBOLP, DEFBRANCHOP_BR_SYMBOLP);
DEFNOP(BR_NOT_SYMBOLP, DEFBRANCHOP_BR_NOT_SYMBOLP);
DEFNOP(OP0172, DEFOP_0172);
DEFNOP(OP0173, DEFOP_0173);
DEFNOP(BR_NIL_LIKELY, DEFBRANCHOP_BR_NIL_LIKELY);
DEFNOP(BR_NOT_NIL_LIKELY, DEFBRANCHOP_BR_NOT_NIL_LIKELY);
DEFNOP(BR_ALWAYS_NIL, DEFBRANCHOP_BR_ALWAYS_NIL);
DEFNOP(OP0177_ILLEGAL, DEFOP_0177_ILLEGAL);


//
// Local Variables:
// compile-command: "make cycle"
// fill-column: 78
// End:
