#include <iostream.h>

#ifdef NOTDEF
#include "physmemregion.h"
#endif
#include "memmap.h"
#include "types.h"


e3MemMap::e3MemMap()
{
  ;
}  

e3MemMap::~e3MemMap()
{
  cout << "e3MemMap::~e3MemMap" << endl;
}

e3Boolean e3MemMap::isIOSpaceAddress(e3WordAddr addr) const
{
  if ((addr >= E3_IO_SPACE_VIRTUAL_ADDRESS)
      && (addr < (E3_IO_SPACE_VIRTUAL_ADDRESS + E3_IO_SPACE_LENGTH)))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3Boolean e3MemMap::isAMemoryAddress(e3WordAddr addr) const
{
  if ((addr >= E3_A_MEMORY_VIRTUAL_ADDRESS)
      && (addr < (E3_A_MEMORY_VIRTUAL_ADDRESS + E3_A_MEMORY_LENGTH)))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3Boolean e3MemMap::addressIsWithinRange(e3WordAddr a) const
{
  if (a & (~E3_MAX_VIRTUAL_ADDRESS))
    {
      return(e3False);
    }
  else
    {
      return(e3True);
    }
}

e3Boolean e3MemMap::addressIsMemory(e3WordAddr a) const
{
  if (!addressIsWithinRange(a))
    {
      return(e3False);
    }
  else if (isIOSpaceAddress(a))
    {
      return(e3False);
    }
  else if (isAMemoryAddress(a))
    {
      return(e3False);
    }
  else
    {
      return(e3True);
    }
}

e3Word e3MemMap::readWord(e3WordAddr addr) const
{
  if (addressIsMemory(addr))
    {
      e3Word retval = myWord[addr];
      return(retval);
    }
  else
    {
      cerr << "e3MemMap::readWordFollowingPointers -- not normal memory!" << endl;
      return(e3Word::allOnesTrap());
    }
}

e3Word e3MemMap::readWordFollowingInvisiblePointers(e3WordAddr addr) const
{
  if (!addressIsMemory(addr))
    {
      cerr << "e3MemMap::readWord -- not normal memory!" << endl;
      return(e3Word::allOnesTrap());
    }
  else
    {
      e3Word w = readWord(addr); // $ Inefficiently duplicates address range check.

      if (w.isInvisibleForwardingPointer())
	{
	  return(readWordFollowingInvisiblePointers(w.getPointer()));
	}
      else
	{
	  return(w);
	}
    }
}

void e3MemMap::writeWord(e3WordAddr addr, e3Word new_value)
{
  if (addressIsMemory(addr))
    {
      myWord[addr] = new_value;
    }
  else
    {
      cerr << "e3MemMap::write -- to bad addr!" << endl;
    }
}

/*
 *
 */

#ifdef NOTDEF
class vlmSysCommArea
{
public:
  void dump(ostream &os);

protected:

  e3Word SYS_COM_AREA_ORIGIN_PNTR;
  e3Word SYS_COM_VALID_SIZE;
  e3Word SYS_COM_OBARRAY_PNTR;
  e3Word SYS_COM_ETHER_FREE_LIST;
  e3Word SYS_COM_ETHER_TRANSMIT_LIST;
  e3Word SYS_COM_ETHER_RECEIVE_LIST;
  e3Word SYS_COM_BAND_FORMAT;
  e3Word SYS_COM_GC_GENERATION_NUMBER;
  e3Word SYS_COM_DEVICE_INTERRUPT_TABLE;
  e3Word SYS_COM_TEMPORARY;
  e3Word SYS_COM_FREE_AREA;
  e3Word SYS_COM_FREE_REGION;
  e3Word SYS_COM_MEMORY_SIZE;
  e3Word SYS_COM_WIRED_SIZE;
  e3Word SYS_COM_CHAOS_FREE_LIST;
  e3Word SYS_COM_CHAOS_TRANSMIT_LIST;
  e3Word SYS_COM_CHAOS_RECEIVE_LIST;
  e3Word SYS_COM_DEBUGGER_REQUESTS;
  e3Word SYS_COM_DEBUGGER_KEEP_ALIVE;
  e3Word SYS_COM_DEBUGGER_DATA_1;
  e3Word SYS_COM_DEBUGGER_DATA_2;
  e3Word SYS_COM_MAJOR_VERSION;
  e3Word SYS_COM_DESIRED_MICROCODE_VERSION;
  e3Word SYS_COM_HIGHEST_VIRTUAL_ADDRESS;
  e3Word SYS_COM_POINTER_WIDTH;
  e3Word SYS_COM_DESCRIPTOR_SPACE_FREE_POINTER;
  e3Word SYS_COM_PAGE_DEVICE_TABLE;
  e3Word SYS_COM_SYSTEM_NUPI_DESCRIPTOR;
  e3Word SYS_COM_PROCESSOR_SLOT;
  e3Word SYS_COM_OVERTEMP_EVENT;
  e3Word SYS_COM_FIBER_OPTIC_WARNING_EVENT;
  e3Word SYS_COM_NUPI_OVERTEMP_EVENT;
  e3Word SYS_COM_PHYSICAL_MEMORY_MAP;
  e3Word SYS_COM_KEYBD_ERROR_EVENT;
  e3Word SYS_COM_DISK_RETRY_EVENT;
  e3Word SYS_COM_UNUSED_SIB_EVENT;
  e3Word SYS_COM_PARITY_ERROR_EVENT;
  e3Word SYS_COM_PARITY_ERROR_EVENT_2;
  e3Word SYS_COM_SYSLOG_WRAP_EVENT;
  e3Word SYS_COM_WORLD_RECORD_AREA;
  e3Word SYS_COM_ENTRY_REGION_AREA;
  e3Word SYS_COM_EXIT_REGION_AREA;
  e3Word SYS_COM_WORLD_LIST_THREAD;
  e3Word SYS_COM_WORLD_RECORD;
  e3Word SYS_COM_INTERNAL_EXTERNAL_TRANSLATE_TABLE;
  e3Word SYS_COM_SWAPIN_ACB;
  e3Word SYS_COM_SWAPOUT_ACB;
  e3Word SYS_COM_ERROR_ACB_ADDIN;
  e3Word SYS_COM_ERROR_ACB_HOST;
  e3Word SYS_COM_CREC_ACB;
};

void vlmSysCommArea::dump(ostream &os)
{
  cout << "vlmSysCommArea::dump --" << endl;

  os << "SYS_COM_AREA_ORIGIN_PNTR:                  " << this->SYS_COM_AREA_ORIGIN_PNTR << endl;
  os << "SYS_COM_VALID_SIZE:                        " << this->SYS_COM_VALID_SIZE << endl;
  os << "SYS_COM_OBARRAY_PNTR:                      " << this->SYS_COM_OBARRAY_PNTR << endl;
  os << "SYS_COM_ETHER_FREE_LIST:                   " << this->SYS_COM_ETHER_FREE_LIST << endl;
  os << "SYS_COM_ETHER_TRANSMIT_LIST:               " << this->SYS_COM_ETHER_TRANSMIT_LIST << endl;
  os << "SYS_COM_ETHER_RECEIVE_LIST:                " << this->SYS_COM_ETHER_RECEIVE_LIST << endl;
  os << "SYS_COM_BAND_FORMAT:                       " << this->SYS_COM_BAND_FORMAT << endl;
  os << "SYS_COM_GC_GENERATION_NUMBER:              " << this->SYS_COM_GC_GENERATION_NUMBER << endl;
  os << "SYS_COM_DEVICE_INTERRUPT_TABLE:            " << this->SYS_COM_DEVICE_INTERRUPT_TABLE << endl;
  os << "SYS_COM_TEMPORARY:                         " << this->SYS_COM_TEMPORARY << endl;
  os << "SYS_COM_FREE_AREA:                         " << this->SYS_COM_FREE_AREA << endl;
  os << "SYS_COM_FREE_REGION:                       " << this->SYS_COM_FREE_REGION << endl;
  os << "SYS_COM_MEMORY_SIZE:                       " << this->SYS_COM_MEMORY_SIZE << endl;
  os << "SYS_COM_WIRED_SIZE:                        " << this->SYS_COM_WIRED_SIZE << endl;
  os << "SYS_COM_CHAOS_FREE_LIST:                   " << this->SYS_COM_CHAOS_FREE_LIST << endl;
  os << "SYS_COM_CHAOS_TRANSMIT_LIST:               " << this->SYS_COM_CHAOS_TRANSMIT_LIST << endl;
  os << "SYS_COM_CHAOS_RECEIVE_LIST:                " << this->SYS_COM_CHAOS_RECEIVE_LIST << endl;
  os << "SYS_COM_DEBUGGER_REQUESTS:                 " << this->SYS_COM_DEBUGGER_REQUESTS << endl;
  os << "SYS_COM_DEBUGGER_KEEP_ALIVE:               " << this->SYS_COM_DEBUGGER_KEEP_ALIVE << endl;
  os << "SYS_COM_DEBUGGER_DATA_1:                   " << this->SYS_COM_DEBUGGER_DATA_1 << endl;
  os << "SYS_COM_DEBUGGER_DATA_2:                   " << this->SYS_COM_DEBUGGER_DATA_2 << endl;
  os << "SYS_COM_MAJOR_VERSION:                     " << this->SYS_COM_MAJOR_VERSION << endl;
  os << "SYS_COM_DESIRED_MICROCODE_VERSION:         " << this->SYS_COM_DESIRED_MICROCODE_VERSION << endl;
  os << "SYS_COM_HIGHEST_VIRTUAL_ADDRESS:           " << this->SYS_COM_HIGHEST_VIRTUAL_ADDRESS << endl;
  os << "SYS_COM_POINTER_WIDTH:                     " << this->SYS_COM_POINTER_WIDTH << endl;
  os << "SYS_COM_DESCRIPTOR_SPACE_FREE_POINTER:     " << this->SYS_COM_DESCRIPTOR_SPACE_FREE_POINTER << endl;
  os << "SYS_COM_PAGE_DEVICE_TABLE:                 " << this->SYS_COM_PAGE_DEVICE_TABLE << endl;
  os << "SYS_COM_SYSTEM_NUPI_DESCRIPTOR:            " << this->SYS_COM_SYSTEM_NUPI_DESCRIPTOR << endl;
  os << "SYS_COM_PROCESSOR_SLOT:                    " << this->SYS_COM_PROCESSOR_SLOT << endl;
  os << "SYS_COM_OVERTEMP_EVENT:                    " << this->SYS_COM_OVERTEMP_EVENT << endl;
  os << "SYS_COM_FIBER_OPTIC_WARNING_EVENT:         " << this->SYS_COM_FIBER_OPTIC_WARNING_EVENT << endl;
  os << "SYS_COM_NUPI_OVERTEMP_EVENT:               " << this->SYS_COM_NUPI_OVERTEMP_EVENT << endl;
  os << "SYS_COM_PHYSICAL_MEMORY_MAP:               " << this->SYS_COM_PHYSICAL_MEMORY_MAP << endl;
  os << "SYS_COM_KEYBD_ERROR_EVENT:                 " << this->SYS_COM_KEYBD_ERROR_EVENT << endl;
  os << "SYS_COM_DISK_RETRY_EVENT:                  " << this->SYS_COM_DISK_RETRY_EVENT << endl;
  os << "SYS_COM_UNUSED_SIB_EVENT:                  " << this->SYS_COM_UNUSED_SIB_EVENT << endl;
  os << "SYS_COM_PARITY_ERROR_EVENT:                " << this->SYS_COM_PARITY_ERROR_EVENT << endl;
  os << "SYS_COM_PARITY_ERROR_EVENT_2:              " << this->SYS_COM_PARITY_ERROR_EVENT_2 << endl;
  os << "SYS_COM_SYSLOG_WRAP_EVENT:                 " << this->SYS_COM_SYSLOG_WRAP_EVENT << endl;
  os << "SYS_COM_WORLD_RECORD_AREA:                 " << this->SYS_COM_WORLD_RECORD_AREA << endl;
  os << "SYS_COM_ENTRY_REGION_AREA:                 " << this->SYS_COM_ENTRY_REGION_AREA << endl;
  os << "SYS_COM_EXIT_REGION_AREA:                  " << this->SYS_COM_EXIT_REGION_AREA << endl;
  os << "SYS_COM_WORLD_LIST_THREAD:                 " << this->SYS_COM_WORLD_LIST_THREAD << endl;
  os << "SYS_COM_WORLD_RECORD:                      " << this->SYS_COM_WORLD_RECORD << endl;
  os << "SYS_COM_INTERNAL_EXTERNAL_TRANSLATE_TABLE: " << this->SYS_COM_INTERNAL_EXTERNAL_TRANSLATE_TABLE << endl;
  os << "SYS_COM_SWAPIN_ACB:                        " << this->SYS_COM_SWAPIN_ACB << endl;
  os << "SYS_COM_SWAPOUT_ACB:                       " << this->SYS_COM_SWAPOUT_ACB << endl;
  os << "SYS_COM_ERROR_ACB_ADDIN:                   " << this->SYS_COM_ERROR_ACB_ADDIN << endl;
  os << "SYS_COM_ERROR_ACB_HOST:                    " << this->SYS_COM_ERROR_ACB_HOST << endl;
  os << "SYS_COM_CREC_ACB:                          " << this->SYS_COM_CREC_ACB << endl;
}

/*
 *
 */

class vlmScratchPadInitArea
{
public:

public:
  void dump(ostream &os);

#ifdef NOTDEF
protected:
#endif

  /* From qdefs.lisp. */
  e3Word INITIAL_TOP_LEVEL_FUNCTION;
  e3Word ERROR_HANDLER_STACK_GROUP;
  e3Word CURRENT_STACK_GROUP;
  e3Word INITIAL_STACK_GROUP;
  e3Word LAST_ARRAY_ELEMENT_ACCESSED;
};

void vlmScratchPadInitArea::dump(ostream &os)
{
  cout << "vlmScratchPadInitArea::dump --" << endl;

  os << "INITIAL_TOP_LEVEL_FUNCTION:  " << this->INITIAL_TOP_LEVEL_FUNCTION << endl;
  os << "ERROR_HANDLER_STACK_GROUP:   " << this->ERROR_HANDLER_STACK_GROUP << endl;
  os << "CURRENT_STACK_GROUP:         " << this->CURRENT_STACK_GROUP << endl;
  os << "INITIAL_STACK_GROUP:         " << this->INITIAL_STACK_GROUP << endl;
  os << "LAST_ARRAY_ELEMENT_ACCESSED: " << this->LAST_ARRAY_ELEMENT_ACCESSED << endl;
}

/*
 *
 */

/*
 *
 */

class vlmAreaList
{
public:

  void dump(ostream &os);

private:

  e3Word myResidentSymbolArea;
  e3Word mySystemCommunicationArea;
  e3Word myScratchPadInitArea;
  e3Word myMicroCodeLinkArea;	// ucode "knows about?" "part of microcode, not the band?"
  e3Word myRegionOrigin;
  e3Word myRegionLength;
  e3Word myRegionBits;
  e3Word myRegionFreePointer;
  e3Word myDeviceDescriptorArea;
  e3Word myDiskPageMapArea;
  e3Word myAddressSpaceMap;
  e3Word myRegionGCPointer;
  e3Word myRegionListThread;
  e3Word myRegionAreaMap;
  e3Word myAreaName;
  e3Word myAreaRegionList;
  e3Word myAreaRegionBits;
  e3Word myAreaRegionSize;
  e3Word myAreaMaximumSize;
  e3Word myModuleOpArea;
  e3Word mySupportEntryVector;
  e3Word myExtraPDLArea;
  e3Word myMicroCodeEntryArea;
  e3Word myMicroCodeEntryDebugInfoArea;
  e3Word myScavengerState;
  e3Word myLinearPDLArea;
  e3Word myLinearBindPDLArea;
  e3Word myWorkingStorageArea;
  e3Word myPermanentStorageArea;
  e3Word myPropertyListArea;
  e3Word myPNString;
  e3Word myControlTables;
  e3Word myNRSym;
  e3Word myMacroCompiledProgram;
  e3Word myPDLArea;
  e3Word mySGAndBindPDLArea;
  e3Word myIndirectionCellArea;
  e3Word myFaslTableArea;
  e3Word myFaslTempArea;
  e3Word myDebugInfoArea;
};

void vlmAreaList::dump(ostream &os)
{
  cout << "vlmAreaList::dump --" << endl;

  os << "myResidentSymbolArea:          " << this->myResidentSymbolArea << endl;
  os << "mySystemCommunicationArea:     " << this->mySystemCommunicationArea << endl;
  os << "myScratchPadInitArea:          " << this->myScratchPadInitArea << endl;
  os << "myMicroCodeLinkArea:           " << this->myMicroCodeLinkArea << endl;
  os << "myRegionOrigin:                " << this->myRegionOrigin << endl;
  os << "myRegionLength:                " << this->myRegionLength << endl;
  os << "myRegionBits:                  " << this->myRegionBits << endl;
  os << "myRegionFreePointer:           " << this->myRegionFreePointer << endl;
  os << "myDeviceDescriptorArea:        " << this->myDeviceDescriptorArea << endl;
  os << "myDiskPageMapArea:             " << this->myDiskPageMapArea << endl;
  os << "myAddressSpaceMap:             " << this->myAddressSpaceMap << endl;
  os << "myRegionGCPointer:             " << this->myRegionGCPointer << endl;
  os << "myRegionListThread:            " << this->myRegionListThread << endl;
  os << "myRegionAreaMap:               " << this->myRegionAreaMap << endl;
  os << "myAreaName:                    " << this->myAreaName << endl;
  os << "myAreaRegionList:              " << this->myAreaRegionList << endl;
  os << "myAreaRegionBits:              " << this->myAreaRegionBits << endl;
  os << "myAreaRegionSize:              " << this->myAreaRegionSize << endl;
  os << "myAreaMaximumSize:             " << this->myAreaMaximumSize << endl;
  os << "myModuleOpArea:                " << this->myModuleOpArea << endl;
  os << "mySupportEntryVector:          " << this->mySupportEntryVector << endl;
  os << "myExtraPDLArea:                " << this->myExtraPDLArea << endl;
  os << "myMicroCodeEntryArea:          " << this->myMicroCodeEntryArea << endl;
  os << "myMicroCodeEntryDebugInfoArea: " << this->myMicroCodeEntryDebugInfoArea << endl;
  os << "myScavengerState:              " << this->myScavengerState << endl;
  os << "myLinearPDLArea:               " << this->myLinearPDLArea << endl;
  os << "myLinearBindPDLArea:           " << this->myLinearBindPDLArea << endl;
  os << "myWorkingStorageArea:          " << this->myWorkingStorageArea << endl;
  os << "myPermanentStorageArea:        " << this->myPermanentStorageArea << endl;
  os << "myPropertyListArea:            " << this->myPropertyListArea << endl;
  os << "myPNString:                    " << this->myPNString << endl;
  os << "myControlTables:               " << this->myControlTables << endl;
  os << "myNRSym:                       " << this->myNRSym << endl;
  os << "myMacroCompiledProgram:        " << this->myMacroCompiledProgram << endl;
  os << "myPDLArea:                     " << this->myPDLArea << endl;
  os << "mySGAndBindPDLArea:            " << this->mySGAndBindPDLArea << endl;
  os << "myIndirectionCellArea:         " << this->myIndirectionCellArea << endl;
  os << "myFaslTableArea:               " << this->myFaslTableArea << endl;
  os << "myFaslTempArea:                " << this->myFaslTempArea << endl;
  os << "myDebugInfoArea:               " << this->myDebugInfoArea << endl;
}  

/*
 *
 */



void e3MemMap::dump(ostream &os)
{
  vlmSysCommArea *ca = (vlmSysCommArea *)(&(myWord[0x100]));
  ca->dump(os);

  vlmSysCommArea *cax = (vlmSysCommArea *)(&(myWord[0x200]));
  cax->dump(os);

  vlmScratchPadInitArea *spia = (vlmScratchPadInitArea *)(&(myWord[0x400]));
  spia->dump(os);

  vlmAreaList *area_list = (vlmAreaList *)(&(myWord[0x800]));
  area_list->dump(os);
}
#endif
