#ifndef E3MEMMAP_H
#define E3MEMMAP_H

#include <iostream.h>

#include "word.h"

class e3Band;			/* Forward declaration. */

class e3MemMap
{
  friend e3Band;

public:

  e3MemMap();
  virtual ~e3MemMap();

  e3Word     readWord(e3WordAddr) const;
  e3Word     readWordFollowingInvisiblePointers(e3WordAddr) const;
  void       writeWord(e3WordAddr, e3Word);
  void       dump(ostream &);

 protected:

  e3Boolean  addressIsWithinRange(e3WordAddr) const;
  e3Boolean  isIOSpaceAddress(e3WordAddr addr) const;
  e3Boolean  isAMemoryAddress(e3WordAddr addr) const;
  e3Boolean  addressIsMemory(e3WordAddr) const;

 private:

  /* These from lroy-qcom.lisp */
  static const e3WordAddr  E3_IO_SPACE_VIRTUAL_ADDRESS = 0x01fdfc00;
  static const e3WordAddr  E3_IO_SPACE_LENGTH          = 0x20000;
  static const e3WordAddr  E3_A_MEMORY_VIRTUAL_ADDRESS = 0x01fffc00;
  static const e3WordAddr  E3_A_MEMORY_LENGTH          = 0x400;
  static const e3WordAddr  E3_MAX_VIRTUAL_ADDRESS      = 0x01ffffff; /* 25 bit virtual addresss. */

  e3Word    myWord[E3_MAX_VIRTUAL_ADDRESS];
};

#endif /* E3MEMMAP_H */
