#ifndef E3WORD_H
#define E3WORD_H

#include <fstream.h>

#include "types.h"

/*
 * SSDN2 pg 7-8
 */

typedef enum
{
  E3_CDR_CODE_NORMAL   = 0,
  E3_CDR_CODE_ERROR    = 1,
  E3_CDR_CODE_NIL      = 2,
  E3_CDR_CODE_NEXT     = 3
} e3CdrCode;

/*
 * SSDN2 pg 7-4
 */

typedef enum
{
 E3_DTP_TRAP =             0,
 E3_DTP_LIST =             1,
 E3_DTP_STACK_LIST =       2,
 E3_DTP_SYMBOL =           3,
 E3_DTP_ARRAY =            4,
 E3_DTP_FIX =              5,
 E3_DTP_CHARACTER =        6,
 E3_DTP_SINGLE_FLOAT =     7,
 E3_DTP_SHORT_FLOAT =      8,
 E3_DTP_INSTANCE =         9,
 E3_DTP_EXTENDED_NUMBER =  10,
 E3_DTP_LOCATIVE =         11,
 E3_DTP_FUNCTION =         12,
 E3_DTP_CLOSURE =          13,
 E3_DTP_LEXICAL_CLOSURE =  14,
 E3_DTP_U_ENTRY =          15,
 E3_DTP_STACK_GROUP =      16,
 E3_DTP_GC_FORWARD =       17,
 E3_DTP_EXTERNAL_VALUE_CELL_POINTER = 18,
 E3_DTP_ONE_Q_FORWARD =    19,
 E3_DTP_HEADER_FORWARD =   20,
 E3_DTP_BODY_FORWARD =     21,
 E3_DTP_SYMBOL_HEADER =    22,
 E3_DTP_HEADER =           23,
 E3_DTP_ARRAY_HEADER =     24,
 E3_DTP_INSTANCE_HEADER =  25,
 E3_DTP_FEF_HEADER =       26,
 E3_DTP_SELF_REF_POINTER = 27,
 E3_DTP_GC_YOUNG_POINTER = 28,
 E3_DTP_FREE =             29,
 E3_DTP_NULL =             30,
 E3_DTP_ONES_TRAP =        31
} e3DataType;

/*
 * The basic "Q" (or "quantum" of storage).
 */

class e3DPMTEntry;		/* Forward reference. */

class e3Word
{
public:

  e3u32         getBits(void) const; /* Inline later.  (This feels like a kludge.) */
  void          setBits(e3u32); /* Inline later. */
  e3u32         selectBitsPPSS(e3u32 position, e3u32 size) const; /* DOES shift bits down. */

  e3CdrCode     getCdrCode(void) const;
  e3DataType    getDataType(void) const;
  e3WordAddr    getPointer(void) const;
  void          clear(void);	/* Didn't want to overload assignment w/o setting DTP. */

  e3Boolean     isInvisibleForwardingPointer(void) const;

  friend ifstream& operator >> (ifstream& is, e3Word&);
  friend ostream& operator << (ostream&, e3Word);

  static e3Word allOnesTrap(void); /* Returns a deliberately bad "signature" Q. */


#ifdef PARANOID
  void          abortIfNot(e3DataType tag, char *diag) const;
#else
#undef abortIfNot(tag)
#endif

private:

  void          setDataType(e3DataType);
  e3u32         selectBitsMask(e3u32 mask) const; /* Does NOT shift selected bits down. */
  void          dump(ostream &os);

  e3u32         myBits;	/* Stored in Explorer byte order (little-endian) */
};

#endif /* E3WORD_H */
