/*
 * dumpq.c
 *
 * dump the contents of a Q semi-readably.
 */

#include "utils.h"

#include <stdio.h>
#include <ctype.h>
#include <common/types.h>

char *cdrcodes[4] = {
    "CDR-NORMAL",
    "CDR-ERROR ",
    "CDR-NIL   ",
    "CDR-NEXT  "
};

char *dtpcodes[32] = {
    "DTP-Trap",
    "DTP-List",
    "DTP-Stack-List",
    "DTP-Symbol",
    "DTP-Array",
    "DTP-Fix",
    "DTP-Character",
    "DTP-Single-Float",
    "DTP-Short-Float",
    "DTP-Instance",
    "DTP-Extended-Number",
    "DTP-Locative",
    "DTP-Function",
    "DTP-Closure",
    "DTP-Lexical-Closure",
    "DTP-U-Entry",
    "DTP-Stack-Group",
    "DTP-GC-Forward",
    "DTP-External-Value-Cell-Pointer",
    "DTP-One-Q-Forward",
    "DTP-Header-Forward",
    "DTP-Body-Forward",
    "DTP-Symbol-Header",
    "DTP-Header", /* _Not_ in SSDN2 */
    "DTP-Array-Header",
    "DTP-Instance-Header",
    "DTP-Fef-Header",
    "DTP-Self-Ref-Pointer",
    "DTP-GC-Young-Pointer",
    "DTP-Free",
    "DTP-Null",
    "DTP-Ones-Trap"
};

void dump_q(u32 data, u32 address)
{
    printf("%08lx: %08lx '%c%c%c%c'  %s  %s\n",
	   address, data,
	   (int)(isprint( data        & 0xff)?  data        & 0xff: '.'),
	   (int)(isprint((data >>  8) & 0xff)? (data >>  8) & 0xff: '.'),
	   (int)(isprint((data >> 16) & 0xff)? (data >> 16) & 0xff: '.'),
	   (int)(isprint( data >> 24        )?  data >> 24        : '.'),
	   cdrcodes[data >> 30], dtpcodes[(data >> 25) & 31]);
}

/* EOF */
