/*
 * funcall.c
 *
 * function calling and returns
 */

#include "funcall.h"

#include <stdio.h>
#include "exploiter.h"
#include "context.h"
#include "memory.h"
#include "utils.h"

void set_function(lisp_q fun)
{
    context.function = fun;
    context.location_counter = (memread(fun) & 0x3ff) << 1;

    printf("entering function:\n");
    dump_raw_fef(fun);
}

void create_frame_locals(lisp_q fef_header)
{
    int num_locals;

    /* FIXME: Needs to handle the long-args-word case */
    num_locals = (fef_header >> 10) & 15;
    
    printf("establishing local frame:\n");
    context.local_pointer = context.pdl_pointer;

    while(num_locals--) {
	push_cdrnext(C_NIL);
    }
}

void save_outbound_call_frame(void)
{
    push(context.call_info);
    push(context.arg_pointer);
    push(context.local_pointer);
    push(context.function);
    push(DTP_FIX | context.location_counter);
}

void restore_call_frame(void)
{
    lisp_q saved_arg_pointer;

    saved_arg_pointer = context.arg_pointer;
    context.pdl_pointer = context.local_pointer;

    context.location_counter = ADDRESS(pop());
    context.function = pop();
    context.local_pointer = pop();
    context.arg_pointer = pop();
    context.call_info = pop();

    context.pdl_pointer = saved_arg_pointer;
}

#define CT_OPTIONALS  1
#define CT_LOCALS     2
#define CT_REST       4
#define CT_LONGARGS   8
#define CT_UNUSED    16

int call_types[8] = {
    0, 1, 2, 4, 3, 5, 16, 8
};

int arg_parse(lisp_q fef_header, lisp_q call_info, int call_type, int num_args)
{
    int num_required;
    int num_optional;
    int supplied_optionals;

    /* FIXME: Cheap hack city, needs to cover a lot more stuff */
    
    num_required = (fef_header >> 14) & 15;
    num_optional = (fef_header >> 18) & 7;

    supplied_optionals = num_args - num_required;

    while (num_args < (num_required + num_optional)) {
	push_cdrnext(C_NIL);
	num_args++;
    }

    return supplied_optionals;
}

void funcall(lisp_q function, lisp_q call_info)
{
    int num_args;
    lisp_q fef_header;
    int call_type;
    int optionals;
    lisp_q new_arg_pointer;
    
    num_args = call_info & CI_NUMARGS;

    if (DTP(function) != DTP_FUNCTION) {
	printf("funcall(): function not DTP_FUNCTION.\n");
	exit(-1);
    }

    fef_header = memread(function);

    call_type = (fef_header >> 21) & 7;

    new_arg_pointer = context.pdl_pointer - num_args;
    
    if ((call_info & CI_RETURNDEST) == D_RETURN) {
	/* Replace return fields */
	call_info &= ~CI_RETURNFIELDS;
	call_info |= (context.call_info & CI_RETURNFIELDS);
    } else if ((call_info & CI_RETURNDEST) == D_TAIL_REC) {
	/* Replace return fields and destination */
	call_info &= ~(CI_RETURNFIELDS | CI_RETURNDEST);
	call_info |= (context.call_info & (CI_RETURNFIELDS | CI_RETURNDEST));
	/* FIXME: Do stack-smash thing */

	printf("funcall_1(): D_TAIL_REC not complete.\n");
	exit(-1);
    }

    optionals = arg_parse(fef_header, call_info, call_type, num_args);
    
    save_outbound_call_frame();

    context.arg_pointer = new_arg_pointer;
    context.call_info = call_info;
    
    dump_q(function, 0);
    
    set_function(function);
    create_frame_locals(fef_header);
    
    if (call_types[call_type] & CT_OPTIONALS) {
	push_cdrnext(DTP_FIX | optionals);
    }
}

void return_1(lisp_q retval)
{
    context.indicators = retval;

    /* FIXME: Add return barrier */

    /* skip back over all D_RETURN FRAMES */
    while ((context.call_info & CI_RETURNDEST) == D_RETURN) {
	restore_call_frame();
    }

    if ((context.call_info & CI_RETURNDEST) == D_PUSH) {
	restore_call_frame();

	push(context.indicators);
    } else if ((context.call_info & CI_RETURNDEST) == D_INDS) {
	restore_call_frame();
    } else {
	printf("unknown return code.\n");
	exit(-1);
    }
}

/* EOF */
