/*
 * memory.c
 *
 * memory load and access functions
 */

/* FIXME: use mmap() instead of fileslurp */

#include "memory.h"

#include "exploiter.h"
#include "context.h"
#include "funcall.h"
#include "utils.h"

#include <stdio.h>

lisp_q *image;
lisp_q *sca;
lisp_q *area_origin_area;
lisp_q *dpmt;

int num_wired_words;

#define CLUSTER_NUMBER(q) (((q) >> 13) & 0xfff)
#define PAGE_NUMBER(q) (((q) >> 9) & 0xf)

lisp_q memread(lisp_q address)
{
    lisp_q *dpmt_entry;
    
    address &= Q_BITS_ADDRESS;

    if (address < num_wired_words) {
	return image[address];
    } else if (address >= 0x01fffc00) {
	printf("AMEM: 0x%03lx.\n", address & 0x3ff);
	return 0;
    } else if (address >= 0x01fdfc00) {
	printf("IO: 0x%05lx.\n", (address + 0x400) & 0x1ffff);
	return 0;
    }

    dpmt_entry = &dpmt[CLUSTER_NUMBER(address) << 1];
/*     printf("DPMT: %08lx %08lx.\n", dpmt_entry[0], dpmt_entry[1]); */

    return image[0x2000 * (dpmt_entry[1] & 0xffff) + (address & 0x1fff)];
}

lisp_q memread_inviz(lisp_q address)
{
    lisp_q tmp;

    tmp = memread(address);

    if (DTP(tmp) == DTP_EVCP) {
	printf("INVIZ: EVCP 0x%08lx.\n", tmp);
	return memread_inviz(tmp);
    } else if (DTP(tmp) == DTP_ONE_Q_FORWARD) {
	printf("INVIZ: 1QF 0x%08lx.\n", tmp);
	return memread_inviz(tmp);
    }

    return tmp;
}

void memwrite(lisp_q address, lisp_q data)
{
    lisp_q *dpmt_entry;
    
    address &= Q_BITS_ADDRESS;

    if (address < num_wired_words) {
	image[address] = data;
	return;
    }

    dpmt_entry = &dpmt[CLUSTER_NUMBER(address) << 1];

    image[0x2000 * (dpmt_entry[1] & 0xffff) + (address & 0x1fff)] = data;
}

void memwrite_inviz(lisp_q address, lisp_q data)
{
    lisp_q tmp;

    tmp = memread(address);

    if (DTP(tmp) == DTP_EVCP) {
	printf("INVIZ: EVCP 0x%08lx.\n", tmp);
	memwrite_inviz(tmp, data);
    } else if (DTP(tmp) == DTP_ONE_Q_FORWARD) {
	printf("INVIZ: 1QF 0x%08lx.\n", tmp);
	memwrite_inviz(tmp, data);
    } else {
	memwrite(address, CDRCODE(tmp) | NOT_CDRCODE(data));
    }
}

void push(lisp_q foo)
{
    memwrite(context.pdl_pointer++, foo);
}

void push_cdrnext(lisp_q foo)
{
    push(foo | CDR_NEXT);
}

lisp_q pop(void)
{
    return memread(--context.pdl_pointer);
}

lisp_q car(lisp_q cons)
{
    return memread_inviz(cons);
}

lisp_q cdr(lisp_q cons)
{
    switch (CDRCODE(car(cons))) {
    case CDR_NIL:
	return C_NIL;

    case CDR_NEXT:
	return cons + 1;

    case CDR_NORMAL:
	return memread_inviz(cons + 1);

    case CDR_ERROR:
	printf("CDR of CDR-ERROR taken.\n");
	exit(-1);

    default:
	exit(-1); /* GCC can't see that this can never be reached. :-( */
    }
}

lisp_q get_area_address(int area)
{
    return area_origin_area[area];
}

void memory_init(lisp_q *data)
{
    image = data;
    sca = image + 01000;
    area_origin_area = image + ADDRESS(sca[0]);
    dpmt = image + ADDRESS(area_origin_area[9]);
    num_wired_words = ADDRESS(sca[13]);
}

/* EOF */
