/*
 * auxop.c
 *
 * auxop instruction handlers
 */

#include "exploiter.h"
#include "context.h"
#include "memory.h"
#include "interp.h"
#include "utils.h"
#include "funcall.h"
#include <stdio.h>

int auxop_032(u16 opcode) { /* %STORE-KEY-WORD-ARGS */
    lisp_q valid_keys;
    lisp_q allow_other_keys;
    lisp_q first_store;

    /*
     * From the documentation string:
     *
     * Support for keyword argument decoding. The argument-list of keys and
     * values are obtained from Local 0 and compared against valid keys.
     * ALLOW-OTHER-KEYS is true or nil and indicate whether other keys should
     * be allowed. LOCATIVE-TO-FIRST-STORE is a locative to the first local
     * slot to where to store the values. CLOS uses the args slightly
     * different, since it just wants to check the keys and not store them.
     * In CLOS. the argument list is passed in the ALLOW-OTHER-KEYS and
     * LOCATIVE-TO-FIRST-STORE is always NIL. VALID-KEYS is the same as the
     * normal case.
     *
     * Also see the definition of STORE-KEYARGS in kernel/functions.lisp (the
     * runtime version of this opcode, used when the compiler can't optimize
     * it out to this).
     */

    first_store = NOT_CDRCODE(pop());
    allow_other_keys = NOT_CDRCODE(pop());
    valid_keys = NOT_CDRCODE(pop());

    if (first_store == C_NIL) {
	printf("%%STORE-KEY-WORD-ARGS: CLOS case unimplemented.\n");
	return 0;
    }
    
    printf("%%STORE-KEY-WORD-ARGS: Not implemented.\n");

    return 0;
}

int step_auxop(u16 opcode)
{
    u16 opnum;

    opnum = opcode & 0x1ff;

    if (opnum == 032) {
	return auxop_032(opcode);
    } else if ((opnum == 0101) || /* COMPLEX-CALL-TO-PUSH */
	       (opnum == 0102)) { /* COMPLEX-CALL-TO-RETURN */
	lisp_q function;
	lisp_q call_info;

	function = pop();
	call_info = pop();
	
	dump_q(function, 0);
	dump_q(call_info, 1);

	call_info &= 0xfffff1ff;
	call_info |= (opnum & 3) << 9;
	
	funcall(function, call_info);
    } else if (opnum == 0122) { /* RETURN-NIL */
	return_1(C_NIL);
    } else if (opnum == 0136) { /* RETURN-PRED */
	return_1((NOT_CDRCODE(context.indicators) == C_NIL)? C_NIL: C_T);
    } else if (opnum == 0137) { /* RETURN-NOT-INDS */
	return_1((NOT_CDRCODE(context.indicators) == C_NIL)? C_T: C_NIL);
    } else if ((opnum & 0700) == 0400) { /* UNBIND-n */
	/* FIXME: Need to implement this when we implement BIND */
	unbind_n((opnum & 077) + 1);
	return 1;
    } else if ((opnum & 0700) == 0500) { /* POP-n */
	context.pdl_pointer -= (opnum & 077) + 1;
    } else if ((opnum & 0700) == 0600) { /* RETURN-n */
	return_n(opnum & 077);
    } else {
	printf("Unknown auxop.\n");
	return 0;
    }

    return 1;
}

/* EOF */
