;;; -*- Mode:Common-Lisp; Package:SYSTEM-INTERNALS; Base:8; Cold-load:T -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1987-1989 Texas Instruments Incorporated.  All rights reserved.

;;; Explorer-II Processor-Specific Hardware Initializations

;;; Edit History:
;;;
;;;   Date     Author  Patch #   Description
;;;--------------------------------------------------------------------------
;;; 09-09-87    ab      ---      Original.
;;; 01/12/88    ab               o Modifications for MX.

;;;
;;; IO-Space Read/Write Primitives
;;;


(DEFUN io-space-read (adr)
  (%io-space-read
    (LDB %%nubus-f-and-slot-bits adr)
    (LDB %%nubus-all-but-f-and-slot-bits adr)))


(DEFUN io-space-write (adr value)
  (%io-space-write
    (LDB %%nubus-f-and-slot-bits adr)
    (LDB %%nubus-all-but-f-and-slot-bits adr)
    value))

(DEFUN read-xcr ()
  (io-space-read (IF (mx-p)
		     MX-External-Control-Reg
		     External-Control-Reg))
  )

(DEFUN set-xcr-bit (byte-spec &optional (value 1))
  (WITHOUT-INTERRUPTS
    (io-space-write (IF (mx-p)
			MX-External-Control-Reg
		        External-Control-Reg)
		    (DPB value byte-spec (read-xcr))))
  )

(DEFUN get-processor-slot ()
  (COND ((mx-p)
	 (LDB %%PBR-Slot-ID (io-space-read Mx-Phys-Bus-Resource-Register)))
	((exp2-p)
	 (LDB %%Processor-Slot-ID (read-xcr)))
	(t (logand #xf processor-slot-number)))
  )


;;;
;;; Event Timer Initialization
;;;

(DefVar *Event-Generator-Interrupt-Descriptor*)

(DEFUN Initialize-Event-Generator-Interrupt ()
  (SETQ *Event-Generator-Interrupt-Descriptor*
	(Make-Array (* 2. 2.)       ;(length %IO-Descriptor-Words)
		    :type art-16b
		    :Displaced-To (allocate-device-descriptor-space 2) 
                    ))
  (Aset-32b 0
	    *Event-Generator-Interrupt-Descriptor*
	    %IO-Device-Block-Link)            ;Init Link Word   
  (Aset-32b %Event-Timer-Event-Type	
	    *Event-Generator-Interrupt-Descriptor* 
	    %IO-Device-Descriptor-Word)     ;Init info word
  (%Add-Interrupt *Event-Generator-Interrupt-Descriptor* %Explorer-II-Event-Timer-Level))


(DEFUN enable-event-timer-interrupt (&optional (enable-p t))
  (set-xcr-bit (IF (mx-p) %%MXCR-Event-Timer-Enable %%Event-Timer-Run)
	       (IF enable-p 1 0)))

(DEFUN setup-event-generator ()
  (initialize-event-generator-interrupt)
  (enable-event-timer-interrupt))

